// -*- C++ -*-

//=============================================================================
/**
 *  @file   Identification_Service.h
 *
 *  Identification_Service.h,v 1.5 2004/02/04 20:20:21 parsons Exp
 *
 *  @author Huang-Ming Huang <hh1@cse.wustl.edu>
 */
//=============================================================================

#ifndef IDENTIFICATION_SERVICE_H
#define IDENTIFICATION_SERVICE_H

#include "ace/Service_Object.h"
#include "orbsvcs/orbsvcs/CosNamingC.h"
#include "orbsvcs/orbsvcs/FTRTC.h"
#include "orbsvcs/orbsvcs/FtRtecEventCommC.h"
#include "ftrtec_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

namespace FTRTEC
{
  class Identification_Service : public ACE_Service_Object
  {
  public:
    Identification_Service();
    ~Identification_Service();

    /**
    * This function returns 0 when init is not called yet.
    */
    static Identification_Service* instance();

    int init(int argc, ACE_TCHAR* argv[]);

    const FtRtecEventComm::ObjectId& object_id() const;
    const CosNaming::Name& name() const;
  private:
    FtRtecEventComm::ObjectId object_id_;
    CosNaming::Name name_;
  };


  ACE_STATIC_SVC_DECLARE_EXPORT (TAO_FTRTEC, Identification_Service)
  ACE_STATIC_SVC_REQUIRE(Identification_Service)
  ACE_FACTORY_DECLARE (TAO_FTRTEC, Identification_Service)
}

#endif
