// ESF_Peer_Admin.cpp,v 1.11 2005/01/05 19:29:10 jwillemsen Exp

#ifndef TAO_ESF_PEER_ADMIN_CPP
#define TAO_ESF_PEER_ADMIN_CPP

#include "ESF_Peer_Workers.h"

ACE_RCSID(ESF, ESF_Peer_Admin, "ESF_Peer_Admin.cpp,v 1.11 2005/01/05 19:29:10 jwillemsen Exp")

template<class EVENT_CHANNEL, class PROXY, class INTERFACE, class PEER>
TAO_ESF_Peer_Admin<EVENT_CHANNEL,PROXY,INTERFACE,PEER>::
    TAO_ESF_Peer_Admin (EVENT_CHANNEL *ec)
  :  TAO_ESF_Proxy_Admin<EVENT_CHANNEL,PROXY,INTERFACE> (ec)
{
}

template<class EVENT_CHANNEL, class PROXY, class INTERFACE, class PEER>
TAO_ESF_Peer_Admin<EVENT_CHANNEL,PROXY,INTERFACE,PEER>::
    ~TAO_ESF_Peer_Admin (void)
{
}

template<class EVENT_CHANNEL, class PROXY, class INTERFACE, class PEER> void
TAO_ESF_Peer_Admin<EVENT_CHANNEL,PROXY,INTERFACE,PEER>::
    peer_connected (PEER *peer
                    ACE_ENV_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  TAO_ESF_Peer_Connected<PROXY,PEER> worker (peer);

  this->for_each (&worker ACE_ENV_ARG_PARAMETER);
}

template<class EVENT_CHANNEL, class PROXY, class INTERFACE, class PEER> void
TAO_ESF_Peer_Admin<EVENT_CHANNEL,PROXY,INTERFACE,PEER>::
    peer_reconnected (PEER *peer
                      ACE_ENV_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  TAO_ESF_Peer_Reconnected<PROXY,PEER> worker (peer);

  this->for_each (&worker ACE_ENV_ARG_PARAMETER);
}

template<class EVENT_CHANNEL, class PROXY, class INTERFACE, class PEER> void
TAO_ESF_Peer_Admin<EVENT_CHANNEL,PROXY,INTERFACE,PEER>::
    peer_disconnected (PEER *peer
                       ACE_ENV_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  TAO_ESF_Peer_Disconnected<PROXY,PEER> worker (peer);

  this->for_each (&worker ACE_ENV_ARG_PARAMETER);
}

#endif /* TAO_ESF_PEER_ADMIN_CPP */
