// -*- C++ -*-

//=============================================================================
/**
 * @file Security_PolicyFactory.h
 *
 * Security_PolicyFactory.h,v 1.6 2005/06/14 08:54:59 jwillemsen Exp
 *
 * @author Ossama Othman <ossama@uci.edu>
 */
//=============================================================================


#ifndef TAO_SECURITY_POLICY_FACTORY_H
#define TAO_SECURITY_POLICY_FACTORY_H

#include /**/ "ace/pre.h"

#include "security_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "tao/PI/PI.h"
#include "tao/LocalObject.h"

// This is to remove "inherits via dominance" warnings from MSVC.
// MSVC is being a little too paranoid.
#if defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable:4250)
#endif /* _MSC_VER */

namespace TAO
{
  namespace Security
  {

    /**
     * @class PolicyFactory
     *
     * @brief Policy factory for all security related policies.
     *
     * Policy factory for all security related policies.
     */
    class TAO_Security_Export PolicyFactory
      : public PortableInterceptor::PolicyFactory,
        public CORBA::LocalObject
    {
    public:

      virtual CORBA::Policy_ptr create_policy (CORBA::PolicyType type,
                                               const CORBA::Any & value
                                           ACE_ENV_ARG_DECL_WITH_DEFAULTS)
        ACE_THROW_SPEC ((CORBA::SystemException,
                         CORBA::PolicyError));
    };

  } // End Security namespace
}  // End TAO namespace


#if defined(_MSC_VER)
#pragma warning(pop)
#endif /* _MSC_VER */

#include /**/ "ace/post.h"

#endif /* TAO_SECURITY_POLICY_FACTORY_H */
