// -*- C++ -*-

//=============================================================================
/**
 *  @file    Non_Servant_Upcall.h
 *
 *  Non_Servant_Upcall.h,v 1.3 2005/02/22 15:19:59 jwillemsen Exp
 *
 *  @author Irfan Pyarali
 */
//=============================================================================

#ifndef TAO_NONSERVANT_UPCALL_H
#define TAO_NONSERVANT_UPCALL_H

#include /**/ "ace/pre.h"

#include "portableserver_export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

// Forward declaration
class TAO_Root_POA;
class TAO_Object_Adapter;

namespace TAO
{
  namespace Portable_Server
  {
    /**
     * @class Non_Servant_Upcall
     *
     * @brief This class helps us with a recursive thread lock without
     * using a recursive thread lock.  Non_Servant_Upcall has a
     * magic constructor and destructor.  We unlock the
     * Object_Adapter lock for the duration of the non-servant
     * (i.e., adapter activator and servant activator) upcalls;
     * reacquiring once the upcalls complete.  Even though we are
     * releasing the lock, other threads will not be able to make
     * progress since
     * <Object_Adapter::non_servant_upcall_in_progress_> has been
     * set.
     */
    class TAO_PortableServer_Export Non_Servant_Upcall
    {
    public:

      /// Constructor.
      Non_Servant_Upcall (::TAO_Root_POA &poa);

      /// Destructor.
      ~Non_Servant_Upcall (void);

      ::TAO_Root_POA &poa (void) const;

    protected:

      TAO_Object_Adapter &object_adapter_;
      ::TAO_Root_POA &poa_;
      Non_Servant_Upcall *previous_;
    };
  }
}

#if defined (__ACE_INLINE__)
# include "Non_Servant_Upcall.inl"
#endif /* __ACE_INLINE__ */

#include /**/ "ace/post.h"

#endif /* TAO_NONSERVANT_UPCALL_H */
