package VC9WorkspaceCreator;

# ************************************************************
# Description   : A VC9 Workspace Creator
# Author        : Johnny Willemsen
# Create Date   : 11/22/2007
# ************************************************************

# ************************************************************
# Pragmas
# ************************************************************

use strict;

use VC9ProjectCreator;
use VC8WorkspaceCreator;

use vars qw(@ISA);
@ISA = qw(VC8WorkspaceCreator);

# ************************************************************
# Data Section
# ************************************************************

my(%lang_map) = ('cplusplus' => 'Visual C#',
                 'csharp'    => 'Visual C#',
                 'vb'        => 'Visual Basic',
                 'java'      => 'Visual J#');

# ************************************************************
# Subroutine Section
# ************************************************************

sub pre_workspace {
  my($self) = shift;
  my($fh)   = shift;
  my($crlf) = $self->crlf();

  print $fh '﻿', $crlf,
            'Microsoft Visual Studio Solution File, Format Version 10.00', $crlf;
  $self->print_workspace_comment($fh,
            '# Visual Studio 2008', $crlf,
            '# $Id: VC9WorkspaceCreator.pm 1225 2007-11-27 13:13:42Z elliott_c $', $crlf,
            '#', $crlf,
            '# This file was generated by MPC.  Any changes made directly to', $crlf,
            '# this file will be lost the next time it is generated.', $crlf,
            '#', $crlf,
            '# MPC Command:', $crlf,
            '# ', $self->create_command_line_string($0, @ARGV), $crlf);
}

1;
