# -*- Makefile -*-

#----------------------------------------------------------------------------
#
#       $Id: rules.ciao.GNU 72941 2006-06-02 12:16:34Z jwillemsen $
#
#       Common Makefile rules for all of CIAO
#
#----------------------------------------------------------------------------

ifndef TAO_ROOT
  TAO_ROOT = $(ACE_ROOT)/TAO
endif

ifndef CIAO_ROOT
  CIAO_ROOT = $(TAO_ROOT)/CIAO
endif

ifndef TAO_IDL3_TO_IDL2
  TAO_IDL3_TO_IDL2 = $(CIAO_ROOT)/tools/IDL3_TO_IDL2/tao_idl3_to_idl2
  TAO_IDL3_TO_IDL2_DEP = $(TAO_IDL3_TO_IDL2)$(EXEEXT)
else
ifndef TAO_IDL3_TO_IDL2_DEP
  TAO_IDL3_TO_IDL2_DEP = $(TAO_IDL3_TO_IDL2)
endif
endif

ifeq (,$(findstring -L$(CIAO_ROOT)/ciao,$(LDFLAGS)))
  LDFLAGS += -L$(CIAO_ROOT)/ciao
endif
ifeq (,$(findstring -I$(CIAO_ROOT),$(INCLDIRS)))
  INCLDIRS += -I$(CIAO_ROOT)
endif

# Turn on symbol versioning. The scheme that we follow is to allow
# applications dependent on libraries, with same version numbers (major,
# minor and beta) to run, but applications with dependencies on libraries
# with different minor or major or beta versions to fail.
#
ifeq (cmd,$(findstring cmd,$(SHELL)))
CIAO_MAJOR_VERSION := $(shell awk "/CIAO_MAJOR_VERSION/ { print $$3}" ${CIAO_ROOT}/ciao/Version.h)
CIAO_MINOR_VERSION := $(shell awk "/CIAO_MINOR_VERSION/ { print $$3}" ${CIAO_ROOT}/ciao/Version.h)
CIAO_BETA_VERSION := $(shell awk "/CIAO_BETA_VERSION/ { print $$3}" ${CIAO_ROOT}/ciao/Version.h)
else
CIAO_MAJOR_VERSION := $(shell awk '/CIAO_MAJOR_VERSION/ { print $$3}' ${CIAO_ROOT}/ciao/Version.h)
CIAO_MINOR_VERSION := $(shell awk '/CIAO_MINOR_VERSION/ { print $$3}' ${CIAO_ROOT}/ciao/Version.h)
CIAO_BETA_VERSION := $(shell awk '/CIAO_BETA_VERSION/ { print $$3}' ${CIAO_ROOT}/ciao/Version.h)
endif

# Version number of the libraries
#
ifeq ($(versioned_so),1)
  # Only set SOVERSION for CIAO if versioning is turned on and SOVERION is
  # blank, which gives users to ability to override it.
  ifeq ($(SOVERSION),)
    SOVERSION = .$(CIAO_MAJOR_VERSION).$(CIAO_MINOR_VERSION).$(CIAO_BETA_VERSION)
  endif # SOVERSION

  # Name that will be written into the dynamic library
  #
  ifneq ($(SONAME),)
    SONAME = $(SHLIB).$(CIAO_MAJOR_VERSION).$(CIAO_MINOR_VERSION).$(CIAO_BETA_VERSION)
  endif # SONAME
endif # versioned_so
