//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.



#ifndef BURN_ISO2CD_H
#define BURN_ISO2CD_H
#include <QFile>
#include <Phonon/MediaObject>
#include <Phonon/AudioOutput>
#include <QProcess>
#include <QByteArray>
#include <QDialog>
#include "../build/ui_burn_iso_2_cd.h"
//
class burniso2cd : public QDialog, public Ui::burniso2cd
{
Q_OBJECT
public:
	burniso2cd( QWidget * parent = 0, Qt::WFlags f = 0 );
	QStringList device_path;
	QStringList id_device;
	QByteArray erase_output;
	bool is_erasing;
	bool loaded_success;
	QTimer *timer;
	QString disc_real_type;
	
private slots:
  void start_erase();
  void device_scan();
  void media_available();
  void combo_changed(int n);
  void updateEraseDisplay();
  void printOutErase(int, QProcess::ExitStatus);
  void disable_buttons();
  void enable_buttons();
  void play_success();
  void play_error();
  
private:
QProcess *erase;
  
  
};
#endif

