//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>. 
void acetoneiso::converter()
{

QMessageBox::warning(this, "AcetoneISO",tr("Note:\nISO-9660 filesystem does not support multisector images, this means you will loose all sectors above first sector. Generally speaking, the first sector holds data file.\nIf it's a video game image in MDF/IMG/CCD format, you will probably loose sectors that hold copyprotection files."));
QDir acetone_bin = QDir::home();
acetone_bin.cd(".acetoneiso");
QFile poweriso_file( acetone_bin.path() + "/poweriso");
	if(!poweriso_file.exists()) {
	get_poweriso();
	return;
	}
	
	//estrazione qui
	QDir Home = QDir::home();
	QString isodaconvertire;
	isodaconvertire = QFileDialog::getOpenFileName(this,tr("Open Image"), Home.path() ,  tr("Image Files (*.daa *.bin *.mdf *.ashdisc *.bwi *.b5i *.lcd *.img *.cdi *.cif *.p01 *.pdi *.nrg *.ncd *.pxi *.gi *.fcd *.vcd *.c2d *.cue)"));
		if ( isodaconvertire.isNull() ){
		  return;
		}
         QFileInfo fi(isodaconvertire);
        QString filenopath = fi.fileName();
		filenopath.chop(4);
		 	QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save ISO file"),
				filenopath ,
				tr("Images (*.iso)"));
		if (fileName.isNull() ) {
		 return; 
		}
		fileName = fileName.append(".iso");
		

	 showProgressDisplay();
	 POweriso = new QProcess();
	 POweriso->setReadChannel(QProcess::StandardOutput);
	 POweriso->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(POweriso, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_POweriso() )); 
	connect(POweriso, SIGNAL(finished(int, QProcess::ExitStatus)), this,SLOT( message_extract_finish() ) );  
POweriso->start( poweriso_file.fileName(), QStringList() << "convert" << isodaconvertire << "-o" << fileName );
     
}

//mac converter
void acetoneiso::macimg()
{

QMessageBox msgBox;
msgBox.setText(tr("It is highly recommended to use \"Extract to folder\" feature.\nThis is because the converted ISO image is not a true ISO-9660 filesystem and requires to be mounted from terminal. A loaded hfsplus module is also needed.\nExtracting the image contents to a folder is way easier and faster, and if you need you can always convert the folder to ISO in a second moment with AcetoneISO!\nChoose what to do:  "));
QPushButton *connectButton = msgBox.addButton(tr(" Extract to folder (best solution) "), QMessageBox::ActionRole);
QPushButton *connectButton2 = msgBox.addButton(tr(" Convert to ISO (worst solution) "), QMessageBox::ActionRole);
msgBox.exec();
 if (msgBox.clickedButton() == connectButton) {
    extract();
   }
 else if  (msgBox.clickedButton() == connectButton2) {
    QDir acetone_bin = QDir::home();
    acetone_bin.cd(".acetoneiso");
    QFile poweriso_file( acetone_bin.path() + "/poweriso");
    if(!poweriso_file.exists())
       get_poweriso();
    else{
//estrazione qui
       QDir Home = QDir::home();
       QString isodaconvertire;
       isodaconvertire = QFileDialog::getOpenFileName(this,tr("Open Image"), Home.path() ,  tr("Image Files (*.dmg)"));
       if (isodaconvertire.isNull() ){
	return; 
       }
          QFileInfo fi(isodaconvertire);
          QString filenopath = fi.fileName();
          filenopath.chop(4);
          QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save ISO file"),filenopath ,tr("Images (*.iso)"));
          if (fileName.isNull() ) {
	   return; 
	  }
             fileName = fileName.append(".iso");
	     
	 showProgressDisplay();
	 MAcimg = new QProcess();
	 MAcimg->setReadChannel(QProcess::StandardOutput);
	 MAcimg->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(MAcimg, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_MAcimg() )); 
	 connect(MAcimg, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT( printOutMACIMG(int, QProcess::ExitStatus) ) );	     
        MAcimg->start( poweriso_file.fileName(), QStringList() << "convert" << isodaconvertire << "-o" << fileName );
            
           
        
      }
   }
}


void acetoneiso::extract()
{
QDir acetone_bin = QDir::home();
acetone_bin.cd(".acetoneiso");
QFile poweriso_file( acetone_bin.path() + "/poweriso");
if(!poweriso_file.exists())
   get_poweriso();
else {
//estrazione qui
   QDir Home = QDir::home();
   QString isodaestrarre;
   isodaestrarre = QFileDialog::getOpenFileName(this,tr("Open Image"), Home.path() ,  tr("Image Files (*.iso *.daa *.bin *.mdf *.ashdisc *.bwi *.b5i *.lcd *.img *.cdi *.cif *.p01 *.pdi *.nrg *.ncd *.pxi *.gi *.fcd *.vcd *.c2d *.dmg *.cue)"));
   if ( isodaestrarre.isNull() ) {
    }
   else {
         QString folder = QFileDialog::getExistingDirectory(this, tr("AcetoneISO::Select where to extract image"),Home.path());
         if (folder.isNull() ) {
	  }
         else {
              
	   
	 showProgressDisplay();
	 POweriso = new QProcess();
	 POweriso->setReadChannel(QProcess::StandardOutput);
	 POweriso->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(POweriso, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_POweriso() )); 
	connect(POweriso, SIGNAL(finished(int, QProcess::ExitStatus)), this,SLOT( message_extract_finish() ) ); 
	
            POweriso->start( poweriso_file.fileName(), QStringList() << "extract" << isodaestrarre << "/" << "-od" << folder );
             
              }
          }
      }
}


void acetoneiso::get_poweriso()
{
QMessageBox msgBox;
msgBox.setText(tr("Do you want to download Poweriso?\nIf you click yes you accept PowerISO's Freeware(proprietary but gratis) License.\nRemember: if you are running a 64-bit OS, you need ia32-libs package installed and maybe others."));
 msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
 switch (msgBox.exec()) {
 case QMessageBox::Yes:
    {
	QDir acetone_bin = QDir::home();
	acetone_bin.cd(".acetoneiso");
	QDir::setCurrent( acetone_bin.path() );
	WGet.start("wget", QStringList() << "http://www.poweriso.com/poweriso-1.3.tar.gz" );
	connect(&WGet, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT( extract_poweriso() ));
	progBarra();
     }
     break;
 case QMessageBox::No:
     QMessageBox::warning(this, "AcetoneISO",tr("Without Poweriso you won't be able to convert and extract images to ISO or folders!"));
     break;
 default:
     // should never be reached
     break;
 }
}


void acetoneiso::extract_poweriso()
{
QDir acetone_bin = QDir::home();
acetone_bin.cd(".acetoneiso");
QDir::setCurrent( acetone_bin.path() );
TAr.start("tar", QStringList() << "-xf" << "poweriso-1.3.tar.gz");
}


void acetoneiso::messaggio_poweriso()
{
QDir acetone_bin = QDir::home();
acetone_bin.cd(".acetoneiso");
QDir::setCurrent( acetone_bin.path() );
QFile poweriso_tar("poweriso-1.3.tar.gz");
poweriso_tar.remove();
QMessageBox::information(this, "AcetoneISO",tr("Poweriso downloaded and extracted!"));
} 



void acetoneiso::contextExtract()
{
QDir acetone_bin = QDir::home();
acetone_bin.cd(".acetoneiso");
QFile poweriso_file( acetone_bin.path() + "/poweriso");
if(!poweriso_file.exists())
   get_poweriso();
else {
//estrazione qui
QDir Home = QDir::home();
QFile file(Home.path() + "/.acetoneiso/acetoneiso.conf");
file.open(QIODevice::ReadOnly);//lo apro in sola lettura
QByteArray utf = (leggiRigo( 4, &file ));
QString strd = QString::fromUtf8(utf);
file.close();
strd.remove(0,5);
strd.chop(1);
//controllo che se strd finisce con / allora si deve togliere.
if( strd.endsWith( "/" ) ) {
   strd.chop(1);
   }
QString isodaestrarre = ( strd + "/" + fileDaMontare ); //file da estrarre comprensivo di percorso

QFile image_exists(isodaestrarre);
if (!image_exists.exists()) {
  QMessageBox::critical(this, "AcetoneISO",tr("The image ") + isodaestrarre  + tr(" doesn't exist.\nI'll remove it from database display."));
  int riga = listWidget->currentRow() ;
  listWidget->takeItem( riga  );
  file.close();
  return;
}

         QString folder = QFileDialog::getExistingDirectory(this, tr("AcetoneISO::Select where to extract image"),Home.path());
         if (folder.isNull() ) {
	   return;
	  }
         
	 showProgressDisplay();
	 POweriso = new QProcess();
	 POweriso->setReadChannel(QProcess::StandardOutput);
	 POweriso->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(POweriso, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_POweriso() )); 
	connect(POweriso, SIGNAL(finished(int, QProcess::ExitStatus)), this,SLOT( message_extract_finish() ) ); 
             POweriso->start( poweriso_file.fileName(), QStringList() << "extract" << isodaestrarre << "/" << "-od" << folder );
             
              
file.close();
          }
}

