#include "AdunKernel/AdunRelationship.h"

@implementation AdRelationship

- (id) initWithObject: (id) objectOne 
	relationship: (NSString*) aString 
	object: (id) objectTwo
{
	return [self initWithObject: objectOne 
			relationship: aString 
			relationshipType: @"AdOneToOneRelationship"
			object: objectTwo];
}


- (id) initWithObject: (id) objectOne 
	relationship: (NSString*) aString 
	objects: (NSArray*) anArray
{
	return [self initWithObject: objectOne 
			relationship: aString 
			relationshipType: @"AdOneToManyRelationship"
			object: anArray];
}

- (id) initWithObjects: (NSArray*) arrayOne 
	relationship: (NSString*) aString 
	objects: (NSArray*) arrayTwo
{
	return [self initWithObject: arrayOne 
			relationship: aString 
			relationshipType: @"AdManyToManyRelationship"
			object: arrayTwo];
}

- (id) initWithObject: (id) objectOne 
	relationship: (NSString*) aString 
	relationshipType: (NSString*) type 
	object: (id) objectTwo
{
	if(self == [super init])
	{
		validTypes = [[NSArray alloc] initWithObjects: 
				@"AdOneToOneRelationship",
				@"AdOneToManyRelationship",
				@"AdManyToManyRelationship",
				nil];

		if([validTypes containsObject: type])
			relationshipType = [type retain];
		else
			[NSException raise: NSInvalidArgumentException
				format: @"Invalid value (%@) for relationship type", 
					type];
		
		if([type isEqual: @"AdOneToManyRelationship"])
			if(![objectTwo isKindOfClass: [NSArray class]])
				[NSException raise: NSInvalidArgumentException
					format: @"Second object must be an array for type %@",
					relationshipType];
		
		if([type isEqual: @"AdManyToManyRelationship"])
			if(![objectTwo isKindOfClass: [NSArray class]]  ||
				![objectOne isKindOfClass: [NSArray class]])
			{			
				[NSException raise: NSInvalidArgumentException
					format: @"Second object must be an array for type %@",
					relationshipType];
			}
		
		object = [objectTwo retain];
		subject = [objectOne retain];
		relationship = [aString retain];
	}

	return self;
}

- (void) dealloc
{
	[validTypes release];
	[relationshipType release];
	[relationship release];
	[object release];
	[subject release];
}

- (NSString*) description
{
	return [NSString stringWithFormat: @"subjects :%@ relationship: %@ objects: %@ type: %@",
			subject,
			relationship,
			object,
			relationshipType];
}

- (id) type
{
	return relationshipType;
}

- (NSString*) relationship
{
	return relationship;
}

- (void) setRelationship: (NSString*) aString
{
	[relationship release];
	relationship = [aString retain];
}

- (id) subjects
{
	return subject;
}

- (id) objects
{
	return object;
}

- (void) setSubject: (id) anObject
{
	if(![relationshipType isEqual: @"AdOneToOneRelationship"])
		[NSException raise: NSInternalInconsistencyException
			format: @"Attempted to set a single subject in a ToMany relationship"];
	
	[subject release];
	subject = [anObject retain];
}

- (void) setSubjects: (NSArray*) anArray
{
	if([relationshipType isEqual: @"AdOneToOneRelationship"])
		[NSException raise: NSInternalInconsistencyException
			format: @"Attempted to set multiple subjects in a ToOne relationship"];
	
	[subject release];
	subject = [anArray retain];
}

- (void) setObject: (id) anObject
{
	if([relationshipType isEqual: @"AdManyToManyRelationship"])
		[NSException raise: NSInternalInconsistencyException
			format: @"Attempted to set single subject in a ManyToMany relationship"];
	
	[object release];
	object = [anObject retain];
}

- (void) setObjects: (NSArray*) anArray
{
	if(![relationshipType isEqual: @"AdManyToManyRelationship"])
		[NSException raise: NSInternalInconsistencyException
			format: @"Attempted to set multiple subjects in a OneToOne or OneToMany relationship"];
	
	[object release];
	object = [anArray retain];
}

 @end

