/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#include "Commands/AdFlushEnergiesCommand.h"

@implementation AdCore (AdFlushEnergiesCommand)

//\note this will change if the method of retaining the energy info changes

- (id) flushEnergies: (NSDictionary*) options
{
	int numberOfBytes, code;
	id error;
	NSString* reason;
	NSMutableData* data;
	NSKeyedArchiver* flushArchiver;

	if(energyFile == NULL)
		[NSException raise: NSInternalInconsistencyException
			format: @"AdCore energyFile is NULL!"];

	if((int)[energyDict count] == 0)
	{
		error = [NSError errorWithDomain: AdCoreCommandErrorDomain
			code: 0
			userInfo: [NSDictionary dictionaryWithObject:
					@"There is no available data to write."
					forKey:
					NSLocalizedDescriptionKey]];
		
		[commandErrors setValue: error forKey: @"flushEnergies"];
		return nil;
	}

	NSDebugLLog(@"AdFlushEnergiesCommand", 
		@"There are %d logged energies", [energyDict count]);
	
	//copy the current energy data

	data = [NSMutableData new];
	flushArchiver = [[NSKeyedArchiver alloc] initForWritingWithMutableData: data];
	[flushArchiver setOutputFormat: NSPropertyListXMLFormat_v1_0];
	[flushArchiver encodeInt: energyCount forKey: @"NumberOfStateFrames"];
	NSDebugLLog(@"AdFlushEnergiesCommand", @"Encoding energies");
	[flushArchiver encodeObject: energyDict forKey: @"StateFrames"];
	[flushArchiver finishEncoding];
	NSDebugLLog(@"AdFlushEnergiesCommand", @"Complete");
	numberOfBytes = [data length];

	rewind(energyFile);

	if((int)fwrite([data bytes], 1, [data length], energyFile) != numberOfBytes)
	{
		code = ferror(energyFile);
		reason = [NSString stringWithFormat: @"Unable to flush data to file: %s", strerror(code)];
		error = [NSError errorWithDomain: AdCoreCommandErrorDomain
			code: code
			userInfo: [NSDictionary dictionaryWithObject: reason
					forKey:
					NSLocalizedDescriptionKey]];
		[commandErrors setValue: error forKey: @"flushEnergies"];
	}

	if(fflush(energyFile) == EOF)
	{
		code = errno;
		reason = [NSString stringWithFormat: @"Unable to flush data to file: %s", strerror(code)];
		error = [NSError errorWithDomain: AdCoreCommandErrorDomain
			code: code
			userInfo: [NSDictionary dictionaryWithObject: reason
					forKey:
					NSLocalizedDescriptionKey]];
		[commandErrors setValue: error forKey: @"flushEnergies"];
		return nil;
	}

	[flushArchiver release];
	[data release];

	//remove any previous logged error for this command
	[commandErrors removeObjectForKey: @"flushEnergies"];

	return nil;
}

- (NSMutableDictionary*) flushEnergiesOptions
{
	return nil;
}

- (NSError*) flushEnergiesError
{
	return [commandErrors objectForKey: @"flushEnergies"];
}

@end

