/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ADUN_CORE_
#define _ADUN_CORE_

#include <stdbool.h>
#include <stdio.h>
#include "Foundation/Foundation.h"
#include "AdunKernel/AdCoreCommand.h"
#include "AdunKernel/AdunController.h"
#include "AdunKernel/AdunIOManager.h"
#include "AdunKernel/AdunEnvironment.h"
#include "AdunKernel/AdunForceFieldManager.h"
#include "AdunKernel/AdunIOManager.h"
#include "AdunKernel/AdunSimulator.h"
#include "AdunKernel/AdunSystemNode.h"
#include "AdunKernel/AdunSystem.h"
#include "AdunKernel/AdunTimer.h"
#include "AdunKernel/AdunRelationship.h"
#include "AdunKernel/AdunDataSet.h"
#include "AdunKernel/AdunDataMatrix.h"

/**
AdCore is the top level object for the adun kernel. It sets up and contains all other framework objects. 
The core dynamically loads framework plugins (which are subclasses of AdController) that manipulate the framework in a certain way.
\note Make core singelton
\note Add error checking to all basic core commands - currently they assume that all variable, object etc
that must be setup previously have been
\ingroup Inter
**/

//Should define an enum of error codes 
#define AdCoreCommandErrorDomain @"AdCoreCommandErrorDomain"

@interface AdCore: NSObject <AdCoreCommand>
{
	@private
	int energyCount;
	BOOL checkpointed;
	BOOL endSimulation;
	BOOL runLoopIsRunning;
	FILE* trajectoryFile;
	FILE* energyFile;
	id controller;
	id system;
	id archiver;
	id dataSources;
	AdIOManager* ioManager;
	AdEnvironment* environment;
	AdForceFieldManager* forceField;
	AdSimulator* simulator;
	AdMemoryManager* memoryManager;
	AdTimer* scheduler;
	NSMutableDictionary* energyDict;
	NSAutoreleasePool* pool;
	NSArray* validCommands;
	NSMutableDictionary* commandErrors;
	NSMutableDictionary* commandResults;
	NSDate* date;
	NSAutoreleasePool* corePool;
	NSError* terminationError;
	NSMutableArray* containerDataSources;
} 

//Basic Commands

- (id) setOutputDirectories: (NSDictionary*) dict;
- (id) loadProcessData: (NSDictionary*) dict;
- (id) createSimulator: (NSDictionary*) dict; 
- (id) createSystem: (NSDictionary*) dict;
- (id) loadController: (NSDictionary*) dict;
- (id) main: (NSDictionary*) dict;
- (void) startRunLoop;
- (BOOL) simulationIsRunning;
/**
Peforms any neccessary house keeping at the end of a call to main
*/
- (void) cleanUp;
//cehckpointing
- (void) initialCheckpoint;
- (void) checkpointState;
- (void) checkpointSystem: (NSString*) filename;
- (void) checkpoint;
//Keys
- (id) simulator;
- (id) forceField;
- (id) system;
- (id) controller;
- (id) scheduler;
@end

#endif


