/*
   Project: AdunServer

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-31 15:41:02 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ADSERVER_H_
#define _ADSERVER_H_

#include <Foundation/Foundation.h>
#include <AdunKernel/AdServerInterface.h>
#include <AdunKernel/AdCommandInterface.h>
#include <AdunKernel/RemoteProcessAccess.h>
#include "ULFramework/ULServerInterface.h"
#include "ULFramework/ULProcess.h"

/**
\ingroup server
\bug AdServer only creates its log file on startup. If its subsequently deleted it is not recreated.
**/

@interface AdServer : NSObject <ULServerInterface, AdServerInterface>
{
	NSConnection* connection;
	NSMutableDictionary* processes;
	NSMutableDictionary* tasks;
	NSMutableDictionary* interfaces;
	NSMutableDictionary* state; //!< Dictionary of bools inidicating if the simulator is accepting requests
	NSMutableDictionary* processErrors;
	id adunCorePath;
}

- (void) kernelTermination: (NSNotification*) aNotification;

@end

#endif // _ADSERVER_H_

