/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ULANALYSER_
#define _ULANALYSER_
#include <AppKit/AppKit.h>
#include <AdunKernel/AdunDataSet.h>
#include <MolTalk/Structure.oh>
#include <MolTalk/StructureFactory.oh>
#include "ULFramework/ULIOManager.h"
#include "ULFramework/ULAnalysisManager.h"
#include "ULFramework/ULSimulation.h"
#include "ULAnalyserDataSetView.h"
#include "ViewController.h"
#include "ULProgressPanel.h"
#include "ULOutlineViewDelegate.h"

/**
Main class for data analysis

\todo Retrieve information strings from loaded objects
\todo Read gnuplot launch path from defaults.
\todo Reimplement reloadSimulation:

\ingroup interface
*/

@interface ULAnalyser: NSObject
{
	@private
	int checkCount;
	BOOL threadError;
	id pluginList;
	id optionsView;
	id resultsLog;
	id window;
	id analysisManager;
	id mainViewController;
	id currentOptions;
	id pluginResults;
	id selectedDataSet;		//!< The data set currently being displayed
	id pluginDataSets;		//!< Array of data sets returned by the last plugin
	id outlineDelegate;
	ULProgressPanel* progressPanel;
	NSString* selectedPlugin;
	NSDictionary* classMap;		//!< Maps class names to user readable names
	id dataSetList;			//!< List showing data sets returned by a plugin
	id loadedObjectsTable;		//!< Table showing the currently loaded objects
	id loadedObjects;		//!< Array holding the currently loaded objects
	id loadableTypes;		//!< The types of object ULAnalyser can load
	id selectedObjects;		//!< The loaded objects that have been selected
	id dataView;			//!< Object that controls the display of data sets
	id toolbar;
	NSImage* saveImage;
	NSImage* applyImage;
	NSImage* reloadImage;
	//gnuplot
	id gnuplotInterface;
	int historyDepth;
	int currentHistoryPosition;
	NSRange commandRange;
	NSRange gnuplotPrompt;
	NSFileHandle* gnuplotOutput;
	NSFileHandle* gnuplotError;
	NSTask* gnuplot;
	NSPipe* pipey;
	NSPipe* outPipe;
	NSMutableArray* history;
}
- (id) initWithModelViewController: (id) mVC;
- (void) open: (id) sender;
- (void) close: (id) sender;
- (void) analyse: (id) sender;
- (void) load: (id) sender;
- (void) display: (id) sender;
- (void) save: (id) sender;
- (void) remove: (id) sender;
- (void) logString: (NSString*) string;
- (void) setAvailableDataSets: (NSArray*) array;
/**
Called when a user selects a different data set in the view
*/
- (void) dataSetDidChange: (id) sender;
@end

/**
Category containing methods which handle the 
gnuplot interface.
*/
@interface ULAnalyser (ULAnalyserGnuplotExtensions)
- (void) setupGnuplotInterface;
- (void) gnuplotDealloc;
@end

/**
 ULAnalyser category containing methods related to
 displaying plugin options and applying plugins to data.

 \todo Handle return of multiple data sets.
*/
@interface ULAnalyser (ULAnalyserPluginExtensions)

- (void) pluginChanged: (id) sender;
- (void) displayOptionsForPlugin;
- (void) applyCurrentPlugin: (id) sender;
- (void) outputPluginResults: (id) sender;
- (void) updateAvailablePlugins;
- (void) updatePluginOptions;
@end
#endif
