/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-07-06 16:32:04 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULOPTIONSCONTROLLER_H_
#define _ULOPTIONSCONTROLLER_H_

#include <Foundation/Foundation.h>
#include "ULOptions.h"
#include "ULIOManager.h"
#include "ULDatabaseInterface.h"

/**
\ingroup mControl
*/

@interface ULOptionsController : NSObject
{
	ULOptions* currentOptions;
	ULIOManager* ioManager;
	NSString* defaultOptionsFile;
	id simulationDatabase;
}

- (void) saveModelObject;
- (void) newModelObject;
- (id) optionForKeyPath: (NSString*) keyPath;
- (void) addOptionsForController: (NSString*) controller;

@end

#endif // _ULOPTIONSCONTROLLER_H_

