/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-23 14:10:58 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULPROCESSMANAGER_H_
#define _ULPROCESSMANAGER_H_

#include <Foundation/Foundation.h>
#include "ULFramework/ULServerInterface.h"
#include "ULFramework/ULProcess.h"
#include "ULFramework/ULIOManager.h"

/**
ULProcessManager contains, runs and manages Adun simulation processes.
It contains two LIFO queues that contain waiting and running process
respectivly aswell as a dictionary of open connections to various AdunServers.
It provides information about the various processes and also gives access to 
the simulation results using ULResults. 
It adopts the ULServerCommandInterface protocol to facilitate ease of passing of messages
from the View to the Server and hence to the Simulation.
\note Does it really give access to ULResults??
\bug Calcualted elapsed time is the time since the process was created not the
time the process was running
\todo Refactor process commands to use AdServerCommandInterface
\todo Commands are currently using exceptions when really they should use NSError

\ingroup mControl
*/

@interface ULProcessManager : NSObject <ULServerCommandInterface>
{
	NSMutableArray* spawnedStack; //!< stack of spawned currently running processes
	NSMutableArray* newStack;	//!< stack of new waiting processes
	NSMutableArray* finishedStack; //!< stack of finished processes
	NSMutableArray* hosts;
	NSMutableDictionary* connections;	//!< Dictionary of hostname:connection pairs
}

+ (id) appProcessManager;
/** Creates a new process object based on newSystem and newOptions
\param newSystem ULSystem object
\param newOptions ULOptions object
*/
- (void) newProcessWithSystem: (id) newSystem options: (id) newOptions host: (NSString*) host;
/** Creates a new process object based on newSystem and newOptions
\param newSystems An array of ULSystem objects
\param newOptions ULOptions object
*/
- (void) newProcessWithSystems: (id) newSystems options: (id) newOptions host: (NSString*) host;
/**
Spawns the first process in the newProcess queue (FIFO)
*/
- (void) spawnNewProcess;

- (int) numberWaitingProcesses;

- (int) numberSpawnedProcesses;
- (NSMutableArray*) allProcesses;
//\note These should be refactored to execute:error:process
//e.g.[processManager exectue @"haltProcess" error: &errorPointer process: someProcess]
- (void) haltProcess: (ULProcess*) process;
- (void) startProcess: (ULProcess*) process;
- (void) removeProcess: (ULProcess*) process;
- (void) terminateProcess: (ULProcess*) process;
- (void) restartProcess: (ULProcess*) process;
- (BOOL) exportProcess: (ULProcess*) process toFile: (NSString*) filename overwrite: (BOOL) flag error: (NSError**) error;
@end

#endif // _ULPROCESSMANAGER_H_

