# ---------------------------------------------------------------------------
# - APX0006.als                                                             -
# - afnix:apx test module                                                   -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   apx read/write stream test module
# @author amaury darsch

# preload some libraries
interp:library "afnix-sio"

# load the project
interp:load "apx-prjld"

# create an input/output stream
const is (afnix:sio:InputString)
const os (afnix:sio:OutputString)

# create an apx read/write stream
const xapx (afnix:apx:rwstm is os)

# send a request message
xapx:send-command-message "help"

# update the input string
is:set (os:to-string)

# read the request command
trans mesg (xapx:read-message)

# get the request node list
trans  rlst (mesg:get-request-list)
assert 1    (rlst:length)

# get the first request and check
const rqst  (rlst:get 0)
# check the node name
assert "apx:request" (rqst:get-name)
# check the command value
assert "help" (rqst:get-command-value)
