#ifndef _AREA_DBASE
#define _AREA_DBASE

#include "area_dbase.h"

struct b_node_a
{   char   *key;
    Area_Dbase *data;
    b_node_a *left;
    b_node_a *right;

    b_node_a *next;
};

class btree_a
{
public:
   btree_a();
   ~btree_a();

   int    add(char *key,Area_Dbase *data);
   int    del(char *key);
   Area_Dbase *find(char *key);
   bool   can_find(char *key);
   int    reset_next_in_list();
   Area_Dbase *get_next_in_list();

   void show();
   void save_state();
   void restore_state();

private:
   int    add_node(b_node_a **baseptr,b_node_a *newnode);
   int    del_node(b_node_a **baseptr,char *key);
   Area_Dbase *find_node(b_node_a *baseptr, char *key);
   void show(b_node_a *baseptr,int level); 
   int free_node(b_node_a *the_node);

   // The start of all the mess, the root of the tree.
   b_node_a *root;		
   b_node_a *root_list;
   b_node_a *last_added;
   b_node_a *next_in_list;
   b_node_a *next_in_list_saved;
};

#endif

