#ifndef _BULLETIN_H
#define _BULLETIN_H

#include <stdio.h>
#include "strings.h"
#include "entity.h"
#include "flags.h"
#include "errlog.h"

class Inp_Handler;
class Player;

int bulletin_command_handler(MudObject *the_obj, char *the_input);
int bulletin_get_subject(MudObject *the_obj, char *the_input);
int post_on_pop(Inp_Handler *the_handler, char *notused1, char *notused2, 
                                        char *notused3, Strings *notused4);
int pop_on_pop(Inp_Handler *the_handler, char *notused1, char *notused2,
                                         char *notused3, Strings *notused4);

class BullEntry;

class Bulletin : public Entity
{
 public:

   virtual ~Bulletin();
   Bulletin(char *bull_name, int build_port);

   void set_location(char *the_str);
   char *get_location();
   virtual int set_title(char *the_str);
   char *get_title();
   void set_authorized(char *the_str);
   char *get_authorized();
   int  player_authorized(Player *the_player);
   int load_bulletin(ErrLog *error_log);
   int delete_bull(void);
   void display_help(Player *the_player);
   int add_entry(BullEntry *the_entry);
   int delete_entry(int the_num);
   int write_bull();
   int list_entries(Player *the_player);
   BullEntry *get_entry(int the_num);

   Flags *get_bullflags();
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);
   virtual void write_object(FILE *the_file, int build_format);
   int     is_build_port();
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();
   BullEntry **get_loaded_bull();

 private:

   Strings   bullfilename;
   FILE      *the_bullfile;

   Strings   title;
   Strings   location;
   Strings   authorized;

   BullEntry *loaded_bull;
   BullEntry **build_ptr;

   int       for_builder;

   Flags     *bull_flags;
};


class BullEntry
{
 public:

   ~BullEntry();
   BullEntry(Bulletin *assign_board);

   void set_author(char *the_str);
   void set_subject(char *the_str);
   void set_body(char *the_str);
   void set_date();
   char *get_date();
   char *get_author();
   char *get_subject();
   char *get_body();
   int  edit_body(Player *the_player);
   void copy_bull(BullEntry *copy_from);
   BullEntry *get_next_bull();
   void set_next_bull(BullEntry *new_bull);
   int write_bull(FILE *the_file);
   int read_bull(FILE *the_file, ErrLog *error_log);
   void display_bull(Player *the_player);

   void set_board(Bulletin *new_board);
   Bulletin *get_board();

 private:

   Strings       date;
   Strings       author;
   Strings       subject;
   Strings       body;

   BullEntry    *next_bull;
   Bulletin     *the_board;
};


#endif






