#ifndef _OBJECT_LIST_H
#define _OBJECT_LIST_H

#include <stdio.h>
#include "mudobject.h"
#include "tokenfile.h"
#include "object_list.h"
#include "btree_a.h"
#include "errlog.h"
#include "marker.h"
#include "specials.h"
#include "ability.h"
#include "player.h"
#include "config.h"
#include "quest.h"
#include "mask.h"

class Mobile;
class Race;
class Inclination;
class Talent;

class Object_List
{
public:
	char * get_status();
   Object_List(ErrLog *error_log, bool quiet_mode);
   ~Object_List();

   int add_hardcoded(ErrLog *error_log);
   MudObject *get_mudobject(char *the_area, char *the_name);
   Specials *get_special_obj(char *the_area, char *the_name);
   Ability *get_ability_obj(char *the_name);
   int add_area(Area_Dbase *temp_area, ErrLog *error_log);
   int add_mudobject(char *the_area, MudObject *the_object);
   int reset_list();
   Area_Dbase *get_next_area();
   int delete_obj(MudObject *the_obj);
   int remove_obj(MudObject *the_obj);
   Area_Dbase *get_area(char *the_name);
   int reload_races(void);
   int reload_inclinations(void);
   int reload_talents(void);
   int reload_abilities(void);
   int reload_bulletins(void);
   int reload_masks(void);

   Location *is_location(MudObject *the_object);
   MudObject *clone_object(MudObject *orig_obj);

   int display_data(Player *the_player);
   int display_list_data(Player *the_player); 

   int display_races(Player *the_player);
   int display_inclinations(Player *the_player);

   int has_inclinations();
   int has_talents();

   void save_state();
   void restore_state();

   int load_abilities(ErrLog *error_log);
   int load_races(ErrLog *error_log);
   int load_inclinations(ErrLog *error_log);
   int load_talents(ErrLog *error_log);
   int load_masks(ErrLog *error_log);
   int load_bulletins(ErrLog *error_log);
   Race *get_race_obj(char *the_name);
   Mask *get_mask_obj(char *the_name);
   Inclination *get_inclination_obj(char *the_name);
   Talent *get_talent_obj(char *the_name);
   int load_quests(ErrLog *error_log);
   int list_quests(Player *the_player);
   Quest *get_quest_obj(char *the_name);
   int extend_reset(Individual *the_ind, int new_val);

   Mobile *player_to_mobile(Player *the_player);


private:

   Object_List();
   int coordinate(ErrLog *error_log);

   btree_a the_dbase;

   long num_lookups;
   long max_lookup;
   long avg_lookup;
   long min_lookup;

   Strings status;

   int loaded;
};

#endif






