#ifndef _STRINGS_H
#define _STRINGS_H

class Player;
class Individual;
class MudObject;

class Strings
{
public:

   Strings();
   Strings(char *the_string);
   virtual ~Strings();
   int str_copy(char *the_string);
   int str_copy(Strings *the_string);
   char *str_show(void);
   int change_letter(int the_num, char the_letter);   
   char get_letter(int the_num);
   int upper(int the_num);
   int lower(int the_num);
   int uppercase();
   int lowercase();
   int truncate(int where_at);
   int str_len();
   int str_cat(char *new_str);
   int cstr_len();
   int str_cmp(char *new_str);
   int str_n_cmp(char *new_str, int the_length);
   int sprintf(char *new_str, ... );
   int num_char(char the_char);
   int remove_newline(void);
   int remove_returns(void);
   int remove_head_spaces(void);
   int remove_tail_spaces(void);
   int handle_backspaces(void);
   int assign_word(char *the_str, int word_num);
   int assign_word_sdl(char *the_str, int word_num);
   int assign_phrase(char *the_str, int after_word_num);
   int find_in_str(char *find_str);
   int make_newlines_visible(void);
   int format_for_comm(char *the_string, int indent, int max_len);
   int format_for_actions(char *the_string, MudObject *the_user, 
                                                  Individual *the_target);
   int format_for_abilities(char *the_string, Player *the_player, 
                                                  MudObject *the_target);
   int swap_chars(char char1, char char2);

   int copy_lines(char *the_string, int lines);
   int del_lines(int lines);
   int sanitize_input();

   int operator = (char *x);
   int operator = (Strings *x); 
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

private:

   char *find_letter(char *the_str, int the_num);
   char *strmalloc(int the_length);

   char *str;  /* the actual btree database */
   unsigned int  length_alloc;

};

#endif







