#ifndef _VERB_H
#define _VERB_H

#include "mudtypes.h"
#include "entity.h"


struct verb_data {
   char     *verbname;
   int      verbformat;
   int      permissions;
   Cmd_Func verbcommands;
};

class Player;  

class Verb : public Entity {
 public:

   Verb();
   virtual ~Verb();
   Verb(char *verb_name);

   char *get_verb_str();
   int get_verb_format();
   int get_verb_comflag();
   void set_verb_format(int the_format);
   void set_verb_comflag(int the_comflag);
   void set_verb_command(Cmd_Func in_command);
   Cmd_Func get_command();
   int add_new_execute(long timespan);
   int display_data(Player *the_player);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();


 private:
 
   Strings the_verb;
   int format;
   int comflag;
   Cmd_Func the_command;  

   long num_executes;
   long max_execute;
   long min_execute;
   long avg_execute;   
};

#endif
