// Converter.cpp : implementation file
//

#include "stdafx.h"
#include "aime_w32.h"
#include "Converter.h"
#include "strings.h"
#include "global.h"
#include "../utils/converter/generator.h"
#include "../utils/converter/modules.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConverter dialog


CConverter::CConverter(CWnd* pParent /*=NULL*/)
	: CDialog(CConverter::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConverter)
	m_to_type = 0;
	m_file_to = _T("");
	m_file_from = _T("");
	m_file_type = _T("");
	//}}AFX_DATA_INIT
	m_file_type = "AIME Version 0.52-0.58";
	is_modal = FALSE;
}


void CConverter::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConverter)
	DDX_Radio(pDX, IDC_TO_TYPE, m_to_type);
	DDX_Text(pDX, IDC_FILE_TO, m_file_to);
	DDV_MaxChars(pDX, m_file_to, 200);
	DDX_Text(pDX, IDC_FILE_FROM, m_file_from);
	DDV_MaxChars(pDX, m_file_from, 200);
	DDX_CBString(pDX, IDC_FILE_TYPE, m_file_type);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConverter, CDialog)
	//{{AFX_MSG_MAP(CConverter)
	ON_BN_CLICKED(IDC_FILE1, OnFile1)
	ON_BN_CLICKED(IDC_FILE2, OnFile2)
	ON_BN_CLICKED(IDC_DOIT, OnDoit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConverter message handlers

void CConverter::OnFile1() 
{
	CFileDialog *dlg;
	char holder[200];
	int counter = 0;

	UpdateData(TRUE);
	dlg = new CFileDialog(TRUE, NULL, m_file_from, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
						  "AIME Data Files (*.area;*.dat;*.aime)|*.area;*.dat;*.aime|All Files (*.*)|*.*||");
	if (dlg->DoModal() == IDOK)
	{
		m_file_from = dlg->GetPathName();
		strncpy(holder, LPCTSTR(m_file_from), 199);
		while ((holder[counter] != '\0') && (holder[counter] != '.'))
			counter++;
		if (holder[counter] == '.')
			holder[counter] = '\0';
		
		if (m_file_to == "")
		{
			if (m_to_type == 0)
			{
				if (!strcmp(dlg->GetFileExt(), "dat"))
					strcat(holder, ".dat");
				else
					strcat(holder, ".area");
			}
			else
			{
				strcat(holder, ".aime");
			}
			m_file_to = holder;
		}
		UpdateData(FALSE);
	}
	delete dlg;
}

void CConverter::OnFile2() 
{
	CFileDialog *dlg;
	CString ext;

	UpdateData(TRUE);
	if (m_to_type == 0)
		ext = "area";
	else
		ext = "aime";

	dlg = new CFileDialog(FALSE, ext, m_file_to, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
						  "AIME Data Files (*.area;*.dat)|*.area;*.dat|Pseudo-Data Files (*.aime)|*.aime|All Files (*.*)|*.*||");
	if (dlg->DoModal() == IDOK)
	{
		m_file_to = dlg->GetPathName();
		UpdateData(FALSE);
	}
	delete dlg;	
}

void CConverter::OnDoit() 
{
	convert_indicated();
}

BOOL CConverter::has_large_header(CString filename)
{
	int loc_slash;
	while ((loc_slash = filename.Find('\\')) != -1)
		filename = filename.Right(filename.GetLength() - loc_slash - 1);
	filename = filename.Left(filename.Find('.'));

	if ((!filename.Compare("abilities")) ||
		(!filename.Compare("actions")) ||
		(!filename.Compare("races")) ||
		(!filename.Compare("levels")) ||
		(!filename.Compare("quests")) ||
		(!filename.Compare("masks")))
		return FALSE;

	return TRUE;
}

void CConverter::convert_indicated()
{
	FILE *read_file;
	FILE *write_file;
	CString holder;
	Strings p_filename;
	char *tmp_char;
	Generator *the_gen;
	int results;
	int start_pseudo = 0;  // if we are doing pseudo to aime convert
	char *ext = NULL;
	

	if (is_modal)
		UpdateData(TRUE);

	if ((m_file_from == "") || (m_file_to == ""))
	{
		AfxMessageBox("You must set the from and to file box to something.");
		return;
	}

	if (m_file_type == "Auto-Detect")
	{
		AfxMessageBox("AutoDetect not supported yet.  Please select another.");
		return;
	}

	// First we create the pseudo-data file from the read file, unless we are doing pseudo
	// to aime format, then we skip this step
	if ((read_file = fopen(LPCTSTR(m_file_from), "r")) == NULL)
	{
		holder.Format("Error, could not open read file:\n%s", m_file_from);
		AfxMessageBox(holder);
		return;
	}


	if (m_to_type == 1)
		p_filename = (char *) LPCTSTR(m_file_to);
	else
	{
		p_filename = (char *) LPCTSTR(m_file_from);
		tmp_char = p_filename.str_show();
		while ((tmp_char) && (*tmp_char != '\0') && (*tmp_char != '.'))
			tmp_char++;

		if (*tmp_char == '.')
		{
			*tmp_char = '\0';
			ext = tmp_char+1;

			// if this is already a pseudo-code file
			if (!strcmp(ext, "aime"))
				start_pseudo = 1;
		}

		p_filename.str_cat(".aime");
	}

	if (!start_pseudo)
	{
		// First we generate the pseudo-data file
		if (convert_file(read_file, p_filename.str_show(), (char *) LPCTSTR(m_file_type), (char *) LPCTSTR(m_file_from)) <= 0)
		{
			AfxMessageBox("Failed converting file.");
			fclose(read_file);
			return;
		}

		// Next, if they wanted a full convert, convert the pseudo-data file to AIME data
		fclose(read_file);

		if (m_to_type == 0)
		{
		   if ((read_file = fopen(LPCTSTR(p_filename.str_show()), "r")) == NULL)
		   {
		 	   holder.Format("Error, could not open pseudo-data file:\n%s", m_file_from);
			   AfxMessageBox(holder);
			   return;
		   }
		}
	}

	if (m_to_type == 0)
	{
		if ((write_file = fopen(LPCTSTR(m_file_to), "w+")) == NULL)
		{
			if (start_pseudo)
				AfxMessageBox("Failed trying to generate AIME data file.");
			else
				AfxMessageBox("Pseudo-data file successfully Generated, "
				          "but failed trying to generate AIME data file.");
			fclose(write_file);
			return;
		}
		the_gen = new Generator(write_file, has_large_header(m_file_to));
		
		while ((results = the_gen->generate_element(read_file)) > 0);

		if (results == -1)
		{
			if (start_pseudo)
				AfxMessageBox("Failed trying to generate AIME data file.");
			else
				AfxMessageBox("Pseudo-data file successfully Generated, "
				          "but failed trying to generate AIME data file.");
			fclose(write_file);
			return;
		}
		AfxMessageBox("Conversion successfully completed.");
	}
	else
		AfxMessageBox("Pseudo-Data file successfully generated.");

	if (m_to_type == 0)
		fclose(write_file);

	if (mainstruct != NULL)
		mainstruct->unlock_bootstrap();
	delete the_gen;
}

int CConverter::DoModal() 
{
	// TODO: Add your specialized code here and/or call the base class
	is_modal = TRUE;
	return CDialog::DoModal();
}
