//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_DIALOGS_QUESTIONDIALOG_H
#define GUI_DIALOGS_QUESTIONDIALOG_H

//--------------------
//forward delcarations
class QGridLayout;
class QLabel;
class QTextEdit;
class QPushButton;
class QPixmap;
class QFrame;
//--------------------

#include <qdialog.h>

//=====================================
/*! \brief A configurable question dialog that returns true/false
 */
//=====================================

class QuestionDialog : public QDialog
{
Q_OBJECT
//----------------------
public:
  ///Basic constructor
  QuestionDialog( QString question,
                  QString message,
                  QString questionIconName,
                  QWidget *parent=0,
                  const char* name=0);

  ///Destructor
  ~QuestionDialog();
//----------------------
private:
  ///Grids objects placed in
  QGridLayout *gridTop, *gridBottom, *gridFull;

  ///Question displayed in window
  QLabel* questionText;

  ///Message displayed in window
  QTextEdit* messageText;

  ///Ok button
  QPushButton* okButton;

  ///Cancel button
  QPushButton* cancelButton;

  ///Question icon
  QPixmap* questionIcon;

  ///Label which shows question icon
  QLabel* questionIconLabel;

  ///Top and bottom frames
  QFrame *topFrame, *bottomFrame;
//----------------------
};
//======================

#endif //GUI_DIALOGS_QUESTIONDIALOG_H
