// ---------------------------------------------------------------------------
// - Literal.cpp                                                             -
// - standard object library - literal class implementation                  -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Vector.hpp"
#include "String.hpp"

namespace aleph {

  // the literal supported quarks
  static const long QUARK_TOSTRING  = String::intern ("to-string");
  static const long QUARK_TOLITERAL = String::intern ("to-literal");

  // apply this literal with a set of arguments and a quark

  Object* Literal::apply (Runnable* robj, Nameset* nset, const long quark,
			  Vector* argv) {
    // get the number of arguments
    long argc = (argv == nilp) ? 0 : argv->length ();

    // dispatch 0 argument
    if (argc == 0) {
      if (quark == QUARK_TOSTRING)  return new String (tostring  ());
      if (quark == QUARK_TOLITERAL) return new String (toliteral ());
    }

    // call the object method
    return Object::apply (robj, nset, quark, argv);
  }
}
