// ---------------------------------------------------------------------------
// - t_bitset.cpp                                                            -
// - standard object library - bitset class tester                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "BitSet.hpp"

int main (int, char**) {
  using namespace aleph;

  // create a new bitset
  BitSet bs (256);

  // random check first
  if (bs.get (1) == true) return 1;
  bs.mark (1);
  if (bs.get (1) == false) return 1;
  bs.clear (1);
  if (bs.get (1) == true) return 1;

  // check for 0 mark
  for (long i = 0; i < 256; i++)
    if (bs.get (i) == true) return 1;

  // mark to 1
  for (long i = 0; i < 256; i++) bs.mark (i);
  for (long i = 0; i < 256; i++) 
    if (bs.get (i) == false) return 1;

  // clear and check
  for (long i = 0; i < 256; i++) bs.clear (i);
  for (long i = 0; i < 256; i++) 
    if (bs.get (i) == true) return 1;

  // done
  return 0;
}
