/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2002-2003 by Synge Todo <wistaria@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: fixed_capacity_traits.C,v 1.3 2004/03/16 15:12:30 wistaria Exp $ */

#include <alps/fixed_capacity_traits.h>
#include <alps/fixed_capacity_vector.h>

#include <iostream>
#include <list>
#include <queue>
#include <stack>
#include <vector>

template<class T>
class capacity_checker
{
public:
  capacity_checker() {
    output<T, alps::fixed_capacity_traits<T>::capacity_is_fixed>();
  }

private:
  template<class U, bool B> struct output;
  template<class U> struct output<U, true> {
    output() {
      std::cout << "capacity is fixed (static_max_size = "
                << alps::fixed_capacity_traits<U>::static_max_size << ")\n";
    }
  };
  template<class U> struct output<U, false> {
    output() { std::cout << "capacity is not fixed\n"; }
  };

}; // capacity_checker


int main()
{
  std::cout << "T = std::vector<int>\n";
  capacity_checker<std::vector<int> >();
  std::cout << std::endl;

  std::cout << "T = std::list<int>\n";
  capacity_checker<std::list<int> >();
  std::cout << std::endl;

  std::cout << "T = alps::fixed_capacity_vector<int,8>\n";
  capacity_checker<alps::fixed_capacity_vector<int,8> >();
  std::cout << std::endl;

  std::cout << "T = alps::fixed_capacity_deque<int,8>\n";
  capacity_checker<alps::fixed_capacity_deque<int,8> >();
  std::cout << std::endl;

  std::cout << "T = std::stack<int, alps::fixed_capacity_vector<int,4> >\n";
  capacity_checker<std::stack<int, alps::fixed_capacity_vector<int,4> > >();
  std::cout << std::endl;

  std::cout << "T = std::stack<int>\n";
  capacity_checker<std::stack<int> >();
  std::cout << std::endl;

  std::cout << "T = std::queue<int, alps::fixed_capacity_deque<int,6> >\n";
  capacity_checker<std::queue<int, alps::fixed_capacity_deque<int,6> > >();
  std::cout << std::endl;

  std::cout << "T = std::queue<int>\n";
  capacity_checker<std::queue<int> >();
  std::cout << std::endl;

  std::cout 
    << "T = std::priority_queue<int, alps::fixed_capacity_vector<int,16> >\n";
  capacity_checker<std::priority_queue<int, 
    alps::fixed_capacity_vector<int,16> > >();
  std::cout << std::endl;

  std::cout << "T = std::priority_queue<int>\n";
  capacity_checker<std::priority_queue<int> >();
  std::cout << std::endl;

  std::cout << "T = double\n";
  capacity_checker<double>();

  return 0;
}
