//
//  load_config.cpp -- implementation of the functions to load the config file
//  -- created 4/20/00  updated 5/9/00
////////////////////////////////////////////////////////////

#include "load_config.h"

extern Althea gAlthea;

//  The master function that loads the configuration file into memory
int load_Althea()
{
	string upper_string, name, smtp, imap, port, username, password, folder_root, fccfolder, field, filter_string, folder,emailaddress, extra_string, other_string;
	char  *home_directory;
	ifstream local_config_in, rc_config_in;
	config_command command;
	char accelerator;
	keystrokes key;
	bool done = 0;
	Configuration *newconfig = new Configuration();
	gAlthea.set_config(newconfig);

	bool savepassword=1, usessl=0;

	//  Get the environment variable HOME, this is POSIX and Windows Compliant
	home_directory=(char *)malloc(255);
	strcpy(home_directory,getenv ("HOME"));
	strcat(home_directory, "/");
	strcat(home_directory, LOCAL_CONFIG_FILE); 
		
	local_config_in.open(home_directory);
	free(home_directory);
	rc_config_in.open(RC_CONFIG_FILE);
	

	// If we do not have a config file in either /etc or home directory
	if ((local_config_in == NULL) && (rc_config_in == NULL) )
	{
		// Taking the next line out since we have a GUI config window
//		error ("No configuration file in home directory or /etc");

		// display the welcome message
		GtkWidget *register_window;
		register_window = create_register_window();
	        gtk_widget_show( register_window );

		return 1;
	}

	//  First load in rc configuration

	if (!(rc_config_in == NULL))
	{
	while (!done)
	{
		// NOTE:  After every read I check to see if we are "done" and then break if done
		//	There must be a better way to do this but I'm blanking.


		if (done)
			break;
		// Get the first < sign, skipping comment lines
		cfg_read_til_lessthan(&rc_config_in, &done);

		if (done)
			break;
		
		// Read the command
		upper_string = *new string();
		upper_string = cfg_read_til_greaterthan(&rc_config_in, &done);

		if (done)
			break;
		
		// Make the string upper case
		upper_string = string_to_upper(upper_string);
		
		// Make the string into a command
		command = convert_upper_to_command (upper_string);
			
		switch (command) 
		{
			case CHECK_MAIL_KEY:
				// Default is c
				key = CHECK_MAIL;
				accelerator = 'c';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case DELETE_MESSAGE_KEY:
				// Default is d
				key = DELETE_MESSAGE;
				accelerator = 'd';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case FORWARD_MESSAGE_KEY:
				// Default is f
				key = FORWARD_MESSAGE;
				accelerator = 'f';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case COMPOSE_MESSAGE_KEY:
				// Default is m
				key = COMPOSE_MESSAGE;
				accelerator = 'm';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case PRINT_MESSAGE_KEY:
				// Default is p
				key = PRINT_MESSAGE;
				accelerator = 'p';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case QUIT_ALTHEA_KEY:
				// Default is q
				key = QUIT_ALTHEA;
				accelerator = 'q';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case REPLY_MESSAGE_KEY:
				// Default is r
				key = REPLY_MESSAGE;
				accelerator = 'r';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case SAVE_MESSAGE_KEY:
				// Default is s
				key = SAVE_MESSAGE;
				accelerator = 's';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case SEND_MESSAGE_KEY:
				// Default is s
				key = SEND_MESSAGE;
				accelerator = 's';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case ATTACH_FILE_KEY:
				// Default is f
				key = ATTACH_FILE;
				accelerator = 'f';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case CLOSE_MESSAGE_KEY:
				// Default is c
				key = CLOSE_MESSAGE;
				accelerator = 'c';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&rc_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&rc_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
			case SERVER:
				// Load in defaults
			  	savepassword=1;
				usessl=0;
				name = "Untitled Server";
				port = "143";
				folder_root = "~/mail";
				fccfolder = "sent-mail";
				smtp = "localhost";
				emailaddress="";
				// Read the inside of <Server> directive for needed stuff
				if (read_Server_XML(&rc_config_in, &name, &smtp, &imap, &port, &username, &password, &folder_root, &fccfolder,&emailaddress, &done,&savepassword,&usessl)) {
				// Put the Server in our data structure
				  load_Server(name, smtp, imap, port, username, password, folder_root, fccfolder,emailaddress,savepassword,usessl);
				}
				if (gAlthea.get_Verbose())
                        	cout << "Server loaded" << endl;
                        break;
                        
                 	case FILTER:
				read_Filter_XML(&rc_config_in, &field, &filter_string, &folder, &done);
				Filter *F;
				F = new Filter( field, filter_string, folder );
				gAlthea.add_Filter( *F );
			    break;   
			default:
				break;       		
                 };
	}  // end of big while 1
	rc_config_in.close();
	}  // end of big if
	
	//  Second, load in local configuration

	if (!(local_config_in == NULL))
	{
	while (!done)
	{
		// NOTE:  After every read I check to see if we are "done" and then break if done
		//	There must be a better way to do this but I'm blanking.

		if (done)
			break;
		// Get the first < sign, skipping comment lines
		cfg_read_til_lessthan(&local_config_in, &done);

		if (done)
			break;
		
		// Read the command
		upper_string = *new string();
		upper_string = cfg_read_til_greaterthan(&local_config_in, &done);

		if (done)
			break;
		
		// Make the string upper case
		upper_string = string_to_upper(upper_string);
		
		// Make the string into a command
		command = convert_upper_to_command (upper_string);
			
		switch (command) 
		{
			case CHECK_MAIL_KEY:
				// Default is c
				key = CHECK_MAIL;
				accelerator = 'c';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case DELETE_MESSAGE_KEY:
				// Default is d
				key = DELETE_MESSAGE;
				accelerator = 'd';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case FORWARD_MESSAGE_KEY:
				// Default is f
				key = FORWARD_MESSAGE;
				accelerator = 'f';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case COMPOSE_MESSAGE_KEY:
				// Default is m
				key = COMPOSE_MESSAGE;
				accelerator = 'm';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case PRINT_MESSAGE_KEY:
				// Default is p
				key = PRINT_MESSAGE;
				accelerator = 'p';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case QUIT_ALTHEA_KEY:
				// Default is q
				key = QUIT_ALTHEA;
				accelerator = 'q';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case REPLY_MESSAGE_KEY:
				// Default is r
				key = REPLY_MESSAGE;
				accelerator = 'r';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case SAVE_MESSAGE_KEY:
				// Default is s
				key = SAVE_MESSAGE;
				accelerator = 's';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case SEND_MESSAGE_KEY:
				// Default is s
				key = SEND_MESSAGE;
				accelerator = 's';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case ATTACH_FILE_KEY:
				// Default is f
				key = ATTACH_FILE;
				accelerator = 'f';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
                    case CLOSE_MESSAGE_KEY:
				// Default is c
				key = CLOSE_MESSAGE;
				accelerator = 'c';
				other_string = *new string();
				
				// Read the inside of the directive for needed stuff
				extra_string = cfg_read_til_lessthanslash(&local_config_in, &done);
				if (done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(&local_config_in, &done);
				if (done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
				if (isalpha(other_string[0]))
				{
					accelerator = extra_string[0];
					load_Keystroke(key, accelerator);
				}
					
                        break;
			case SERVER:
				// Load in defaults
				name = "Untitled Server";
				port = "143";
				folder_root = "~/mail";
				fccfolder = "sent-mail";
				smtp = "localhost";
				emailaddress="";
			  	savepassword=1;
				usessl=0;
				

				// Read the inside of <Server> directive for needed stuff
				if (read_Server_XML(&local_config_in, &name, &smtp, &imap, &port, &username, &password, &folder_root, &fccfolder,&emailaddress, &done,&savepassword,&usessl)) {
				// Put the Server in our data structure
                    	load_Server(name, smtp, imap, port, username, password, folder_root, fccfolder,emailaddress,savepassword,usessl);
				}
				if (gAlthea.get_Verbose())
                        	cout << "Server loaded" << endl;
                        break;
                        
                 	case FILTER:
				read_Filter_XML(&local_config_in, &field, &filter_string, &folder, &done);
				Filter *F;
				F = new Filter( field, filter_string, folder );
				gAlthea.add_Filter( *F );
			    break;  
			default:
				break;        		
                 };
	}  // end of big while 1
	local_config_in.close();
	} // end of big if
	return 0;
}

// Other functions that will be used to load things into the data structure
void load_Server(const string & name, const string & smtp, const string & imap, const string & port, const string & username, const string & password, const string & folder_root, string & fccfolder, string & emailaddress, bool savepassword, bool usessl )
{
	Server *S;

	int newport;
	newport = atoi(port.c_str());
	S = new Server( name, smtp, imap, newport, username, password, folder_root, fccfolder, emailaddress );
	S->set_Save_Password(savepassword);
	S->set_Use_SSL(usessl);
	gAlthea.add_Server( *S );

	get_mail(S);


}

/*void load_Filter(const string & field, const string & filter_string, const string & folder)
{





}
*/

void load_Expert_Mode(int expert)
{
	Configuration *temp_config = gAlthea.get_config();
	if (expert)
		temp_config->set_expert_mode();
	else
		temp_config->set_beginner_mode();
}

config_command convert_upper_to_command(const string & upper_string)
{
	if (upper_string == "SERVER")
		return SERVER;
	if (upper_string == "/SERVER")
		return SLASHSERVER;
	if (upper_string == "EXPERT")
		return EXPERT;
	if (upper_string == "CACHE")
		return CACHE;
	if (upper_string == "FILTER")
	        return FILTER;
	if (upper_string == "/FILTER")
		return SLASHFILTER;
	if (upper_string == "NAME")
	        return NAME;
	if (upper_string == "SMTPSERVER")
	        return SMTPSERVER;
	if (upper_string == "IMAPSERVER")
	        return IMAPSERVER;
	if (upper_string == "IMAPPORT")
	        return IMAPPORT;	 
	if (upper_string == "USERNAME")
		return USERNAME;
	if (upper_string == "PASSWORD")
		return PASSWORD;
	if (upper_string == "CRYPTPASSWORD")
		return CRYPTPASSWORD;
	if (upper_string == "EMAILADDRESS")
		return EMAILADDRESS;
	if (upper_string == "MAILBOX")
		return MAILBOX;
	if (upper_string == "FCCFOLDER")
		return FCCFOLDER;	
	if (upper_string == "SAVEPASSWORD")
		return SAVEPASSWORD;	
	if (upper_string == "USESSL")
		return USESSL;	
	if (upper_string == "FIELD")
		return FIELD;	
	if (upper_string == "FILTERSTRING")
		return FILTERSTRING;	
	if (upper_string == "FILTERFOLDER")
		return FILTERFOLDER;	
	if (upper_string == "CHECK_MAIL_KEY")
		return CHECK_MAIL_KEY;	
	if (upper_string == "DELETE_MESSAGE_KEY")
		return DELETE_MESSAGE_KEY;
	if (upper_string == "FORWARD_MESSAGE_KEY")
		return FORWARD_MESSAGE_KEY;
	if (upper_string == "COMPOSE_MESSAGE_KEY")
		return COMPOSE_MESSAGE_KEY;
	if (upper_string == "PRINT_MESSAGE_KEY")
		return PRINT_MESSAGE_KEY;
	if (upper_string == "QUIT_ALTHEA_KEY")
		return QUIT_ALTHEA_KEY;
	if (upper_string == "REPLY_MESSAGE_KEY")
		return REPLY_MESSAGE_KEY;
	if (upper_string == "SAVE_MESSAGE_KEY")
		return SAVE_MESSAGE_KEY;
	if (upper_string == "SEND_MESSAGE_KEY")
		return SEND_MESSAGE_KEY;
	if (upper_string == "ATTACH_FILE_KEY")
		return ATTACH_FILE_KEY;
	if (upper_string == "CLOSE_MESSAGE_KEY")
		return CLOSE_MESSAGE_KEY;
	return NOCOMMAND;
}
void load_Cache (int cache)
{
}

void load_Keystroke(keystrokes key, char accelerator)
{
	gAlthea.get_config()->set_key_accelerator(key, accelerator);
}
// cfg_read_til_lessthan
// Preconditions:  config_in has been opened
// Postconditions:  We have read the file until we come to the first lessthan sign.
//	If we come up against the end of file, we set the variable done to 1 and return immediately.
//	Ignore lines that begin with #.  They are comments.
// Return:  What we read in until the lessthan sign.
string cfg_read_til_lessthan(ifstream *config_in, bool *done)
{
	char c;
	string temp = *new string();
	
	if (!(config_in->get(c)))
	{
		*done = true;
		return temp;
	}
	while(c != '<')
	{
		if (c == '#')
		{
			// Ignore the line (or rest of line), it is a comment
			while (c != '\n') 
				if (!(config_in->get(c)))
				{
					*done = true;
					return temp;
				}
		}
		else 
		{
			temp += c;
			if (!(config_in->get(c)))
			{
				*done = true;
				return temp;
			}
		}
	} // Done the while loop
	return temp;
}

// cfg_read_til_lessthanslash
// Preconditions:  config_in has been opened
// Postconditions:  We have read the file until we come to the first occurance of lessthanslash.
//	If we come up against the end of file, we set the variable done to 1 and return immediately
//	Ignore lines that begin with #.  They are comments..
// Return:  What we read in until the lessthanslash.
string cfg_read_til_lessthanslash(ifstream *config_in, bool *done)
{
	char c;
	bool local_done = 0;
	string temp = *new string();
	
	if (!(config_in->get(c)))
	{
		*done = true;
		return temp;
	}
	
	while (!local_done)
	{
		while(c != '<')
		{
			if (c == '#')
			{
				// Ignore the line (or rest of line), it is a comment
				while (c != '\n') 
					if (!(config_in->get(c)))
					{
						*done = true;
						return temp;
					}
			}
			else 
			{
				temp += c;
				if (!(config_in->get(c)))
				{
					*done = true;
					return temp;
				}
			}
		} // Done the while c loop
		if (config_in->get(c))
		{
			if (c == '/')
			{
				local_done = true;
			}
		}
		else
		{
			*done = true;
			return temp;
		}
	} // End the local done while loop
	return temp;
}

// cfg_read_til_greaterthan
// Preconditions:  config_in has been opened
// Postconditions:  We have read the file until we come to the first greaterthan sign.
//	If we come up against the end of file, we set the variable done to 1 and return immediately.
//	Ignore lines that begin with #.  They are comments.
// Return:  What we read in until the greaterthan sign.
string cfg_read_til_greaterthan(ifstream *config_in, bool *done)
{
	char c;
	string temp = *new string();
	
	if (!(config_in->get(c)))
	{
		*done = true;
		return temp;
	}
	while(c != '>')
	{
		if (c == '#')
		{
			// Ignore the line (or rest of line), it is a comment
			while (c != '\n') 
				if (!(config_in->get(c)))
				{
					*done = true;
					return temp;
				}
		}
		else 
		{
			temp += c;
			if (!(config_in->get(c)))
			{
				*done = true;
				return temp;
			}
		}
	} // Done the while loop
	return temp;

}

// string_to_upper
// Preconditions:  The upper_string exists and consists of letters only
// Postconditions:
// Return:  The string in upper case letters.
string string_to_upper(string upper_string)
{
	string temp = *new string();
	unsigned int counter;
	
	for (counter = 0; counter < upper_string.size(); counter++)
	{
		temp += toupper(upper_string[counter]);
	}
	return temp;
}

// read_Server_XML
// Preconditions:  config_in has been opened
// Postconditions:  We have read the config_in until the </Server> directive and placed
//	everything in between into the respective referenced variables
bool read_Server_XML(ifstream *config_in, string *name, string *smtp, string *imap, string *port, 
string *username, string *password, string *folder_root, string *fccfolder, string *emailaddress, bool *done, bool *savepassword,bool *usessl)
{


        bool gotpassword=false;
	bool local_done = 0;
	string upper_string, data, other_string;
	config_command command;
	
	while (!local_done)
	{
		if (*done)
			break;
		// Get the first < sign, skipping comment lines
		upper_string = cfg_read_til_lessthan(config_in, done);

		if (*done)
			break;
		
		// Read the command
		upper_string = *new string();
		upper_string = cfg_read_til_greaterthan(config_in, done);

		if (*done)
			break;
		
		// Make the string upper case
		upper_string = string_to_upper(upper_string);
		
		// Make the string into a command
		command = convert_upper_to_command (upper_string);
		string depassword;			
		switch (command) 
		{
			case NAME:
				
				// Read the inside of the directive for needed stuff
				*name = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
                        break;
                        
                 	case SMTPSERVER:
				
				// Read the inside of the directive for needed stuff
				*smtp = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.\n");
					return true;
				}
                        break;
                 	
                 	case IMAPSERVER:
				
				// Read the inside of the directive for needed stuff
				*imap = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
                        break;
                 
                 	case IMAPPORT:
				
				// Read the inside of the directive for needed stuff
				*port = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
                        break;
                     
                 	case USERNAME:
                 					
				// Read the inside of the directive for needed stuff
				*username = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
                        break;
                        case PASSWORD:
   			        gotpassword=true;
				// Read the inside of the directive for needed stuff
				*password = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
                        break;
                        case CRYPTPASSWORD:
			        gotpassword=true;
				// Read the inside of the directive for needed stuff
				*password = cfg_read_til_lessthanslash(config_in, done);
			        depassword=AltheaDecrypt(*password);
				
				*password=depassword;
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{
					error("Config file is not in proper format.");
					return true;
				}
                        break;
		        case EMAILADDRESS:
		  
				// Read the inside of the directive for needed stuff
				*emailaddress = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{

					error("Config file is not in proper format.");
					return true;
				}
                        break;
                        
                 	case MAILBOX:
				
				// Read the inside of the directive for needed stuff
				*folder_root = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				if (other_string != upper_string)
				{

					error("Config file is not in proper format.");
					return true;
				}
                        break;
                        
                 	case FCCFOLDER:
				
				// Read the inside of the directive for needed stuff
				*fccfolder = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{

					error("Config file is not in proper format.");
					return true;
				}
                        break;

                 	case SAVEPASSWORD:
				
				// Read the inside of the directive for needed stuff
				*savepassword = atoi(cfg_read_til_lessthanslash(config_in, done).c_str());
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{

					error("Config file is not in proper format.");
					return true;
				}
                        break;
                 	case USESSL:
				
				// Read the inside of the directive for needed stuff
				*usessl = atoi(cfg_read_til_lessthanslash(config_in, done).c_str());
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{

					error("Config file is not in proper format.");
					return true;
				}
                        break;
                        
                 	case SLASHSERVER:
                 		local_done = true;
                 		break;
			default:
				break;
                 };
	}  // end of big while 1

	if (!gotpassword) {
	  other_server_info *other_info=new other_server_info;
	  other_info->name=*name;
	  other_info->smtp=*smtp;
	  other_info->imap=*imap;
	  other_info->port=*port;
	  other_info->username=*username;
	  other_info->folder_root=*folder_root;
	  other_info->fccfolder=*fccfolder;
	  other_info->emailaddress=*emailaddress;
	  other_info->savepassword=*savepassword;
	  other_info->usessl=*usessl;
	  GtkWidget *promptwindow=create_promptwindow(other_info);
	  gAlthea.promptwindows.push_front(promptwindow);
	  gtk_widget_show( promptwindow );
	  return false;
	} else {
	  return true;
	}
	  

}

// read_Filter_XML
// Preconditions:  config_in has been opened
// Postconditions:  We have read the config_in until the </Filter> directive and placed
//	everything in between into the respective referenced variables
void read_Filter_XML(ifstream *config_in, string *field, string *filter_string, string *folder, bool *done)
{

	bool local_done = 0;
	string upper_string, data, other_string;
	config_command command;
	
	while (!local_done)
	{
		if (*done)
			break;
		// Get the first < sign, skipping comment lines
		upper_string = cfg_read_til_lessthan(config_in, done);

		if (*done)
			break;
		
		// Read the command
		upper_string = *new string();
		upper_string = cfg_read_til_greaterthan(config_in, done);

		if (*done)
			break;
		
		// Make the string upper case
		upper_string = string_to_upper(upper_string);
		
		// Make the string into a command
		command = convert_upper_to_command (upper_string);
			
		switch (command) 
		{
			case FIELD:
				
				// Read the inside of the directive for needed stuff
				*field = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{

					error("Config file is not in proper format.");
					return;
				}
                        break;
                        
                 	case FILTERSTRING:
				
				// Read the inside of the directive for needed stuff
				*filter_string = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{

					error("Config file is not in proper format.");
					return;
				}
                        break;
                 	
                 	case FILTERFOLDER:
				
				// Read the inside of the directive for needed stuff
				*folder = cfg_read_til_lessthanslash(config_in, done);
				if (*done)
					break;
					
				// Read the rest of the directive
				other_string = cfg_read_til_greaterthan(config_in, done);
				if (*done)
					break;
				// Make the string to upper
				other_string = string_to_upper(other_string);
				
				// Compare it to the original string (upper_string) to make
				// sure the file is in the correct format
				
				if (other_string != upper_string)
				{

					error("Config file is not in proper format.");
					return;
				}
                        break;
                 
                 	case SLASHFILTER:
                 		local_done = true;
                 		break;
			default:
				break;
                 };
	}  // end of big while 1
}
