# G.3 Is "anarcho"-capitalism a new form of individualist anarchism?

No. As Carole Pateman once pointed out, _"[t]here has always been a strong
radical individualist tradition in the USA. Its adherents have been divided
between those who drew anarchist, egalitarian conclusions, and those who
reduced political life to the capitalist economy writ large, to a series of
exchanges between unequally situated individuals."_ [**The Problem of
Political Obligation**, p. 205] What right-"libertarians" and
"anarcho"-capitalists do is to confuse these two traditions, ignoring
fundamental aspects of individualist anarchism in order to do so. Thus
anarchist Peter Sabatini:

> _"in those rare moments when [Murray] Rothbard (or any other [right-wing]
Libertarian) does draw upon individualist anarchism, he is always highly
selective about what he pulls out. Most of the doctrine's core principles,
being decidedly anti-Libertarianism, are conveniently ignored, and so what
remains is shrill anti-statism conjoined to a vacuous freedom in hackneyed
defence of capitalism. In sum, the 'anarchy' of Libertarianism reduces to a
liberal fraud."_ [**Libertarianism: Bogus Anarchy**]

As class struggle anarchist Benjamin Franks notes, individualist anarchism
_"has similarities with, but is not identical to, anarcho-capitalism."_
[**Rebel Alliances**, p. 44] For Colin Ward, while the _"mainstream"_ of
anarchist propaganda _"has been **anarchist-communism**"_ there are _"several
traditions of **individualist anarchism**"_, including that associated with
Max Stirner and _"a remarkable series of 19th-century American figures"_ who
_"differed from free-market liberals in their absolute mistrust of American
capitalism, and in their emphasis on mutualism."_ Ward was careful to note
that by the _"late 20th century the word 'libertarian' . . . was appropriated
by a new group of American thinkers"_ and so _"it is necessary to examine the
modern individualist 'libertarian' response from the standpoint of the
anarchist tradition."_ It was found to be wanting, for while Rothbard was
_"the most aware of the actual anarchist tradition among the anarcho-
capitalist apologists"_ he may have been _"aware of a tradition, but he is
singularly unaware of the old proverb that freedom for the pike means death
for the minnow."_ The individualist anarchists were _"busy social inventors
exploring the potential of autonomy."_ The _"American 'libertarians' of the
20th century are academics rather than social activists, and their
inventiveness seems to be limited to providing an ideology for untrammelled
market capitalism."_ [**Anarchism: A Short Introduction**, pp. 2-3, p. 62, p.
67, and p. 69]

In this section we will sketch these differences between the genuine
libertarian ideas of Individualist Anarchism and the bogus "anarchism" of
right-"libertarian" ideology. This discussion builds upon our general critique
of "anarcho"-capitalism we presented in [section F](secFcon.html). However,
here we will concentrate on presenting individualist anarchist analysis of
"anarcho"-capitalist positions rather than, as before, mostly social anarchist
ones (although, of course, there are significant overlaps and similarities).
In this way, we can show the fundamental differences between the two theories
for while there are often great differences between specific individualist
anarchist thinkers all share a vision of a free society distinctly at odds
with the capitalism of their time as well as the "pure" system of economic
textbooks and right-"libertarian" dreams (which, ironically, so often reflects
the 19th century capitalism the individualist anarchists were fighting).

First it should be noted that some "anarcho"-capitalists shy away from the
term, preferring such expressions as "market anarchist" or "individualist
anarchist." This suggests that there is some link between their ideology and
that of Tucker and his comrades. However, the founder of "anarcho"-capitalism,
Murray Rothbard, refused that label for, while _"strongly tempted,"_ he could
not do so because _"Spooner and Tucker have in a sense pre-empted that name
for their doctrine and that from that doctrine I have certain differences."_
Somewhat incredibly Rothbard argued that on the whole politically _"these
differences are minor,"_ economically _"the differences are substantial, and
this means that my view of the consequences of putting our more of less common
system into practice is very far from theirs."_ [_"The Spooner-Tucker
Doctrine: An Economist's View"_, pp. 5-15, **Journal of Libertarian Studies**,
vol. 20, no. 1, p. 7]

What an understatement! Individualist anarchists advocated an economic system
in which there would have been very little inequality of wealth and so of
power (and the accumulation of capital would have been minimal without profit,
interest and rent). Removing this social and economic basis would result in
**substantially** different political regimes. In other words, politics is not
isolated from economics. As anarchist David Wieck put it, Rothbard _"writes of
society as though some part of it (government) can be extracted and replaced
by another arrangement while other things go on as before, and he constructs a
system of police and judicial power without any consideration of the influence
of historical and economic context."_ [**Anarchist Justice**, p. 227]

Unsurprisingly, the political differences he highlights **are** significant,
namely _"the role of law and the jury system"_ and _"the land question."_ The
former difference relates to the fact that the individualist anarchists
_"allow[ed] each individual free-market court, and more specifically, each
free-market jury, totally free rein over judicial decision."_ This horrified
Rothbard. The reason is obvious, as it allows real people to judge the law as
well as the facts, modifying the former as society changes and evolves. For
Rothbard, the idea that ordinary people should have a say in the law is
dismissed. Rather, _"it would not be a very difficult task for Libertarian
lawyers and jurists to arrive at a rational and objective code of libertarian
legal principles and procedures."_ [**Op. Cit.**, pp. 7-8] Of course, the fact
that _"lawyers"_ and _"jurists"_ may have a radically different idea of what
is just than those subject to their laws is not raised by Rothbard, never mind
answered. While Rothbard notes that juries may defend the people against the
state, the notion that they may defend the people against the authority and
power of the rich is not even raised. That is why the rich have tended to
oppose juries as well as popular assemblies. Unsurprisingly, as we indicated
in [section F.6.1](secF6.html#secf61), Rothbard wanted laws to be made by
judges, lawyers, jurists and other "libertarian" experts rather than jury
judged and driven. In other words, to exclude the general population from any
say in the law and how it changes. This hardly a _"minor"_ difference! It is
like a supporter of the state saying that it is a _"minor"_ difference if you
favour a dictatorship rather than a democratically elected government. As
Tucker argued, _"it is precisely in the tempering of the rigidity of
enforcement that one of the chief excellences of Anarchism consists . . .
under Anarchism all rules and laws will be little more than suggestions for
the guidance of juries, and that all disputes . . . will be submitted to
juries which will judge not only the facts but the law, the justice of the
law, its applicability to the given circumstances, and the penalty or damage
to be inflicted because of its infraction . . . under Anarchism the law . . .
will be regarded as **just** in proportion to its flexibility, instead of now
in proportion to its rigidity."_ [**The Individualist Anarchists**, pp. 160-1]
In others, the law will evolve to take into account changing social
circumstances and, as a consequence, public opinion on specific events and
rights. Tucker's position is fundamentally **democratic** and evolutionary
while Rothbard's is autocratic and fossilised.

This is particularly the case if you are proposing an economic system that is
based on inequalities of wealth, power and influence and the means of
accumulating more. As we note in [section G.3.3](secG3.html#secg33), one of
the few individualist anarchists that remained pointed this out and opposed
Rothbard's arguments. As such, while Rothbard may have subscribed to a system
of competing defence companies like Tucker, he expected them to operate in a
substantially different legal system, enforcing different (capitalist)
property rights and within a radically different socio-economic system. These
differences are hardly _"minor"_. As such, to claim that "anarcho"-capitalism
is simply individualist anarchism with "Austrian" economics shows an utter
lack of understanding of what individualist anarchism stood and aimed for.

On the land question, Rothbard opposed the individualist position of
_"occupancy and use"_ as it _"would automatically abolish all rent payments
for land."_ Which was precisely **why** the individualist anarchists advocated
it! In a predominantly rural economy, as was the case during most of the 19th
century in America, this would result in a significant levelling of income and
social power as well as bolstering the bargaining position of non-land workers
by reducing the numbers forced onto the labour market (which, as we note in
[section F.8.5](secF8.html#secf85), was the rationale for the state enforcing
the land monopoly in the first place). He bemoans that landlords cannot charge
rent on their _"justly-acquired private property"_ without noticing that is
begging the question as anarchists deny that this is _"justly-acquired"_ land
in the first place. Unsurprisingly, Rothbard considered _"the proper theory of
justice in landed property can be found in John Locke"_, ignoring the awkward
fact that the first self-proclaimed anarchist book was written **precisely**
to refute that kind of theory and expose its anti-libertarian implications.
His argument simply shows how far from anarchism his ideology is. For
Rothbard, it goes without saying that the landlord's _"freedom of contract"_
tops the worker's freedom to control their own work and live and, of course,
their right to life. [**Op. Cit.**, p. 8 and p. 9]

For anarchists, _"the land is indispensable to our existence, consequently a
common thing, consequently insusceptible of appropriation."_ [Proudhon, **What
is Property?**, p. 107] Tucker looked forward to a time when capitalist
property rights in land were ended and _"the Anarchistic view that occupancy
and use should condition and limit landholding becomes the prevailing view."_
This _"does not simply mean the freeing of unoccupied land. It means the
freeing of all land not occupied **by the owner**"_ and _"tenants would not be
forced to pay you rent, nor would you be allowed to seize their property. The
Anarchic associations would look upon your tenants very much as they would
look upon your guests."_ [**The Individualist Anarchists**, p. 159, p. 155 and
p. 162] The ramifications of this position on land use are significant. At its
most basic, what counts as force and coercion, and so state intervention, are
fundamentally different due to the differing conceptions of property held by
Tucker and Rothbard. If we apply, for example, the individualist anarchist
position on land to the workplace, we would treat the workers in a factory as
the rightful owners, on the basis of occupation and use; at the same time, we
could treat the share owners and capitalists as aggressors for attempting to
force their representatives as managers on those actually occupying and using
the premises. The same applies to the landlord against the tenant farmer.
Equally, the outcome of such differing property systems will be radically
different -- in terms of inequalities of wealth and so power (with having
others working for them, it is unlikely that would-be capitalists or landlords
would get rich). Rather than a _"minor"_ difference, the question of land use
fundamentally changes the nature of the society built upon it and whether it
counts as genuinely libertarian or not.

Tucker was well aware of the implications of such differences. Supporting a
scheme like Rothbard's meant _"departing from Anarchistic ground,"_ it was
_"Archism"_ and, as he stressed in reply to one supporter of such property
rights, it opened the door to other authoritarian positions: _"Archism in one
point is taking him to Archism in another. Soon, if he is logical, he will be
an Archist in all respects."_ It was a _"fundamentally foolish"_ position,
because it _"starts with a basic proposition that must be looked upon by all
consistent Anarchists as obvious nonsense."_ _"What follows from this?"_ asked
Tucker. _"Evidently that a man may go to a piece of vacant land and fence it
off; that he may then go to a second piece and fence that off; then to a
third, and fence that off; then to a fourth, a fifth, a hundredth, a
thousandth, fencing them all off; that, unable to fence off himself as many as
he wishes, he may hire other men to do the fencing for him; and that then he
may stand back and bar all other men from using these lands, or admit them as
tenants at such rental as he may choose to extract."_ It was _"a theory of
landed property which all Anarchists agree in viewing as a denial of equal
liberty."_ It is _"utterly inconsistent with the Anarchistic doctrine of
occupancy and use as the limit of property in land."_ [**Liberty**, No. 180,
p. 4 and p. 6] This was because of the dangers to liberty capitalist property
rights in land implied:

> _"I put the right of occupancy and use above the right of contract . . .
principally by my interest in the right of contract. Without such a preference
the theory of occupancy and use is utterly untenable; without it . . . it
would be possible for an individual to acquire, and hold simultaneously,
virtual titles to innumerable parcels of land, by the merest show of labour
performed thereon . . . [This would lead to] the virtual ownership of the
entire world by a small fraction of its inhabitants . . . [which would see]
the right of contract, if not destroyed absolutely, would surely be impaired
in an intolerable degree."_ [**Op. Cit.**, no. 350, p. 4]

Clearly a position which Rothbard had no sympathy for, unlike landlords.
Strange, though, that Rothbard did not consider the obvious liberty destroying
effects of the monopolisation of land and natural resources as _"rational
grounds"_ for opposing landlords but, then, as we noted in [section
F.1](secF1.html) when it came to private property Rothbard simply could not
see its state-like qualities -- even when he pointed them out himself! For
Rothbard, the individualist anarchist position involved a _"hobbling of land
sites or of optimum use of land ownership and cultivation and such arbitrary
misallocation of land injures all of society."_ [Rothbard, **Op. Cit.**, p. 9]
Obviously, those subject to the arbitrary authority of landlords and pay them
rent are not part of _"society"_ and it is a strange coincidence that the
interests of landlords just happen to coincide so completely with that of
_"all of society"_ (including their tenants?). And it would be churlish to
remind Rothbard's readers that, as a methodological individualist, he was
meant to think that there is no such thing as _"society"_ \-- just
individuals. And in terms of these individuals, he clearly favoured the
landlords over their tenants and justifies this by appealing, like any crude
collectivist, to an abstraction (_"society"_) to which the tenants must
sacrifice themselves and their liberty. Tucker would not have been impressed.

For Rothbard, the nineteenth century saw _"the establishment in North America
of a truly libertarian land system."_ [**The Ethics of Liberty**, p. 73] In
contrast, the Individualist Anarchists attacked that land system as the _"land
monopoly"_ and looked forward to a time when _"the libertarian principle to
the tenure of land"_ was actually applied [Tucker, **Liberty**, no. 350, p. 5]
So given the central place that "occupancy and use" lies in individualist
anarchism, it was extremely patronising for Rothbard to assert that _"it seems
. . . a complete violation of the Spooner-Tucker 'law of equal liberty' to
prevent the legitimate owner from selling his land to someone else."_ [_"The
Spooner-Tucker Doctrine: An Economist's View", _**Op. Cit.**, p. 9]
Particularly as Tucker had explicitly addressed this issue and indicated the
logical and common sense basis for this so-called "violation" of their
principles. Thus "occupancy and use" was _"the libertarian principle to the
tenure of land"_ because it stopped a class of all powerful landlords
developing, ensuring a real equality of opportunity and liberty rather than
the formal "liberty" associated with capitalism which, in practice, means
selling your liberty to the rich.

Somewhat ironically, Rothbard bemoaned that it _"seems to be a highly
unfortunate trait of libertarian and quasi-libertarian groups to spend the
bulk of their time and energy emphasising their most fallacious or
unlibertarian points."_ [**Op. Cit.**, p. 14] He pointed to the followers of
Henry George and their opposition to the current land holding system and the
monetary views of the individualist anarchists as examples (see [section
G.3.6](secG3.html#secg36) for a critique of Rothbard's position on mutual
banking). Of course, both groups would reply that Rothbard's positions were,
in fact, both fallacious and unlibertarian in nature. As, indeed, did Tucker
decades before Rothbard proclaimed his private statism a form of "anarchism."
Yarros' critique of those who praised capitalism but ignored the state imposed
restrictions that limited choice within it seems as applicable to Rothbard as
it did Herbert Spencer:

> _"A system is voluntary when it is voluntary all round . . . not when
certain transactions, regarded from certain points of view, appear voluntary.
Are the circumstances which compel the labourer to accept unfair terms law-
created, artificial, and subversive of equal liberty? That is the question,
and an affirmative answer to it is tantamount to an admission that the present
system is not voluntary in the true sense."_ [**Liberty**, no. 184, p. 2]

So while "anarcho"-capitalists like Walter Block speculate on how starving
families renting their children to wealthy paedophiles is acceptable _"on
libertarian grounds"_ it is doubtful that any individualist anarchist would be
so blasé about such an evil. [_"Libertarianism vs. Objectivism: A Response to
Peter Schwartz,"_ pp. 39-62, **Reason Papers**, Vol. 26, Summer 2003, p. 20]
Tucker, for example, was well aware that liberty without equality was little
more than a bad joke. _"If,"_ he argued, _"after the achievement of all
industrial freedoms, economic rent should prove to be the cause of such
inequalities in comfort that an effective majority found themselves at the
point of starvation, they would undoubtedly cry, 'Liberty be damned!' and
proceed to even up; and I think that at that stage of the game they would be
great fools if they didn't. From this it will be seen that I am no[t] . . . a
stickler for absolute equal liberty under all circumstances."_ Needless to
say, he considered this outcome as unlikely and was keen to _"[t]ry freedom
first."_ [**Liberty**, no. 267, p. 2 and p. 3]

The real question is why Rothbard considered this a **political** difference
rather than an economic one. Unfortunately, he did not explain. Perhaps
because of the underlying **socialist** perspective behind the anarchist
position? Or perhaps the fact that feudalism and monarchism was based on the
owner of the land being its ruler suggests a political aspect to propertarian
ideology best left unexplored? Given that the idea of grounding rulership on
land ownership receded during the Middle Ages, it may be unwise to note that
under "anarcho"-capitalism the landlord and capitalist would, likewise, be
sovereign over the land **and** those who used it? As we noted in [section
F.1](secF1.html), this is the conclusion that Rothbard does draw. As such,
there **is** a political aspect to this difference, namely the difference
between a libertarian social system and one rooted in authority.

Ultimately, _"the expropriation of the mass of the people from the soil forms
the basis of the capitalist mode of production."_ [Marx, **Capital**, vol. 1,
p. 934] For there are _"two ways of oppressing men: either directly by brute
force, by physical violence; or indirectly by denying them the means of life
and this reducing them to a state of surrender."_ In the second case,
government is _"an organised instrument to ensure that dominion and privilege
will be in the hands of those who . . . have cornered all the means of life,
first and foremost the land, which they make use of to keep the people in
bondage and to make them work for their benefit."_ [Malatesta, **Anarchy**, p.
21] Privatising the coercive functions of said government hardly makes much
difference.

As such, Rothbard was right to distance himself from the term individualist
anarchism. It is a shame he did not do the same with anarchism as well!

## G.3.1 Is "anarcho"-capitalism American anarchism?

Unlike Rothbard, some "anarcho"-capitalists are more than happy to proclaim
themselves "individualist anarchists" and so suggest that their notions are
identical, or nearly so, with the likes of Tucker, Ingalls and Labadie. As
part of this, they tend to stress that individualist anarchism is uniquely
American, an indigenous form of anarchism unlike social anarchism. To do so,
however, means ignoring not only the many European influences on individualist
anarchism itself (most notably, Proudhon) but also downplaying the realities
of American capitalism which quickly made social anarchism the dominant form
of Anarchism in America. Ironically, such a position is deeply contradictory
as "anarcho"-capitalism itself is most heavily influenced by a European
ideology, namely "Austrian" economics, which has lead its proponents to reject
key aspects of the indigenous American anarchist tradition.

For example, "anarcho"-capitalist Wendy McElroy does this in a short essay
provoked by the Seattle protests in 1999. After property destruction in
Seattle placed American anarchists back in the media, she stated that social
anarchism _"is not American anarchism. Individualist anarchism, the indigenous
form of the political philosophy, stands in rigorous opposition to attacking
the person or property of individuals."_ While Canadian, her rampant American
nationalism is at odds with the internationalism of the individualist
anarchists and like an ideological protectionist she argued that _"Left [sic!]
anarchism (socialist and communist) are foreign imports that flooded the
country like cheap goods during the 19th century."_ [**Anarchism: Two Kinds**]
Apparently Albert and Lucy Parsons were un-Americans, as was Voltairine de
Cleyre who turned from individualist to communist anarchism. And best not
mention the social conditions in America which quickly made communist-
anarchism predominant in the movement or that individualist anarchists like
Tucker proudly proclaimed their ideas socialist!

She argued that _"[m]any of these anarchists (especially those escaping
Russia) introduced lamentable traits into American radicalism"_ such as
_"propaganda by deed"_ as well as a class analysis which _"divided society
into economic classes that were at war with each other."_ Taking the issue of
_"propaganda by the deed"_ first, it should be noted that use of violence
against person or property was hardly alien to American traditions. The Boston
Tea Party was just as _"lamentable"_ an attack on _"property of individuals"_
as the window breaking at Seattle while the revolution and revolutionary war
were hardly fought using pacifist methods or respecting the _"person or
property of individuals"_ who supported imperialist Britain. Similarly, the
struggle against slavery was not conducted purely by means Quakers would have
supported (John Brown springs to mind), nor was (to use just one example)
Shay's rebellion. So _"attacking the person or property of individuals"_ was
hardly alien to American radicalism and so was definitely **not** imported by
_"foreign"_ anarchists.

Of course, anarchism in America became associated with terrorism (or
_"propaganda by the deed"_) due to the Haymarket events of 1886 and Berkman's
assassination attempt against Frick during the Homestead strike.
Significantly, McElroy makes no mention of the substantial state and employer
violence which provoked many anarchists to advocate violence in self-defence.
For example, the great strike of 1877 saw the police open fire on strikers on
July 25th, killing five and injuring many more. _"For several days, meetings
of workmen were broken up by the police, who again and again interfered with
the rights of free speech and assembly."_ The **Chicago Times** called for the
use of hand grenades against strikers and state troops were called in, killing
a dozen strikers. _"In two days of fighting, between 25 and 50 civilians had
been killed, some 200 seriously injured, and between 300 and 400 arrested. Not
a single policeman or soldier had lost his life."_ This context explains why
many workers, including those in reformist trade unions as well as anarchist
groups like the IWPA, turned to armed self-defence ("violence"). The Haymarket
meeting itself was organised in response to the police firing on strikers and
killing at least two. The Haymarket bomb was thrown after the police tried to
break-up a peaceful meeting by force: _"It is clear then that . . . it was the
police and not the anarchists who were the perpetrators of the violence at the
Haymarket."_ All but one of the deaths and most of the injuries were caused by
the police firing indiscriminately in the panic after the explosion. [Paul
Avrich, **The Haymarket Tragedy**, pp. 32-4, p. 189, p. 210, and pp. 208-9] As
for Berkman's assassination attempt, this was provoked by the employer's
Pinkerton police opening fire on strikers, killing and wounding many. [Emma
Goldman, **Living My Life**, vol. 1, p. 86]

In other words, it was **not** foreign anarchists or alien ideas which
associated anarchism with violence but, rather, the reality of American
capitalism. As historian Eugenia C. Delamotte puts it, _"the view that
anarchism stood for violence . . . spread rapidly in the mainstream press from
the 1870s"_ because of _"the use of violence against strikers and
demonstrators in the labour agitation that marked these decades -- struggles
for the eight-hour day, better wages, and the right to unionise, for example.
Police, militia, and private security guards harassed, intimidated,
bludgeoned, and shot workers routinely in conflicts that were just as
routinely portrayed in the media as worker violence rather than state
violence; labour activists were also subject to brutal attacks, threats of
lynching, and many other forms of physical assault and intimidation . . . the
question of how to respond to such violence became a critical issue in the
1870s, with the upswelling of labour agitation and attempts to suppress it
violently."_ [**Gates of Freedom**, pp. 51-2]

Joseph Labadie, it should be noted, thought the _"Beastly police"_ got what
they deserved at Haymarket as they had attempted to break up a peaceful public
meeting and such people should _"go at the peril of their lives. If it is
necessary to use dynamite to protect the rights of free meeting, free press
and free speech, then the sooner we learn its manufacture and use . . . the
better it will be for the toilers of the world."_ The radical paper he was
involved in, the **Labor Leaf**, had previously argued that _"should trouble
come, the capitalists will use the regular army and militia to shoot down
those who are not satisfied. It won't be so if the people are equally ready."_
Even reformist unions were arming themselves to protect themselves, with many
workers applauding their attempts to organise union militias. As one worker
put it: _"With union men well armed and accustomed to military tactics, we
could keep Pinkerton's men at a distance . . . Employers would think twice,
too, before they attempted to use troops against us . . . Every union ought to
have its company of sharpshooters."_ [quoted by Richard Jules Oestreicher,
**Solidarity and Fragmentation**, p. 200 and p. 135]

While the violent rhetoric of the Chicago anarchists was used at their trial
and is remembered (in part because enemies of anarchism take great glee in
repeating it), the state and employer violence which provoked it has been
forgotten or ignored. Unless this is mentioned, a seriously distorted picture
of both communist-anarchism **and** capitalism are created. It is significant,
of course, that while the **words** of the Martyrs are taken as evidence of
anarchism's violent nature, the actual violence (up to and including murder)
against strikers by state and private police apparently tells us nothing about
the nature of the state or capitalist system (Ward Churchill presents an
excellent summary of such activities in his article _"From the Pinkertons to
the PATRIOT Act: The Trajectory of Political Policing in the United States,
1870 to the Present"_ [**CR: The New Centennial Review**, Vol. 4, No. 1, pp.
1-72]).

So, as can be seen, McElroy distorts the context of anarchist violence by
utterly ignoring the far worse capitalist violence which provoked it. Like
more obvious statists, she demonises the resistance to the oppressed while
ignoring that of the oppressor. Equally, it should also be noted Tucker
rejected violent methods to end class oppression not out of principle, but
rather strategy as there _"was no doubt in his mind as to the righteousness of
resistance to oppression by recourse to violence, but his concern now was with
its expedience . . . he was absolutely convinced that the desired social
revolution would be possible only through the utility of peaceful propaganda
and passive resistance."_ [James J. Martin, **Men Against the State**, p. 225]
For Tucker _"as long as freedom of speech and of the press is not struck down,
there should be no resort to physical force in the struggle against
oppression."_ [quoted by Morgan Edwards, _"Neither Bombs Nor Ballots: Liberty
&amp; the Strategy of Anarchism"_, pp. 65-91, **Benjamin R. Tucker and the
Champions of Liberty**, Coughlin, Hamilton and Sullivan (eds.), p. 67] Nor
should we forget that Spooner's rhetoric could be as blood-thirsty as Johann
Most's at times and that American individualist anarchist Dyer Lum was an
advocate of insurrection.

As far as class analysis goes, which allegedly _"divided society into economic
classes that were at war with each other"_, it can be seen that the "left"
anarchists were simply acknowledging the reality of the situation -- as did,
it must be stressed, the individualist anarchists. As we noted in [section
G.1](secG1.html), the individualist anarchists were well aware that there was
a class war going on, one in which the capitalist class used the state to
ensure its position (the individualist anarchist _"knows very well that the
present State is an historical development, that it is simply the tool of the
property-owning class; he knows that primitive accumulation began through
robbery bold and daring, and that the freebooters then organised the State in
its present form for their own self-preservation."_ [A.H. Simpson, **The
Individualist Anarchists**, p. 92]). Thus workers had a right to a genuinely
free market for _"[i]f the man with labour to sell has not this free market,
then his liberty is violated and his property virtually taken from him. Now,
such a market has constantly been denied . . . to labourers of the entire
civilised world. And the men who have denied it are . . . Capitalists . . .
[who] have placed and kept on the statute-books all sorts of prohibitions and
taxes designed to limit and effective in limiting the number of bidders for
the labour of those who have labour to sell."_ [**Instead of a Book**, p. 454]
For Joshua King Ingalls, _"[i]n any question as between the worker and the
holder of privilege, [the state] is certain to throw itself into the scale
with the latter, for it is itself the source of privilege, the creator of
class rule."_ [quoted by Bowman N. Hall, _"Joshua K. Ingalls, American
Individualist: Land Reformer, Opponent of Henry George and Advocate of Land
Leasing, Now an Established Mode,"_ pp. 383-96, **American Journal of
Economics and Sociology**, Vol. 39, No. 4, p. 292] Ultimately, the state was
_"a police force to regulate the people in the interests of the plutocracy."_
[Ingalls, quoted by Martin, **Op. Cit.**, p. 152]

Discussing Henry Frick, manager of the Homestead steelworkers who was shot by
Berkman for using violence against striking workers, Tucker noted that Frick
did not _"aspire, as I do, to live in a society of mutually helpful equals"_
but rather it was _"his determination to live in luxury produced by the toil
and suffering of men whose necks are under his heel. He has deliberately
chosen to live on terms of hostility with the greater part of the human
race."_ While opposing Berkman's act, Tucker believed that he was _"a man with
whom I have much in common, -- much more at any rate than with such a man as
Frick."_ Berkman _"would like to live on terms of equality with his fellows,
doing his share of work for not more than his share of pay."_ [**The
Individualist Anarchists**, pp. 307-8] Clearly, Tucker was well aware of the
class struggle and why, while not supporting such actions, violence occurred
when fighting it.

As Victor Yarros summarised, for the individualist anarchists the _"State is
the servant of the robbers, and it exists chiefly to prevent the expropriation
of the robbers and the restoration of a free and fair field for legitimate
competition and wholesome, effective voluntary cooperation."_ [_"Philosophical
Anarchism: Its Rise, Decline, and Eclipse"_, pp. 470-483, **The American
Journal of Sociology**, vol. 41, no. 4, p. 475] For "anarcho"-capitalists, the
state exploits all classes subject to it (perhaps the rich most, by means of
taxation to fund welfare programmes and legal support for union rights and
strikes).

So when McElroy states that, _"Individualist anarchism rejects the State
because it is the institutionalisation of force against peaceful
individuals"_, she is only partly correct. While it may be true for
"anarcho"-capitalism, it fails to note that for the individualist anarchists
the modern state was the institutionalisation of force by the capitalist class
to deny the working class a free market. The individualist anarchists, in
other words, like social anarchists also rejected the state because it imposed
certain class monopolies and class legislation which ensured the exploitation
of labour by capital -- a significant omission on McElroy's part. _"Can it be
soberly pretended for a moment that the State . . . is purely a defensive
institution?"_ asked Tucker. _"Surely not . . . you will find that a good
nine-tenths of existing legislation serves . . . either to prescribe the
individual's personal habits, or, worse still, to create and sustain
commercial, industrial, financial, and proprietary monopolies which deprive
labour of a large part of the reward that it would receive in a perfectly free
market."_ [Tucker, **Instead of a Book**, pp. 25-6] In fact:

> _"As long as a portion of the products of labour are appropriated for the
payment of fat salaries to useless officials and big dividends to idle
stockholders, labour is entitled to consider itself defrauded, and all just
men will sympathise with its protest."_ [Tucker, **Liberty**, no. 19, p. 1]

It goes without saying that almost all "anarcho"-capitalists follow Rothbard
in being totally opposed to labour unions, strikes and other forms of working
class protest. As such, the individualist anarchists, just as much as the
"left" anarchists McElroy is so keen to disassociate them from, argued that
_"[t]hose who made a profit from buying or selling were class criminals and
their customers or employees were class victims. It did not matter if the
exchanges were voluntary ones. Thus, left anarchists hated the free market as
deeply as they hated the State."_ [McElroy, **Op. Cit.**] Yet, as any
individualist anarchist of the time would have told her, the "free market" did
not exist because the capitalist class used the state to oppress the working
class and reduce the options available to choose from so allowing the
exploitation of labour to occur. Class analysis, in other words, was not
limited to _"foreign"_ anarchism, nor was the notion that making a profit was
a form of exploitation (usury). As Tucker continually stressed: _"Liberty will
abolish interest; it will abolish profit; it will abolish monopolistic rent;
it will abolish taxation; it will abolish the exploitation of labour."_ [**The
Individualist Anarchists**, p. 157]

It should also be noted that the "left" anarchist opposition to the
individualist anarchist "free market" is due to an analysis which argues that
it will not, in fact, result in the anarchist aim of ending exploitation nor
will it maximise individual freedom (see [section G.4](secG4.html)). We do not
"hate" the free market, rather we love individual liberty and seek the best
kind of society to ensure free people. By concentrating on markets being free,
"anarcho"-capitalism ensures that it is wilfully blind to the freedom-
destroying similarities between capitalist property and the state (as we
discussed in [section F.1](secF1.html)). An analysis which many individualist
anarchists recognised, with the likes of Dyer Lum seeing that replacing the
authority of the state with that of the boss was no great improvement in terms
of freedom and so advocating co-operative workplaces to abolish wage slavery.
Equally, in terms of land ownership the individualist anarchists opposed any
voluntary exchanges which violated _"occupancy and use"_ and so they, so,
_"hated the free market as deeply as they hated the State."_ Or, more
correctly, they recognised that voluntary exchanges can result in
concentrations of wealth and so power which made a mockery of individual
freedom. In other words, that while the market may be free the individuals
within it would not be.

McElroy partly admits this, saying that _"the two schools of anarchism had
enough in common to shake hands when they first met. To some degree, they
spoke a mutual language. For example, they both reviled the State and
denounced capitalism. But, by the latter, individualist anarchists meant
'state-capitalism' the alliance of government and business."_ Yet this
_"alliance of government and business"_ has been the only kind of capitalism
that has ever existed. They were well aware that such an alliance made the
capitalist system what it was, i.e., a system based on the exploitation of
labour. William Bailie, in an article entitled _"The Rule of the Monopolists"_
simply repeated the standard socialist analysis of the state when he talked
about the _"gigantic monopolies, which control not only our industry, but all
the machinery of the State, -- legislative, judicial, executive, -- together
with school, college, press, and pulpit."_ Thus the _"preponderance in the
number of injunctions against striking, boycotting, and agitating, compared
with the number against locking-out, blacklisting, and the employment of armed
mercenaries."_ The courts could not ensure justice because of the
_"subserviency of the judiciary to the capitalist class . . . and the nature
of the reward in store for the accommodating judge."_ Government _"is the
instrument by means of which the monopolist maintains his supremacy"_ as the
law-makers _"enact what he desires; the judiciary interprets his will; the
executive is his submissive agent; the military arm exists in reality to
defend **his** country, protect **his** property, and suppress **his**
enemies, the workers on strike."_ Ultimately, _"when the producer no longer
obeys the State, his economic master will have lost his power."_ [**Liberty**,
no. 368, p. 4 and p. 5] Little wonder, then, that the individualist anarchists
thought that the end of the state and the class monopolies it enforces would
produce a radically different society rather than one essentially similar to
the current one but without taxes. Their support for the "free market" implied
the end of capitalism and its replacement with a new social system, one which
would end the exploitation of labour.

She herself admits, in a roundabout way, that "anarcho"-capitalism is
significantly different from individualist anarchism. _"The schism between the
two forms of anarchism has deepened with time,"_ she asserts. This was
_"[l]argely due to the path breaking work of Murray Rothbard"_ and so, unlike
genuine individualist anarchism, the new _"individualist anarchism"_ (i.e.,
"anarcho"-capitalism) _"is no longer inherently suspicious of profit-making
practices, such as charging interest. Indeed, it embraces the free market as
the voluntary vehicle of economic exchange"_ (does this mean that the old
version of it did not, in fact, embrace _"the free market"_ after all?) This
is because it _"draws increasingly upon the work of Austrian economists such
as Mises and Hayek"_ and so _"it draws increasingly farther away from left
anarchism"_ and, she fails to note, the likes of Warren and Tucker. As such,
it would be churlish to note that "Austrian" economics was even more of a
_"foreign import"_ much at odds with American anarchist traditions as
communist anarchism, but we will! After all, Rothbard's support of usury
(interest, rent and profit) would be unlikely to find much support from
someone who looked forward to the development of _"an attitude of hostility to
usury, in any form, which will ultimately cause any person who charges more
than cost for any product to be regarded very much as we now regard a
pickpocket."_ [Tucker, **The Individualist Anarchists**, p. 155] Nor, as noted
above, would Rothbard's support for an _"Archist"_ (capitalist) land ownership
system have won him anything but dismissal nor would his judge, jurist and
lawyer driven political system have been seen as anything other than rule by
the few rather than rule by none.

Ultimately, it is a case of influences and the kind of socio-political
analysis and aims they inspire. Unsurprisingly, the main influences in
individualist anarchism came from social movements and protests. Thus poverty-
stricken farmers and labour unions seeking monetary and land reform to ease
their position and subservience to capital all plainly played their part in
shaping the theory, as did the Single-Tax ideas of Henry George and the
radical critiques of capitalism provided by Proudhon and Marx. In contrast,
"anarcho"-capitalism's major (indeed, predominant) influence is "Austrian"
economists, an ideology developed (in part) to provide intellectual support
against such movements and their proposals for reform. As we will discuss in
the [next section](secG3.html#secg32), this explains the quite fundamental
differences between the two systems for all the attempts of
"anarcho"-capitalists to appropriate the legacy of the likes of Tucker.

## G.3.2 What are the differences between "anarcho"-capitalism and
individualist anarchism?

The key differences between individualist anarchism and "anarcho"-capitalism
derive from the fact the former were socialists while the latter embrace
capitalism with unqualified enthusiasm. Unsurprisingly, this leans to
radically different analyses, conclusions and strategies. It also expresses
itself in the vision of the free society expected from their respective
systems. Such differences, we stress, all ultimately flow from fact that the
individualist anarchists were/are socialists while the likes of Rothbard are
wholeheartedly supporters of capitalism.

As scholar Frank H. Brooks notes, _"the individualist anarchists hoped to
achieve socialism by removing the obstacles to individual liberty in the
economic realm."_ This involved making equality of opportunity a reality
rather than mere rhetoric by ending capitalist property rights in land and
ensuring access to credit to set-up in business for themselves. So while
supporting a market economy _"they were also advocates of socialism and
critics of industrial capitalism, positions that make them less useful as
ideological tools of a resurgent capitalism."_ [**The Individualist
Anarchists**, p. 111] Perhaps unsurprisingly, most right-"libertarians" get
round this problem by hiding or downplaying this awkward fact. Yet it remains
essential for understanding both individualist anarchism and why
"anarcho"-capitalism is not a form of anarchism.

Unlike both individualist and social anarchists, "anarcho"-capitalists support
capitalism (a "pure" free market type, which has never existed although it has
been approximated occasionally as in 19th century America). This means that
they totally reject the ideas of anarchists with regards to property and
economic analysis. For example, like all supporters of capitalists they
consider rent, profit and interest as valid incomes. In contrast, all
Anarchists consider these as exploitation and agree with Tucker when he argued
that _"**[w]hoever** contributes to production is alone entitled. **What** has
no rights that **who** is bound to respect. **What** is a thing. **Who** is a
person. Things have no claims; they exist only to be claimed. The possession
of a right cannot be predicted of dead material, but only a living person."_
[quoted by Wm. Gary Kline, **The Individualist Anarchists**, p. 73]

This, we must note, is the fundamental critique of the capitalist theory that
capital is productive. In and of themselves, fixed costs do not create value.
Rather, value is created depends on how investments are developed and used
once in place and because of this the Individualist Anarchists, like other
anarchists, considered non-labour derived income as usury, unlike
"anarcho"-capitalists. Similarly, anarchists reject the notion of capitalist
property rights in favour of possession (including the full fruits of one's
labour). For example, anarchists reject private ownership of land in favour of
a "occupancy and use" regime. In this we follow Proudhon's **What is
Property?** and argue that _"property is theft"_ as well as _"despotism"_.
Rothbard, as noted in the [section F.1](secF1.html), rejected this
perspective.

As these ideas are an **essential** part of anarchist politics, they cannot be
removed without seriously damaging the rest of the theory. This can be seen
from Tucker's comments that _"**Liberty** insists. . . [on] the abolition of
the State and the abolition of usury; on no more government of man by man, and
no more exploitation of man by man."_ [quoted by Eunice Schuster, **Native
American Anarchism**, p. 140] Tucker indicates here that anarchism has
specific economic **and** political ideas, that it opposes capitalism along
with the state. Therefore anarchism was never purely a "political" concept,
but always combined an opposition to oppression with an opposition to
exploitation. The social anarchists made exactly the same point. Which means
that when Tucker argued that _"**Liberty** insists on Socialism. . . -- true
Socialism, Anarchistic Socialism: the prevalence on earth of Liberty,
Equality, and Solidarity"_ he knew exactly what he was saying and meant it
wholeheartedly. [**Instead of a Book**, p. 363] So because
"anarcho"-capitalists embrace capitalism and reject socialism, they cannot be
considered anarchists or part of the anarchist tradition.

There are, of course, overlaps between individualist anarchism and
"anarcho"-capitalism, just as there are overlaps between it and Marxism (and
social anarchism, of course). However, just as a similar analysis of
capitalism does not make individualist anarchists Marxists, so apparent
similarities between individualist anarchism and "anarcho"-capitalism does not
make the former a forerunner of the latter. For example, both schools support
the idea of "free markets." Yet the question of markets is fundamentally
second to the issue of property rights, for what is exchanged on the market is
dependent on what is considered legitimate property. In this, as Rothbard
noted, individualist anarchists and "anarcho"-capitalists differ and different
property rights produce different market structures and dynamics. This means
that capitalism is not the only economy with markets and so support for
markets cannot be equated with support for capitalism. Equally, opposition to
markets is **not** the defining characteristic of socialism. As such, it
**is** possible to be a market socialist (and many socialists are) as
"markets" and "property" do not equate to capitalism as we proved in sections
[G.1.1](secG1.html#secg11) and [G.1.2](secG1.html#secg12) respectively.

One apparent area of overlap between individualist anarchism and
"anarcho"-capitalism is the issue of wage labour. As we noted in [section
G.1.3](secG1.html#secg13), unlike social anarchists, some individualist
anarchists were not consistently against it. However, this similarity is more
apparent than real as the individualist anarchists were opposed to
exploitation and argued (unlike "anarcho"-capitalism) that in their system
workers bargaining powers would be raised to such a level that their wages
would equal the full product of their labour and so it would not be an
exploitative arrangement. Needless to say, social anarchists think this is
unlikely to be the case and, as we discuss in [section
G.4.1](secG4.html#secg41), individualist anarchist support for wage labour is
in contradiction to many of the stated basic principles of the individualist
anarchists themselves. In particular, wage labour violates "occupancy and use"
as well as having more than a passing similarity to the state.

However, these problems can be solved by consistently applying the principles
of individualist anarchism, unlike "anarcho"-capitalism, and that is why it is
a real (if inconsistent) school of anarchism. Moreover, the social context
these ideas were developed in and would have been applied ensure that these
contradictions would have been minimised. If they had been applied, a genuine
anarchist society of self-employed workers would, in all likelihood, have been
created (at least at first, whether the market would increase inequalities is
a moot point between anarchists). Thus we find Tucker criticising Henry George
by noting that he was _"enough of an economist to be very well aware that,
whether it has land or not, labour which can get no capital -- that is, which
is oppressed by capital -- cannot, without accepting the alternative of
starvation, refuse to reproduce capital for the capitalists."_ Abolition of
the money monopoly will increase wages, so allowing workers to _"steadily lay
up money, with which he can buy tools to compete with his employer or to till
his bit of land with comfort and advantage. In short, he will be an
independent man, receiving what he produces or an equivalent thereof. How to
make this the lot of all men is the labour question. Free land will not solve
it. Free money, supplemented by free land, will."_ [**Liberty**, no. 99, p. 4
and p. 5] Sadly, Rothbard failed to reach George's level of understanding (at
least as regards his beloved capitalism).

Which brings us another source of disagreement, namely on the effects of state
intervention and what to do about it. As noted, during the rise of capitalism
the bourgeoisie were not shy in urging state intervention against the masses.
Unsurprisingly, working class people generally took an anti-state position
during this period. The individualist anarchists were part of that tradition,
opposing what Marx termed _"primitive accumulation"_ in favour of the pre-
capitalist forms of property and society it was destroying.

However, when capitalism found its feet and could do without such obvious
intervention, the possibility of an "anti-state" capitalism could arise. Such
a possibility became a definite once the state started to intervene in ways
which, while benefiting the system as a whole, came into conflict with the
property and power of individual members of the capitalist and landlord class.
Thus social legislation which attempted to restrict the negative effects of
unbridled exploitation and oppression on workers and the environment were
having on the economy were the source of much outrage in certain bourgeois
circles:

> _"Quite independently of these tendencies [of individualist anarchism] . . .
the anti-socialist bourgeoisie (which is also anti-statist, being hostile to
any social intervention on the part of the State to protect the victims of
exploitation -- in the matter of working hours, hygienic working conditions
and so on), and the greed of unlimited exploitation, had stirred up in England
a certain agitation in favour of pseudo-individualism, an unrestrained
exploitation. To this end, they enlisted the services of a mercenary pseudo-
literature . . . which played with doctrinaire and fanatical ideas in order to
project a species of 'individualism' that was absolutely sterile, and a
species of 'non-interventionism' that would let a man die of hunger rather
than offend his dignity."_ [Max Nettlau, **A Short History of Anarchism**, p.
39]

This perspective can be seen when Tucker denounced Herbert Spencer as a
champion of the capitalistic class for his vocal attacks on social legislation
which claimed to benefit working class people but staying strangely silent on
the laws passed to benefit (usually indirectly) capital and the rich.
"Anarcho"-capitalism is part of that tradition, the tradition associated with
a capitalism which no longer needs obvious state intervention as enough wealth
has been accumulated to keep workers under control by means of market power.

In other words, there are substantial differences between the victims of a
thief trying to stop being robbed and be left alone to enjoy their property
and the successful thief doing the same! Individualist Anarchist's were aware
of this. For example, Victor Yarros stressed this key difference between
individualist anarchism and the proto-"libertarian" capitalists of
"voluntaryism":

> _"[Auberon Herbert] believes in allowing people to retain all their
possessions, no matter how unjustly and basely acquired, while getting them,
so to speak, to swear off stealing and usurping and to promise to behave well
in the future. We, on the other hand, while insisting on the principle of
private property, in wealth honestly obtained under the reign of liberty, do
not think it either unjust or unwise to dispossess the landlords who have
monopolised natural wealth by force and fraud. We hold that the poor and
disinherited toilers would be justified in expropriating, not alone the
landlords, who notoriously have no equitable titles to their lands, but
**all** the financial lords and rulers, all the millionaires and very wealthy
individuals. . . . Almost all possessors of great wealth enjoy neither what
they nor their ancestors rightfully acquired (and if Mr. Herbert wishes to
challenge the correctness of this statement, we are ready to go with him into
a full discussion of the subject). . . _

> _"If he holds that the landlords are justly entitled to their lands, let him
make a defence of the landlords or an attack on our unjust proposal."_ [quoted
by Carl Watner, _"The English Individualists As They Appear In Liberty,"_ pp.
191-211, **Benjamin R. Tucker and the Champions of Liberty**, Coughlin,
Hamilton and Sullivan (eds.), pp. 199-200]

It could be argued, in reply, that some "anarcho"-capitalists do argue that
stolen property should be returned to its rightful owners and, as a result, do
sometimes argue for land reform (namely, the seizing of land by peasants from
their feudal landlords). However, this position is, at best, a pale shadow of
the individualist anarchist position or, at worse, simply rhetoric. As leading
"anarcho"-capitalist Walter Block pointed out:

> _"While this aspect of libertarian theory sounds very radical, in practice
it is less so. This is because the claimant always needs proof. Possession is
nine tenths of the law, and to overcome the presumption that property is now
in the hands of its rightful owners required that an evidentiary burden by
overcome. The further back in history was the initial act of aggression (not
only because written evidence is less likely to be available), the less likely
it is that there can be proof of it."_ [**Op. Cit.**, pp. 54-5]

Somewhat ironically, Block appears to support land reform in Third World
countries in spite of the fact that the native peoples have no evidence to
show that they are the rightful owners of the land they work. Nor does he
bother himself to wonder about the wider social impact of such theft, namely
in the capital that was funded using it. If the land was stolen, then so were
its products and so was any capital bought with the profits made from such
goods. But, as he says, this aspect of right-"libertarian" ideology _"sounds
very radical"_ but _"in practice it is less so."_ Apparently, theft **is**
property! Not to mention that nine tenths of property is currently possessed
(that is, used) not by its "rightful owners" but rather those who by economic
necessity have to work for them. This is a situation the law was designed to
protect, including (apparently) a so-called "libertarian" one.

This wider impact is key. As we indicated in [section F.8](secF8.html), state
coercion (particularly in the form of the land monopoly) was essential in the
development of capitalism. By restricting access to land, working class people
had little option but to seek work from landlords and capitalists. Thus the
stolen land ensured that workers were exploited by the landlord and the
capitalist and so the exploitation of the land monopoly was spread throughout
the economy, with the resulting exploited labour being used to ensure that
capital accumulated. For Rothbard, unlike the individualist anarchists, the
land monopoly had limited impact and can be considered separately from the
rise of capitalism:

> _"the emergence of wage-labour was an enormous boon for many thousands of
poor workers and saved them from starvation. If there is no wage labour, as
there was not in most production before the Industrial Revolution, then each
worker must have enough money to purchase his own capital and tools. One of
the great things about the emergence of the factory system and wage labour is
that poor workers did not have to purchase their own capital equipment; this
could be left to the capitalists."_ [**Konkin on Libertarian Strategy**]

Except, of course, **before** the industrial revolution almost all workers
did, in fact, have their own capital and tools. The rise of capitalism was
based on the exclusion of working people from the land by means of the land
monopoly. Farmers were barred, by the state, from utilising the land of the
aristocracy while their access to the commons was stripped from them by the
imposition of capitalist property rights by the state. Thus Rothbard is right,
in a sense. The emergence of wage-labour was based on the fact that workers
had to purchase access to the land from those who monopolised it by means of
state action -- which was precisely what the individualist anarchists opposed.
Wage labour, after all, first developed **on the land** not with the rise of
the factory system. Even Rothbard, we hope, would not have been so crass as to
say that landlordism was an enormous boon for those poor workers as it saved
them from starvation for, after all, one of the great things about landlordism
is that poor workers did not have to purchase their own land; that could be
left to the landlords.

The landless workers, therefore, had little option but to seek work from those
who monopolised the land. Over time, increasing numbers found work in industry
where employers happily took advantage of the effects of the land monopoly to
extract as much work for as little pay as possible. The profits of both
landlord and capitalist exploitation were then used to accumulate capital,
reducing the bargaining power of the landless workers even more as it became
increasingly difficult to set-up in business due to natural barriers to
competition. It should also be stressed that once forced onto the labour
market, the proletariat found itself subjected to numerous state laws which
prevented their free association (for example, the banning of unions and
strikes as conspiracies) as well as their ability to purchase their own
capital and tools. Needless to say, the individualist anarchists recognised
this and considered the ability of workers to be able to purchase their own
capital and tools as an essential reform and, consequently, fought against the
money monopoly. They reasoned, quite rightly, that this was a system of class
privilege designed to keep workers in a position of dependency on the
landlords and capitalists, which (in turn) allowed exploitation to occur. This
was also the position of many workers, who rather than consider capitalism a
boon, organised to defend their freedom and to resist exploitation -- and the
state complied with the wishes of the capitalists and broke that resistance.

Significantly, Tucker and other individualist anarchists saw state
intervention as a result of capital manipulating legislation to gain an
advantage on the so-called free market which allowed them to exploit labour
and, as such, it benefited the **whole** capitalist class (_"If, then, the
capitalist, by abolishing the free market, compels other men to procure their
tools and advantages of him on less favourable terms than they could get
before, while it may be better for them to come to his terms than to go
without the capital, does he not deduct from their earnings?"_ [Tucker,
**Liberty**, no. 109, p. 4]). Rothbard, at best, acknowledges that **some**
sections of big business benefit from the current system and so fails to have
a comprehensive understanding of the dynamics of capitalism as a **system**
(rather as an ideology). This lack of understanding of capitalism as a
historic and dynamic system rooted in class rule and economic power is
important in evaluating "anarcho"-capitalist claims to anarchism.

Then there is the issue of strategy, with Rothbard insisting on _"political
action,"_ namely voting for the Libertarian Party. _"I see no other
conceivable strategy for the achievement of liberty than political action,"_
he stated. Like Marxists, voting was seen as the means of achieving the
abolition of the state, as _"a militant and abolitionist" _Libertarian Party_
"in control of Congress could wipe out all the [non-'libertarian'] laws
overnight . . . No other strategy for liberty can work."_ [**Op. Cit.**] The
individualist anarchists, like other anarchists, rejected such arguments as
incompatible with genuine libertarian principles. As Tucker put it, voting
could not be libertarian as it would make the voter _"an accomplice in
aggression."_ [**The Individualist Anarchists**, p. 305]

Rothbard's position indicates an interesting paradox. Rothbard wholeheartedly
supported _"political action"_ as the only means of achieving the end of the
state. Marxists (when not excommunicating anarchism from the socialist
movement) often argue that they agree with the anarchists on the ends
(abolition of the state) but only differ on the means (i.e., political action
over direct action). Obviously, no one calls Marx an anarchist and this is
precisely because he aimed to use political action to achieve the abolition of
the state. Yet, for some reason, Rothbard's **identical** position on tactics
makes some call him an anarchist. So, given Rothbard's argument that the state
must be seized first by a political party by means of _"political action"_ in
order to achieve his end, the question must be raised why he is considered an
anarchist at all. Marx and Engels, like Lenin, all made identical arguments
against anarchism, namely that political action was essential so that the
Socialist Party could seize state power and implement the necessary changes to
ensure that the state withered away. No one has ever considered them
anarchists in spite of the common aim of ending the state yet many consider
Rothbard to be an anarchist despite advocating the same methods as the
Marxists. As we noted in [section F.8](secF8.html), a better term for
"anarcho"-capitalism could be "Marxist-capitalism" and Rothbard's argument for
"political action" confirms that suggestion.

Needless to say, other strategies favoured by many individualists anarchists
were rejected by "anarcho"-capitalists. Unlike Tucker, Lum and others,
Rothbard was totally opposed to trade unions and strikes, viewing unions as
coercive institutions which could not survive under genuine capitalism (given
the powers of property owners and the inequalities of such a society, he may
well have been right in thinking workers would be unable to successfully
defend their basic freedoms against their masters but that is another issue).
The individualist anarchists were far more supportive. Henry Cohen, for
example, considered the union as a _"voluntary association formed for the
mutual benefit of its members, using the boycott and other passive weapons in
its fight against capitalism and the State."_ This was _"very near the
Anarchist idea."_ Some individualists were more critical of unions than
others. One, A.H. Simpson, argued that the trade unions _"are as despotic and
arbitrary as any other organisation, and no more Anarchistic than the Pullman
or Carnegie companies."_ In other words, the unions were to be opposed because
they were like capitalist corporations! [**The Individualist Anarchists**, p.
285 and p. 288] For Tucker, as we note in [section G.5](secG5.html), unions
were _"a movement for self-government on the part of the people"_ and it was
_"in supplanting"_ the state _"by an intelligent and self-governing socialism
that the trades unions develop their chief significance."_ [**Liberty**, no.
22, p. 3]

So the claims that "anarcho"-capitalism is a new form of individualist
anarchism can only be done on the basis of completely ignoring the actual
history of capitalism as well as ignoring the history, social context,
arguments, aims and spirit of individualist anarchism. This is only convincing
if the actual ideas and aims of individualist anarchism are unknown or ignored
and focus is placed on certain words used (like "markets" and "property")
rather than the specific meanings provided to them by its supporters. Sadly,
this extremely superficial analysis is all too common -- particularly in
academic circles and, of course, in right-"libertarian" ones.

Finally, it may be objected that "anarcho"-capitalism is a diverse, if small,
collection of individuals and some of them are closer to individualist
anarchism than others. Which is, of course, true (just as some Marxists are
closer to social anarchism than others). A few of them do reject the notion
that hundreds of years of state-capitalist intervention has had little impact
on the evolution of the economy and argue that a genuinely free economy would
see the end of the current form of property rights and non-labour income as
well as self-employment and co-operatives becoming the dominant form of
workplace organisation (the latter depends on the former, of course, for
without the necessary social preconditions a preference for self-employment
will remain precisely that). As Individualist Anarchist Shawn Wilbur put it,
there is a difference between those "anarcho"-capitalists who are ideologues
for capitalism first and foremost and the minority who are closer to
traditional anarchist aspirations. If the latter manage to jettison the
baggage they have inherited from "Austrian" economics as well as the likes of
Murray Rothbard and realise that they are, in fact, free market socialists and
**not** in favour of capitalism then few anarchists would hold their past
against them any more than they would a state socialist or left-liberal who
realised the error of their ways. Until they do, though, few anarchists would
accept them as anarchists.

## G.3.3 What about "anarcho"-capitalists' support of "defence associations"?

It would be fair to say that "anarcho"-capitalist interest in individualist
anarchism rests on their argument that, to quote Tucker, _"defense is a
service, like any other service"_, and that such a service could and should be
provided by private agencies paid for like any other commodity on the market.
[**Liberty**, no. 104, p. 4] Therefore:

> _"Anarchism means no government, but it does not mean no laws and no
coercion. This may seem paradoxical, but the paradox vanishes when the
Anarchist definition of government is kept in view. Anarchists oppose
government, not because they disbelieve in punishment of crime and resistance
to aggression, but because they disbelieve in compulsory protection.
Protection and taxation without consent is itself invasion; hence Anarchism
favours a system of voluntary taxation and protection."_ [**Op. Cit.**, no.
212, p. 2]

While most of the rest of the theory is ignored or dismissed as being the
product of "bad" economics, this position is considered the key link between
the two schools of thought. However, it is not enough to say that both the
individualist anarchists and "anarcho"-capitalists support a market in
protection, you need to look at what forms of property are being defended and
the kind of society within which it is done. Change the social context, change
the kinds of property which are being defended and you change the nature of
the society in question. In other words, defending capitalist property rights
within an unequal society is radically different in terms of individual
liberty than defending socialistic property rights within an equal society --
just as a market economy based on artisan, peasant and co-operative production
is fundamentally different to one based on huge corporations and the bulk of
the population being wage slaves. Only the most superficial analysis would
suggest that they are the same and label both as being "capitalist" in nature.

It should, therefore, not be forgotten that the individualist anarchists
advocated a system rooted in individual possession of land and tools plus the
free exchange of the products of labour between self-employed people or wage
workers who receive the full equivalent of their product. This means that they
supported the idea of a market in "defence associations" to ensure that the
fruits of an individual's labour would not be stolen by others. Again, the
social context of individualist anarchism -- namely, an egalitarian economy
without exploitation of labour (see [section G.3.4](secG3.html#secg34)) -- is
crucial for understanding these proposals. However, as in their treatment of
Tucker's support for contract theory, "anarcho"-capitalists remove the
individualist anarchists' ideas about free-market defence associations and
courts from the social context in which they were proposed, using those ideas
in an attempt to turn the individualists into defenders of capitalism.

As indicated in [section G.1.4](secG1.html#secg14), the social context in
question was one in which an economy of artisans and peasant farmers was being
replaced by a state-backed capitalism. This context is crucial for
understanding the idea of the "defence associations" that Tucker suggested.
For what he proposed was clearly **not** the defence of capitalist property
relations. This can be seen, for example, in his comments on land use. Thus:

> _"'The land for the people' . . . means the protection by . . . voluntary
associations for the maintenance of justice . . . of all people who desire to
cultivate land in possession of whatever land they personally cultivate . . .
and the positive refusal of the protecting power to lend its aid to the
collection of any rent, whatsoever."_ [**Instead of a Book**, p. 299]

There is no mention here of protecting **capitalist** farming, i.e. employing
wage labour; rather, there is explicit mention that only land being used for
**personal** cultivation -- thus **without** employing wage labour -- would be
defended. In other words, the defence association would defend _"occupancy and
use"_ (which is a clear break with capitalist property rights) and not the
domination of the landlord over society or those who use the land the landlord
claims to own. This means that certain contracts were not considered valid
within individualist anarchism even if they were voluntarily agreed to by the
parties involved and so would not be enforceable by the "defence
associations." As Tucker put it:

> _"A man cannot be allowed, merely by putting labour, to the limit of his
capacity and beyond the limit of his personal use, into material of which
there is a limited supply and the use of which is essential to the existence
of other men, to withhold that material from other men's use; and any contract
based upon or involving such withholding is lacking in sanctity or legitimacy
as a contract to deliver stolen goods."_ [**Liberty**, No. 321, p. 4]

Refusal to pay rent on land is a key aspect of Tucker's thought, and it is
significant that he explicitly rejects the idea that a defence association can
be used to collect it. In addition, as a means towards anarchy, Tucker
suggests _"inducing the people to steadily refuse the payment of rent and
taxes."_ [**Instead of a Book**, p. 299] It is hard to imagine that a
landowner influenced by Murray Rothbard or David Friedman would support such
an arrangement or a "defence association" that supported it. As such, the
individualist anarchist system would impose restrictions on the market from an
"anarcho"-capitalist perspective. Equally, from an individualist anarchist
perspective, "anarcho"-capitalism would be enforcing a key class monopoly by
force and so would simply be another kind of state. As Tucker put it in reply
to the proto-right-"libertarian" Auberon Herbert:

> _"It is true that Anarchists . . . do, in a sense, propose to get rid of
ground-rent by force. That is to say, if landlords should try to evict
occupants, the Anarchists advise the occupants to combine to maintain their
ground by force . . . But it is also true that the Individualists . . .
propose to get rid of theft by force . . . The Anarchists justify the use of
machinery (local juries, etc.) to adjust the property question involved in
rent just as the Individualists justify similar machinery to adjust the
property question involved in theft."_ [**Op. Cit.**, no. 172, p. 7]

It comes as no surprise to discover that Tucker translated Proudhon's **What
is Property?** and subscribed to its conclusion that _"property is theft"_!

This opposition to the _"land monopoly"_ was, like all the various economic
proposals made by the individualist anarchists, designed to eliminate the vast
differences in wealth accruing from the _"usury"_ of industrial capitalists,
bankers, and landlords. For example, Josiah Warren _"proposed like Robert Owen
an exchange of notes based on labour time . . . He wanted to establish an
'equitable commerce' in which all goods are exchanged for their cost of
production . . . In this way profit and interest would be eradicated and a
highly egalitarian order would emerge."_ [Peter Marshall, **Demanding the
Impossible**, p. 385] Given that the Warrenites considered that both workers
and managers would receive equal payment for equal hours worked (the manager
may, in fact earn less if it were concluded that their work was less
unpleasant than that done on the shopfloor), the end of a parasitic class of
wealthy capitalists was inevitable.

In the case of Benjamin Tucker, he was a firm adherent of socialist economic
analysis, believing that a free market and interest-free credit would reduce
prices to the cost of production and increase demand for labour to the point
where workers would receive the full value of their labour. In addition,
recognising that gold was a rare commodity, he rejected a gold-backed money
supply in favour of a land-backed one, as land with _"permanent improvements
on"_ it is _"an excellent basis for currency."_ [**Instead of a Book**, p.
198] Given that much of the population at the time worked on their own land,
such a money system would have ensured easy credit secured by land. Mutualism
replaced the gold standard (which, by its very nature would produce an
oligarchy of banks) with money backed by other, more available, commodities.

Such a system, the individualist anarchists argued, would be unlikely to
reproduce the massive inequalities of wealth associated with capitalism and
have a dynamic utterly different to that system. They did not consider the
state as some alien body grafted onto capitalism which could be removed and
replaced with "defence associations" leaving the rest of society more or less
the same. Rather, they saw the state as being an essential aspect of
capitalism, defending key class monopolies and restricting freedom for the
working class. By abolishing the state, they automatically abolished these
class monopolies and so capitalism. In other words, they had political **and**
economic goals and ignoring the second cannot help but produce **different**
results. As Voltairine de Cleyre put it in her individualist days, Anarchism
_"means not only the denial of authority, not only a new economy, but a
revision of the principles of morality. It means the development of the
individual as well as the assertion of the individual."_ [**The Voltairine de
Cleyre Reader**, p. 9]

Right-"libertarians" reject all of this, the social context of Tucker's ideas
on "defence associations." They do not aim for a _"new economy"_, but simply
the existing one without a public state. They have no critique of capitalist
property rights nor any understanding of how such rights can produce economic
power and limit individual freedom. In fact, they attack what they consider
the "bad economics" of the individualists without realising it is
**precisely** these "bad" (i.e. anti-capitalist) economics which will
minimise, if not totally eliminate, any potential threat to freedom associated
with "defence associations." Without the accumulations of wealth inevitable
when workers' do not receive the full product of their labour, it is unlikely
that a "defence association" would act like the private police forces American
capitalists utilised to break unions and strikes both in Tucker's time and
now. Unless this social context exists, any defence associations will soon
become mini-states, serving to enrich the elite few by protecting the usury
they gain from, and their power and control (i.e. government) over, those who
toil. In other words, the "defence associations" of Tucker and Spooner would
not be private states, enforcing the power of capitalists and landlords upon
wage workers. Instead, they would be like insurance companies, protecting
possessions against theft (as opposed to protecting capitalist theft from the
dispossessed as would be the case in "anarcho"-capitalism -- an important
difference lost on the private staters). Where social anarchists disagree with
individualist anarchists is on whether a market system will actually produce
such equality, particularly one without workers' self-management replacing the
authority inherent in the capitalist-labourer social relationship. As we
discuss in [section G.4](secG4.html), without the equality and the egalitarian
relationships of co-operative and artisan production there would be a tendency
for capitalism and private statism to erode anarchy.

In addition, the emphasis given by Tucker and Lysander Spooner to the place of
juries in a free society is equally important for understanding how their
ideas about defence associations fit into a non-capitalist scheme. For by
emphasising the importance of trial by jury, they knock an important leg from
under the private statism associated with "anarcho"-capitalism. Unlike a
wealthy judge, a jury made up mainly of fellow workers would be more inclined
to give verdicts in favour of workers struggling against bosses or of peasants
being forced off their land by immoral, but legal, means. As Lysander Spooner
argued in 1852: _"If a jury have not the right to judge between the government
and those who disobey its laws, and resist its oppressions, the government is
absolute, and the people, legally speaking, are slaves. Like many other slaves
they may have sufficient courage and strength to keep their masters somewhat
in check; but they are nevertheless known to the law only as slaves."_
[**Trial by Jury**] It is hardly surprising that Rothbard rejects this in
favour of a legal system determined and interpreted by lawyers, judges and
jurists. Indeed, as we noted in [section F.6.1](secF6.html#secf61), Rothbard
explicitly rejected the idea that juries should be able to judge the law as
well as the facts of a case under his system. Spooner would have had no
problem recognising that replacing government imposed laws with those made by
judges, jurists and lawyers would hardly change the situation much. Nor would
he have been too surprised at the results of a free market in laws in a
society with substantial inequalities in income and wealth.

Individualist Anarchist Laurance Labadie, the son of Tucker associate Joseph
Labadie, argued in response to Rothbard as follows:

> _"Mere common sense would suggest that any court would be influenced by
experience; and any free-market court or judge would in the very nature of
things have some precedents guiding them in their instructions to a jury. But
since no case is exactly the same, a jury would have considerable say about
the heinousness of the offence in each case, realising that circumstances
alter cases, and prescribing penalty accordingly. This appeared to Spooner and
Tucker to be a more flexible and equitable administration of justice possible
or feasible, human beings being what they are . . . _

> _"But when Mr. Rothbard quibbles about the jurisprudential ideas of Spooner
and Tucker, and at the same time upholds **presumably in his courts** the very
economic evils which are at bottom the very reason for human contention and
conflict, he would seem to be a man who chokes at a gnat while swallowing a
camel."_ [quoted by Mildred J. Loomis and Mark A. Sullivan, _"Laurance
Labadie: Keeper Of The Flame"_, pp. 116-30, **Benjamin R. Tucker and the
Champions of Liberty**, Coughlin, Hamilton and Sullivan (eds.), p. 124]

As we argued in detail in [section F.6](secF6.html), a market for "defence
associations" within an unequal system based on extensive wage labour would
simply be a system of private states, enforcing the authority of the property
owner over those who use but do not own their property. Such an outcome can
only be avoided within an egalitarian society where wage-labour is minimised,
if not abolished totally, in favour of self-employment (whether individually
or co-operatively). In other words, the kind of social context which the
individualist anarchists explicitly or implicitly assumed and aimed for. By
focusing selectively on a few individualist proposals taken out of their
social context, Rothbard and other "anarcho"-capitalists have turned the
libertarianism of the individualist anarchists into yet another ideological
weapon in the hands of (private) statism and capitalism.

When faced with the actual visions of a good society proposed by such people
as Tucker and Spooner, "anarcho"-capitalists tend to dismiss them as
irrelevant. They argue that it does not matter what Tucker or Spooner thought
would emerge from the application of their system, it is the fact they
advocated the "free market", "private property" and "defence associations"
that counts. In response anarchists note three things. Firstly, individualist
anarchists generally held radically different concepts of what a "free market"
and "private property" would be in their system and so the tasks of any
"defence association" would be radically different. As such, anarchists argue
that "anarcho"-capitalists simply look at the words people use rather than
what they meant by them and the social context in which they are used.
Secondly, it seems a strange form of support to rubbish the desired goals of
people you claim to follow. If someone claimed to be a Marxist while, at the
same time, arguing that Marx was wrong about socialism people would be
justified in questioning their use of that label. Thirdly, and most
importantly, no one advocates a means which would not result in their desired
ends. If Tucker and Spooner did not think their system would result in their
goals they would have either changed their goals or changed their method. As
noted in [section G.1.1](secG1.html#secg11), Tucker explicitly argued that
concentrations of wealth under capitalism had reached such levels that his
system of free competition would not end it. Clearly, then, outcomes were
important to individualist anarchists.

The lack of commonality can also be seen from the right-"libertarian" response
to Kevin Carson's excellent **Studies in Mutualist Political Economy**, an
impressive modern restatement of the ideas of Tucker and other individualist
anarchists. Leading "anarcho"-capitalist Walter Block dismissed _"Marxists
like Carson"_ and labelled him _"a supposed anarchist"_ who on many issues
_"is out there, way, way out there in some sort of Marxist never-never land."_
[_"Kevin Carson as Dr. Jeryll and Mr. Hyde"_, pp. 35-46, **Journal of
Libertarian Studies**, vol. 20, no. 1, p. 40, p. 43 and p. 45] Another
right-"libertarian", George Reisman, concurred stating that for the most part
_"Carson is a Marxist"_, while arguing that _"the 'individualist' anarchist
shows himself to be quite the collectivist, attributing to the average person
qualities of independent thought and judgement that are found only in
exceptional individuals."_ Carson's _"views on the nature of ownership give
full support to the conception of anarchy . . . as being nothing but chaos."_
Overall, _"Carson is essentially a Marxist and his book filled with ignorant
Marxist diatribes against capitalism."_ [_"Freedom is Slavery: Laissez-Faire
capitalism is government intervention"_, pp. 47-86, **Op. Cit.**, p. 47, p.
55, p. 61 and p. 84] Needless to say, all the issues which Block and Geisman
take umbridge at can be found in the works of individualist anarchists like
Tucker (Carson's excellent dissection of these remarkably ignorant diatribes
is well worth reading [_"Carson's Rejoinders"_, pp. 97-136, **Op. Cit.**]).

So the notion that a joint support for a market in "defence services" can
allow the social and theoretical differences between "anarcho"-capitalism and
individualist anarchism to be ignored is just nonsense. This can best be seen
from the fate of any individualist anarchist defence association within
"anarcho"-capitalism. As it would not subscribe to Rothbard's preferred system
of property rights it would be in violation of the _"general libertarian law
code"_ drawn up and implemented by right-"libertarian" jurists, judges and
lawyers. This would, by definition, make such an association _"outlaw"_ when
it defended tenants against attempts to extract rents from them or to evict
them from the land or buildings they used but did not own. As it is a judge-
run system, no jury would be able to judge the law as well as the crime, so
isolating the capitalist and landlord class from popular opposition. Thus the
ironic situation arises that the **_"Benjamin Tucker defence association"_**
would be declared an outlaw organisation under "anarcho"-capitalism and driven
out of business (i.e., destroyed) as it broke the land monopoly which the law
monopoly enforces. Even more ironically, such an organisation would survive in
an communist anarchist society (assuming it could find enough demand to make
it worthwhile).

If the world had had the misfortune of having "anarcho"-capitalism imposed on
it in the nineteenth century, individualist anarchists like Warren, Tucker,
Labadie, Ingalls and Lum would have joined Proudhon, Bakunin, Kropotkin,
Parsons and Goldman in prison for practising _"occupancy and use"_ in direct
violation of the _"general libertarian law code."_ That it was private police,
private courts and private prisons which were enforcing such a regime would
not have been considered that much of an improvement.

Unsurprisingly, Victor Yarros explicitly distanced himself from those who
_"want liberty to still further crush and oppress the people; liberty to enjoy
their plunder without fear of the State's interfering with them . . . liberty
to summarily deal with impudent tenants who refuse to pay tribute for the
privilege of living and working on the soil."_ [**Liberty**, no. 102, p. 4] He
would have had little problem recognising "anarcho"-capitalism as being a
supporter of _"that particular kind of freedom which the **bourgeoisie**
favours, and which is championed by the **bourgeoisie's** loyal servants,
[but] will never prove fascinating to the disinherited and oppressed."_ [**Op.
Cit.**, no. 93, p. 4]

## G.3.4 Why is individualist anarchist support for equality important?

Another another key difference between genuine individualist anarchism and
"anarcho"-capitalism is the former's support for equality and the latter's a
lack of concern for it.

In stark contrast to anarchists of all schools, inequality is not seen to be a
problem with "anarcho"-capitalists (see [section F.3](secF3.html)). However,
it is a truism that not all "traders" are equally subject to the market (i.e.,
have the same market power). In many cases, a few have sufficient control of
resources to influence or determine price and in such cases, all others must
submit to those terms or not buy the commodity. When the commodity is labour
power, even this option is lacking -- workers have to accept a job in order to
live. As we argued in [section C.9](secC9.html), workers are usually at a
disadvantage on the labour market when compared to capitalists, and this
forces them to sell their liberty in return for making profits for others.
These profits increase inequality in society as the property owners receive
the surplus value their workers produce. This increases inequality further,
consolidating market power and so weakens the bargaining position of workers
further, ensuring that even the freest competition possible could not
eliminate class power and society (something Tucker eventually recognised as
occurring with the development of trusts within capitalism -- see [section
G.1.1](secG1.html#secg11)).

By removing the underlying commitment to abolish non-labour income, any
"anarchist" capitalist society would have vast differences in wealth and so
power. Instead of government imposed monopolies in land, money and so on, the
economic power flowing from private property and capital would ensure that the
majority remained in (to use Spooner's words) _"the condition of servants"_
(see sections [F.2](secF2.html) and [F.3.1](secF3.html#secf31) for more on
this). The Individualist Anarchists were aware of this danger and so supported
economic ideas that opposed usury (i.e. rent, profit and interest) and ensured
the worker the full value of her labour. While not all of them called these
ideas "socialist" it is clear that these ideas **are** socialist in nature and
in aim (similarly, not all the Individualist Anarchists called themselves
anarchists but their ideas are clearly anarchist in nature and in aim). This
combination of the political and economic is essential as they mutually
reinforce each other. Without the economic ideas, the political ideas would be
meaningless as inequality would make a mockery of them. As Spooner argued,
inequality lead to many social evils:

> _"Extremes of difference, in their pecuniary circumstances, divide society
into castes; set up barriers to personal acquaintance; prevent or suppress
sympathy; give to different individuals a widely different experience, and
thus become the fertile source of alienation, contempt, envy, hatred, and
wrong. But give to each man all the fruits of his own labour, and a
comparative equality with others in his pecuniary condition, and caste is
broken down; education is given more equally to all; and the object is
promoted of placing each on a social level with all: of introducing each to
the acquaintance of all; and of giving to each the greatest amount of that
experience, which, being common to all, enables him to sympathise with all,
and insures to himself the sympathy of all. And thus the social virtues of
mankind would be greatly increased."_ [**Poverty: Its Illegal Causes and Legal
Cure**, pp. 46-7]

Because of the evil effects of inequality on freedom, both social and
individualist anarchists desire to create an environment in which
circumstances would not drive people to sell their liberty to others at a
disadvantage. In other words, they desired an equalisation of market power by
opposing interest, rent and profit and capitalist definitions of private
property. Kline summarises this by saying _"the American [individualist]
anarchists exposed the tension existing in liberal thought between private
property and the ideal of equal access. The Individual Anarchists were, at
least, aware that existing conditions were far from ideal, that the system
itself working against the majority of individuals in their efforts to attain
its promises. Lack of capital, the means to creation and accumulation of
wealth, usually doomed a labourer to a life of exploitation. This the
anarchists knew and they abhorred such a system."_ [**The Individualist
Anarchists: A critique of liberalism**, p. 102]

This desire for bargaining equality is reflected in their economic ideas and
by removing these underlying economic ideas of the individualist anarchists,
"anarcho"-capitalism makes a mockery of any ideas they do appropriate.
Essentially, the Individualist Anarchists agreed with Rousseau that in order
to prevent extreme inequality of fortunes you deprive people of the means to
accumulate in the first place and **not** take away wealth from the rich. An
important point which "anarcho"-capitalism fails to understand or appreciate.

The Individualist Anarchists assumed that exploitation of labour would be non-
existent in their system, so a general equality would prevail and so economic
power would not undermine liberty. Remove this underlying assumption, assume
that profits could be made and capital accumulated, assume that land can be
monopolised by landlords (as the "anarcho"-capitalists do) and a radically
different society is produced. One in which economic power means that the vast
majority have to sell themselves to get access to the means of life and are
exploited by those who own them in the process. A condition of "free markets"
may exist, but as Tucker argued in 1911, it would not be anarchism. The
**_deus ex machina_** of invisible hands takes a beating in the age of
monopolies.

So we must stress that the social situation is important as it shows how
apparently superficially similar arguments can have radically different aims
and results depending on who suggests them and in what circumstances. Hence
the importance of individualist anarchist support for equality. Without it,
genuine freedom would not exist for the many and "anarchy" would simply be
private statism enforcing rule by the rich.

## G.3.5 Would individualist anarchists have accepted "Austrian" economics?

One of the great myths perpetrated by "anarcho"-capitalists is the notion that
"anarcho"-capitalism is simply individualist anarchism plus "Austrian"
economics. Nothing could be further from the truth, as is clear once the
individualist anarchist positions on capitalist property rights, exploitation
and equality are understood. Combine this with their vision of a free society
as well as the social and political environment they were part of and the
ridiculous nature of such claims become obvious.

At its most basic, Individualist anarchism was rooted in socialist economic
analysis as would be expected of a self-proclaimed socialist theory and
movement. The "anarcho"-capitalists, in a roundabout way, recognise this with
Rothbard dismissing the economic fallacies of individualist anarchism in
favour of "Austrian" economics. _"There is,"_ he stated, _"in the body of
thought known as 'Austrian economics,' a scientific [sic!] explanation of the
workings of the free market . . . which individualist anarchists could easily
incorporate into their so political and social **Weltanshauung**. But to do
this, they must throw out the worthless excess baggage of money-crankism and
reconsider the nature and justification of the economic categories of
interest, rent and profit."_ Yet Rothbard's assertion is nonsense, given that
the individualist anarchists were well aware of various justifications for
exploitation expounded by the defenders of capitalism and rejected everyone.
He himself noted that the _"individualist anarchists were exposed to critiques
of their economic fallacies; but, unfortunately, the lesson, despite the
weakness of Tucker's replies, did not take."_ [_"The Spooner-Tucker Doctrine:
An Economist's View"_, **Op. Cit.**, p. 14] As such, it seems like extremely
wishful thinking that the likes of Tucker would have rushed to embrace an
economic ideology whose basic aim has always been to refute the claims of
socialism and defend capitalism from attacks on it.

Nor can it be suggested that the individualist anarchists were ignorant of the
developments within bourgeois economics which the "Austrian" school was part
of. Both Tucker and Yarros, for example, attacked marginal productivity theory
as advocated by John B. Clark. [**Liberty**, no. 305] Tucker critiqued another
anarchist for once being an _"Anarchistic socialist, standing squarely upon
the principles of Liberty and Equity"_ but then _"abandon[ing] Equity by
repudiating the Socialistic theory of value and adopting one which differs but
little, if any, from that held by the ordinary economist."_ [**Op. Cit.**, no.
80, p. 4] So the likes of Tucker were well aware of the so-called marginalist
revolution and rejected it.

Somewhat ironically, a key founder of "Austrian" economics was quoted
favourably in **Liberty** but only with regards to his devastating critique of
existing theories of interest and profit. Hugo Bilgram asked a defender of
interest whether he had _"ever read Volume 1 of Böhm-Bawerk's 'Capital and
Interest'"_ for in this volume _"the fructification theory is . . . completely
refuted."_ Bilgram, needless to say, did not support Böhm-Bawerk's defence of
usury, instead arguing that restrictions in the amount of money forced people
to pay for its use and _"[t]his, and nothing else, [causes] the interest
accruing to capital, regarding which the modern economists are doing their
utmost to find a theory that will not expose the system of industrial piracy
of today."_ He did not exclude Böhm-Bawerk's theory from his conclusion that
_"since every one of these pet theories is based on some fallacy, [economists]
cannot agree upon any one."_ The abolition of the money monopoly will
_"abolish the power of capital to appropriate a net profit."_ [**Op. Cit.**,
no. 282, p. 11] Tucker himself noted that Böhm-Bawerk _"has refuted all these
ancient apologies for interest -- productivity of capital, abstinence, etc."_
[**Op. Cit.**, no. 287, p. 5] **Liberty** also published a synopsis of Francis
Tandy's **Voluntary Socialism**, whose chapter 6 was _"devoted to an analysis
of value according to the marginal utility value of Böhm-Bawerk. It also deals
with the Marxian theory of surplus value, showing that all our economic ills
are due to the existence of that surplus value."_ [**Op. Cit.**, no. 334, p.
5] Clearly, then, the individualist anarchists were aware of the "Austrian"
tradition and only embraced its critique of previous defences of non-labour
incomes.

We have already critiqued the "time preference" justification for interest in
[section C.2.7](secC2.html#secc27) so will not go into it in much detail here.
Rothbard argued that it _"should be remembered by radicals that, if they
wanted to, all workers could refuse to work for wages and instead form their
own producers' co-operatives and wait for years for their pay until the
products are sold to the consumers; the fact that they do not do so, shows the
enormous advantage of the capital investment, wage-paying system as a means of
allowing workers to earn money far in advance of the sale of their products."_
And how, Professor Rothbard, are these workers to live during the years they
wait until their products are sold? The reason why workers do not work for
themselves has nothing to do with "time preference" but their lack of
resources, their **class** position. Showing how capitalist ideology clouds
the mind, Rothbard asserted that interest (_"in the shape of 'long-run'
profit"_) would still exist in a _"world in which everyone invested his own
money and nobody loaned or borrowed."_ [**Op. Cit.**, p. 12] Presumably, this
means that the self-employed worker who invests her own money into her own
farm pays herself interest payments just as her labour income is, presumably,
the "profits" from which this "interest" payment is deducted along with the
"rent" for access to the land she owns!

So it seems extremely unlikely that the individualist anarchists would have
considered "Austrian" economics as anything other than an attempt to justify
exploitation and capitalism, like the other theories they spent so much time
refuting. They would quickly have noted that "time preference", like the
"waiting"/"abstinence" justifications for interest, is based on taking the
current class system for granted and ignoring the economic pressures which
shape individual decisions. In Tucker's words (when he critiqued Henry
George's argument that interest is related to time) _"increase which is purely
the work of time bears a price only because of monopoly."_ The notion that
"time" produced profit or interest was one Tucker was well aware of, and
refuted on many occasions. He argued that it was class monopoly, restrictions
on banking, which caused interest and _"where there is no monopoly there will
be little or no interest."_ If someone _"is to be rewarded for his mere time,
what will reward him save [another]'s labour? There is no escape from this
dilemma. The proposition that the man who for time spent in idleness receives
the product of time employed in labour is a parasite upon the body industrial
is one which . . . [its supporters] can never successfully dispute with men
who understand the rudiments of political economy."_ [**Liberty**, no. 109, p.
4 and p. 5] For Joshua King Ingalls, _"abstinence"_ (or the ability to
_"wait,"_ as it was renamed in the late nineteenth century) was _"a term with
which our cowardly moral scientists and political economists attempt to
conjure up a spirit that will justify the greed of our land and money systems;
by a casuistry similar to that which once would have justified human
slavery."_ [_"Labor, Wages, And Capital. Division Of Profits Scientifically
Considered,"_ **Brittan's Quarterly Journal**, I (1873), pp. 66-79]

What of the economic justification for that other great evil for individualist
anarchists, rent? Rothbard attacked Adam Smith's comment that landlords were
monopolists who demanded rent for nature's produce and liked to reap what they
never sowed. As he put it, Smith showed _"no hint of recognition here that the
landlord performs the vital function of allocating the land to its most
productive use."_ [**An Austrian Perspective on the History of Economic
Thought**, vol. 1, p. 456] Yet, as Smith was well aware, it is the farmer who
has to feed himself and pay rent who decides how best to use the land, not the
landlord. All the landlord does is decide whether to throw the farmer off the
land when a more profitable business opportunity arrives (as in, say, the
Highland clearances) or that it is more "productive" to export food while
local people starve (as in, say, the great Irish famine). It was precisely
this kind of arbitrary power which the individualist anarchists opposed. As
John Beverley Robinson put it, the _"land owner gives nothing whatever, but
permission to you to live and work on his land. He does not give his product
in exchange for yours. He did not produce the land. He obtained a title at law
to it; that is, a privilege to keep everybody off his land until they paid him
his price. He is well called the lord of the land -- the landlord!"_
[**Patterns of Anarchy**, p. 271]

Significantly, while Rothbard attacked Henry George's scheme for land
nationalisation as being a tax on property owners and stopping rent playing
the role "Austrian" economic theory assigns it, the individualist anarchists
opposed it because, at best, it would not end landlordism or, at worse, turn
the state into the only landlord. In an unequal society, leasing land from the
state _"would greatly enhance the power of capitalism to engross the control
of the land, since it would relieve it of the necessity of applying large
amounts in purchasing land which it could secure the same control of by lease
. . . It would greatly augment and promote the reign of the capitalism and
displace the independent worker who now cultivates his own acres, but who
would be then unable to compete with organised capital . . . and would be
compelled to give up his holding and sink into the ranks of the proletariat."_
[Joshua King Ingalls, Bowman N. Hall, _"Joshua K. Ingalls, American
Individualist: Land Reformer, Opponent of Henry George and Advocate of Land
Leasing, Now an Established Mode"_, pp. 383-96, **American Journal of
Economics and Sociology**, Vol. 39, No. 4, p. 394]

Given Tucker's opposition to rent, interest and profit it should go without
saying that he rejected the neo-classical and "Austrian" notion that a
workers' wages equalled the "marginal product," i.e. its contribution to the
production process (see [section C.2](secC2.html) for a critique of this
position). Basing himself on the socialist critique of classical economics
developed by Proudhon and Marx, he argued that non-labour income was usury and
would be driven to zero in a genuinely free market. As such, any notion that
Tucker thought that workers in a "free market" are paid according to their
marginal product is simply wrong and any claim otherwise shows a utter
ignorance of the subject matter. Individualist anarchists like Tucker strongly
believed that a truly free (i.e. non-capitalist) market would ensure that the
worker would receive the _"full product"_ of his or her labour. Nevertheless,
in order to claim Tucker as a proto-"anarcho"-capitalist,
"anarcho"-capitalists may argue that capitalism pays the "market price" of
labour power, and that this price **does** reflect the _"full product"_ (or
value) of the worker's labour. As Tucker was a socialist, we doubt that he
would have agreed with the "anarcho"-capitalist argument that market price of
labour reflected the value it produced. He, like the other individualist
anarchists, was well aware that labour produces the "surplus value" which was
appropriated in the name of interest, rent and profit. In other words, he very
forcibly rejected the idea that the market price of labour reflects the value
of that labour, considering _"the natural wage of labour is its product"_ and
_"that this wage, or product, is the only just source of income."_ [**Instead
of a Book**, p. 6]

**Liberty** also favourably quoted a supporter of the silver coinage, General Francis A. Walker, and his arguments in favour of ending the gold standard. It praised his argument as _"far more sound and rational than that of the supercilious, narrow, bigoted monomentallists."_ Walker attacked those _"economists of the **a priori** school, who treat all things industrial as if they were in a state of flux, ready to be poured indifferently into any kind of mould or pattern."_ These economists _"are always on hand with the answer that industrial society will 'readjust' itself to the new conditions"_ and _"it would not matter if wages were at any time unduly depressed by combinations of employers, inasmuch as the excess of profits resulting would infallibly become capital, and as such, constitute an additional demand for labour . . . It has been the teaching of the economists of this sort which has so deeply discredited political economy with the labouring men on the one hand, and with practical business men on the other."_ The _"greatest part of the evil of a diminishing money supply is wrought through the discouragement of enterprise."_ [**Liberty**, no. 287, p. 11] Given that the "Austrian" school takes the **a priori** methodology to ridiculous extremes and is always on hand to defend _"excess of profits"_, _"combinations of employers"_ and the gold standard we can surmise Tucker's reaction to Rothbard's pet economic ideology.

Somewhat ironically, given Rothbard's attempts to inflict bourgeois economics
along with lots of other capitalist ideology onto individualist anarchism,
Kropotkin noted that supporters of _"individualist anarchism . . . soon
realise that the individualisation they so highly praise is not attainable by
individual efforts, and . . . [some] abandon the ranks of the anarchists, and
are driven into the liberal individualism of the classical economists."_
[**Anarchism**, p. 297] "Anarcho"-capitalists confuse the ending place of
**ex**-anarchists with their starting point. As can be seen from their attempt
to co-opt the likes of Spooner and Tucker, this confusion only appears
persuasive by ignoring the bulk of their ideas as well as rewriting the
history of anarchism.

So it can, we think, be safe to assume that Tucker and other individualist
anarchists would have little problem in refuting Rothbard's economic fallacies
as well as his goldbug notions (which seem to be the money monopoly in another
form) and support for the land monopoly. Significantly, modern individualist
anarchists like Kevin Carson have felt no need to embrace "Austrian" economics
and retain their socialist analysis while, at the same time, making telling
criticisms of Rothbard's favourite economic ideology and the apologetics for
"actually existing" capitalism its supporters too often indulge in (Carson
calls this _"vulgar libertarianism"_, wherein right-"libertarians" forget that
the current economy is far from their stated ideal when it is a case of
defending corporations or the wealthy).

## G.3.6 Would mutual banking simply cause inflation?

One of the arguments against Individualist and mutualist anarchism, and mutual
banking in general, is that it would just produce accelerating inflation. The
argument is that by providing credit without interest, more and more money
would be pumped into the economy. This would lead to more and more money
chasing a given set of goods, so leading to price rises and inflation.

Rothbard, for example, dismissed individualist anarchist ideas on mutual
banking as being _"totally fallacious monetary views."_ He based his critique
on "Austrian" economics and its notion of _"time preference"_ (see [section
C.2.7](secC2.html#secc27) for a critique of this position). Mutual banking
would artificially lower the interest rate by generating credit, Rothbard
argued, with the new money only benefiting those who initially get it. This
process "exploits" those further down the line in the form accelerating
inflation. As more and more money was be pumped into the economy, it would
lead to more and more money chasing a given set of goods, so leading to price
rises and inflation. To prove this, Rothbard repeated Hume's argument that
_"if everybody magically woke up one morning with the quantity of money in his
possession doubled"_ then prices would simply double. [_"The Spooner-Tucker
Doctrine: An Economist's View"_, **Journal of Libertarian Studies**, vol. 20,
no. 1, p. 14 and p. 10]

However, Rothbard is assuming that the amount of goods and services are fixed.
This is just wrong and shows a real lack of understanding of how money works
in a real economy. This is shown by the lack of agency in his example, the
money just "appears" by magic (perhaps by means of a laissez-fairy?). Milton
Friedman made the same mistake, although he used the more up to date example
of government helicopters dropping bank notes. As post-Keynesian economist
Nicholas Kaldor pointed out with regards to Friedman's position, the
_"transmission mechanism from money to income remained a 'black box' -- he
could not explain it, and he did not attempt to explain it either. When it
came to the question of **how** the authorities increase the supply of bank
notes in circulation he answered that they are scattered over populated areas
by means of a helicopter -- though he did not go into the ultimate
consequences of such an aerial Santa Claus."_ [**The Scourge of Monetarism**,
p. 28]

Friedman's and Rothbard's analysis betrays a lack of understanding of
economics and money. This is unsurprising as it comes to us via neo-classical
economics. In neo-classical economics inflation is always a monetary phenomena
-- too much money chasing too few goods. Milton Friedman's Monetarism was the
logical conclusion of this perspective and although "Austrian" economics is
extremely critical of Monetarism it does, however, share many of the same
assumptions and fallacies (as Hayek's one-time follower Nicholas Kaldor noted,
key parts of Friedman's doctrine are _"closely reminiscent of the Austrian
school of the twenties and the early thirties"_ although it _"misses some of
the subtleties of the Hayekian transmission mechanism and of the money-induced
distortions in the 'structure of production.'"_ [**The Essential Kaldor**, pp.
476-7]). We can reject this argument on numerous points.

Firstly, the claim that inflation is always and everywhere a monetary
phenomena has been empirically refuted -- often using Friedman's own data and
attempts to apply his dogma in real life. As we noted in [section
C.8.3](secC8.html#secc83), the growth of the money supply and inflation have
no fixed relationship, with money supply increasing while inflation falls. As
such, _"the claim that inflation is always and everywhere caused by increases
in the money supply, and that the rate of inflation bears a stable,
predictable relationship to increases in the money supply is ridiculous."_
[Paul Ormerod, **The Death of Economics**, p. 96] This means that the
assumption that increasing the money supply by generating credit will always
simply result in inflation cannot be supported by the empirical evidence we
have. As Kaldor stressed, the _"the 'first-round effects' of the helicopter
operation could be anything, depending on where the scatter occurred . . .
there is no reason to suppose that the ultimate effect on the amount of money
in circulation or on incomes would bear any close relation to the initial
injections."_ [**The Scourge of Monetarism**, p. 29]

Secondly, even if we ignore the empirical record (as "Austrian" economics
tends to do when faced with inconvenient facts) the "logical" argument used to
explain the theory that increases in money will increase prices is flawed.
Defenders of this argument usually present mental exercises to prove their
case (as in Hume and Friedman). Needless to say, such an argument is spurious
in the extreme simply because money does not enter the economy in this
fashion. It is generated to meet specific demands for money and is so,
generally, used productively. In other words, money creation is a function of
the demand for credit, which is a function of the needs of the economy (i.e.
it is endogenous) and **not** determined by the central bank injecting it into
the system (i.e. it is **not** exogenous). And this indicates why the argument
that mutual banking would produce inflation is flawed. It does not take into
account the fact that money will be used to generate **_new_** goods and
services.

As leading Post-Keynesian economist Paul Davidson argued, the notion that
_"inflation is always and everywhere a monetary phenomenon"_ (to use
Friedman's expression) is _"ultimately based on the old homily that inflation
is merely 'too many dollars chasing too few goods.'"_ Davidson notes that
_"[t]his 'too many dollars cliché is usually illustrated by employing a two-
island parable. Imagine a hypothetical island where the only available goods
are 10 apples and the money supply consists of, say, 10 $1 bills. If all the
dollars are used to purchase the apples, the price per apple will be $1. For
comparison, assume that on a second island there are 20 $1 bills and only 10
apples. All other things being equal, the price will be $2 per apple. Ergo,
inflation occurs whenever the money supply is excessive relative to the
available goods."_ The similarities with Rothbard's argument are clear. So are
its flaws as _"no explanation is given as to why the money supply was greater
on the second island. Nor is it admitted that, if the increase in the money
supply is associated with entrepreneurs borrowing 'real bills' from banks to
finance an increase in payrolls necessary to harvest, say, 30 additional
apples so that the $20 chases 40 apples, then the price will be only $0.50 per
apple. If a case of 'real bills' finance occurs, then an increase in the money
supply is not associated with higher prices but with greater output."_
[**Controversies in Post Keynesian Economics**, p. 100] Davidson is
unknowingly echoing Tucker (_"It is the especial claim of free banking that it
will increase production . . . If free banking were only a picayanish attempt
to distribute more equitably the small amount of wealth now produced, I would
not waste a moment's energy on it."_ [**Liberty**, no. 193, p. 3]).

This, in reply to the claims of neo-classical economics, indicates why mutual
banking would not increase inflation. Like the neo-classical position,
Rothbard's viewpoint is static in nature and does not understand how a real
economy works. Needless to say, he (like Friedman) did not discuss how the new
money gets into circulation. Perhaps, like Hume, it was a case of the money
fairy (laissez-fairy?) placing the money into people's wallets. Maybe it was a
case, like Friedman, of government (black?) helicopters dropping it from the
skies. Rothbard did not expound on the mechanism by which money would be
created or placed into circulation, rather it just appears one day out of the
blue and starts chasing a given amount of goods. However, the individualist
anarchists and mutualists did not think in such bizarre (typically, economist)
ways. Rather than think that mutual banks would hand out cash willy-nilly to
passing strangers, they realistically considered the role of the banks to be
one of evaluating useful investment opportunities (i.e., ones which would be
likely to succeed). As such, the role of credit would be to **increase** the
number of goods and services in circulation along with money, so ensuring that
inflation is not generated (assuming that it is caused by the money supply, of
course). As one Individualist Anarchist put it, _"[i]n the absence of such
restrictions [on money and credit], imagine the rapid growth of wealth, and
the equity in its distribution, that would result."_ [John Beverley Robinson,
**The Individualist Anarchists**, p. 144] Thus Tucker:

> _"A is a farmer owning a farm. He mortgages his farm to a bank for $1,000,
giving the bank a mortgage note for that sum and receiving in exchange the
bank's notes for the same sum, which are secured by the mortgage. With the
bank-notes A buys farming tools off B. The next day B uses the notes to buy
off C the materials used in the manufacture of tools. The day after, C in turn
pays them to D in exchange for something he needs. At the end of a year, after
a constant succession of exchanges, the notes are in the hands of Z, a dealer
in farm produce. He pays them to A, who gives in return $1,000 worth of farm
products which he has raised during the year. Then A carries the notes to the
bank, receives in exchange for them his mortgage note, and the bank cancels
the mortgage. Now, in this whole circle of transactions, has there been any
lending of capital? If so, who was the lender? If not, who is entitled to
interest?"_ [**Instead of a Book**, p. 198]

Obviously, in a real economy, as Rothbard admits _"inflation of the money
supply takes place a step at a time and that the first beneficiaries, the
people who get the new money first, gain at the expense of the people
unfortunate enough to come last in line."_ This process is _"plunder and
exploitation"_ as the _"prices of things they [those last in line] have to buy
shooting up before the new injection [of money] filters down to them."_ [**Op.
Cit.**, p. 11] Yet this expansion of the initial example, again, assumes that
there is no increase in goods and services in the economy, that the _"first
beneficiaries"_ do nothing with the money bar simply buying more of the
existing goods and services. It further assumes that this existing supply of
goods and services is unchangeable, that firms do not have inventories of
goods and sufficient slack to meet unexpected increases in demand. In reality,
of course, a mutual bank would be funding productive investments and any firm
will respond to increasing demand by increasing production as their
inventories start to decline. In effect, Rothbard's analysis is just as static
and unrealistic as the notion of money suddenly appearing overnight in
people's wallets. Perhaps unsurprisingly Rothbard compared the credit
generation of banks to the act of counterfeiters so showing his utter lack of
awareness of how banks work in a credit-money (i.e., real) economy.

The "Austrian" theory of the business cycle is rooted in the notion that banks
artificially lower the rate of interest by providing more credit than their
savings and specie reverses warrant. Even in terms of pure logic, such an
analysis is flawed as it cannot reasonably be asserted that all
"malinvestment" is caused by credit expansion as capitalists and investors
make unwise decisions all the time, irrespective of the supply of credit. Thus
it is simply false to assert, as Rothbard did, that the _"process of
inflation, as carried out in the real [sic!] world"_ is based on _"new money"_
entering the market by means of _"the loan market"_ but _"this fall is
strictly temporary, and the market soon restores the rate to its proper
level."_ A crash, according to Rothbard, is the process of restoring the rate
of interest to its _"proper"_ level yet a crash can occur even if the interest
rate is at that rate, assuming that the banks can discover this equilibrium
rate and have an incentive to do so (as we discussed in [section
C.8](secC8.html) both are unlikely). Ultimately, credit expansion fails under
capitalism because it runs into the contradictions within the capitalist
economy, the need for capitalists, financiers and landlords to make profits
via exploiting labour. As interest rates increase, capitalists have to service
their rising debts putting pressure on their profit margins and so raising the
number of bankruptcies. In an economy without non-labour income, the
individualist anarchists argued, this process is undercut if not eliminated.

So expanding this from the world of fictional government helicopters and money
fairies, we can see why Rothbard is wrong. Mutual banks operate on the basis
of providing loans to people to set up or expand business, either as
individuals or as co-operatives. When they provide a loan, in other words,
they **increase** the amount of goods and services in the economy. Similarly,
they do not simply increase the money supply to reduce interest rates. Rather,
they reduce interest rates to increase the demand for money in order to
increase the productive activity in an economy. By producing new goods and
services, inflation is kept at bay. Would increased demand for goods by the
new firms create inflation? Only if every firm was operating at maximum
output, which would be a highly unlikely occurrence in reality (unlike in
economic textbooks).

So what, then does case inflation? Inflation, rather than being the result of
monetary factors, is, in fact, a result of profit levels and the dynamic of
the class struggle. In this most anarchists agree with post-Keynesian
economics which views inflation as _"a symptom of an on-going struggle over
income distribution by the exertion of market power."_ [Paul Davidson, **Op.
Cit.**, p. 102] As workers' market power increases via fuller employment,
their organisation, militancy and solidarity increases so eroding profits as
workers keep more of the value they produce. Capitalists try and maintain
their profits by rising prices, thus generating inflation (i.e. general price
rises). Rather than accept the judgement of market forces in the form of lower
profits, capitalists use their control over industry and market power of their
firms to maintain their profit levels at the expense of the consumer (i.e.,
the workers and their families).

In this sense, mutual banks **could** contribute to inflation -- by reducing
unemployment by providing the credit needed for workers to start their own
businesses and co-operatives, workers' power would increase and so reduce the
power of managers to extract more work for a given wage and give workers a
better economic environment to ask for better wages and conditions. This was,
it should be stressed, a key reason why the individualist anarchists supported
mutual banking:

> _"people who are now deterred from going into business by the ruinously high
rates which they must pay for capital with which to start and carry on
business will find their difficulties removed . . . This facility of acquiring
capital will give an unheard of impetus to business, and consequently create
an unprecedented demand for labour -- a demand which will always be in excess
of the supply, directly to the contrary of the present condition of the labour
market . . . Labour will then be in a position to dictate its wages."_
[Tucker, **The Individualist Anarchists**, pp. 84-5]

And, it must also be stressed, this was a key reason why the capitalist class
turned against Keynesian full employment policies in the 1970s (see [section
C.8.3](secC8.html#secc83)). Lower interest rates and demand management by the
state lead precisely to the outcome predicted by the likes of Tucker, namely
an increase in working class power in the labour market as a result of a
lowering of unemployment to unprecedented levels. This, however, lead to
rising prices as capitalists tried to maintain their profits by passing on
wage increases rather than take the cut in profits indicated by economic
forces. This could also occur if mutual banking took off and, in this sense,
mutual banking could produce inflation. However, such an argument against the
scheme requires the neo-classical and "Austrian" economist to acknowledge that
capitalism cannot produce full employment and that the labour market must
always be skewed in favour of the capitalist to keep it working, to maintain
the inequality of bargaining power between worker and capitalist. In other
words, that capitalism needs unemployment to exist and so cannot produce an
efficient and humane allocation of resources.

By supplying working people with money which is used to create productive co-
operatives and demand for their products, mutual banks increase the amount of
goods and services in circulation as they increase the money supply. Combined
with the elimination of profit, rent and interest, inflationary pressures are
effectively undercut (it makes much more sense to talk of a interest/rent
/profits-prices spiral rather than a wages-prices spiral when discussing
inflation). Only in the context of the ridiculous examples presented by neo-
classical and "Austrian" economics does increasing the money supply result in
rising inflation. Indeed, the "sound economic" view, in which if the various
money-substitutes are in a fixed and constant proportion to "real money" (i.e.
gold or silver) then inflation would not exist, ignores the history of money
and the nature of the banking system. It overlooks the fact that the emergence
of bank notes, fractional reserve banking and credit was a spontaneous
process, not planned or imposed by the state, but rather came from the profit
needs of capitalist banks which, in turn, reflected the real needs of the
economy (_"The truth is that, as the exchanges of the world increased, and the
time came when there was not enough gold and silver to effect these exchanges,
so . . . people had to resort to paper promises."_ [John Beverley Robinson,
**Op. Cit.**, p. 139]). What **was** imposed by the state, however, was the
imposition of legal tender, the use of specie and a money monopoly (_"attempt
after attempt has been made to introduce credit money outside of government
and national bank channels, and the promptness of the suppression has always
been proportional to the success of the attempt."_ [Tucker, **Liberty**, no.
193, p. 3]).

Given that the money supply is endogenous in nature, any attempt to control
the money supply will fail. Rather than control the money supply, which would
be impossible, the state would have to use interest rates. To reduce the
demand for money, interest rates would be raised higher and higher, causing a
deep recession as business cannot maintain their debt payments and go
bankrupt. This would cause unemployment to rise, weakening workers' bargaining
power and skewing the economy back towards the bosses and profits -- so making
working people pay for capitalism's crisis. Which, essentially, is what the
Thatcher and Reagan governments did in the early 1980s. Finding it impossible
to control the money supply, they raised interest rates to dampen down the
demand for credit, which provoked a deep recession. Faced with massive
unemployment, workers' market power decreased and their bosses increased,
causing a shift in power and income towards capital.

So, obviously, in a capitalist economy the increasing of credit is a source of
instability. While not causing the business cycle, it does increase its
magnitude. As the boom gathers strength, banks want to make money and increase
credit by lowering interest rates below what they should be to match savings.
Capitalists rush to invest, so soaking up some of the unemployment which
always marks capitalism. The lack of unemployment as a disciplinary tool is
why the boom turns to bust, not the increased investment. Given that in a
mutualist system, profits, interest and rent do not exist then erosion of
profits which marks the top of a boom would not be applicable. If prices drop,
then labour income drops. Thus a mutualist society need not fear inflation. As
Kaldor argued with regard to the current system, _"under a 'credit-money'
system . . . unwanted or excess amounts of money **could never come into
existence**; it is the increase in the value of transactions . . . which calls
forth an increase in the 'money supply' (whether in the form of bank balances
or notes in circulation) as a result of the net increase in the value of
working capital at the various stages of production and distribution."_ [**Op.
Cit.**, p. 46] The gold standard cannot do what a well-run credit-currency can
do, namely tailor the money supply to the economy's demand for money. The
problem in the nineteenth century was that a capitalist credit-money economy
was built upon a commodity-money base, with predictably bad results.

Would this be any different under Rothbard's system? Probably not. For
Rothbard, each bank would have 100% reserve of gold with a law passed that
defined fractional reserve banking as fraud. How would this affect mutual
banks? Rothbard argued that attempts to create mutual banks or other non-gold
based banking systems would be allowed under his system. Yet, how does this
fit into his repeated call for a 100% gold standard for banks? Why would a
mutual bank be excluded from a law on banking? Is there a difference between a
mutual bank issuing credit on the basis of a secured loan rather than gold and
a normal bank doing so? Needless to say, Rothbard never did address the fact
that the customers of the banks **know** that they practised fractional
reserve banking and still did business with them. Nor did he wonder why no
enterprising banker exploited a market niche by advertising a 100% reserve
policy. He simply assumed that the general public subscribed to his gold-bug
prejudices and so would not frequent mutual banks. As for other banks, the
full might of the law would be used to stop them practising the same policies
and freedoms he allowed for mutual ones. So rather than give people the
freedom to choose whether to save with a fractional reserve bank or not,
Rothbard simply outlawed that option. Would a regime inspired by Rothbard's
goldbug dogmas really allow mutual banks to operate when it refuses other
banks the freedom to issue credit and money on the same basis? It seems
illogical for that to be the case and so would such a regime not, in fact,
simply be a new form of the money monopoly Tucker and his colleagues spent so
much time combating? One thing is sure, though, even a 100% gold standard will
not stop credit expansion as firms and banks would find ways around the law
and it is doubtful that private defence firms would be in a position to
enforce it.

Once we understand the absurd examples used to refute mutual banking plus the
real reasons for inflation (i.e., _"a symptom of a struggle over the
distribution of income."_ [Davidson, **Op. Cit.**, p. 89]) and how credit-
money actually works, it becomes clear that the case against mutual banking is
far from clear. Somewhat ironically, the post-Keynesian school of economics
provides a firm understanding of how a real credit system works compared to
Rothbard's logical deductions from imaginary events based on propositions
which are, at root, identical with Walrasian general equilibrium theory (an
analysis "Austrians" tend to dismiss). It may be ironic, but not unsurprising
as Keynes praised Proudhon's follower Silvio Gesell in **The General Theory**
(also see Dudley Dillard's essay _"Keynes and Proudhon"_ [**The Journal of
Economic History**, vol. 2, No. 1, pp. 63-76]). Libertarian Marxist Paul
Mattick noted Keynes debt to Proudhon, and although Keynes did not subscribe
to Proudhon's desire to use free credit to fund _"independent producers and
workers' syndicates"_ as a means create an economic system _"without
exploitation"_ he did share the Frenchman's _"attack upon the payment of
interest"_ and wish to see the end of the rentier. [**Marx and Keynes**, p. 5
and p. 6]

Undoubtedly, given the "Austrian" hatred of Keynes and his economics
(inspired, in part, by the defeat inflicted on Hayek's business cycle theory
in the 1930s by the Keynesians) this will simply confirm their opinion that
the Individualist Anarchists did not have a sound economic analysis! As
Rothbard noted, the individualist anarchist position was _"simply pushing to
its logical conclusion a fallacy adopted widely by preclassical and by current
Keynesian writers."_ [**Op. Cit.**, p. 10] However, Keynes was trying to
analyse the economy as it is rather than deducing logically desired
conclusions from the appropriate assumptions needed to confirm the prejudices
of the assumer (like Rothbard). In this, he did share the same method if not
exactly the same conclusions as the Individualist Anarchists and Mutualists.

Needless to say, social anarchists do not agree that mutual banking can reform
capitalism away. As we discuss in [section G.4](secG4.html), this is due to
many factors, including the natural barriers to competition capital
accumulation creates. However, this critique is based on the real economy and
does not reflect Rothbard's abstract theorising based on pre-scientific
methodology. While other anarchists may reject certain aspects of Tucker's
ideas on money, we are well aware, as one commentator noted, that his
_"position regarding the State and money monopoly derived from his Socialist
convictions"_ where socialism _"referred to an intent to fundamentally
reorganise the societal systems so as to return the full product of labour to
the labourers."_ [Don Werkheiser, _"Benjamin R. Tucker: Champion of Free
Money"_, pp. 212-221, **Benjamin R. Tucker and the Champions of Liberty**,
Coughlin, Hamilton and Sullivan (eds.), p. 212]

[‹ G.2 Why do individualist anarchists reject social
anarchism?](/afaq/secG2.html "Go to previous page" ) [up](/afaq/secGcon.html
"Go to parent page" ) [G.4 Why do social anarchists reject individualist
anarchism? ›](/afaq/secG4.html "Go to next page" )

