# G.5 Benjamin Tucker: Capitalist or Anarchist?

Benjamin Tucker, like all genuine anarchists, was against both the state and
capitalism, against both oppression and exploitation. While not against the
market and property he was firmly against capitalism as it was, in his eyes, a
state-supported monopoly of social capital (tools, machinery, etc.) which
allows owners to exploit their employees, i.e., to avoid paying workers the
full value of their labour. He thought that the _"labouring classes are
deprived of their earnings by usury in its three forms, interest, rent and
profit."_ [quoted by James J. Martin, **Men Against the State**, p. 210f]
Therefore _"Liberty will abolish interest; it will abolish profit; it will
abolish monopolistic rent; it will abolish taxation; it will abolish the
exploitation of labour; it will abolish all means whereby any labourer can be
deprived of any of his product."_ [**The Individualist Anarchists**, p. 157]

This stance puts him squarely in the libertarian socialist tradition and,
unsurprisingly, Tucker referred to himself many times as a socialist and
considered his philosophy to be _"Anarchistic socialism."_ For Tucker,
capitalist society was exploitative and stopped the full development of all
and so had to be replaced:

> _"[This] society is fundamentally anti-social. The whole so-called social
fabric rests on privilege and power, and is disordered and strained in every
direction by the inequalities that necessarily result therefrom. The welfare
of each, instead of contributing to that of all, as it naturally should and
would, almost invariably detracts from that of all. Wealth is made by legal
privilege a hook with which to filch from labour's pockets. Every man who gets
rich thereby makes his neighbours poor. The better off one is, the worse the
rest are . . . Labour's Deficit is precisely equal to the Capitalist's
Efficit. _

> _"Now, Socialism wants to change all this. Socialism says . . . that no man
shall be able to add to his riches except by labour; that is adding to his
riches by his labour alone no man makes another man poorer; that on the
contrary every man thus adding to his riches makes every other man richer; . .
. that every increase in capital in the hands of the labourer tends, in the
absence of legal monopoly, to put more products, better products, cheaper
products, and a greater variety of products within the reach of every man who
works; and that this fact means the physical, mental, and moral perfecting of
mankind, and the realisation of human fraternity."_ [**Instead of a Book**,
pp. 361-2]

It is true that he also sometimes railed against "socialism," but in those
cases it is clear that he was referring to **state** socialism. Like many
anarchists (including Proudhon, Bakunin and Kropotkin), he argued that there
are two kinds of socialism based upon two different principles:

> _"The two principles referred to are Authority and Liberty, and the names of
the two schools of Socialistic thought which fully and unreservedly represent
one or the other of them are, respectively, State Socialism and Anarchism.
Whoso knows what these two schools want and how they propose to get it
understands the Socialistic movement. For, just as it has been said that there
is no half-way house between Rome and Reason, so it may be said that there is
no half-way house between State Socialism and Anarchism."_ [**The Anarchist
Reader**, p. 150]

Like other socialists, Tucker argued that profits _"to a few mean robbery of
others, -- monopoly. Andrews and Warren, realising this, make individual
sovereignty **and** the cost principle the essential conditions of a true
civilisation."_ [**Liberty**, no. 94, p. 1] Like Proudhon, he argued that
_"property, in the sense of individual possession, is liberty."_ [**Op.
Cit.**, no. 122, p. 4] However, unlike state socialists and communist-
anarchists, Tucker saw a key role for a market system under socialism. In this
he followed Proudhon who also argued that competition was required to ensure
that prices reflected the labour costs involved in producing it and so
interest, rent and profit were opposed because they did not reflect actual
costs but simply usury paid to the wealthy for being allowed to use part of
their wealth, a part the rich could comfortably lend out to others as they
were not using it. Once capitalism was abolished, the market would be able to
reach its full promise and become a means of enriching all rather than the
few:

> _"Liberty's aim -- universal happiness -- is that of all Socialists, in
contrast with that of the Manchester men -- luxury fed by misery. But its
principle -- individual sovereignty -- is that of the Manchester men, in
contrast with that of the Socialists -- individual subordination. But
individual sovereignty, **when logically carried out**, leads, not to luxury
fed by misery, but to comfort for all industrious persons and death for all
idle ones."_ [**Liberty**, no. 89, p. 1]

As other anarchists have also argued, likewise for Tucker -- the state is the
_"protector"_ of the exploiter. _"Usury is the serpent gnawing at labour's
vitals, and only liberty can detach and kill it. Give labourers their liberty
and they will keep their wealth."_ [**The Individualist Anarchists**, p. 89]
From this it is clear that he considered laissez-faire capitalism to be
opposed to genuine individual sovereignty. This was because it was based on
the state interfering in the market by enforcing certain restrictions on
competition in favour of the capitalist class and certain types of private
property. Thus his opposition to the state reflected his opposition to
capitalist property rights and the abolition of the state automatically meant
their abolition as well.

Tucker spent considerable time making it clear that he was against capitalist
private property rights, most notably in land and what was on it. He supported
Proudhon's argument that _"property is theft,"_ even translating many of
Proudhon's works including the classic _"What is Property?"_ where that phrase
originated. Tucker advocated **possession** (or _"occupancy and use,"_ to use
his preferred expression for the concept) but not private property, believing
that empty land, houses, and so on should be squatted by those who could use
them, as labour (i.e. use) would be the only title to "property" (Tucker
opposed all non-labour income as usury). For Tucker, the true _"Anarchistic
doctrine"_ was _"occupancy and use as the basis and limit of land ownership."_
Supporting the current property rights regime meant _"departing from
Anarchistic ground."_ It was _"Archism"_ and _"all Anarchists agree in viewing
[it] as a denial of equal liberty"_ and _"utterly inconsistent with the
Anarchistic doctrine of occupancy and use as the limit of property in land."_
[**Liberty**, no. 180, p. 4 and p. 6] He looked forward to the day when _"the
Anarchistic view that occupancy and use should condition and limit landholding
becomes the prevailing view."_ [**Op. Cit.**, no. 162, p. 5]

This was because Tucker did not believe in a _"natural right"_ to property nor
did he approve of unlimited holdings of scarce goods and _"in the case of
land, or of any other material the supply of which is so limited that all
cannot hold it in unlimited quantities, Anarchism undertakes to protect no
titles except such as are based on actual occupancy and use."_ [**Instead of a
Book**, p. 61] He clearly recognised that allowing "absolute" rights to
private property in land would result in the liberty of non-owners being
diminished and so _"I put the right of occupancy and use above the right of
contract . . . principally by my interest in the right of contract. Without
such a preference the theory of occupancy and use is utterly untenable;
without it . . . it would be possible for an individual to acquire, and hold
simultaneously, virtual titles to innumerable parcels of land, by the merest
show of labour performed thereon._ This would lead to _"the virtual ownership
of the entire world by a small fraction of its inhabitants"_ which would
result in _"the right of contract, if not destroyed absolutely, would surely
be impaired in an intolerable degree."_ [**Liberty**, no. 350, p. 4] Thus
_"[i]t is true . . . that Anarchism does not recognise the principle of human
rights. But it recognises human equality as a necessity of stable society."_
[**Instead of a Book**, p. 64]

So Tucker considered private property in land use (which he called the _"land
monopoly"_) as one of the four great evils of capitalism. According to Tucker,
_"the land monopoly . . . consists in the enforcement by government of land
titles which do not rest upon personal occupancy and cultivation . . . the
individual should no longer be protected by their fellows in anything but
personal occupation and cultivation of land."_ _"Rent"_, he argued, _"is due
to the denial of liberty which takes the shape of the land monopoly, vesting
titles to land in individuals and associations which do not use it, and
thereby compelling the non-owning users to pay tribute to the non-using owners
as a condition of admission to the competitive market."_ the land _"should be
free to all, and no one would control more than he [or she] used."_ [**The
Individualist Anarchists**, p. 85, p. 130 and p. 114] Ending this monopoly
would, he thought, reduce the evils of capitalism and increase liberty
(particularly in predominantly agricultural societies such as the America of
his era). For those who own no property have no room for the soles of their
feet unless they have the permission of those who do own property, hardly a
situation that would increase, never mind protect, freedom for all.
Significantly, Tucker extended this principle to what was on the land, and so
Tucker would _"accord the actual occupant and user of land the right to that
which is upon the land, who left it there when abandoning the land."_
[**Liberty**, no. 350, p. 4] The freedom to squat empty land and buildings
would, in the absence of a state to protect titles, further contribute to the
elimination of rent:

> _"Ground rent exists only because the State stands by to collect it and to
protect land titles rooted in force or fraud. Otherwise land would be free to
all, and no one could control more than he used."_ [quoted by James J. Martin,
**Op. Cit.**, p. 210]

This would lead to _"the abolition of landlordism and the annihilation of
rent."_ [**Instead of a Book**, p. 300] Significantly, Tucker considered the
**Irish Land League** (an organisation which used non-payment of rent to
secure reforms against the British state) as _"the nearest approach, on a
large scale, to perfect Anarchistic organisation that the world has yet seen.
An immense number of local groups . . . each group autonomous, each free . . .
each obeying its own judgement . . . all co-ordinated and federated."_ [**The
Individualist Anarchists**, p. 263]

The other capitalist monopolies were based on credit, tariffs and patents and
all were reflected in (and supported by) the law. As far as tariffs went, this
was seen as a statist means of _"fostering production at high prices"_ which
the workers paid for. Its abolition _"would result in a great reduction in the
prices of all articles taxed._ [**Op. Cit.**, p. 85 and p. 86] With
capitalists in the protected industries being unable to reap high profits,
they would be unable to accumulate capital to the same degree and so the
market would also become more equal. As for patents, Tucker considered that
there was _"no more justification for the claim of the discoverer of an idea
to exclusive use of it than there would have been for a claim on the part of
the man who first 'struck oil' to ownership of the entire oil region or
petroleum product . . . The central injustice of copyright and patent law is
that it compels the race to pay an individual through a long term of years a
monopoly price for knowledge that he has discovered today, although some other
man or men might, and in many cases very probably would, have discovered it
tomorrow."_ [**Liberty**, no. 173, p. 4] The state, therefore, protects the
inventors (or, these days, the company the inventors work for) _"against
competition for a period long enough to enable them to extort from the people
a reward enormously in excess of the labour measure of their services -- in
other words, in giving certain people a right of property for a term of years
in laws and facts of Nature, and the power to extract tribute from others for
the use of this natural wealth, which should be open to all."_ [**The
Individualist Anarchists**, p. 86]

However, the key monopoly was the credit monopoly. Tucker believed that
bankers monopoly of the power to create credit and currency was the linchpin
of capitalism. Although he thought that all forms of monopoly are detrimental
to society, he maintained that the banking monopoly is the worst, since it is
the root from which both the industrial-capitalist and landlordist monopolies
grow and without which they would wither and die. For, if credit were not
monopolised, its price (i.e. interest rates) would be much lower, which in
turn would drastically lower the price of capital goods and buildings --
expensive items that generally cannot be purchased without access to credit.
This would mean that the people currently _"deterred from going into business
by the ruinously high rates they must pay for capital with which to start and
carry on business will find their difficulties removed"_ (they would simply
_"pay for the labour of running the banks"_). This _"facility of acquiring
capital will give an unheard of impetus to business, and consequently create
an unprecedented demand for labour -- a demand which will always be in excess
of the supply, directly to the contrary of the present condition of the labour
market . . . Labour will then be in a position to dictate its wages."_ [**Op.
Cit.**, p. 84 and p. 85]

Following Proudhon, Tucker argued that if any group of people could legally
form a "mutual bank" and issue credit based on any form of collateral they saw
fit to accept, the price of credit would fall to the labour cost of the
paperwork involved in running the bank. He claimed that banking statistics
show this cost to be less than one percent of principal, and hence, that a
one-time service fee which covers this cost and no more is the only **non-
usurious** charge a bank can make for extending credit. This charge should not
be called "interest" since, as it represented the labour-cost in providing, it
is non-exploitative. This would ensure that workers could gain free access to
the means of production (and so, in effect, be the individualist equivalent of
the communist-anarchist argument for socialisation).

Tucker believed that under mutual banking, capitalists' ability to extract
surplus value from workers in return for the use of tools, machinery, etc.
would be eliminated because workers would be able to obtain zero-interest
credit and use it to buy their own instruments of production instead of
"renting" them, as it were, from capitalists. _"Make capital free by
organising credit on a mutual plan,"_ stressed Tucker, _"and then these vacant
lands will come into use . . . operatives will be able to buy axes and rakes
and hoes, and then they will be independent of their employers, and then the
labour problem will solved."_ [**Instead of a Book**, p. 321] Easy access to
mutual credit would result in a huge increase in the purchase of capital
goods, creating a high demand for labour, which in turn would greatly increase
workers' bargaining power and thus raise their wages toward equivalence with
the value their labour produces.

For Tucker, reforms had to be applied at the heart of the system and so he
rejected the notion of setting up intentional communities based on anarchist
principles in the countryside or in other countries. _"Government makes itself
felt alike in city and in country,"_ he argued, _"capital has its usurious
grip on the farm as surely as on the workshop, and the oppression and
exactions of neither government nor capital can be avoided by migration. The
State is the enemy, and the best means of fighting it can be found in
communities already existing."_ He stressed that _"I care nothing for any
reform that cannot be effected right here in Boston among the every day people
whom I meet in the streets."_ [quoted by Martin, **Op. Cit.**, p. 249 and p.
248]

It should be noted that while his social and political vision remained mostly
the same over his lifetime, Tucker's rationale for his system changed
significantly. Originally, like the rest of the American individualist
anarchist tradition he subscribed to a system of natural rights. Thus he
advocated "occupancy and use" based on a person's right to have access to the
means of life as well as its positive effects on individual liberty. However,
under the influence of Max Stirner's book **The Ego and Its Own**, Tucker
along with many of his comrades, became egoists (see [next
section](secG6.html) for a discussion of Stirner). This resulted in Tucker
arguing that while previously _"it was my habit to talk glibly of the right of
man to land"_ this was _"a bad habit, and I long ago sloughed it off."_ Now a
person's _"only right over the land is his might over it."_ [**Instead of a
Book**, p. 350] Contracts were seen as the means of securing the peaceful
preservation of the ego's personality as it would be against a person's self-
interest to aggress against others (backed-up, of course, by means of freely
joined defence associations). It should be noted that the issue of egoism
split the individualist anarchist movement and lead to its further decline.

Tucker's ideal society was one of small entrepreneurs, farmers, artisans,
independent contractors and co-operative associations based around a network
of mutual banks. He looked to alternative institutions such as co-operative
banks and firms, schools and trade unions, combined with civil disobedience in
the form of strikes, general strikes, tax and rent strikes and boycotts to
bring anarchism closer. He was firm supporter of the labour movement and
_"strikes, whenever and wherever inaugurated, deserve encouragement from all
the friends of labour . . . They show that people are beginning to know their
rights, and knowing, dare to maintain them."_ Echoing Bakunin's thoughts on
the subject, Tucker maintained that strikes should be supported and encouraged
because _"as an awakening agent, as an agitating force, the beneficent
influence of a strike is immeasurable . . . with our present economic system
almost every strike is just. For what is justice in production and
distribution? That labour, which creates all, shall have **all.**"_
[**Liberty**, no. 19, p. 7] While critical of certain aspects of trade
unionism, Tucker was keen to stress that _"it is not to be denied for a moment
that workingmen are obliged to unite and act together in order, not to
successfully contend with, but to defend themselves at least to some extent
from, the all-powerful possessors of natural wealth and capital."_ [**Op.
Cit.**, no. 158, p. 1]

Like the anarcho-syndicalists and many other social anarchists, Tucker
considered Labour unions as a positive development, being a _"crude step in
the direction of supplanting the State"_ and involved a _"movement for self-
government on the part of the people, the logical outcome of which is ultimate
revolt against those usurping political conspiracies which manifest themselves
in courts and legislatures. Just as the [Irish] Land League has become a
formidable rival of the British State, so the amalgamated trades unions may
yet become a power sufficiently strong to defy the legislatures and overthrow
them."_ Thus unions were _"a potent sign of emancipation."_ Indeed, he called
the rise of the unions _"trades-union socialism,"_ saw in it a means of
_"supplanting"_ the state by _"an intelligent and self-governing socialism"_
and indicated that _"imperfect as they are, they are the beginnings of a
revolt against the authority of the political State. They promise the coming
substitution of industrial socialism for usurping legislative mobism."_ [**The
Individualist Anarchists**, pp. 283-284] Hence we see the co-operative nature
of the voluntary organisations supported by Tucker and a vision of socialism
being based on self-governing associations of working people.

In this way working people would reform capitalism away by non-violent social
protest combined with an increase in workers' bargaining power by alternative
voluntary institutions and free credit. Exploitation would be eliminated and
workers would gain economic liberty. His ideal society would be classless,
with _"each man reaping the fruit of his labour and no man able to live in
idleness on an income from capital"_ and society _"would become a great hive
of Anarchistic workers, prosperous and free individuals."_ While, like all
anarchists, he rejected _"absolute equality"_ he did envision an egalitarian
society whose small differences in wealth were rooted in labour, not property,
and so liberty, while abolishing exploitation, would _"not abolish the limited
inequality between one labourer's product and another's . . . Liberty will
ultimately make all men rich; it will not make all men equally rich."_ [**The
Individualist Anarchists**, p. 276, p. 156 and p. 157] He firmly believed that
the _"most perfect Socialism is possible only on the condition of the most
perfect individualism."_ [quoted by Peter Marshall, **Demanding the
Impossible**, p. 390]

As we noted in [section G.1.3](secG1.html#secg13), there is one apparent area
of disagreement between Tucker and most other socialists, namely the issue of
wage labour. For almost all anarchists the employer/employee social
relationship does not fit in well with Tucker's statement that _"if the
individual has the right to govern himself, all external government is
tyranny."_ [**The Individualist Anarchists**, p. 86] However, even here the
differences are not impossible to overcome. It is important to note that
because of Tucker's proposal to increase the bargaining power of workers
through access to mutual credit, his individualist anarchism is not only
compatible with workers' control but would in fact **promote** it (as well as
logically requiring it -- see [section G.4.1](secG4.html#secg41)).

For if access to mutual credit were to increase the bargaining power of
workers to the extent that Tucker claimed it would, they would then be able
to: (1) demand and get workplace democracy; and (2) pool their credit to buy
and own companies collectively. This would eliminate the top-down structure of
the firm and the ability of owners to pay themselves unfairly large salaries
as well as reducing capitalist profits to zero by ensuring that workers
received the full value of their labour. Tucker himself pointed this out when
he argued that Proudhon (like himself) _"would individualise and associate"_
workplaces by mutualism, which would _"place the means of production within
the reach of all."_ [quoted by Martin, **Op. Cit.**, p. 228] Proudhon used the
word _"associate"_ to denote co-operative (i.e. directly democratic)
workplaces (and given Proudhon's comments -- quoted in [section
G.4.2](secG4.html#secg42) \-- on capitalist firms we can dismiss any attempt
to suggest that the term _"individualise"_ indicates support for capitalist
rather than artisan/peasant production, which is the classic example of
individualised production). For as Proudhon recognised, only a system without
wage slavery (and so exploitation) would ensure the goal of all anarchists:
_"the greatest amount of liberty compatible with equality of liberty."_
[Tucker, **Instead of a Book**, p. 131]

Thus the logical consequence of Tucker's proposals would be a system
equivalent in most important respects to the kind of system advocated by other
left libertarians. In terms of aspirations, Tucker's ideas reflected those of
social anarchists -- a form of socialism rooted in individual liberty. His
fire was directed against the same targets, exploitation and oppression and so
state and capital. He aimed for a society without inequalities of wealth where
it would be impossible to exploit another's labour and where free access to
the means of life were secured by mutual banking and "occupancy and use"
applied to land and what was on it. He considered laissez-faire capitalism to
be a system of state-supported privilege rather than as an ideal to be aimed
for. He argued extensively that getting rid of the state would mean getting
rid of capitalist property rights and so, like other anarchists, he did not
artificially divide economic and political issues. In other words, like social
anarchists, he was against the state because it protected specific kinds of
private property, kinds which allowed its owners to extract tribute from
labour.

In summary, then, Tucker _"remained a left rather than a right-wing
libertarian."_ [Marshall, **Op. Cit.**, p. 391] When he called himself a
socialist he knew well what it meant and systematically fought those (usually,
as today, Marxists and capitalists) who sought to equate it with state
ownership. John Quail, in his history of British Anarchism, puts his finger on
the contextual implications and limitations of Tucker's ideas when he wrote:

> _"Tucker was a Proudhonist and thus fundamentally committed to a society
based on small proprietorship. In the American context, however, where the
small landowner was often locked in battle with large capitalist interests,
this did not represent the reactionary position it often did later where it
could easily degenerate into an 'Anarchism for small business-men.' Tucker had
a keen sense of the right of the oppressed to struggle against oppression."_
[**The Slow Burning Fuse**, p. 19]

As we stressed in [section G.1.4](secG1.html#secg14), many of Tucker's
arguments can only be fully understood in the context of the society in which
he developed them, namely the transformation of America from a pre-capitalist
into a capitalist one by means of state intervention (the process of
_"primitive accumulation"_ to use Marx's phrase -- see [section
F.8.5](secF8.html#secf85)). At that time, it was possible to argue that access
to credit would allow workers to set-up business and undermine big business.
However, eventually Tucker had come to argue that this possibility had
effectively ended and even the freest market would not be able to break-up the
economic power of corporations and trusts (see [section
G.1.1](secG1.html#secg11)).

In this, ironically, Tucker came to the same conclusion as his old enemy
Johann Most had done three decades previously. In the 1880s, Tucker had argued
that wage labour would be non-exploitative under individualist anarchy. This
was part of the reason why Most had excommunicated Tucker from anarchism, for
he thought that Tucker's system could not, by definition, end exploitation due
to its tolerance of wage labour, an argument Tucker disputed but did not
disprove (see [section G.4.1](secG4.html) for more discussion on this issue).
In 1888 Tucker had speculated that _"the question whether large concentrations
of capital for production on the large scale confronts us with the
disagreeable alternative of either abolishing private property or continuing
to hold labour under the capitalistic yoke."_ [**Liberty**, no. 122, p. 4] By
1911, he had come to the conclusion that the latter had come to pass and
considered revolutionary or political action as the only means of breaking up
such concentrations of wealth (although he was against individualist
anarchists participating in either strategy). [Martin, **Op. Cit.**, pp.
273-4] In other words, Tucker recognised that economic power existed and, as a
consequence, free markets were not enough to secure free people in conditions
of economic inequality.

There are, of course, many differences between the anarchism of, say, Bakunin
and Kropotkin and that of Tucker. Tucker's system, for example, does retain
some features usually associated with capitalism, such as competition between
firms in a free market. However, the fundamental socialist objection to
capitalism is not that it involves markets or "private property" but that it
results in exploitation. Most socialists oppose private property and markets
because they result in exploitation and have other negative consequences
rather than an opposition to them as such. Tucker's system was intended to
eliminate exploitation and involves a radical change in property rights, which
is why he called himself a socialist and why most other anarchists concurred.
This is why we find Kropotkin discussing Tucker in his general accounts of
anarchism, accounts which note that the anarchists _"constitute the left
wing"_ of the socialists and which make no comment that Tucker's ideas were
any different in this respect. [**Anarchism**, p. 285] A position, needless to
say, Tucker also held as he considered his ideas as part of the wider
socialist movement.

This fact is overlooked by "anarcho"-capitalists who, in seeking to make
Tucker one of their "founding fathers," point to the fact that he spoke of the
advantages of owning "property." But it is apparent that by "property" he was
referring to simple "possession" of land, tools, etc. by independent artisans,
farmers, and co-operating workers (he used the word property _"as denoting the
labourer's individual possession of his product or his share of the joint
product of himself and others."_ [Tucker, **Instead of a Book**, p. 394]. For,
since Tucker saw his system as eliminating the ability of capitalists to
maintain exploitative monopolies over the means of production, it is therefore
true **by definition** that he advocated the elimination of "private property"
in the capitalist sense.

So while it is true that Tucker placed "property" and markets at the heart of
his vision of anarchy, this does not make him a supporter of capitalism (see
sections [G.1.1](secG1.html#secg11) and [G.1.2](secG1.html#secg12)). Unlike
supporters of capitalism, the individualist anarchists identified "property"
with simple "possession," or _"occupancy and use"_ and considered profit, rent
and interest as exploitation. Indeed, Tucker explicitly stated that _"all
property rests on a labour title, and no other property do I favour."_
[**Instead of a Book**, p. 400] Because of their critique of capitalist
property rights and their explicit opposition to usury (profits, rent and
interest) individualist anarchists like Tucker could and did consider
themselves as part of the wider socialist movement, the libertarian wing as
opposed to the statist/Marxist wing.

Thus, Tucker is clearly a left libertarian rather than a forefather of right-
wing "libertarianism". In this he comes close to what today would be called a
market socialist, albeit a non-statist variety. As can be seen, his views are
directly opposed to those of right "libertarians" like Murray Rothbard on a
number of key issues. Most fundamentally, he rejected "absolute" property
rights in land which are protected by laws enforced either by private security
forces or a "night watchman state." He also recognised that workers were
exploited by capitalists, who use the state to ensure that the market was
skewed in their favour, and so urged working people to organise themselves to
resist such exploitation and, as a consequence, supported unions and strikes.
He recognised that while formal freedom may exist in an unequal society, it
could not be an anarchy due to the existence of economic power and the
exploitation and limitations in freedom it produced. His aim was a society of
equals, one in which wealth was equally distributed and any differences would
be minor and rooted in actual work done rather than by owning capital or land
and making others produce it for them. This clearly indicates that Rothbard's
claim to have somehow modernised Tucker's thought is **false** \-- "ignored"
or "changed beyond recognition" would be more appropriate.

[‹ G.4 Why do social anarchists reject individualist
anarchism?](/afaq/secG4.html "Go to previous page" ) [up](/afaq/secGcon.html
"Go to parent page" ) [G.6 What are the ideas of Max Stirner?
›](/afaq/secG6.html "Go to next page" )

