# J.1 Are anarchists involved in social struggles?

Yes. Anarchism, above all else, is a movement which aims to not only analyse
the world but also to change it. Therefore anarchists aim to participate in
and encourage social struggle. Social struggle includes strikes, marches,
protests, demonstrations, boycotts, occupations and so on. Such activities
show that the **_"spirit of revolt"_** is alive and well, that people are
thinking and acting for themselves and against what authorities want them to
do. This, in the eyes of anarchists, plays a key role in helping create the
seeds of anarchy within capitalism.

Anarchists consider socialistic tendencies to develop within society as people
see the benefits of co-operation and particularly when mutual aid develops
within the struggle against authority, oppression and exploitation. Anarchism,
as Kropotkin argued, _"originated in everyday struggles."_ [**Environment and
Revolution**, p.58] Therefore, anarchists do not place anarchy abstractly
against capitalism but see it as a tendency within and against the system -- a
tendency created by struggle and which can be developed to such a degree that
it can **replace** the dominant structures and social relationships with new,
more liberatory and humane ones. This perspective indicates why anarchists are
involved in social struggles -- they are an expression of these tendencies
within but against capitalism which can ultimately replace it.

However, there is another reason why anarchists are involved in social
struggle -- namely the fact that we are part of the oppressed and, like other
oppressed people, fight for our freedom and to make our life better in the
here and now. It is not in some distant tomorrow that we want to see the end
of oppression, exploitation and hierarchy. It is today, in our own life, that
the anarchist wants to win our freedom, or at the very least, to improve our
situation, reduce oppression, domination and exploitation as well as
increasing individual liberty for _"every blow given to the institutions of
private property and to the government, every exaltation of the conscience of
man, disruption of the present conditions, every lie unmasked, every part of
human activity taken away from the control of the authorities, every
augmentation of the spirit of solidarity and initiative is a step towards
Anarchism."_ [Errico Malatesta, **Towards Anarchism**, p. 75] We are aware
that we often fail to do so, but the very process of struggle can help create
a more libertarian aspect to society:

> _"Whatever may be the practical results of the struggle for immediate gains,
the greatest value lies in the struggle itself. For thereby workers [and other
oppressed sections of society] learn that the bosses interests are opposed to
theirs and that they cannot improve their conditions, and much less emancipate
themselves, except by uniting and becoming stronger than the bosses. If they
succeed in getting what they demand, they will be better off: they will earn
more, work fewer hours and will have more time and energy to reflect on the
things that matter to them, and will immediately make greater demands and have
greater needs. If they do not succeed they will be led to study the reasons of
their failure and recognise the need for closer unity and greater activity and
they will in the end understand that to make victory secure and definite, it
is necessary to destroy capitalism. The revolutionary cause, the cause of
moral elevation and emancipation of the workers [and other oppressed sections
of society] must benefit by the fact that workers [and other oppressed people]
unite and struggle for their interests."_ [Malatesta, **Errico Malatesta: His
Life and Ideas**, p. 191]

Therefore, _"we as anarchists and workers, must incite and encourage"_ workers
and other oppressed people _"to struggle, and join them in their struggle."_
[Malatesta, **Op. Cit.**, p. 190] This is for three reasons. Firstly, struggle
helps generate libertarian ideas and movements which could help make existing
society more anarchistic and less oppressive. Secondly, struggle creates
people, movements and organisations which are libertarian in nature and which,
potentially, can replace capitalism with a more humane society. Thirdly,
because anarchists are part of the oppressed and so have an interest in taking
part in and showing solidarity with struggles and movements that can improve
our life in the here and now (_"an injury to one is an injury to all"_).

As we will see in [section J.2](secJ2.html) anarchists encourage direct action
within social struggles as well as arguing for anarchist ideas and theories.
However, what is important to note here is that social struggle is a sign that
people are thinking and acting for themselves and working together to change
things. Howard Zinn is completely correct:

> _"civil disobedience . . . is **not** our problem. Our problem is civil
**obedience.** Our problem is that numbers of people all over the world have
obeyed the dictates of the leaders of their government and have gone to war,
and millions have been killed because of this obedience . . . Our problem is
that people are obedient all over the world in the face of poverty and
starvation and stupidity, and war, and cruelty. Our problem is that people are
obedient while the jails are full of petty thieves, and all the while the
grand thieves are running the country. That's our problem."_ [**Failure to
Quit**, p. 45]

Therefore, social struggle is an important thing for anarchists and we take
part in it as much as we can. Moreover, anarchists do more than just take
part. We are fighting to get rid of the system that causes the problems which
people fight against. We explain anarchism to those who are involved in
struggle with us and seek to show the relevance of anarchism to people's
everyday lives through such struggles and the popular organisations which they
create. By so doing we try to popularise the ideas and methods of anarchism,
namely solidarity, self-management and direct action.

Anarchists do not engage in abstract propaganda (become an anarchist, wait for
the revolution -- if we did that, in Malatesta's words, _"that day would never
come."_ [**Op. Cit.**, p. 195]). We know that our ideas will only win a
hearing and respect when we can show both their relevance to people's lives in
the here and now and show that an anarchist world is both possible and
desirable. In other words, social struggle is the "school" of anarchism, the
means by which people become anarchists and anarchist ideas are applied in
action. Hence the importance of social struggle and anarchist participation
within it.

Before discussing issues related to social struggle, it is important to point
out here that anarchists are interested in struggles against all forms of
oppression and do not limit ourselves to purely economic issues. The
hierarchical and exploitative nature of the capitalist economy is only part of
the story -- other forms of oppression are needed in order to keep it going
(not to mention those associated with the state) and have resulted from its
workings (in addition to those inherited from previous hierarchical and class
systems). Domination, exploitation, hierarchy and oppression do not remain in
the workplace. They infest our homes, our friendships and our communities.
They need to be fought everywhere, not just in work.

Therefore, anarchists are convinced that human life and the struggle against
oppression cannot be reduced to mere money and, indeed, the _"proclivity for
economic reductionism is now actually obscurantist. It not only shares in the
bourgeois tendency to render material egotism and class interest the
centrepieces of history it also denigrates all attempts to transcend this
image of humanity as a mere economic being . . . by depicting them as mere
'marginalia' at best, as 'well-intentioned middle-class ideology' at worse, or
sneeringly, as 'diversionary,' 'utopian,' and 'unrealistic' . . . Capitalism,
to be sure, did not create the 'economy' or 'class interest,' but it subverted
all human traits -- be they speculative thought, love, community, friendship,
art, or self-governance -- with the authority of economic calculation and the
rule of quantity. Its 'bottom line' is the balance sheet's sum and its basic
vocabulary consists of simple numbers."_ [Murray Bookchin, **The Modern
Crisis**, pp. 125-126]

In other words, issues such as freedom, justice, individual dignity, quality
of life and so on cannot be reduced to the categories of capitalist economics.
Anarchists think that any radical movement which does so fails to understand
the nature of the system it is fighting against (indeed, economic reductionism
plays into the hands of capitalist ideology). So, when anarchists take part in
and encourage social struggle they do not aim to restrict or reduce them to
economic issues (however important these are). The anarchist knows that the
individual has more interests than just material ones and we consider it
essential to take into account the needs of the emotions, mind and spirit just
as much as those of the belly:

> _"The class struggle does not centre around material exploitation alone but
also around spiritual exploitation. In addition, entirely new issues emerge:
coercive attitudes, the quality of work, ecology (or stated in more general
terms, psychological and environmental oppression) . . . Terms like 'classes'
and 'class struggle,' conceived of almost entirely as economic categories and
relations, are too one-sided to express the **universalisation** of the
struggle. Use these limited expressions if you like (the target is still a
ruling class and a class society), but this terminology, with its traditional
connotations, does not reflect the sweep and the multi-dimensional nature of
the struggle . . . [and] fail to encompass the cultural and spiritual revolt
that is taking place along with the economic struggle."_ [**Post-Scarcity
Anarchism**, pp. 151-2]

For anarchists, exploitation and class rule are just part of a wider system of
domination and hierarchy. Material gains, therefore, can never completely
make-up for oppressive social relationships. As the anarchist character
created by anarchist science-fiction writer Ursula Le Guin put it, capitalists
_"think if people have enough things they will be content to live in prison."_
[**The Dispossessed**, p. 120] Anarchists disagree -- and the experience of
social revolt in the "affluent" 1960s proves their case.

This is unsurprising for, ultimately, the _"antagonism [between classes] is
spiritual rather than material. There will never be a sincere understanding
between bosses and workers. . . because the bosses above all want to remain
bosses and secure always more power at the expense of the workers, as well as
by competition with other bosses, whereas the workers have had their fill of
bosses and don't want any more."_ [Malatesta, **Op. Cit.**, p. 79]

## J.1.1 Why are social struggles important?

Social struggle is an expression of the class struggle, namely the struggle of
working class people **against** their exploitation, oppression and alienation
and **for** their liberty from capitalist and state. It is what happens when
one group of people have hierarchical power over another: where there is
oppression, there is resistance and where there is resistance to authority you
will see anarchy in action. For this reason anarchists are in favour of, and
are involved within, social struggles. Ultimately they are a sign of
individuals asserting their autonomy and disgust at an unfair system. As
Howard Zinn stresses:

> _"Both the source and the solution of our civil liberties problems are in
the situations of every day: where we live, where we work, where we go to
school, where we spend most of our hours. Our actual freedom is not determined
by the Constitution or by [the Supreme] Court, but by the power the policeman
has over us in the street or that of the local judge behind him; by the
authority of our employers [if we are working]; by the power of teachers,
principals, university president, and boards of trustees if we are students;
by the welfare bureaucracy if we are poor [or unemployed]; by prison guards if
we are in jail; by landlords if we are tenants; by the medical profession or
hospital administration if we are physically or mentally ill._

> _"Freedom and justice are local things, at hand, immediate. They are
determined by power and money, whose authority over our daily lives is much
less ambiguous than decisions of the Supreme Court. Whatever claim we . . .
can make to liberty on the national level . . . on the local level we live at
different times in different feudal fiefdoms where our subordination is
clear."_ [**Failure to Quit**, pp. 53-4]

These realities of wealth and power will remain unshaken unless counter-forces
appear on the very ground our liberty is restricted -- on the street, in
workplaces, at home, at school, in hospitals and so on. For the _"only limit
to the oppression of government is the power with which people show themselves
capable of opposing it."_ [Malatesta, **Errico Malatesta: His Life and
Ideas**, p. 196]

Social struggles for improvements are also important indications of the spirit
of revolt and of people supporting each other in the continual assertion of
their (and our) freedom. They show people standing up for what they consider
right and just, building alternative organisations, creating their own
solutions to their problems - and are a slap in the face of all the paternal
authorities which dare govern us. Hence their importance to anarchists and all
people interested in extending freedom.

In addition, social struggle helps break people from their hierarchical
conditioning. Anarchists view people not as fixed objects to be classified and
labelled, but as human beings engaged in making their own lives. We live,
love, think, feel, hope, dream, and can change ourselves, our environment and
social relationships. Social struggle is the way this is done collectively.
Such struggle promotes attributes within people which are crushed by hierarchy
(attributes such as imagination, organisational skills, self-assertion, self-
management, critical thought, self-confidence and so on) as people come up
against practical problems in their struggles and have to solve them
themselves. This builds self-confidence and an awareness of individual and
collective power. By seeing that their boss, the state and so on are against
them they begin to realise that they live in a class ridden, hierarchical
society that depends upon their submission to work. As such, social struggle
is a politicising experience.

Struggle allows those involved to develop their abilities for self-rule
through practice and so begins the process by which individuals assert their
ability to control their own lives and to participate in social life directly.
These are all key elements of anarchism and are required for an anarchist
society to work (_"Self-management of the struggle comes first, then comes
self-management of work and society"_ [Alfredo Bonnano, _"Self-Management"_,
pp. 35-37, **Anarchy: A Journal of Desire Armed**, no. 48, p. 35]). So self-
activity is a key factor in self-liberation, self-education and the creating
of anarchists. In a nutshell, people learn in struggle:

> _"In our opinion all action which is directed toward the destruction of
economic and political oppression, which serves to raise the moral and
intellectual level of the people; which gives them an awareness of their
individual rights and their power, and persuades them themselves to act on
their own behalf . . . brings us closer to our ends and is therefore a good
thing. On the other hand all activity which tends to preserve the present
state of affairs, that tends to sacrifice man against his will for the triumph
of a principle, is bad because it is a denial of our ends._ [Malatesta, **Op.
Cit.**, p. 69]

A confident working class is an essential factor in making successful and
libertarian improvements within the current system and, ultimately, in making
a revolution. Without that self-confidence people tend to just follow
"leaders" and we end up changing rulers rather than changing society. So part
of our job as anarchists is to encourage people to fight for whatever small
reforms are possible at present, to improve our/their conditions, to give
people confidence in their ability to start taking control of their lives, and
to point out that there is a limit to whatever (sometimes temporary) gains
capitalism will or can concede. Hence the need for a revolutionary change.

Only this can ensure that anarchist ideas are the most popular ones for if we
think a movement is, all things considered, a positive or progressive one then
we should not abstain but should seek to popularise anarchist ideas and
strategies within it. In this way we create **_"schools of anarchy"_** within
the current system and lay the foundations of something better. Revolutionary
tendencies and movements, in other words, must create the organisations that
contain, in embryo, the society of the future (see [section
H.1.6](secH1.html#sech16)). These organisations, in turn, further the progress
of radical change by providing social spaces for the transformation of
individuals (via the use of direct action, practising self-management and
solidarity, and so on). Therefore, social struggle aids the creation of a free
society by accustoming people to govern themselves within self-managed
organisations and empowering the (officially) disempowered via the use of
direct action and mutual aid.

Hence the importance of social (or class) struggle for anarchists (which, we
may add, goes on all the time and is a two-sided affair). Social struggle is
the means of breaking the normality of capitalist and statist life, a means of
developing the awareness for social change and the means of making life better
under the current system. The moment that people refuse to bow to authority,
its days are numbered. Social struggle indicates that some of the oppressed
see that by using their power of disobedience they can challenge, perhaps
eventually end, hierarchical power.

Ultimately, anarchy is not just something you believe in, it is not a cool
label you affix to yourself, it is something you do. You participate. If you
stop doing it, anarchy crumbles. Social struggle is the means by which we
ensure that anarchy becomes stronger and grows.

## J.1.2 Are anarchists against reforms?

No, we are not. While most anarchists are against reformism (namely the notion
that we can somehow reform capitalism and the state away) we are most
definitely in favour of reforms (i.e. improvements in the here and now).
Anarchists are radicals; as such, we seek the root causes of societal
problems. Reformists seek to ameliorate the symptoms of societal problems,
while anarchists focus on the causes.

This does not mean, however, that we ignore struggles for reforms in the here
and now. The claim that anarchists are against such improvements are often put
forth by opponents of anarchism in an effort to paint us as irrelevant
extremists with no practical outlet for our ideas beyond abstract calls for
revolution. This is not true. Libertarians are well aware that we can act to
make our lives better while, at the same time, seeking to remove the root
causes of the problems we face. (see, for example, Emma Goldman's account of
her recognition of how false it was deny the need for short-term reforms in
favour of revolution. [**Living My Life**, vol. 1, p. 52]). In the words of
the revolutionary syndicalist Emile Pouget:

> _"Trade union endeavour has a double aim: with tireless persistence, it must
pursue betterment of the working class's current conditions. But, without
letting themselves become obsessed with this passing concern, the workers
should take care to make possible and imminent the essential act of
comprehensive emancipation: the expropriation of capital._

> _"At present, trade union action is designed to win partial and gradual
improvements which, far from constituting a goal, can only be considered as a
means of stepping up demands and wresting further improvements from capitalism
. . ._

> _"This question of partial improvements served as the pretext for attempts
to sow discord in the trades associations. Politicians . . . have tried to . .
. stir up ill-feeling and to split the unions into two camps, by categorising
workers as reformists and as revolutionaries. The better to discredit the
latter, they have dubbed them 'the advocates of all or nothing' and they have
falsely represented them as supposed adversaries of improvements achievable
right now._

> _"The most that can be said about this nonsense is that it is witless. There
is not a worker . . . who, on grounds of principle or for reasons of tactics,
would insist upon working ten hours for an employer instead of eight hours,
while earning six francs instead of seven . . ._

> _"What appears to afford some credence to such chicanery is the fact that
the unions, cured by the cruel lessons of experience from all hope in
government intervention, are justifiably mistrustful of it. They know that the
State, whose function is to act as capital's gendarme, is, by its very nature,
inclined to tip the scales in favour of the employer side. So, whenever a
reform is brought about by legal avenues, they do not fall upon it with the
relish of a frog devouring the red rag that conceals the hook, they greet it
with all due caution, especially as this reform is made effective only if the
workers are organised to insist forcefully upon its implementation._

> _"The trade unions are even more wary of gifts from the government because
they have often found these to be poison gifts . . . Wanting real improvements
. . . instead of waiting until the government is generous enough to bestow
them, they wrest them in open battle, through direct action._

> _"If, as sometimes is the case, the improvement they seek is subject to the
law, the trade unions strive to obtain it through outside pressure brought to
bear upon the authorities and not by trying to return specially mandated
deputies to Parliament, a puerile pursuit that might drag on for centuries
before there was a majority in favour of the yearned-for reform._

> _"When the desired improvement is to be wrestled directly from the
capitalist, the trades associations resort to vigorous pressure to convey
their wishes. Their methods may well vary, although the direct action
principle underlies them all . . . _

> _"But, whatever the improvement won, it must always represent a reduction in
capitalist privileges and be a partial expropriation. So . . . the fine
distinction between 'reformist' and 'revolutionary' evaporates and one is led
to the conclusion that the only really reformist workers are the revolutionary
syndicalists."_ [**No Gods, No Masters**, vol. 2, pp. 71-3]

Pouget was referring to revolutionary unions but his argument can be
generalised to all social movements.

By seeking improvements from below by direct action, solidarity and the
organisation of those who directly suffer the injustice, anarchists can make
reforms more substantial, effective and long lasting than "reforms" made from
above by reformists. By recognising that the effectiveness of a reform is
dependent on the power of the oppressed to resist those who would dominate
them, anarchists seek change from the bottom-up and so make reforms real
rather than just words gathering dust in the law books.

For example, a reformist sees poverty and looks at ways to lessen the
destructive and debilitating effects of it: this produced things like the
minimum wage, affirmative action, the projects in the USA and similar reforms
in other countries. An anarchist looks at poverty and says, "what causes
this?" and attacks that source of poverty, rather than the symptoms. While
reformists may succeed in the short run with their institutional panaceas, the
festering problems remain untreated, dooming reform to eventual costly,
inevitable failure -- measured in human lives, no less. Like a quack that
treats the symptoms of a disease without getting rid of what causes it, all
the reformist can promise is short-term improvements for a condition that
never goes away and may ultimately kill the sufferer. The anarchist, like a
real doctor, investigates the causes of the illness and treats them while
fighting the symptoms.

Therefore, anarchists are of the opinion that _"[w]hile preaching against
every kind of government, and demanding complete freedom, we must support all
struggles for partial freedom, because we are convinced that one learns
through struggle, and that once one begins to enjoy a little freedom one ends
by wanting it all. We must always be with the people . . . [and] get them to
understand . . . [what] they may demand should be obtained by their own
efforts and that they should despise and detest whoever is part of, or aspires
to, government."_ [Malatesta, **Errico Malatesta: His Life and Ideas** p. 195]

So, anarchists are not opposed to struggles for reforms and improvements in
the here and now. Indeed, few anarchists think that an anarchist society will
occur without a long period of anarchist activity encouraging and working
within social struggle against injustice. Thus Malatesta's words:

> _"the subject is not whether we accomplish Anarchism today, tomorrow or
within ten centuries, but that we walk towards Anarchism today, tomorrow and
always."_ [**Towards Anarchism**, p. 75]

So, when fighting for improvements anarchists do so in an anarchist way, one
that encourages self-management, direct action and the creation of libertarian
solutions and alternatives to both capitalism and the state.

## J.1.3 Why are anarchists against reformism?

Firstly, it must be pointed out that the struggle for reforms within
capitalism is **not** the same as reformism. Reformism is the idea that
reforms within capitalism are enough in themselves and attempts to change the
system are impossible (and not desirable). As such all anarchists are against
this form of reformism -- we think that the system can be (and should be)
changed and until that happens any reforms, no matter how essential, will not
get to the root of social problems.

In addition, particularly in the old social democratic labour movement,
reformism also meant the belief that social reforms could be used to
**transform** capitalism into socialism. In this sense, only Individualist
anarchists and Mutualists can be considered reformist as they think their
system of mutual banking can reform capitalism into a free system. However, in
contrast to Social Democracy, such anarchists think that such reforms cannot
come about via government action, but only by people creating their own
alternatives and solutions by their own actions:

> _"But experience testifies and philosophy demonstrates, contrary to that
prejudice, that any revolution, to be effective, must be spontaneous and
emanate, not from the heads of the authorities but from the bowels of the
people: that government is reactionary rather than revolutionary: that it
could not have any expertise in revolutions, given that society, to which that
secret is alone revealed, does not show itself through legislative decree but
rather through the spontaneity of its manifestations: that, ultimately, the
only connection between government and labour is that labour, in organising
itself, has the abrogation of government as its mission."_ [Proudhon, **No
Gods, No Master**, vol. 1, p. 52]

So, anarchists oppose reformism because it takes the steam out of
revolutionary movements by providing easy, decidedly short-term "solutions" to
deep social problems. In this way, reformists can present the public with
they've done and say "look, all is better now. The system worked." Trouble is
that over time, the problems will only continue to grow because the reforms
did not tackle them in the first place. To use Alexander Berkman's excellent
analogy:

> _"If you should carry out [the reformers'] ideas in your personal life, you
would not have a rotten tooth that aches pulled out all at once. You would
have it pulled out a little to-day, some more next week, for several months or
years, and by then you would be ready to pull it out altogether, so it should
not hurt so much. That is the logic of the reformer. Don't be 'too hasty,'
don't pull a bad tooth out all at once."_ [**What is Anarchism?**, p. 64]

Rather than seek to change the root cause of the problems (namely in a
hierarchical, oppressive and exploitative system), reformists try to make the
symptoms better. In the words of Berkman again:

> _"Suppose a pipe burst in your house. You can put a bucket under the break
to catch the escaping water. You can keep on putting buckets there, but as
long as you do not mend the broken pipe, the leakage will continue, no matter
how much you may swear about it . . . until you repair the broken social
pipe."_ [**Op. Cit.**, pp. 67-8]

What reformism fails to do is fix the underlying root causes of the real
problems society faces. Therefore, reformists try to pass laws which reduce
the level of pollution rather than work to end a system in which it makes
economic sense to pollute. Or they pass laws to improve working conditions and
safety while failing to get rid of the wage slavery which creates the bosses
whose interests are served by them ignoring those laws and regulations. The
list is endless. Ultimately, reformism fails because reformists _"believe in
good faith that it is possible to eliminate the existing social evils by
recognising and respecting, in practice if not in theory, the basic political
and economic institutions which are the cause of, as well as the prop that
supports these evils."_ [Malatesta, **Errico Malatesta: His Life and Ideas**,
p. 82]

Revolutionaries, in contrast to reformists, fight both symptoms **and** the
root causes. They recognise that as long as the cause of the evil remains, any
attempts to fight the symptoms, however necessary, will never get to the root
of the problem. There is no doubt that we have to fight the symptoms, however
revolutionaries recognise that this struggle is not an end in itself and
should be considered purely as a means of increasing working class strength
and social power within society until such time as capitalism and the state
(i.e. the root causes of most problems) can be abolished.

Reformists also tend to objectify the people whom they are "helping": they
envision them as helpless, formless masses who need the wisdom and guidance of
the "best and the brightest" to lead them to the Promised Land. Reformists
mean well, but this is altruism borne of ignorance, which is destructive over
the long run. Freedom cannot be given and so any attempt to impose reforms
from above cannot help but ensure that people are treated as children,
incapable of making their own decisions and, ultimately, dependent on
bureaucrats to govern them. This can be seen from public housing. As Colin
Ward argues, the _"whole tragedy of publicly provided non-profit housing for
rent and the evolution of this form of tenure in Britain is that the local
authorities have simply taken over, though less flexibly, the role of the
landlord, together with all the dependency and resentment that it engenders."_
[**Housing: An Anarchist Approach**, p. 184] This feature of reformism was
skilfully used by the right-wing to undermine publicly supported housing and
other aspects of the welfare state. The reformist social-democrats reaped what
they had sown.

Reformism often amounts to little more than an altruistic contempt for the
masses, who are considered as little more than victims who need to be provided
for by state. The idea that we may have our own visions of what we want is
ignored and replaced by the vision of the reformists who enact legislation
**for** us and make "reforms" from the top-down. Little wonder such reforms
can be counter-productive -- they cannot grasp the complexity of life and the
needs of those subject to them. Reformists effectively say, _"don't do
anything, we'll do it for you."_ You can see why anarchists would loathe this
sentiment; anarchists are the consummate do-it-yourselfers, and there's
nothing reformists hate more than people who can take care of themselves, who
will not let them "help" them.

Reformists may mean well, but they do not grasp the larger picture -- by
focusing exclusively on narrow aspects of a problem, they choose to believe
that is the whole problem. In this wilfully narrow examination of pressing
social ills, reformists are, more often than not, counter-productive. The
disaster of the urban rebuilding projects in the United States (and similar
projects in Britain which moved inner-city working class communities into edge
of town developments during the 1950s and 1960s) are an example of reformism
at work: upset at the growing slums, reformists supported projects that
destroyed the ghettos and built brand-new housing for working class people to
live in. They looked nice (initially), but they did nothing to address the
problem of poverty and indeed created more problems by breaking up communities
and neighbourhoods.

Logically, it makes no sense. Why dance around a problem when you can attack
it directly? Reformists dilute social movements, softening and weakening them
over time. The AFL-CIO labour unions in the USA, like the ones in Western
Europe, killed the labour movement by narrowing and channelling labour
activity and taking power from the workers themselves, where it belongs, and
placing it the hands of a bureaucracy. The British Labour Party, after over
100 years of reformist practice, has done little more than manage capitalism,
seen most of its reforms undermined by right-wing governments (and by the
following Labour governments!) and the creation of a leadership of the party
(in the shape of New Labour) which was in most ways as right-wing as the
Conservative Party (if not more so, as shown once they were in power). Bakunin
would not have been surprised.

Also, it is funny to hear left-wing "revolutionaries" and "radicals" put
forward the reformist line that the capitalist state can help working people
(indeed be used to abolish itself!). Despite the fact that leftists blame the
state and capitalism for most of the problems we face, they usually turn to
the **capitalist** state to remedy the situation, not by leaving people alone,
but by becoming more involved in people's lives. They support government
housing, government jobs, welfare, government-funded and regulated child care,
government-funded drug "treatment," and other government-centred programmes
and activities. If a capitalist (and racist/sexist/authoritarian) government
is the problem, how can it be depended upon to change things to the benefit of
working class people or other oppressed sections of the population? Surely any
reforms passed by the state will not solve the problem? As Malatesta
suggested:

> _"Governments and the privileged classes are naturally always guided by
instincts of self-preservation, of consolidation and the development of their
powers and privileges; and when they consent to reforms it is either because
they consider that they will serve their ends or because they do not feel
strong enough to resist, and give in, fearing what might otherwise be a worse
alternative."_ [**Op. Cit.**, p. 81]

Therefore, reforms gained by direct action are of a different quality and
nature than those passed by reformist politicians -- these latter will only
serve the interests of the ruling class as they do not threaten their
privileges while the former have the potential for real change.

This is not to say that Anarchists oppose **all** state-based reforms nor that
we join with the right in seeking to destroy them (or, for that matter, with
"left" politicians in seeking to "reform" them, i.e., reduce them). Without a
popular social movement creating alternatives to state welfare, so-called
"reform" by the state almost always means attacks on the most vulnerable
elements in society in the interests of capital. As anarchists are against
both state and capitalism, we can oppose such reforms without contradiction
while, at the same time, arguing that welfare for the rich should be abolished
long before welfare for the many is even thought about. See [section
J.5.15](secJ5.html#secj515) for more discussion on the welfare state and
anarchist perspectives on it.

Instead of encouraging working class people to organise themselves and create
their own alternatives and solutions to their problem (which can supplement,
and ultimately replace, whatever welfare state activity which is actually
useful), reformists and other radicals urge people to get the state to act for
them. However, the state is not the community and so whatever the state does
for people you can be sure it will be in **its** interests, not theirs. As
Kropotkin put it:

> _"We maintain that the State organisation, having been the force to which
the minorities resorted for establishing and organising their power over the
masses, cannot be the force which will serve to destroy these privileges . . .
the economic and political liberation of man will have to create new forms for
its expression in life, instead of those established by the State._

> _"Consequently, the chief aim of Anarchism is to awaken those constructive
powers of the labouring masses of the people which at all great moments of
history came forward to accomplish the necessary changes . . ._

> _"This is also why the Anarchists refuse to accept the functions of
legislators or servants of the State. We know that the social revolution will
not be accomplished by means of **laws.** Laws only **follow** the
accomplished facts . . . a law remains a dead letter so long as there are not
on the spot the living forces required for making of the **tendencies**
expressed in the law an accomplished **fact**._

> _"On the other hand . . . the Anarchists have always advised taking an
active part in those workers' organisations which carry on the **direct**
struggle of Labour against Capital and its protector, -- the State._

> _"Such a struggle . . . better than any other indirect means, permits the
worker to obtain some temporary improvements in the present conditions of work
[and life in general], while it opens his [or her] eyes to the evil that is
done by Capitalism and the State that supports it, and wakes up his [or her]
thoughts concerning the possibility of organising consumption, production, and
exchange without the intervention of the capitalist and the State."_
[**Environment and Evolution**, pp. 82-3]

Therefore, while seeking reforms, anarchists are against reformism and
reformists. Reforms are not seen as an end in themselves but rather a means of
changing society from the bottom-up and a step in that direction:

> _"Each step towards economic freedom, each victory won over Capitalism will
be at the same time a step towards political liberty -- towards liberation
from the yoke of the State . . . And each step towards taking from the State
any one of its powers and attributes will be helping the masses to win a
victory over Capitalism."_ [Kropotkin, **Op. Cit.**, p. 95]

However, no matter what, anarchists _"will never recognise the institutions;
we will take or win all possible reforms with the same spirit that one tears
occupied territory from the enemy's grasp in order to keep advancing, and we
will always remain enemies of every government."_ Therefore, it is _"not true
to say"_ that anarchists _"are systematically opposed to improvements, to
reforms. They oppose the reformists on the one hand because their methods are
less effective for securing reforms from government and employers, who only
give in through fear, and because very often the reforms they prefer are those
which not only bring doubtful immediate benefits, but also serve to
consolidate the existing regime and to give the workers a vested interest in
its continued existence."_ [Malatesta, **Op. Cit.**, p. 81 and p. 83]

Only working class people, by our own actions and organisations, getting the
state and capital out of the way can produce an improvement in our lives,
indeed it is the only thing that will lead to **real** changes for the better.
Encouraging people to rely on themselves instead of the state or capital can
lead to self-sufficient, independent, and, hopefully, more rebellious people.
Working class people, despite having fewer options in a number of areas in our
lives, due both to hierarchy and restrictive laws, still are capable of making
choices about our actions, organising our own lives and are responsible for
the consequences of our decisions. We are also more than able to determine
what is and is not a good reform to existing institutions and do not need
politicians informing us what is in our best interests (particularly when it
is the right seeking to abolish those parts of the state not geared purely to
defending property). To think otherwise is to infantilise us, to consider us
less fully human than other people and reproduce the classic capitalist vision
of working class people as means of production, to be used, abused, and
discarded as required. Such thinking lays the basis for paternalistic
interventions in our lives by the state, ensuring our continued dependence and
inequality -- and the continued existence of capitalism and the state.
Ultimately, there are two options:

> _"The oppressed either ask for and welcome improvements as a benefit
graciously conceded, recognise the legitimacy of the power which is over them,
and so do more harm than good by helping to slow down, or divert . . . the
processes of emancipation. Or instead they demand and impose improvements by
their action, and welcome them as partial victories over the class enemy,
using them as a spur to greater achievements, and thus a valid help and a
preparation to the total overthrow of privilege, that is, for the
revolution."_ [Malatesta, **Op. Cit.**, p. 81]

Reformism encourages the first attitude within people and so ensures the
impoverishment of the human spirit. Anarchism encourages the second attitude
and so ensures the enrichment of humanity and the possibility of meaningful
change. Why think that ordinary people cannot arrange their lives for
themselves as well as Government people can arrange it not for themselves but
for others?

## J.1.4 What attitude do anarchists take to "single-issue" campaigns?

Firstly, we must note that anarchists do take part in "single-issue"
campaigns, but do not nourish false hopes in them. This section explains what
anarchists think of such campaigns.

A "single-issue" campaign is usually run by a pressure group which
concentrates on tackling issues one at a time. For example, C.N.D. (The
Campaign for Nuclear Disarmament) is a classic example of "single-issue"
campaigning with the aim of getting rid of nuclear weapons as the be-all and
end-all of its activity. For anarchists, however, single-issue campaigning can
be seen as a source of false hopes. The possibilities of changing one aspect
of a totally inter-related system and the belief that pressure groups can
compete fairly with transnational corporations, the military and so forth, in
their influence over decision making bodies can both be seen to be optimistic
at best.

In addition, many "single-issue" campaigns desire to be "apolitical",
concentrating purely on the one issue which unites the campaign and so refuse
to analyse or discuss wider issues and the root causes of the issue in
question (almost always, the system we live under). This means that they end
up accepting the system which causes the problems they are fighting against.
At best, any changes achieved by the campaign must be acceptable to the
establishment or be so watered down in content that no practical long-term
good is done. This can be seen from the green movement, where groups like
**Greenpeace** and **Friends of the Earth** accept the status quo as a given
and limit themselves to working within it. This often leads to them tailoring
their "solutions" to be "practical" within a fundamentally anti-ecological
political and economic system, so slowing down (at best) ecological
disruption.

For anarchists these problems all stem from the fact that social problems
cannot be solved as single issues. As Larry Law argued:

> _"single issue politics . . . deals with the issue or problem in isolation.
When one problem is separated from all other problems, a solution really is
impossible. The more campaigning on an issue there is, the narrower its
perspectives become . . . As the perspective of each issue narrows, the
contradictions turn into absurdities . . . What single issue politics does is
attend to 'symptoms' but does not attack the 'disease' itself. It presents
such issues as nuclear war, racial and sexual discrimination, poverty,
starvation, pornography, etc., as if they were aberrations or faults in the
system. In reality such problems are the inevitable consequence of a social
order based on exploitation and hierarchical power . . . single issue
campaigns lay their appeal for relief at the feet of the very system which
oppresses them. By petitioning they acknowledge the right of those in power to
exercise that power as they choose."_ [**Bigger Cages, Longer Chains**, pp.
17-20].

Single issue politics often prolong the struggle for a free society by
fostering illusions that it is just parts of the capitalist system which are
wrong, not the whole of it, and that those at the top of the system can, and
will, act in our interests. While such campaigns can do some good, practical,
work and increase knowledge and education about social problems, they are
limited by their very nature and can not lead to extensive improvements in the
here and now, never mind a free society.

Therefore, anarchists often support and work within single-issue campaigns,
trying to get them to use effective methods of activity (such as direct
action), work in an anarchistic manner (i.e. from the bottom up) and to try to
"politicise" them into questioning the whole of the system. However,
anarchists do not let themselves be limited to such activity as a social
revolution or movement is not a group of single-issue campaigns but a mass
movement which understands the inter-related nature of social problems and so
the need to change every aspect of life.

## J.1.5 Why do anarchists try to generalise social struggles?

Basically, we do it in order to encourage and promote solidarity. This is
**the** key to winning struggles in the here and now as well as creating the
class consciousness necessary to create an anarchist society. At its most
simple, generalising different struggles means increasing the chances of
winning them. Take, for example, when one trade or one workplace goes on
strike while the others continue to work:

> _"Consider yourself how foolish and inefficient is the present form of
labour organisation in which one trade or craft may be on strike while the
other branches of the same industry continue to work. Is it not ridiculous
that when the street car workers of New York, for instance, quit work, the
employees of the subway, the cab and omnibus drivers remain on the job? . . .
It is clear, then, that you compel compliance [from your bosses] only when you
are determined, when your union is strong, when you are well organised, when
you are united in such a manner that the boss cannot run his factory against
your will. But the employer is usually some big . . . company that has mills
or mines in various places. . . If it cannot operate . . . in Pennsylvania
because of a strike, it will try to make good its losses by continuing . . .
and increasing production [elsewhere] . . . In that way the company . . .
breaks the strike."_ [Alexander Berkman, **What is Anarchism?**, pp. 199-200]

By organising all workers in one union (after all they all have the same boss)
it increases the power of each trade considerably. It may be easy for a boss
to replace a few workers, but a whole workforce would be far more difficult.
By organising all workers in the same industry, the power of each workplace is
correspondingly increased. Extending this example to outside the workplace,
its clear that by mutual support between different groups increases the
chances of each group winning its fight. As the I.W.W. put it: **_"An injury
to one is an injury to all."_** By generalising struggles, by practising
mutual aid we can ensure that when we are fighting for our rights and against
injustice we will not be isolated and alone. If we don't support each other,
groups will be picked off one by one. and if we go into struggle, there will
be no one there to support us and we are more likely to be defeated.

Therefore, from an anarchist point of view, the best thing about generalising
struggles is that as well as increasing the likelihood of success
(_"Solidarity is Strength"_) it leads to an increased spirit of solidarity,
responsibility and class consciousness. This is because by working together
and showing solidarity those involved get to understand their common interests
and that the struggle is not against **this** injustice or **that** boss but
against **all** injustice and **all** bosses.

This sense of increased social awareness and solidarity can be seen from the
experience of the C.N.T in Spain during the 1930s. The C.N.T. organised all
workers in a given area into one big union. Each workplace was a union branch
and were joined together in a local area confederation. The result was that
the territorial basis of the unions brought all the workers from one area
together and fomented **class** solidarity over and before industry-loyalties
and interests. This can also be seen from the experiences of the syndicalist
unions in Italy and France as well. The structure of such local federations
also situates the workplace in the community where it really belongs.

Also, by uniting struggles together, we can see that there are really no
"single issues" -- that all various different problems are inter-linked. For
example, ecological problems are not just that, but have a political and
economic basis and that economic and social domination and exploitation spills
into the environment. Inter-linking struggles means that they can be seen to
be related to other struggles against capitalist exploitation and oppression
and so encourage solidarity and mutual aid. What goes on in the environment,
for instance, is directly related to questions of domination and inequality
within human society, that pollution is often directly related to companies
cutting corners to survive in the market or increase profits. Similarly,
struggles against sexism or racism can be seen as part of a wider struggle
against hierarchy, exploitation and oppression in all their forms. As such,
uniting struggles has an important educational effect above and beyond the
benefits in terms of winning struggles.

Murray Bookchin presents a concrete example of this process of linking issues
and widening the struggle:

> _"Assume there is a struggle by welfare mothers to increase their allotments
. . . Without losing sight of the concrete issues that initially motivated the
struggle, revolutionaries would try to catalyse an order of relationships
between the mothers entirely different from [existing ones] . . . They would
try to foster a deep sense of community, a rounded human relationship that
would transform the very subjectivity of the people involved . . . Personal
relationships would be intimate, not merely issue-orientated. People would get
to **know** each other, to **confront** each other; they would **explore**
each other with a view of achieving the most complete, unalienated
relationships. Women would discuss sexism, as well as their welfare
allotments, child-rearing as well as harassment by landlords, their dreams and
hopes as human beings as well as the cost of living. _

> _"From this intimacy there would grow, hopefully, a supportive system of
kinship, mutual aid, sympathy and solidarity in daily life. The women might
collaborate to establish a rotating system of baby sitters and child-care
attendants, the co-operative buying of good food at greatly reduced prices,
the common cooking and partaking of meals, the mutual learning of survival
skills and the new social ideas, the fostering of creative talents, and many
other shared experiences. Every aspect of life that could be explored and
changed would be one part of the kind of relationships . . . _

> _"The struggle for increased allotments would expand beyond the welfare
system to the schools, the hospitals, the police, the physical, cultural,
aesthetic and recreational resources of the neighbourhood, the stores, the
houses, the doctors and lawyers in the area, and so on -- into the very
ecology of the district. _

> _"What I have said on this issue could be applied to every issue --
unemployment, bad housing, racism, work conditions -- in which an insidious
assimilation of bourgeois modes of functioning is masked as 'realism' and
'actuality.' The new order of relationships that could be developed from a
welfare struggle . . . [can ensure that the] future penetrates the present; it
recasts the way people 'organise' and the goals for which they strive."_
[**Post-Scarcity Anarchism**, pp. 153-4]

As the anarchist slogan puts it: **_"Resistance is Fertile."_** Planting the
seed of autonomy, direct action and self-liberation can result, potentially,
in the blossoming of free individuals due to the nature of struggle itself
(see [section A.2.7](secA2.html#seca27)). Therefore, the generalisation of
social struggle is not only a key way of winning a specific fight, it can (and
should) also spread into different aspects of life and society and play a key
part in developing free individuals who reject hierarchy in all aspects of
their life.

Social problems are not isolated from each other and so struggles against them
cannot be. The nature of struggle is such that once people start questioning
one aspect of society, the questioning of the rest soon follows. So,
anarchists seek to generalise struggles for these three reasons -- firstly, to
ensure the solidarity required to win; secondly, to combat the many social
problems we face as **people** and to show how they are inter-related; and,
thirdly, to encourage the transformation of those involved into unique
individuals in touch with their humanity, a humanity eroded by hierarchical
society and domination.

[‹ J.0 Section J Introduction](/afaq/secJint.html "Go to previous page" )
[up](/afaq/secJcon.html "Go to parent page" ) [J.2 What is direct action?
›](/afaq/secJ2.html "Go to next page" )

