# J.2 What is direct action?

Direct action, to use Rudolf Rocker's words, is _"every method of immediate
warfare by the workers [or other sections of society] against their economic
and political oppressors. Among these the outstanding are: the strike, in all
its graduations from the simple wage struggle to the general strike; the
boycott; sabotage in all its countless forms; anti-militarist propaganda, and
in particularly critical cases . . . armed resistance of the people for the
protection of life and liberty."_ [**Anarcho-Syndicalism**, p. 78]

Not that anarchists think that direct action is only applicable within the
workplace. Far from it. Direct action must occur everywhere! So, in non-
workplace situations, direct action includes rent strikes, consumer boycotts,
occupations (which, of course, can include sit-down strikes by workers), eco-
tage, individual and collective non-payment of taxes, blocking roads and
holding up construction work of an anti-social nature and so forth. Also
direct action, in a workplace setting, includes strikes and protests on social
issues, not directly related to working conditions and pay. Such activity aims
to ensure the _"protection of the community against the most pernicious
outgrowths of the present system. The social strike seeks to force upon the
employers a responsibility to the public. Primarily it has in view the
protection of the customers, of whom the workers themselves [and their
families] constitute the great majority"_ [**Op. Cit.**, p. 86]

Basically, direct action means that instead of getting someone else to act for
you (e.g. a politician), you act for yourself. Its essential feature is an
organised protest by ordinary people to make a change by their own efforts.
Thus Voltairine De Cleyre's excellent statement on this topic:

> _"Every person who ever thought he had a right to assert, and went boldly
and asserted it, himself, or jointly with others that shared his convictions,
was a direct actionist. Some thirty years ago I recall that the Salvation Army
was vigorously practicing direct action in the maintenance of the freedom of
its members to speak, assemble, and pray. Over and over they were arrested,
fined, and imprisoned; but they kept right on singing, praying, and marching,
till they finally compelled their persecutors to let them alone. The
Industrial Workers [of the World] are now conducting the same fight, and have,
in a number of cases, compelled the officials to let them alone by the same
direct tactics._

> _"Every person who ever had a plan to do anything, and went and did it, or
who laid his plan before others, and won their co-operation to do it with him,
without going to external authorities to please do the thing for them, was a
direct actionist. All co-operative experiments are essentially direct action._

> _"Every person who ever in his life had a difference with anyone to settle,
and went straight to the other persons involved to settle it, either by a
peaceable plan or otherwise, was a direct actionist. Examples of such action
are strikes and boycotts; many persons will recall the action of the
housewives of New York who boycotted the butchers, and lowered the price of
meat; at the present moment a butter boycott seems looming up, as a direct
reply to the price-makers for butter._

> _"These actions are generally not due to any one's reasoning overmuch on the
respective merits of directness or indirectness, but are the spontaneous
retorts of those who feel oppressed by a situation. In other words, all people
are, most of the time, believers in the principle of direct action, and
practisers of it."_ [**The Voltairine De Cleyre Reader**, pp. 47-8]

So direct action means acting for yourself against injustice and oppression.
It can, sometimes, involve putting pressure on politicians or companies, for
example, to ensure a change in an oppressive law or destructive practices.
However, such appeals are direct action simply because they do not assume that
the parties in question will act for us -- indeed the assumption is that
change only occurs when we act to create it. Regardless of what it is, _"if
such actions are to have the desired empowerment effect, they must be largely
self-generated, rather than being devised and directed from above"_ and be
_"ways in which people could take control of their lives"_ so that it
_"empowered those who participated in it."_ [Martha Ackelsberg, **Free Women
of Spain**, p. 55]

So, in a nutshell, direct action is any form of activity which people
themselves decide upon and organise themselves which is based on their own
collective strength and does not involve getting intermediates to act for
them. As such direct action is a natural expression of liberty, of self-
government, for direct action _"against the authority in the shop, direct
action against the authority of the law, direct action against the invasive,
meddlesome authority of our moral code, is the logical, consistent method of
Anarchism."_ [Emma Goldman, **Red Emma Speaks**, pp. 76-7] It is clear that by
acting for yourself you are expressing the ability to govern yourself. Thus it
is a means by which people can take control of their own lives. It is a means
of self-empowerment and self-liberation.

Anarchists reject the view that society is static and that people's
consciousness, values, ideas and ideals cannot be changed. Far from it and
anarchists support direct action **because** it actively encourages the
transformation of those who use it. Direct action is the means of creating a
new consciousness, a means of self-liberation from the chains placed around
our minds, emotions and spirits by hierarchy and oppression.

As direct action is the expression of liberty, the powers that be are vitally
concerned only when the oppressed use direct action to win its demands, for it
is a method which is not easy or cheap to combat. Any hierarchical system is
placed into danger when those at the bottom start to act for themselves and,
historically, people have invariably gained more by acting directly than could
have been won by playing ring around the rosy with indirect means. Direct
action tore the chains of open slavery from humanity. Over the centuries it
has established individual rights and modified the life and death power of the
master class. Direct action won political liberties such as the vote and free
speech. Used fully, used wisely and well, direct action can forever end
injustice and the mastery of humans by other humans.

In the sections that follow, we will indicate why anarchists are in favour of
direct action and why they are against electioneering as a means of change.

## J.2.1 Why do anarchists favour using direct action to change things?

Simply because it is effective and it has a radicalising impact on those who
practice it. As it is based on people acting for themselves, it shatters the
dependency and marginalisation created by hierarchy. This is key:

> _"What is even more important about direct action is that it forms a
decisive step toward recovering the personal power over social life that the
centralised, over-bearing bureaucracies have usurped from the people . . . we
not only gain a sense that we can control the course of social events again;
we recover a new sense of selfhood and personality without which a truly free
society, based in self-activity and self-management, is utterly impossible."_
[Murray Bookchin, **Toward an Ecological Society**, p. 47]

By acting for themselves, people gain a sense of their own power and
abilities. This is essential if people are to run their own lives. As such,
direct action is **the** means by which individuals empower themselves, to
assert their individuality, to make themselves count as individuals by
organising and acting collectively. It is the opposite of hierarchy, within
which individuals are told again and again that they are nothing, are
insignificant and must dissolve themselves into a higher power (the state, the
company, the party, the people, etc.) and feel proud in participating in the
strength and glory of this higher power. Direct action, in contrast, is the
means of asserting your individual opinion, interests and happiness, of
fighting against self-negation:

> _"man has as much liberty as he is willing to take. Anarchism therefore
stands for direct action, the open defiance of, and resistance to, all laws
and restrictions, economic, social and moral. But defiance and resistance are
illegal. Therein lies the salvation of man. Everything illegal necessitates
integrity, self-reliance, and courage. In short, it calls for free independent
spirits, for men who are men, and who have a bone in their back which you
cannot pass your hand through."_ [Emma Goldman, **Red Emma Speaks**, pp. 75-6]

In addition, because direct action is based around individuals solving their
own problems, by their own action, it awakens those aspects of individuals
crushed by hierarchy and oppression -- such as initiative, solidarity,
imagination, self-confidence and a sense of individual and collective power,
that what you do matters and that you with others like you **can** change the
world. Direct action is the means by which people can liberate themselves and
educate themselves in the ways of and skills required for self-management and
liberty:

> _"Direct action meant that the goal of . . . these activities was to provide
ways for people to get in touch with their own powers and capacities, to take
back the power of naming themselves and their lives . . . we learn to think
and act for ourselves by joining together in organisations in which our
experience, our perception, and our activity can guide and make the change.
Knowledge does not precede experience, it flows from it . . . People learn to
be free only by exercising freedom. [As one Spanish Anarchist put it] 'We are
not going to find ourselves . . . with people ready-made for the future . . .
Without continued exercise of their faculties, there will be no free people .
. . The external revolution and the internal revolution presuppose one
another, and they must be simultaneous in order to be successful.'"_ [Martha
Ackelsberg, **Free Women of Spain**, pp. 54-5]

So direct action, to use Bookchin's words, is _"the means whereby each
individual awakens to the hidden powers within herself and himself, to a new
sense of self-confidence and self-competence; it is the means whereby
individuals take control of society directly."_ [**Op. Cit.**, p. 48]

In addition, direct action creates the need for new forms of social
organisation. These new forms of organisation will be informed and shaped by
the process of self-liberation, so be more anarchistic and based upon self-
management. Direct action, as well as liberating individuals, can also create
the free, self-managed organisations which can replace the current
hierarchical ones (see [section I.2.3](secI2.html#seci23)). For example, for
Kropotkin, unions were _"natural organs for the direct struggle with
capitalism and for the composition of the future order."_ [quoted by Paul
Avrich, **The Russian Anarchists**, p. 81] In other words, direct action helps
create the new world in the shell of the old:

> _"direct action not only empowered those who participated in it, it also had
effects on others . . . [it includes] exemplary action that attracted
adherents by the power of the positive example it set. Contemporary examples .
. . include food or day-care co-ops, collectively run businesses, sweat equity
housing programmes, women's self-help health collectives, urban squats or
women's peace camps [as well as traditional examples as industrial unions,
social centres, etc.]. While such activities empower those who engage in them,
they also demonstrate to others that non-hierarchical forms of organisation
can and do exist -- and that they can function effectively."_ [Ackelsberg,
**Op. Cit.**, p. 55]

Also, direct action such as strikes encourage and promote class consciousness
and class solidarity. According to Kropotkin, _"the strike develops the
sentiment of solidarity"_ while, for Bakunin, it _"is the beginnings of the
social war of the proletariat against the bourgeoisie . . . Strikes are a
valuable instrument from two points of view. Firstly, they electrify the
masses, invigorate their moral energy and awaken in them the feeling of the
deep antagonism which exists between their interests and those of the
bourgeoisie . . . secondly they help immensely to provoke and establish
between the workers of all trades, localities and countries the consciousness
and very fact of solidarity: a twofold action, both negative and positive,
which tends to constitute directly the new world of the proletariat, opposing
it almost in an absolute way to the bourgeois world."_ [quoted by Caroline
Cahm, **Kropotkin and the Rise of Revolutionary Anarchism 1872-1886**, p. 256
and pp. 216-217]

Direct action, therefore, helps to create anarchists and anarchist
alternatives within capitalism and statism. As such, it plays an essential
role in anarchist theory and activity. For anarchists, direct action _"is not
a 'tactic' . . . it is a moral principle, an ideal, a sensibility. It should
imbue every aspect of our lives and behaviour and outlook."_ [Bookchin, **Op.
Cit.**, p. 48]

## J.2.2 Why do anarchists reject voting as a means for change?

Simply because electioneering does not work. History is littered with examples
of radicals being voted into office only to become as, or even more,
conservative than the politicians they replaced.

As we have discussed previously (see [section B.2](secB2.html)) any government
is under pressure from two sources of power, the state bureaucracy and big
business. This ensures that any attempts at social change would be undermined
and made hollow by vested interests, assuming they even reached that level to
begin with (the de-radicalising effects of electioneering is discussed in
[section J.2.6](secJ2.html#secj26)). Here we will highlight the power of
vested interests within democratic government.

For anarchists, the general nature of the state and its role within society is
to ensure _"the preservation of the economic 'status quo,' the protection of
the economic privileges of the ruling class, whose agent and **gendarme** it
is"_. [Luigi Galleani, **The End of Anarchism?**, p. 28] As such, the state
and capital restrict and control the outcome of political action of the so-
called sovereign people as expressed by voting.

Taking capital to begin with, if we assume that a relatively reformist
government were elected it would soon find itself facing various economic
pressures. Either capital would disinvest, so forcing the government to back
down in the face of economic collapse, or the government in question would
control capital leaving the country and so would soon be isolated from new
investment and its currency would become worthless. Either is an effective
weapon to control democratically elected governments as both ensure that the
economy would be severely damaged and the promised "reforms" would be dead
letters. Far fetched? No, not really. As discussed in [section
D.2.1](secD2.html#secd21) such pressures were inflicted on the 1974 Labour
Government in Britain and we see the threat reported everyday when the media
reports on what _"the markets"_ think of government policies or when loans are
given only with the guarantee that the country is structurally adjusted in-
line with corporate interests and bourgeois economic dogma.

As far as political pressures go, we must remember that there is a difference
between the state and government. The state is the permanent collection of
institutions that have entrenched power structures and interests. The
government is made up of various politicians. It is the institutions that have
power in the state due to their permanence, not the representatives who come
and go. In other words, the state bureaucracy has vested interests and elected
politicians cannot effectively control them:

> _"Such a bureaucracy consists of armed forces, police forces, and a civil
service. These are largely autonomous bodies. Theoretically they are
subordinate to a democratically elected Parliament, but the Army, Navy, and
Air Forces are controlled by specially trained officers who from their
schooldays onwards are brought up in a narrow caste tradition, and who always,
in dealing with Parliament, can dominate that body by their superior technical
knowledge, professional secrecy, and strategic bluff. As for the bureaucracy
proper, the Civil Service, anyone who has had any experience of its inner
workings knows the extent to which it controls the Cabinet, and through the
Cabinet, Parliament itself. We are really ruled by a secret shadow cabinet . .
. All these worthy servants of the State are completely out of touch with the
normal life of the nation."_ [Herbert Read, **Anarchy and Order**, p. 100]

As an aside, it should be noted that while _"in a society of rich and poor
nothing is more necessary"_ than a bureaucracy as it is _"necessary to protect
an unfair distribution of property"_ it would be wrong to think that it does
not have its own class interests: _"Even if you abolish all other classes and
distinctions and retain a bureaucracy you are still far from the classless
society, for the bureaucracy is itself the nucleus of a class whose interests
are totally opposed to the people it supposedly serves."_ [**Op. Cit.**, p. 99
and p. 100]

In addition to the official bureaucracies and their power, there is also the
network of behind the scenes agencies which are its arm. This can be termed
_"the permanent government"_ and _"the secret state"_, respectively. The
latter, in Britain, is _"the security services, MI5, Special Branch and the
secret intelligence service, MI6."_ Other states have their equivalents (the
FBI, CIA, and so on in the USA). By the former, it is meant _"the secret state
plus the Cabinet Office and upper echelons of Home and Foreign and
Commonwealth Offices, the Armed Forces and Ministry of Defence . . . and the
so-called 'Permanent Secretaries Club,' the network of very senior civil
servants -- the 'Mandarins.'"_ In short, the upper-echelons of the bureaucracy
and state apparatus. Add to this _"its satellites"_, including M.P.s
(particularly right-wing ones), _"agents of influence"_ in the media, former
security services personnel, think tanks and opinion forming bodies, front
companies of the security services, and so on. [Stephen Dorril and Robin
Ramsay, **Smear! Wilson and the Secret State**, pp. X-XI]

These bodies, while theoretically under the control of the elected government,
can effectively (via disinformation, black operations, bureaucratic slowdowns,
media attacks, etc.) ensure that any government trying to introduce policies
which the powers that be disagree with will be stopped. In other words the
state is **not** a neutral body, somehow rising above vested interests and
politics. It is, and always will be, a institution which aims to protect
specific sections of society as well as its own.

An example of this "secret state" at work can be seen in the campaign against
Harold Wilson, the Labour Prime Minister of Britain in the 1970s, which
resulted in his resignation (as documented by Stephen Dorril and Robin
Ramsay). Left-wing Labour M.P. Tony Benn was subjected to intense pressure by
"his" Whitehall advisers during the same period:

> _"In early 1975, the campaign against Benn by the media was joined by the
secret state. The timing is interesting. In January, his Permanent Secretary
had 'declared war' and the following month began the most extraordinary
campaign of harassment any major British politician has experienced. While
this is not provable by any means, it does look as though there is a clear
causal connection between withdrawal of Prime Ministerial support, the open
hostility from the Whitehall mandarins and the onset of covert operations."_
[Dorril and Ramsay, **Op. Cit.**, p. 279]

This is not to forget the role of the secret state in undermining reformist
and radical organisations and movements. This involvement goes from pure
information gathering on "subversives", to disruption and repression. Taking
the example of the US secret state, Howard Zinn notes that in 1975:

> _"congressional committees . . . began investigations of the FBI and CIA. _

> _"The CIA inquiry disclosed that the CIA had gone beyond its original
mission of gathering intelligence and was conducting secret operations of all
kinds . . . [for example] the CIA - with the collusion of a secret Committee
of Forty headed by Henry Kissinger - had worked to 'destabilize' the
[democratically elected, left-wing] Chilean government . . ._

> _"The investigation of the FBI disclosed many years of illegal actions to
disrupt and destroy radical groups and left-wing groups of all kinds. The FBI
had sent forged letters, engaged in burglaries . . . opened mail illegally,
and in the case of Black Panther leader Fred Hampton, seems to have conspired
in murder . . ._

> _"The investigations themselves revealed the limits of government
willingness to probe into such activities . . . [and they] submitted its
findings on the CIA to the CIA to see if there was material the Agency wanted
omitted."_ [**A People's History of the United States**, pp. 542-3]

Also, the CIA secretly employs several hundred American academics to write
books and other materials to be used for propaganda purposes, an important
weapon in the battle for hearts and minds. In other words, the CIA, FBI (and
their equivalents in other countries) and other state bodies can hardly be
considered neutral bodies, who just follow orders. They are a network of
vested interests, with specific ideological viewpoints and aims which usually
place the wishes of the voting population below maintaining the state-capital
power structure in place.

Therefore we cannot expect a different group of politicians to react in
different ways to the same economic and institutional influences and
interests. Its no coincidence that left-wing, reformist parties have
introduced right-wing, pro-capitalist ("Thatcherite/Reaganite") policies
similar to those right-wing, explicitly pro-capitalist parties have. This is
to be expected as the basic function of any political system is to manage the
existing state and economic structures and a society's power relationships. It
is **not** to alter them radically, The great illusion of politics is the
notion that politicians have the power to make whatever changes they like.
Looking at the international picture, the question obviously arises as to what
real control do the politicians have over the international economy and its
institutions or the pattern of world trade and investment. These institutions
have great power and, moreover, have a driving force (the profit motive) which
is essentially out of control (as can be seen by the regular financial crises
during the neo-liberal era).

This can be seen most dramatically in the military coup in Chile against the
democratically re-elected (left-wing) Allende government by the military,
aided by the CIA, US based corporations and the US government to make it
harder for the Allende regime. The coup resulted in thousands murdered and
years of terror and dictatorship, but the danger of a pro-labour government
was ended and the business environment was made healthy for profits (see
[section C.11](secC11.html)). An extreme example, we know, but an important
one for any believer in freedom or the idea that the state machine is somehow
neutral and can be captured and used by left-wing parties -- particularly as
the fate of Chile has been suffered by many other reformist governments across
the world.

Of course there have been examples of quite extensive reforms which did
benefit working class people in major countries. The New Deal in the USA and
the 1945-51 Labour Governments spring to mind. Surely these indicate that our
claims are false? Simply put, no, they do not. Reforms can be won from the
state when the dangers of not giving in outweigh any weakening of ruling class
power implied in the reforms. In the face of economic crisis and working class
protest, the ruling elite often tolerates changes it would otherwise fight
tooth-and-nail in other circumstances. Reforms will be allowed if they can be
used to save the capitalist system and the state from its own excesses and
even improve their operation or if not bending will mean being broke in the
storm of social protest. After all, the possibility of getting rid of the
reforms when they are no longer required will always exist as long as class
society remains.

This can be seen from the reformist governments of 1930s USA and 1940s UK.
Both faced substantial economic problems and both were under pressure from
below, by waves of militant working class struggle which could have developed
beyond mere reformism. The waves of sit-down strikes in the 1930s ensured the
passing of pro-union laws which allowed workers to organise without fear of
being fired. This measure also partly integrated the unions into the
capitalist-state machine by making them responsible for controlling
"unofficial" workplace action (and so ensuring profits). The nationalisation
of roughly 20% of the UK economy during the Labour administration of 1945 (the
most unprofitable sections of it as well) was also the direct result of ruling
class fear. As Conservative M.P. Quintin Hogg acknowledged in the House of
Commons on the 17th February 1943: _"If you do not give the people reform they
are going to give you revolution"_. Memories of the near revolutions across
Europe after the First World War were obviously in many minds, on both sides.
Not that nationalisation was particularly feared as "socialism." Indeed it was
argued that it was the best means of improving the performance of the British
economy. As anarchists at the time noted _"the real opinions of capitalists
can be seen from Stock Exchange conditions and statements of industrialists
than the Tory Front bench"_ and from these it be seen _"that the owning class
is not at all displeased with the record and tendency of the Labour Party."_
[**Neither Nationalisation nor Privatisation**, Vernon Richards (ed.), p. 9]

History confirms Proudhon's argument that the state _"can only turn into
something and do the work of the revolution insofar as it will be so invited,
provoked or compelled by some power outside of itself that seizes the
initiative and sets things rolling,"_ namely by _"a body representative of the
proletariat be formed in Paris . . . in opposition to the bourgeoisie’s
representation."_ [**Property is Theft!**, p. 325] So, if extensive reforms
have implemented by the state, just remember that they were in response to
militant pressure from below and that we could have got so much more. In
general, things have little changed since this anarchist argument against
electioneering was put forward in the 1880s:

> _"in the electoral process, the working class will always be cheated and
deceived . . . if they did manage to send, one, or ten, or fifty of
them[selves to Parliament], they would become spoiled and powerless.
Furthermore, even if the majority of Parliament were composed of workers, they
could do nothing. Not only is there the senate . . . the chiefs of the armed
forces, the heads of the judiciary and of the police, who would be against the
parliamentary bills advanced by such a chamber and would refuse to enforce
laws favouring the workers (it has happened); but furthermore laws are not
miraculous; no law can prevent the capitalists from exploiting the workers; no
law can force them to keep their factories open and employ workers at such and
such conditions, nor force shopkeepers to sell as a certain price, and so
on."_ [S. Merlino, quoted by Galleani, **Op. Cit.**, p. 13]

As any worker will tell you, just because there are laws on such things as
health and safety, union organising, working hours or whatever, it does not
mean that bosses will pay any attention to them. While firing people for
joining a union is illegal in America, it does not stop bosses doing so.
Similarly, many would be surprised to discover that the 8 hour working day was
legally created in many US states by the 1870s but workers had to strike for
it in 1886 as it was not enforced. Ultimately, political action is dependent
on direct action to be enforced where it counts (in the workplace and
streets). And if only direct action can enforce a political decision once it
is made, then it can do so beforehand so showing the limitations in waiting
for politicians to act.

Anarchists reject voting for other reasons. The fact is that electoral
procedures are the opposite of direct action. They are **based** on getting
someone else to act on your behalf. Therefore, far from empowering people and
giving them a sense of confidence and ability, electioneering **dis**-empowers
them by creating a "leader" figure from which changes are expected to flow. As
Brian Martin observes:

> _"all the historical evidence suggests that parties are more a drag than an
impetus to radical change. One obvious problem is that parties can be voted
out. All the policy changes they brought in can simply be reversed later._

> _"More important, though, is the pacifying influence of the radical party
itself. On a number of occasions, radical parties have been elected to power
as a result of popular upsurges. Time after time, the 'radical' parties have
become chains to hold back the process of radical change."_ [_"Democracy
without Elections"_, pp. 123-36, **Reinventing Anarchy, Again**, Howard J.
Ehrlich (ed.), p. 124]

This can easily be seen from the history of various left-wing parties. Labour
or socialist parties, elected in periods of social turbulence, have often
acted to reassure the ruling elite by dampening popular action that could have
threatened capitalist interests. For example, the first action undertaken by
the Popular Front elected in France in 1936 was to put an end to strikes and
occupations and generally to cool popular militancy, which was the Front's
strongest ally in coming to power. The Labour government elected in Britain in
1945 got by with as few reforms as it could, refusing to consider changing
basic social structures and simply replaced wage-labour to a boss with wage-
labour to the state via nationalisation of certain industries. It did,
however, manage to find time within the first days of taking office to send
troops in to break a dockers' strike (this was no isolated event: Labour has
used troops to break strikes far more often than the Conservatives have).

These points indicate why existing power structures cannot effectively be
challenged through elections. For one thing, elected representatives are not
**mandated,** which is to say they are not tied in any binding way to
particular policies, no matter what promises they have made or what voters may
prefer. Around election time, the public's influence on politicians is
strongest, but after the election, representatives can do practically whatever
they want, because there is no procedure for **instant recall.** In practice
it is impossible to recall politicians before the next election, and between
elections they are continually exposed to pressure from powerful special-
interest groups -- especially business lobbyists, state bureaucracies and
political party power brokers.

Under such pressure, the tendency of politicians to break campaign promises
has become legendary. Generally, such promise breaking is blamed on bad
character, leading to periodic "throw-the-bastards-out" fervour -- after which
a new set of representatives is elected, who also mysteriously turn out to be
bastards! In reality it is the system itself that produces "bastards," the
sell-outs and shady dealing we have come to expect from politicians. In light
of modern "democracy", it is amazing that anyone takes the system seriously
enough to vote at all. In fact, voter turnout in the US and other nations
where "democracy" is practiced in this fashion is typically low. Nevertheless,
some voters continue to participate, pinning their hopes on new parties or
trying to reform a major party. For anarchists this activity is pointless as
it does not get at the root of the problem, it is the system which shapes
politicians and parties in its own image and marginalises and alienates people
due to its hierarchical and centralised nature. No amount of party politics
can change that.

However, we should make it clear that most anarchists recognise there is a
difference between voting for a government and voting in a referendum. Here we
are discussing the former, electioneering, as a means of social change.
Referenda are closer to anarchist ideas of direct democracy and are, while
flawed, far better than electing a politician to office once every four years
or so. In addition, Anarchists are not necessarily against **all** involvement
in electoral politics. Some advocate voting when the possible outcome of an
election could be disastrous (for example, if a fascist or quasi-fascist party
looks likely to win the election). Some Social Ecologists, following Murray
Bookchin's arguments, support actual standing in elections and think
anarchists by taking part in local elections can use them to create self-
governing community assemblies. However, few anarchists support such means to
create community assemblies (see [section J.5.14](secJ5.html#secj514) for a
discussion on this).

The problem of elections in a statist system, even on a local scale, means
that the vast majority of anarchists reject voting as a means of change.
Instead we wholeheartedly support direct action as the means of getting
improvements in the here and now as well as the means of creating an
alternative to the current system.

## J.2.3 What are the political implications of voting?

At its most basic, voting implies agreement with the status quo. It is worth
quoting the Scottish libertarian socialist James Kelman at length on this:

> _"State propaganda insists that the reason why at least 40 percent of the
voting public don't vote at all is because they have no feelings one way or
the other. They say the same thing in the USA, where some 85 percent of the
population are apparently 'apolitical' since they don't bother registering a
vote. Rejection of the political system is inadmissible as far as the state is
concerned . . . Of course the one thing that does happen when you vote is that
someone else has endorsed an unfair political system . . . A vote for any
party or any individual is always a vote for the political system. You can
interpret your vote in whichever way you like but it remains an endorsement of
the apparatus . . . If there was any possibility that the apparatus could
effect a change in the system then they would dismantle it immediately. In
other words the political system is an integral state institution, designed
and refined to perpetuate its own existence. Ruling authority fixes the agenda
by which the public are allowed 'to enter the political arena' and that's the
fix they've settled on."_ [**Some Recent Attacks**, p. 87]

We are taught from an early age that voting in elections is right and a duty.
In US schools, for example, children elect class presidents and other
officers. Often mini-general elections are held to "educate" children in
"democracy." Periodically, election coverage monopolises the media. We are
made to feel guilty about shirking our "civic responsibility" if we do not
vote. Countries that have no elections, or only rigged elections, are regarded
as failures. As a result, elections have become a quasi-religious ritual. Yet,
in reality, _"elections in practice have served well to maintain dominant
power structures such as private property, the military, male domination, and
economic inequality. None of these has been seriously threatened through
voting. It is from the point of view of radical critics that elections are
most limiting."_ [_"Democracy without Elections"_, pp. 123-36, **Reinventing
Anarchy, Again**, Howard J. Ehrlich (ed.), p. 124]

Elections serve the interests of state power in other ways. First, voting
helps to legitimate government; hence suffrage has often been expanded at
times when there was little popular demand for it but when mass support of
government was crucial, as during a war or revolution. Second, it comes to be
seen as the only legitimate form of political participation, thus making it
likely that any revolts by oppressed or marginalised groups will be viewed by
the general public as illegitimate. It helps focus attention away from direct
action and building new social structures back into institutions which the
ruling class can easily control. The general election during the May '68
revolt in France, for example, helped diffuse the revolutionary situation, as
did the elections during the Argentine revolt against neo-liberalism in the
early 2000s.

So by turning political participation into the "safe" activities of
campaigning and voting, elections have reduced the risk of more radical direct
action as well as building a false sense of power and sovereignty among the
general population. Voting disempowers the grassroots by diverting energy from
grassroots action. After all, the goal of electoral politics is to elect a
representative who will act **for** us. Therefore, instead of taking direct
action to solve problems ourselves, action becomes indirect, though the
government. This is an insidiously easy trap to fall into, as we have been
conditioned in hierarchical society from day one into attitudes of passivity
and obedience, which gives most of us a deep-seated tendency to leave
important matters to the "experts" and "authorities." Kropotkin described well
the net effect:

> _"Vote! Greater men than you will tell you the moment when the self-
annihilation of capital has been accomplished. They will then expropriate the
few usurpers left . . . and you will be freed without having taken any more
trouble than that of writing on a bit of paper the name of the man whom the
heads of your faction of the party told you to vote for!"_ [quoted by Ruth
Kinna, _"Kropotkin's theory of Mutual Aid in Historical Context"_, pp.
259-283, **International Review of Social History**, No. 40, pp. 265-6]

Anarchists also criticise elections for giving citizens the false impression
that the government serves, or can serve, the people. As Martin reminds us
_"the founding of the modern state a few centuries ago was met with great
resistance: people would refuse to pay taxes, to be conscripted or to obey
laws passed by national governments. The introduction of voting and the
expanded suffrage have greatly aided the expansion of state power. Rather than
seeing the system as one of ruler and ruled, people see at least the
possibility of using state power to serve themselves. As electoral
participation has increased, the degree of resistance to taxation, military
service, and the immense variety of laws regulating behaviour, has been
greatly attenuated"_ [**Op. Cit.**, p. 126]

Ironically, voting has legitimated the growth of state power to such an extent
that the state is now beyond any real popular control by the form of
participation that made that growth possible. Nevertheless, the idea that
electoral participation means popular control of government is so deeply
implanted in people's psyches that even the most overtly sceptical radical
often cannot fully free themselves from it.

Therefore, voting has the important political implication of encouraging
people to identify with state power and to justify the status quo. In
addition, it feeds the illusion that the state is neutral and that electing
parties to office means that people have control over their own lives.
Moreover, elections have a tendency to make people passive, to look for
salvation from above and not from their own self-activity. As such it produces
a division between leaders and led, with the voters turned into spectators of
activity, not the participants within it.

All this does not mean, obviously, that anarchists prefer dictatorship or an
"enlightened" monarchy. Far from it, democratising state power can be an
important step towards abolishing it. All anarchists agree with Bakunin when
he argued that _"the most imperfect republic is a thousand times better that
even the most enlightened monarchy."_ [quoted by Daniel Guerin, **Anarchism**,
p. 20] It simply means that anarchists refuse to join in with the farce of
electioneering, particularly when there are more effective means available for
changing things for the better. Anarchists reject the idea that our problems
can be solved by the very institutions that cause them in the first place!

## J.2.4 Surely voting for radical parties will be effective?

There is no doubt that voting can lead to changes in policies, which can be a
good thing as far as it goes. However, such policies are formulated and
implemented within the authoritarian framework of the hierarchical capitalist
state -- a framework which itself is never open to challenge by voting. On the
contrary, voting legitimates the state framework ensuring that social change
will be (at best) mild, gradual, and reformist rather than rapid and radical.
Indeed, the "democratic" process has resulted in all successful political
parties becoming committed to "more of the same" or tinkering with the details
at best (which is usually the limits of any policy changes). This seems
unlikely to change.

Given the need for radical systemic changes as soon as possible due to the
exponentially accelerating crises of modern civilisation, working for gradual
reforms within the electoral system must be seen as a potentially deadly
tactical error. Electioneering has always been the death of radicalism.
Political parties are only radical when they do not stand a chance of
election. However, many social activists continue to try to use elections, so
participating in the system which disempowers the majority and so helps create
the social problems they are protesting against. It should be a widely
recognised truism in radical circles that elections empower the politicians
and not the voters. Thus elections focus attention to a few leaders, urging
them to act **for** rather than acting for ourselves (see [section
H.1.5](secH1.html#sech15)). If genuine social change needs mass participation
then, by definition, using elections will undermine that. This applies to
within the party as well, for working "within the system" disempowers
grassroots activists, as can be seen by the Green party in Germany during the
early eighties. The coalitions into which the Greens entered with Social
Democrats in the German legislature often had the effect of strengthening the
status quo by co-opting those whose energies might otherwise have gone into
more radical and effective forms of activism. Principles were ignored in
favour of having some influence, so producing watered-down legislation which
tinkered with the system rather than transforming it.

As discussed in [section H.3.9](secH3.html#sech39), the state is more
complicated than the simple organ of the economically dominant class pictured
by Marxists. There are continual struggles both inside and outside the state
bureaucracies, struggles that influence policies and empower different groups
of people. This can produce clashes within the ruling elite, while the need of
the state to defend the system **as a whole** causes conflict with the
interests of sections of the capitalist class. Due to this, many radical
parties believe that the state is neutral and so it makes sense to work within
it -- for example, to obtain labour, consumer, and environmental protection
laws. However, this reasoning ignores the fact that the organisational
structure of the state is not neutral. To quote Brian Martin:

> _"The basic anarchist insight is that the structure of the state, as a
centralised administrative apparatus, is inherently flawed from the point of
view of human freedom and equality. Even though the state can be used
occasionally for valuable ends, as a means the state is flawed and impossible
to reform. The non-reformable aspects of the state include, centrally, its
monopoly over 'legitimate' violence and its consequent power to coerce for the
purpose of war, internal control, taxation and the protection of property and
bureaucratic privilege._

> _"The problem with voting is that the basic premises of the state are never
considered open for debate, much less challenge. The state's monopoly over the
use of violence for war is never at issue. Neither is the state's use of
violence against revolt from within. The state's right to extract economic
resources from the population is never questioned. Neither is the state's
guarantee of either private property (under capitalism) or bureaucratic
prerogative (under state socialism) -- or both."_ [_"Democracy without
Elections",_ pp. 123-36, **Reinventing Anarchy, Again**, Howard J. Ehrlich
(ed.), p. 127]

It may be argued that if a new political group is radical enough it will be
able to use state power for good purposes. While we discuss this in more
detail in [section J.2.6](secJ2.html#secj26), let us consider a specific case,
that of the Greens as many of them believe that the best way to achieve their
aims is to work within the current political system.

By pledging to use the electoral system to achieve change, Green parties
necessarily commit themselves to formulating their proposals as legislative
agendas. But once legislation is passed, the coercive mechanisms of the state
will be needed to enforce it. Therefore, Green parties are committed to
upholding state power. However, our analysis in [section B.2](secB2.html)
indicated that the state is a set of hierarchical institutions through which a
ruling elite dominates society and individuals. And, as we have seen in
[section E](secEcon.html), ecologists, feminists, and peace activists -- who
are key constituencies of the Green movement -- all need to **dismantle**
hierarchies and domination in order to achieve their respective aims.
Therefore, since the state is not only the largest and most powerful hierarchy
but also serves to maintain the hierarchical form of all major institutions in
society (since this form is the most suitable for achieving ruling-class
interests), the state itself is the main obstacle to the success of key
constituencies of the Green movement. Hence it is impossible **in principle**
for a parliamentary Green party to achieve the essential objectives of the
Green movement. A similar argument would apply to any radical party whose main
emphasis was social justice, which like the goals of feminists, radical
ecologists, and peace activists, depends on dismantling hierarchies.

As we argued in the [previous section](secJ2.html#secj23), radical parties are
under pressure from economic and state bureaucracies that ensure that even a
sincere radical party would be powerless to introduce significant reforms. The
only real response to the problems of representative democracy is to urge
people not to vote. Such anti-election campaigns can be a valuable way of
making others aware of the limitations of the current system, which is a
necessary condition for their seriously considering the anarchist alternative
of using direct action and building alternative social and economic
organisations. The implications of abstentionism are discussed in the [next
section](secJ2.html#secj25).

## J.2.5 Why do anarchists support abstentionism and what are its
implications?

At its most basic, anarchists support abstentionism because _"participation in
elections means the transfer of one's will and decisions to another, which is
contrary to the fundamental principles of anarchism."_ [Emma Goldman, **Vision
on Fire**, p. 89] For, as Proudhon stressed, in a statist democracy, the
people _"is limited to choosing, every three or four years, its chiefs and its
imposters."_ [quoted by George Woodcock, **Pierre-Joseph Proudhon**, p. 152]

If you reject hierarchy then participating in a system by which you elect
those who will govern you is almost like adding insult to injury! For, as
Luigi Galleani pointed out, _"whoever has the political competence to choose
his own rulers is, by implication, also competent to do without them."_ [**The
End of Anarchism?**, p. 37] In other words, because anarchists reject the idea
of authority, we reject the idea that picking the authority (be it bosses or
politicians) makes us free. Therefore, anarchists reject governmental
elections in the name of self-government and free association. We refuse to
vote as voting is endorsing authoritarian social structures. We are (in
effect) being asked to make obligations to the state, not our fellow citizens,
and so anarchists reject the symbolic process by which our liberty is
alienated from us.

Anarchists are aware that elections serve to legitimate government. We have
always warned that since the state is an integral part of the system that
perpetuates poverty, inequality, racism, imperialism, sexism, environmental
destruction, and war, we should not expect to solve any of these problems by
changing a few nominal state leaders every four or five years. Therefore
anarchists (usually) advocate abstentionism at election time as a means of
exposing the farce of "democracy", the disempowering nature of elections and
the real role of the state.

For anarchists then, when you vote, you are choosing between rulers. Instead
of urging people to vote we raise the option of choosing to rule yourself, to
organise freely with others -- in your workplace, in your community,
everywhere -- as equals. The option of something you cannot vote for, a new
society. Instead of waiting for others to make some changes for you,
anarchists urge that you do it yourself. In this way, you cannot but build an
alternative to the state which can reduce its power now and, in the long run,
replace it. This is the core of the anarchist support for abstentionism.

In addition, beyond this basic anarchist rejection of elections from an anti-
statist position, anarchists also support abstentionism as it allows us to put
across our ideas at election time. It is a fact that at such times people are
often more interested in politics than usual. So, by arguing for abstentionism
we can get our ideas across about the nature of the current system, how
elected politicians do not control the state bureaucracy, now the state acts
to protect capitalism and so on. In addition, it allows us to present the
ideas of direct action and encourage those disillusioned with political
parties and the current system to become anarchists by presenting a viable
alternative to the farce of politics. For, after all, a sizeable percentage of
non-voters and voters are disillusioned with the current set-up. Many who vote
do so simply against the other candidate, seeking the least-worse option. Many
who do not vote do so for essentially political reasons, such as being fed up
with the political system, failing to see any major differences between the
parties, or recognition that the candidates were not interested in people like
them. These non-voters are often disproportionately left-leaning, compared
with those who did vote. Anarchist abstentionism is a means of turning this
negative reaction to an unjust system into positive activity.

So, anarchist opposition to electioneering has deep political implications
which Luigi Galleani addressed when he wrote:

> _"The anarchists' electoral abstentionism implies not only a conception that
is opposed to the principle of representation (which is totally rejected by
anarchism), it implies above all an absolute lack of confidence in the State .
. . Furthermore, anarchist abstentionism has consequences which are much less
superficial than the inert apathy ascribed to it by the sneering careerists of
'scientific socialism' [i.e. Marxism]. It strips the State of the
constitutional fraud with which it presents itself to the gullible as the true
representative of the whole nation, and, in so doing, exposes its essential
character as representative, procurer and policeman of the ruling classes._

> _"Distrust of reforms, of public power and of delegated authority, can lead
to direct action [in the class struggle] . . . It can determine the
revolutionary character of this . . . action; and, accordingly, anarchists
regard it as the best available means for preparing the masses to manage their
own personal and collective interests; and, besides, anarchists feel that even
now the working people are fully capable of handling their own political and
administrative interests."_ [**Op. Cit.**, pp. 13-14]

Therefore abstentionism stresses the importance of self-activity and self-
liberation as well as having an important educational effect in highlighting
that the state is not neutral but serves to protect class rule and that
meaningful change only comes from below, by direct action. For the dominant
ideas within any class society reflect the opinions of the ruling elite of
that society and so any campaign at election times which argues for
abstentionism and indicates why voting is a farce will obviously challenge
them. In other words, abstentionism combined with direct action and the
building of libertarian alternatives is a very effective means of changing
people's ideas and encouraging a process of self-education and, ultimately,
self-liberation.

In summary, anarchists urge abstentionism in order to **encourage** activity,
not apathy. Not voting is **not** enough, and anarchists urge people to
**organise** and **resist** as well. Abstentionism must be the political
counterpart of class struggle, self-activity and self-management in order to
be effective -- otherwise it is as pointless as voting is.

## J.2.6 What are the effects of radicals using electioneering?

While many radicals would be tempted to agree with our analysis of the
limitations of electioneering and voting, few would automatically agree with
anarchist abstentionist arguments. Instead, they argue that we should combine
direct action with electioneering. In that way (it is argued) we can overcome
the limitations of electioneering by invigorating it with self-activity. In
addition, they suggest, the state is too powerful to leave in the hands of the
enemies of the working class. A radical politician will refuse to give the
orders to crush social protest that a right-wing, pro-capitalist one would.

While these are important arguments in favour of radicals using elections,
they ultimately fail to take into account the nature of the state and the
corrupting effect it has on radicals. This reformist idea has met a nasty end.
If history is anything to go by, the net effect of radicals using elections is
that by the time they are elected to office the radicals will happily do what
they claimed the right-wing would have done. In 1899, for example, the
Socialist Alexandre Millerand joined the French Government. Nothing changed.
During industrial disputes strikers _"appealed to Millerand for help,
confident that, with him in the government, the state would be on their side.
Much of this confidence was dispelled within a few years. The government did
little more for workers than its predecessors had done; soldiers and police
were still sent in to repress serious strikes."_ [Peter N. Stearns,
**Revolutionary Syndicalism and French Labour**, p. 16] Aristide Briand,
another socialist politician was the Minister of the Interior in 1910 and
_"broke a general strike of railwaymen by use of the most draconian methods.
Having declared a military emergency he threatened all strikers with court
martial."_ [Jeremy Jennings, **Syndicalism in France** p. 36] These events
occurred, it should be noted, during the period when social democratic parties
were self-proclaimed revolutionaries and arguing against anarcho-syndicalism
by using the argument that working people needed their own representatives in
office to stop troops being used against them during strikes!

Looking at the British Labour government of 1945 to 1951 we find the same
actions. What is often considered the most left-wing Labour government ever
used troops to break strikes in every year it was in office, starting with a
dockers' strike days after it became the new government. Again, in the 1970s,
Labour used troops to break strikes. Indeed, the Labour Party has used troops
to break strikes more often than the Conservative Party.

Many blame the individuals elected to office for these betrayals, arguing that
we need to elect **better** politicians, select **better** leaders. For
anarchists nothing could be more wrong as its the means used, not the
individuals involved, which is the problem. Writing of his personal experience
as a member of Parliament, Proudhon recounted that _"[a]s soon as I set foot
in the parliamentary Sinai, I ceased to be in touch with the masses; because I
was absorbed by my legislative work, I entirely lost sight of the current
events . . . One must have lived in that isolator which is called a National
Assembly to realise how the men who are most completely ignorant of the state
of the country are almost always those who represent it."_ There was
_"ignorance of daily facts"_ and _"fear of the people"_ (_"the sickness of all
those who belong to authority"_) for _"the people, for those in power, are the
enemy."_ [**Property is Theft!**, p. 19] Ultimately, as syndicalist Emile
Pouget argued, this fate was inevitable as any socialist politician _"could
not break the mould; he is only a cog in the machine of oppression and whether
he wishes it or not he must, as minister, participate in the job of crushing
the proletariat."_ [quoted by Jennings, **Op. Cit.**, p. 36]

These days, few enter Parliament as radicals like Proudhon. The notion of
using elections for radical change is rare. Such a development in itself shows
the correctness of the anarchist critique of electioneering. At its most
basic, electioneering results in the party using it becoming more moderate and
reformist -- it becomes the victim of its own success. In order to gain votes,
the party must appear "moderate" and "practical" and that means working within
the system:

> _"Participation in the politics of the bourgeois States has not brought the
labour movement a hair's-breadth nearer to Socialism, but thanks to this
method, Socialism has almost been completely crushed and condemned to
insignificance . . . Participation in parliamentary politics has affected the
Socialist Labour movement like an insidious poison. It destroyed the belief in
the necessity of constructive Socialist activity, and, worse of all, the
impulse to self-help, by inoculating people with the ruinous delusion that
salvation always comes from above."_ [Rudolf Rocker, **Anarcho-Syndicalism**,
p. 54]

This corruption does not happen overnight. Alexander Berkman indicated how it
slowly developed:

> _"In former days the Socialists . . . claimed that they meant to use
politics only for the purpose of propaganda . . . and took part in elections
on order to have an opportunity to advocate Socialism_

> _"It may seem a harmless thing but it proved the undoing of Socialism.
Because nothing is truer than the means you use to attain your object soon
themselves become your object . . . Little by little they changed their
attitude. Instead of electioneering being merely an educational method, it
gradually became their only method to secure political office, to get elected
to legislative bodies and other government positions. The change naturally led
the Socialists to tone down their revolutionary ardour; it compelled them to
soften their criticism of capitalism and government in order to avoid
persecution and secure more votes . . . they have ceased to be revolutionists;
they have become reformers who want to change things by law . . . And
everywhere, without exception, they have followed the same course, everywhere
they have forsworn their ideals, have duped the masses . . . There is a deeper
reason for this constant and regular betrayal [than individual scoundrels
being elected] . . . no man turns scoundrel or traitor overnight._

> _"It is **power** which corrupts . . . The filth and contamination of
politics everywhere proves that. Moreover, even with the best intentions
Socialists in legislative bodies or in governments find themselves entirely
powerless to accomplishing anything of a socialistic nature . . . The
demoralisation and vitiation take place little by little, so gradually that
one hardly notices it himself . . . [The elected Socialist] finds himself in a
strange and unfriendly atmosphere . . . and he must participate in the
business that is being transacted. Most of that business . . . has no bearing
whatever on the things the Socialist believes in, no connection with the
interests of the working class voters who elected him . . . when a bill of
some bearing upon labour . . . comes up . . . he is ignored or laughed at for
his impractical ideas on the matter . . . _

> _"Our Socialist perceives that he is regarded as a laughing stock [by the
other politicians] . . . and finds more and more difficulty in securing the
floor. . . he knows that neither by his talk nor by his vote can he influence
the proceedings . . . His speeches don't even reach the public . . . He
appeals to the voters to elect more comrades. . . Years pass . . . [and a]
number . . . are elected. Each of them goes through the same experience . . .
[and] quickly come to the conclusion . . . [that they] must show that they are
practical men . . . that they are doing something for their constituency . . .
In this manner the situation compels them to take a 'practical' part in the
proceedings, to 'talk business,' to fall in line with the matters actually
dealt with in the legislative body . . . Spending years in that atmosphere,
enjoying good jobs and pay, the elected Socialists have themselves become part
and parcel of the political machinery . . . With growing success in elections
and securing political power they turn more and more conservative and content
with existing conditions. Removal from the life and suffering of the working
class, living in the atmosphere of the bourgeoisie . . . they have become what
they call 'practical' . . . Power and position have gradually stifled their
conscience and they have not the strength and honesty to swim against the
current . . . They have become the strongest bulwark of capitalism."_ [**What
is Anarchism?**, pp. 92-8]

So the _"political power which they had wanted to conquer had gradually
conquered their Socialism until there was scarcely anything left of it."_
[Rocker, **Op. Cit.**, p. 55]

Not that these arguments are the result of hindsight, we must add. Bakunin was
arguing in the early 1870s that the _"inevitable result [of using elections]
will be that workers' deputies, transferred to a purely bourgeois environment,
and into an atmosphere of purely bourgeois political ideas . . . will become
middle class in their outlook, perhaps even more so than the bourgeois
themselves."_ As long as universal suffrage _"is exercised in a society where
the people, the mass of workers, are **economically** dominated by a minority
holding exclusive possession the property and capital of the country"_
elections _"can only be illusory, anti-democratic in their results."_ [**The
Political Philosophy of Bakunin**, p. 216 and p. 213] This meant that _"the
election to the German parliament of one or two workers . . . from the Social
Democratic Party"_ was _"not dangerous"_ and, in fact, was _"highly useful to
the German state as a lightning-rod, or a safety-valve."_ Unlike the
_"political and social theory"_ of the anarchists, which _"leads them directly
and inexorably to a complete break with all governments and all forms of
bourgeois politics, leaving no alternative but social revolution,"_ Marxism,
he argued, _"inexorably enmeshes and entangles its adherents, under the
pretext of political tactics, in endless accommodation with governments and
the various bourgeois political parties - that is, it thrusts them directly
into reaction."_ [Bakunin, **Statism and Anarchy**, p. 193 and pp. 179-80] In
the case of the German Social Democrats, this became obvious in 1914, when
they supported their state in the First World war, and after 1918, when they
crushed the German Revolution.

So history proved Bakunin's prediction correct (as it did with his prediction
that Marxism would result in elite rule). Simply put, for anarchists, the net
effect of socialists using bourgeois elections would be to put them (and the
movements they represent) into the quagmire of bourgeois politics and
influences. In other words, the parties involved will be shaped by the
environment they are working within and not vice versa.

History is littered with examples of radical parties becoming a part of the
system. From Marxian Social Democracy at the turn of the 19th century to the
German Green Party in the 1980s, we have seen radical parties, initially
proclaiming the need for direct action and extra-parliamentary activity
denouncing these activities once in power. From only using parliament as a
means of spreading their message, the parties involved end up considering
votes as more important than the message. Janet Biehl sums up the effects on
the German Green Party of trying to combine radical electioneering with direct
action:

> _"the German Greens, once a flagship for the Green movement worldwide,
should now be considered stink normal, as their **de facto** boss himself
declares. Now a repository of careerists, the Greens stand out only for the
rapidity with which the old cadre of careerism, party politics, and business-
as-usual once again played itself out in their saga of compromise and betrayal
of principle. Under the superficial veil of their old values -- a very thin
veil indeed, now -- they can seek positions and make compromises to their
heart's content . . . They have become 'practical,' 'realistic' and 'power-
orientated.' This former New Left ages badly, not only in Germany but
everywhere else. But then, it happened with the S.P.D. [The German Social
Democratic Party] in August 1914, then why not with Die Grunen in 1991? So it
did."_ [_"Party or Movement?"_, **Greenline**, no. 89, p. 14]

This, sadly, is the end result of all such attempts. Ultimately, supporters of
using political action can only appeal to the good intentions and character of
their candidates. Anarchists, however, present an analysis of state structures
and other influences that will determine how the character of the successful
candidates will change. In other words, in contrast to Marxists and other
radicals, anarchists present a materialist, scientific analysis of the
dynamics of electioneering and its effects on radicals. Like most forms of
idealism, the arguments of Marxists and other radicals flounder on the rocks
of reality.

However, many radicals refuse to learn this lesson of history and keep trying
to create a new party which will not repeat the saga of compromise and
betrayal which all other radical parties have suffered. And they say that
anarchists are utopian! _"You cannot dive into a swamp and remain clean."_
[Berkman, **Op. Cit.**, p. 99] Such is the result of rejecting (or
"supplementing" with electioneering) direct action as the means to change
things, for any social movement _"to ever surrender their commitment to direct
action for 'working within the system' is to destroy their personality as
socially innovative movements. It is to dissolve back into the hopeless morass
of 'mass organisations' that seek respectability rather than change."_ [Murray
Bookchin, **Toward an Ecological Society**, p. 47]

Moreover, the use of electioneering has a centralising effect on the movements
that use it. Political actions become considered as parliamentary activities
made **for** the population by their representatives, with the 'rank and file'
left with no other role than that of passive support. Only the leaders are
actively involved and the main emphasis falls upon them and it soon becomes
taken for granted that they should determine policy. Conferences become little
more than rallies with politicians freely admitting that they will ignore any
conference decisions as and when required. Not to mention the all-too-common
sight of politicians turning round and doing the exact opposite of what they
promised. In the end, party conferences become simply like parliamentary
elections, with party members supporting this leader against another.

Soon the party reflects the division between manual and mental labour so
necessary for the capitalist system. Instead of working class self-activity
and self-determination, there is a substitution of a non-working class
leadership acting **for** people. This replaces self-management in social
struggle and within the party itself. Electoralism strengthens the leaders
dominance over the party and the party over the people it claims to represent.
The real causes and solutions to the problems we face are mystified by the
leadership and rarely discussed in order to concentrate on the popular issues
that will get them elected. Ultimately, radicals _"instead of weakening the
false and enslaving belief in law and government . . . actually work to
**strengthen** the people's faith in forcible authority and government."_
[Berkman, **Op. Cit.**, p. 100] Which has always proved deadly to encouraging
a spirit of revolt, self-management and self-help -- the very keys to creating
change in a society. Thus this 1870 resolution of the Spanish section of the
First International seems to have been proven to be correct:

> _"Any participation of the working class in the middle class political
government would merely consolidate the present state of affairs and
necessarily paralyse the socialist revolutionary action of the proletariat.
The Federation [of unions] is the true representative of labour, and should
work outside the political system."_ [quoted by Jose Pierats, **Anarchists in
the Spanish Revolution**, p. 169]

Instead of trying to gain control of the state, for whatever reasons,
anarchists try to promote a culture of resistance within society that makes
the state subject to pressure from outside (see [section
J.2.9](secJ2.html#secj29)). And, we feel, history has proven us right time and
time again.

## J.2.7 Surely we should vote for reformist parties in order to expose them?

Some Leninist socialists (like the British **Socialist Workers Party** and its
offshoots) argue that we should urge people to vote for Labour and other
social democratic parties. In this they follow Lenin's 1920 argument against
the anti-Parliamentarian left that revolutionaries _"help"_ elect such parties
as many workers still follow their lead so that they will be _"convinced by
their own experience that we are right,"_ that such parties _"are absolutely
good for nothing, that they are petty-bourgeois and treacherous by nature, and
that their bankruptcy is inevitable."_ If we _"want the **masses** to follow
us"_, we need to _"support"_ such parties _"in the same way as the rope
supports a hanged man."_ In this way, by experiencing the reformists in
office, _"the majority will soon become disappointed in their leaders and will
begin to support communism."_ [**The Lenin Anthology**, p. 603, p. 605 and p.
602]

This tactic is suggested for two reasons. The first is that revolutionaries
will be able to reach more people by being seen to support popular, trade
union based, parties. If they do not, then they are in danger of alienating
sizeable sections of the working class by arguing that such parties will be no
better than explicitly pro-capitalist ones. The second, and the more important
one, is that by electing reformist parties into office the experience of
living under such a government will shatter whatever illusions its supporters
had in them. The reformist parties will be given the test of experience and
when they betray their supporters to protect the status quo it will radicalise
those who voted for them, who will then seek out **real** socialist parties
(namely the likes of the SWP and ISO).

Libertarians reject these arguments for three reasons.

Firstly, it is deeply dishonest as it hides the true thoughts of those who
support the tactic. To tell the truth is a revolutionary act. Radicals should
not follow the capitalist media by telling half-truths, distorting the facts,
hiding what they believe or supporting a party they are opposed to. If this
means being less popular in the short run, then so be it. Attacking
nationalism, capitalism, religion, or a host of other things can alienate
people but few revolutionaries would be so opportunistic as to hold their
tongues on these. In the long run being honest about your ideas is the best
way of producing a movement which aims to get rid of a corrupt social system.
Starting such a movement with half-truths is doomed to failure.

Secondly, anarchists reject the basis of this argument. The logic underlying
it is that by being disillusioned by their reformist leaders and party, voters
will look for **new,** "better" leaders and parties. However, this fails to go
to the root of the problem, namely the dependence on leaders which
hierarchical society creates within people. Anarchists do not want people to
follow the "best" leadership, they want them to govern themselves, to be
**self**-active, manage their own affairs and not follow **any** would-be
leaders. If you seriously think that the liberation of the oppressed is the
task of the oppressed themselves (as Leninists claim to do) then you **must**
reject this tactic in favour of ones that promote working class self-activity.

The third reason we reject this tactic is that it has been proven to fail time
and time again. What most of its supporters seem to fail to notice is that
voters have indeed put reformist parties into office many times. Lenin
suggested this tactic in 1920 and there has been no general radicalisation of
the voting population by this method, nor even in reformist party militants in
spite of the many Labour Party governments in Britain which all attacked the
working class. Moreover, the disillusionment associated with the experience of
reformist parties often expresses itself as a demoralisation with socialism
**as such**, rather than with the reformist's watered down version of it. If
Lenin's position could be persuasive to some in 1920 when it was untried, the
experience of subsequent decades should show its weakness.

This failure, for anarchists, is not surprising, considering the reasons why
we reject this tactic. Given that this tactic does not attack hierarchy or
dependence on leaders, does not attack the ideology and process of voting, it
will obviously fail to present a real alternative to the voting population
(who will turn to other alternatives available at election time and not
embrace direct action). Also the sight of a so-called "socialist" or "radical"
government managing capitalism, imposing cuts, breaking strikes and generally
attacking its supporters will damage the credibility of any form of socialism
and discredit all socialist and radical ideas in the eyes of the population.
If the experience of the Labour Government in Britain during the 1970s and New
Labour after 1997 are anything to go by, it may result in the rise of the far-
right who will capitalise on this disillusionment.

By refusing to argue that no government is "on our side," radicals who urge us
to vote reformist "without illusions" help to disarm theoretically the people
who listen to them. Working class people, surprised, confused and
disorientated by the constant "betrayals" of left-wing parties may turn to
right wing parties (who can be elected) to stop the attacks rather than turn
to direct action as the radical minority within the working class did not
attack voting as part of the problem. How many times must we elect the same
party, go through the same process, the same betrayals before we realise this
tactic does not work? Moreover, if it **is** a case of having to experience
something before people reject it, few state socialists take this argument to
its logical conclusion. We rarely hear them argue we must experience the hell
of fascism or Stalinism or the nightmare of free market capitalism in order to
ensure working class people "see through" them.

Anarchists, in contrast, say that we can argue against reformist politics
without having to associate ourselves with them by urging people to vote for
them. By arguing for abstentionism we can help to theoretically arm the people
who will come into conflict with these parties once they are in office. By
arguing that all governments will be forced to attack us (due to the pressure
from capital and state) and that we have to rely on our own organisations and
power to defend ourselves, we can promote working class self-confidence in its
own abilities, and encourage the rejection of capitalism, the state and
hierarchical leadership as well as the use of direct action.

Finally, we must add, it is not required for radicals to associate themselves
with the farce of parliamentary propaganda in order to win people over to our
ideas. Non-anarchists will see us use **direct action,** see us **act,** see
the anarchistic alternatives we create and see our propaganda. Non-anarchists
can be reached quite well without taking part in, or associating ourselves
with, parliamentary action.

## J.2.8 Will abstentionism lead to the right winning elections?

Possibly. However anarchists don't just say "don't vote", we say "organise" as
well. Apathy is something anarchists have no interest in encouraging.

The reasons **why** people abstain is more important than the act. The idea
that the USA is closer to anarchy because around 50% of people do not vote is
nonsense. Abstentionism in this case is the product of apathy and cynicism,
not political ideas. So anarchists recognise that apathetic abstentionism is
**not** revolutionary or an indication of anarchist sympathies. It is produced
by apathy and a general level of cynicism at **all** forms of political ideas
and the possibility of change.

That is why anarchist abstentionism always stresses the need for direct action
and organising economically and socially to change things, to resist
oppression and exploitation. In such circumstances, the effect of an electoral
strike would be fundamentally different than an apathy induced lack of voting.
_"If the anarchists", _Vernon Richards argued, _"could persuade half the
electorate to abstain from voting this would, from an electoral point of view,
contribute to the victory of the Right. But it would be a hollow victory, for
what government could rule when half the electorate by not voting had
expressed its lack of confidence in all governments?"_ The party in office
would have to rule over a country in which a sizeable minority, even a
majority, had rejected government as such. This would mean that the
politicians _"would be subjected to real pressures from people who believed in
their own power"_ and acted accordingly. So anarchists call on people **not**
to vote, but instead organise themselves and be conscious of their own power.
Only this _"can command the respect of governments, can curb the power of
government as millions of crosses on bits of paper never will."_ [**The
Impossibilities of Social Democracy**, p. 142]

For, as Emma Goldman pointed out, _"if the Anarchists were strong enough to
swing the elections to the Left, they must also have been strong enough to
rally the workers to a general strike, or even a series of strikes . . . In
the last analysis, the capitalist class knows too well that officials, whether
they belong to the Right or the Left, can be bought. Or they are of no
consequence to their pledge."_ [**Vision on Fire**, p. 90] The mass of the
population, however, cannot be bought off and if they are willing and able to
resist then they can become a power second to none. Only by organising,
fighting back and practicing solidarity where we live and work can we
**really** change things. That is where **our** power lies, that is where we
can create a **real** alternative. By creating a network of self-managed, pro-
active community and workplace organisations we can impose by direct action
that which politicians can never give us from Parliament. Only such a movement
can stop the attacks upon us by whoever gets into office. A government (left
or right) which faces a mass movement based upon direct action and solidarity
will always think twice before proposing cuts or introducing authoritarian
laws. Howard Zinn expressed it well:

> _"I think a way to behave is to think not in terms of representative
government, not in terms of voting, not in terms of electoral politics, but
thinking in terms of organising social movements, organising in the workplace,
organising in the neighbourhood, organising collectives that can become strong
enough to eventually take over -- first to become strong enough to resist what
has been done to them by authority, and second, later, to become strong enough
to actually take over the institutions . . . the crucial question is not who
is in office, but what kind of social movement do you have. Because we have
seen historically that if you have a powerful social movement, it doesn’t
matter who is in office. Whoever is in office, they could be Republican or
Democrat, if you have a powerful social movement, the person in office will
have to yield, will have to in some ways respect the power of social movements
. . . voting is not crucial, and organising is the important thing."_ [**An
Interview with Howard Zinn on Anarchism: Rebels Against Tyranny**]

Of course, all the parties claim that they are better than the others and this
is the logic of this question -- namely, we must vote for the lesser evil as
the right-wing in office will be terrible. But what this forgets is that the
lesser evil is still an evil. What happens is that instead of the greater evil
attacking us, we get the lesser evil doing what the right-wing was going to
do. Let us not forget it was the "lesser evil" of the Democrats (in the USA)
and Labour (in the UK) who first introduced, in the 1970s, the monetarist and
other policies that Reagan and Thatcher made their own in the 1980s.

This is important to remember. The central fallacy in this kind of argument is
the underlying assumption that "the left" will **not** implement the same kind
of policies as the right. History does not support such a perspective and it
is a weak hope to place a political strategy on. As such, when people worry
that a right-wing government will come into power and seek to abolish previous
social gains (such as abortion rights, welfare programmes, union rights, and
so forth) they seem to forget that so-called left-wing administrations have
also undermined such reforms. In response to queries by the left on how
anarchists would seek to defend such reforms if their abstentionism aided the
victory of the right, anarchists reply by asking the left how they seek to
defend such reforms when their "left-wing" government starts to attack them.

Ultimately, voting for other politicians will make little difference. The
reality is that politicians are puppets. As we argued in [section
J.2.2](secJ2.html#secj22), real power in the state does not lie with
politicians, but instead within the state bureaucracy and big business. Faced
with these powers, we have seen left-wing governments from Spain to New
Zealand introduce right-wing policies. So even if we elected a radical party,
they would be powerless to change anything important and soon be forced to
attack us in the interests of capitalism. Politicians come and go, but the
state bureaucracy and big business remain forever! Simply put, we cannot
expect a different group of politicians to react that differently to the same
economic and political pressures and influences.

Therefore we cannot rely on voting for the lesser evil to safe us from the
possible dangers of a right-wing election victory. All we can hope for is that
no matter who gets in, the population will resist the government because it
knows and can use its real power: **direct action**. For the _"only limit to
the oppression of government is the power with which the people show
themselves capable of opposing it."_ [Malatesta, **Errico Malatesta: His Life
and Ideas**, p. 196] Hence Vernon Richards:

> _"If the anarchist movement has a role to play in practical politics it is
surely that of suggesting to, and persuading, as many people as possible that
their freedom from the Hitlers, Francos and the rest, depends not on the right
to vote or securing a majority of votes 'for the candidate of ones choice,'
but on evolving new forms of political and social organisation which aim at
the direct participation of the people, with the consequent weakening of the
power, as well of the social role, of government in the life of the
community."_ [_"Anarchists and Voting"_, pp. 176-87, **The Raven**, no. 14,
pp. 177-8]

We discuss what this could involve in the [next section](secJ2.html#secj29).

## J.2.9 What do anarchists do instead of voting?

While anarchists reject electioneering and voting, it does not mean that we
are politically apathetic. Indeed, part of the reason why anarchists reject
voting is because we think that voting is not part of the solution, it is part
of the problem. This is because it endorses an unjust and unfree political
system and makes us look to others to fight our battles for us. It **blocks**
constructive self-activity and direct action. It **stops** the building of
alternatives in our communities and workplaces. Voting breeds apathy and
apathy is our worse enemy.

Given that we have had universal suffrage for some time in the West and we
have seen the rise of Labour and Radical parties aiming to use that system to
effect change in a socialistic direction, it seems strange that we are
probably further away from socialism than when they started. The simple fact
is that these parties have spent so much time trying to win elections that
they have stopped even thinking about creating socialist alternatives in our
communities and workplaces. That is in itself enough to prove that
electioneering, far from eliminating apathy, in fact helps to create it.

So, because of this, anarchists argue that the only way to not waste your vote
is to spoil it! We are the only political movement which argues that nothing
will change unless you act for yourself, take back the power and fight the
system **directly.** Only direct action breaks down apathy and gets results.
It is the first steps towards real freedom, towards a free and just society.
Unsurprisingly, then, anarchists are the first to point out that not voting is
not enough: we need to actively struggle for an alternative to both voting
**and** the current system. Just as the right to vote was won after a long
series of struggles, so the creation of a free, decentralised, self-managed,
libertarian socialist society will be the product of social struggle.

Anarchists are the last people to deny the importance of political liberties
or the importance in wining the right to vote. The question we must ask is
whether it is a more a fitting tribute to the millions of people who used
direct action, fought and suffered for the right to vote to use that victory
to endorse a deeply unfair and undemocratic system or to use other means
(indeed the means they used to win the vote) to create a system based upon
true popular self-government? If we are true to our (and their) desire for a
real, meaningful democracy, we would have to reject political action in favour
of direct action.

This obviously gives an idea of what anarchists do instead of voting, we
agitate, organise and educate. Or, to quote Proudhon, the _"problem before the
labouring classes . . . consists not in capturing, but in subduing both power
and monopoly, -- that is, in generating from the bowels of the people, from
the depths of labour, a greater authority, a more potent fact, which shall
envelop capital and the state and subjugate them."_ For, _"to combat and
reduce power, to put it in its proper place in society, it is of no use to
change the holders of power or introduce some variation into its workings: an
agricultural and industrial combination must be found by means of which power,
today the ruler of society, shall become its slave."_ [**System of Economical
Contradictions**, p. 398 and p. 397]

We do this by organising what Bakunin called _"antipolitical social power of
the working classes."_ [**Bakunin on Anarchism**, p. 263] This activity which
bases itself on the two broad strategies of encouraging direct action and
building alternatives where we live and work.

Taking the first strategy, anarchists say that by using direct action we can
force politicians to respect the wishes of the people. For example, if a
government or boss tries to limit free speech, then anarchists would try to
encourage a free speech fight to break the laws in question until such time as
they are revoked. If a government or landlord refuses to limit rent increases
or improve safety requirements for accommodation, anarchists would organise
squats and rent strikes. In the case of environmental destruction, anarchists
would support and encourage attempts at halting the damage by mass trespassing
on sites, blocking the routes of developments, organising strikes and so on.
If a boss refuses to introduce an 8 hour day, then workers should form a union
and go on strike or simply stop working after 8 hours. Unlike laws, the boss
cannot ignore direct action. Similarly, strikes combined with social protest
would be effective means of stopping authoritarian laws being passed. For
example, anti-union laws would be best fought by strike action and community
boycotts (and given the utterly ineffectual defence pursued by pro-labour
parties using political action to stop anti-union laws who can seriously say
that the anarchist way would be any worse?). Collective non-payment of taxes
would ensure the end of unpopular government decisions. The example of the
poll tax rebellion in the UK in the late in 1980s shows the power of such
direct action. The government could happily handle hours of speeches by
opposition politicians but they could not ignore social protest (and we must
add that the Labour Party which claimed to oppose the tax happily let the
councils controlled by them introduce the tax and arrest non-payers).

The aim would be to spread struggles and involve as many people as possible,
for it is _"merely stupid for a group of workers -- even for the workers
organised as a national group -- to invite the making of a distinction between
themselves and the community. The real protagonists in this struggle are the
community and the State -- the community as an organic and inclusive body and
the State as the representatives of a tyrannical minority . . . The General
Strike of the future must be organised as a strike of the community against
the State. The result of that strike will not be in doubt."_ [Herbert Read,
**Anarchy and Order**, p. 52]

Such a counter-power would focus the attention of those in power far more than
a ballot in a few years time (particularly as the state bureaucracy is not
subject to even that weak form of accountability). As Noam Chomsky argues,
_"[w]ithin the constraints of existing state institutions, policies will be
determined by people representing centres of concentrated power in the private
economy, people who, in their institutional roles, will not be swayed by moral
appeals but by the costs consequent upon the decisions they make -- not
because they are 'bad people,' but because that is what the institutional
roles demands."_ He continues: _"Those who own and manage the society want a
disciplined, apathetic and submissive public that will not challenge their
privilege and the orderly world in which it thrives. The ordinary citizen need
not grant them this gift. Enhancing the Crisis of Democracy by organisation
and political engagement is itself a threat to power, a reason to undertake it
quite apart from its crucial importance in itself as an essential step towards
social change."_ [**Turning the Tide**, pp. 251-2]

In this way, by encouraging social protest, any government would think twice
before pursuing authoritarian, destructive and unpopular policies. In the
final analysis, governments can and will ignore the talk of opposition
politicians, but they cannot ignore social action for very long. In the words
of a Spanish anarchosyndicalist, anarchists _"do not ask for any concessions
from the government. Our mission and our duty is to impose from the streets
that which ministers and deputies are incapable of realising in parliament."_
[quoted by Graham Kelsey, **Anarchosyndicalism, Libertarian Communism and the
State**, p. 79] This was seen after the Popular Front was elected February
1936 and the Spanish landless workers, sick and tired of waiting for the
politicians to act, started to occupy the land. The government _"resorted to
the time-tested procedure of expelling the peasants with the Civil Guard."_
The peasants responded with a _"dramatic rebellion"_ which forced the
politicians to _"legalise the occupied farms. This proved once again that the
only effective reforms are those imposed by force from below. Indeed, direct
action was infinitely more successful than all the parliamentary debates that
took place between 1931 and 1933 about whether to institute the approved
Agrarian Reform law."_ [Abel Paz, **Durruti in the Spanish Revolution**, p.
391]

The second strategy of building alternatives flows naturally from the first.
Any form of campaign requires organisation and by organising in an anarchist
manner we build organisations that _"bear in them the living seeds of the new
society which is to replace the old world."_ [Bakunin, **Op. Cit.**, p. 255]
In organising strikes in the workplace and community we can create a network
of activists and union members who can encourage a spirit of revolt against
authority. By creating assemblies where we live and work we can create an
effective countering power to the state and capital. Such a union, as the
anarchists in Spain and Italy proved, can be the focal point for recreating
self-managed schools, social centres and so on. In this way the local
community can ensure that it has sufficient independent, self-managed
resources available to educate its members. Also, combined with credit unions
(or mutual banks), cooperative workplaces and stores, a self-managed
infrastructure could be created which would ensure that people can directly
provide for their own needs without having to rely on capitalists or
governments. In the words of a C.N.T. militant:

> _"We must create that part of libertarian communism which can be created
within bourgeois society and do so precisely to combat that society with our
own special weapons."_ [quoted by Kelsey, **Op. Cit.**, p. 79]

So, far from doing nothing, by not voting the anarchist actively encourages
alternatives. As the British anarchist John Turner argued, we _"have a line to
work upon, to teach the people self-reliance, to urge them to take part in
non-political [i.e. non-electoral] movements directly started by themselves
for themselves . . . as soon as people learn to rely upon themselves they will
act for themselves . . . We teach the people to place their faith in
themselves, we go on the lines of self-help. We teach them to form their own
committees of management, to repudiate their masters, to despise the laws of
the country."_ [quoted by John Quail, **The Slow Burning Fuse**, p. 87] In
this way we encourage self-activity, self-organisation and self-help -- the
opposite of apathy and doing nothing.

Ultimately, what the state and capital gives, they can also take away. What we
build by our own self-activity can last as long as we want it to and act to
protect it:

> _"The future belongs to those who continue daringly, consistently, to fight
power and governmental authority. The future belongs to us and to our social
philosophy. For it is the only social ideal that teaches independent thinking
and direct participation of the workers in their economic struggle. For it is
only through the organised economic strength of the masses that they can and
will do away with the capitalist system and all the wrongs and injustices it
contains. Any diversion from this stand will only retard our movement and make
it a stepping stone for political climbers."_ [Emma Goldman, **Vision on
Fire**, p. 92]

In short, what happens in our communities, workplaces and environment is too
important to be left to politicians -- or the ruling elite who control
governments. Anarchists need to persuade _"as many people as possible that
their freedom . . . depends not on the right to vote or securing a majority of
votes . . . but on evolving new forms of political and social organisation
which aim at the direct participation of the people, with the consequent
weakening of the power, as well as of the social role, of government in the
life of the community."_ [_"Anarchists and Voting"_, pp. 176-87, **The
Raven**, No. 14, pp. 177-8] We discuss what new forms of economic and social
organisations that this could involve in [section J.5](secJ5.html).

## J.2.10 Does rejecting electioneering mean that anarchists are apolitical?

No. Far from it. The "apolitical" nature of anarchism is Marxist nonsense. As
it desires to fundamentally change society, anarchism can be nothing but
political. However, anarchism does reject (as we have seen) "normal" political
activity as ineffectual and corrupting. However, many (particularly Marxists)
imply this rejection of the con of capitalist politics means that anarchists
concentrate on purely "economic" issues like wages, working conditions and so
forth. By so doing, Marxists claim that anarchists leave the political agenda
to be dominated by capitalist ideology, with disastrous results for the
working class.

This view, however, is **utterly** wrong. Indeed, Bakunin explicitly rejected
the idea that working people could ignore politics and actually agreed with
the Marxists that political indifference only led to capitalist control of the
labour movement:

> _"[some of] the workers in Germany . . . [were organised in] a kind of
federation of small associations . . . 'Self-help' . . . was its slogan, in
the sense that labouring people were persistently advised not to anticipate
either deliverance or help from the state and the government, but only from
their own efforts. This advice would have been excellent had it not been
accompanied by the false assurance that liberation for the labouring people is
possible under **current conditions of social organisation** . . . Under this
delusion . . . the workers subject to [this] influence were supposed to
disengage themselves systematically from all political and social concerns and
questions about the state, property, and so forth . . . [This] completely
subordinated the proletariat to the bourgeoisie which exploits it and for
which it was to remain an obedient and mindless tool."_ [**Statism and
Anarchy**, p. 174]

In addition, Bakunin argued that the labour movement (and so the anarchist
movement) would have to take into account political ideas and struggles but to
do so in a working class way:

> _"The International does not reject politics of a general kind; it will be
compelled to intervene in politics so long as it is forced to struggle against
the bourgeoisie. It rejects only bourgeois politics."_ [**The Political
Philosophy of Bakunin**, p. 313]

To state the obvious, anarchists only reject working class _"political
action"_ if you equate (as did the early Marxists) "political action" with
electioneering, standing candidates for Parliament, local town councils and so
on -- what Bakunin termed bourgeois politics. We do not reject "political
action" in the sense of direct action to effect political changes and reforms.
As two American syndicalists argued, libertarians use _"the term 'political
action' . . . in its ordinary and correct sense. Parliamentary action
resulting from the exercise of the franchise is political action.
Parliamentary action caused by the influence of direct action tactics . . . is
not political action. It is simply a registration of direct action."_ They
also noted that syndicalists _"have proven time and again that they can solve
the many so-called political questions by direct action."_ [Earl C. Ford and
William Z. Foster, **Syndicalism**, p. 19f and p. 23]

So, anarchists reject capitalist politics (i.e. electioneering), but we do not
ignore politics, wider political discussion or political struggles. Anarchists
have always recognised the importance of political debate and ideas in social
movements. Bakunin asked should a workers organisation _"cease to concern
itself with political and philosophical questions? Would [it] . . . ignore
progress in the world of thought as well as the events which accompany or
arise from the political struggle in and between states, concerning itself
only with the economic problem?"_ He rejected such a position: _"We hasten to
say that it is absolutely impossible to ignore political and philosophical
questions. An exclusive pre-occupation with economic questions would be fatal
for the proletariat. Doubtless the defence and organisation of its economic
interests . . . must be the principle task of the proletariat. But is
impossible for the workers to stop there without renouncing their humanity and
depriving themselves of the intellectual and moral power which is so necessary
for the conquest of their economic rights."_ [**Bakunin on Anarchism**, p.
301]

Nor do anarchists ignore elections. As Vernon Richards suggested, anarchists
_"cannot be uninterested in . . . election results, whatever their view about
the demerits of the contending Parties. The fact that the anarchist movement
has campaigned to persuade people not to use their vote is proof of our
commitment and interest. If there is, say, a 60 per cent. poll we will not
assume that the 40 per cent. abstentions are anarchists, but we would surely
be justified in drawing the conclusion that among the 40 per cent. there are a
sizeable minority who have lost faith in political parties and were looking
for other instruments, other values."_ [**The Impossibilities of Social
Democracy**, p. 141] Nor, needless to say, are anarchists indifferent to
struggles for political reforms and the need to stop the state pursuing
authoritarian policies, imperialist adventures and such like.

Thus the charge anarchists are apolitical or indifferent to politics (even
capitalist politics) is a myth. Rather, _"we are not concerned with choosing
between governments but with creating the situation where government can no
longer operate, because only then will we organise locally, regionally,
nationally and internationally to satisfy real needs and common aspirations."_
For _"so long as we have capitalism and government, the job of anarchists is
to fight both, and at the same time encourage people to take what steps they
can to run their own lives."_ [_"Anarchists and Voting"_, pp. 176-87, **The
Raven**, No. 14, p. 179]

Part of this process will be the discussion of political, social and economic
issues in whatever self-managed organisations people create in their
communities and workplaces (as Bakunin argued) and the use of these
organisations to fight for (political, social and economic) improvements and
reforms in the here and now using direct action and solidarity. This means, as
Rudolf Rocker pointed out, anarchists desire a unification of political and
economic struggles as the two as inseparable:

> _"Within the socialist movement itself the Anarchists represent the
viewpoint that the war against capitalism must be at the same time a war
against all institutions of political power, for in history economic
exploitation has always gone hand in hand with political and social
oppression. The exploitation of man by man and the domination of man over man
are inseparable, and each is the condition of the other."_ [**Anarcho-
Syndicalism**, p. 11]

Such a unification must take place on the social and economic field, not the
political, as that is where the working class is strongest. So anarchists are
well aware of the need to fight for political issues and reforms, and so are
_"not in any way opposed to the political struggle, but in their opinion this
struggle . . . must take the form of direct action, in which the instruments
of economic [and social] power which the working class has at its command are
the most effective. The most trivial wage-fight shows clearly that, whenever
the employers find themselves in difficulties, the state steps in with the
police, and even in some cases with the militia, to protect the threatened
interests of the possessing classes. It would, therefore, be absurd for them
to overlook the importance of the political struggle. Every event that affects
the life of the community is of a political nature. In this sense every
important economic action . . . is also a political action and, moreover, one
of incomparably greater importance than any parliamentary proceeding."_ In
other words, _"just as the worker cannot be indifferent to the economic
conditions of his life in existing society, so he cannot remain indifferent to
the political structure of his country. Both in the struggle for his daily
bread and for every kind of propaganda looking towards his social liberation
he needs political rights and liberties, and he must fight for these himself
with all his strength whenever the attempt is made to wrest them from him."_
So the _"focal point of the political struggle lies, then, not in the
political parties, but in the economic [and social] fighting organisations of
the workers."_ [Rocker, **Op. Cit.**, p. 77, p. 74 and p. 77] Hence the
comments in the CNT's newspaper **Solidaridad Obrera**:

> _"Does anyone not know that we want to participate in public life? Does
anyone not know that we have always done so? Yes, we want to participate. With
our organisations. With our papers. Without intermediaries, delegates or
representatives. No. We will not go to the Town Hall, to the Provincial
Capitol, to Parliament."_ [quoted by Jose Pierats, **Anarchists in the Spanish
Revolution**, p. 173]

Indeed, Rudolf Rocker makes the point very clear. _"It has often been charged
against Anarcho-Syndicalism,"_ he wrote, _"that it has no interest in the
political structure of the different countries, and consequently no interest
in the political struggles of the time, and confines its activities entirely
to the fight for purely economic demands. This idea is altogether erroneous
and springs either from outright ignorance or wilful distortion of the facts.
It is not the political struggle as such which distinguishes the Anarcho-
Syndicalist from the modern labour parties, both in principle and tactics, but
the form of this struggle and the aims which it has in view . . . their
efforts are also directed, even today, at restricting the activities of the
state . . . The attitude of Anarcho-Syndicalism towards the political power of
the present-day state is exactly the same as it takes towards the system of
capitalist exploitation"_ and _"pursue the same tactics in their fight against
. . . the state."_ [**Op. Cit.**, pp. 73-4]

As historian Bob Holton suggests, the notion that syndicalism is apolitical
_"is certainly a deeply embedded article of faith among those marxists who
have taken Lenin's strictures against syndicalism at face value. Yet it bears
little relation to the actual nature of revolutionary industrial movements . .
. Nor did syndicalists neglect politics and the state. Revolutionary
industrial movements were on the contrary highly 'political' in that they
sought to understand, challenge and destroy the structure of capitalist power
in society, They quite clearly perceived the oppressive role of the state
whose periodic intervention in industrial unrest could hardly have been
missed."_ For example, the _"vigorous campaign against the 'servile state'
certainly disproves the notion that syndicalists ignored the role of the state
in society. On the contrary, their analysis of bureaucratic state capitalism
helped to make considerable inroads into prevailing Labourist and state
socialist assumptions that the existing state could be captured by electoral
means and used as an agent of through-going social reform."_ [**British
Syndicalism, 1900-1914**, pp. 21-2 and p. 204]

Thus anarchism is not indifferent to or ignores political struggles and
issues. Rather, it fights for political change and reforms as it fights for
economic ones -- by direct action and solidarity. If anarchists _"reject any
participation in the works of bourgeois parliaments, it is not because they
have no sympathy with political struggles in general, but because they are
firmly convinced that parliamentary activity is for the workers the very
weakest and most hopeless form of the political struggle."_ [Rocker, **Op.
Cit.**, p. 76] Anarchists reject the idea that political and economic
struggles can be divided. Such an argument just reproduces the artificially
created division of labour between mental and physical activity of capitalism
within working class organisations and within anti-capitalist movements. We
say that we should not separate out politics into some form of specialised
activity that only certain people (i.e. our "representatives") can do.
Instead, anarchists argue that political struggles, ideas and debates must be
brought into the **social** and **economic** organisations of our class where
they must be debated freely by all members as they see fit and that political
and economic struggle and change must go hand in hand. Rather than being
something other people discuss on behalf of working class people, anarchists,
argue that politics must no longer be in the hands of so-called experts (i.e.
politicians) but instead lie in the hands of those directly affected by it.
Also, in this way the social struggle encourages the political development of
its members by the process of participation and self-management.

In other words, political issues must be raised in economic and social
organisations and discussed there, where working class people have real power.
As Bakunin put it, _"the proletariat itself will pose"_ political and
philosophical questions in their own organisations and so the political
struggle (in the widest scene) will come from the class struggle, for _"[w]ho
can entertain any doubt that out of this ever-growing organisation of the
militant solidarity of the proletariat against bourgeois exploitation there
will issue forth the political struggle of the proletariat against the
bourgeoisie?"_ Anarchists simply think that the _"policy of the proletariat"_
should be _"the destruction of the State"_ rather than working within it and
we argue for a union of political ideas and social organisation and activity.
This is essential for promoting radical politics as it _"digs a chasm between
the bourgeoisie and the proletariat and places the proletariat outside the
activity and political conniving of all parties within the State . . . in
placing itself outside all bourgeois politics, the proletariat necessarily
turns against it."_ So, by _"placing the proletariat outside the politics in
the State and of the bourgeois world, [the working class movement] thereby
constructed a new world, the world of the united proletarians of all lands."_
[**Op. Cit.**, p. 302 p. 276, p. 303 and p. 305]

History supports Bakunin's arguments, as it indicates that any attempt at
taking social and economic issues into political parties has resulting in
wasted energy and their watering down into, at best, reformism and, at worse,
the simple ignoring of them by politicians once in office (see [section
J.2.6](secJ2.html#secj26)). Only by rejecting the artificial divisions of
capitalist society can we remain true to our ideals of liberty, equality and
solidarity. Every example of radicals using electioneering has resulted in
them being changed by the system instead of them changing it. They have become
dominated by capitalist ideas and activity (what is usually termed "realistic"
and "practical") and by working within capitalist institutions they have, to
use Bakunin's words, _"filled in at a single stroke the abyss . . . between
the proletariat and the bourgeoisie"_ that economic and social struggle
creates and, worse, _"have tied the proletariat to the bourgeois towline."_
[**Op. Cit.**, p. 290]

In addition, so-called "economic" struggles do not occur in a vacuum. They
take place in a social and political context and so, necessarily, there can
exist a separation of political and economic struggles only in the mind.
Strikers or eco-warriors, for example, face the power of the state enforcing
laws which protect the power of employers and polluters. This necessarily has
a "political" impact on those involved in struggle. By channelling any
"political" conclusions drawn by those involved in struggle into electoral
politics, this development of political ideas and discussion will be distorted
into discussions of what is possible in the current system, and so the radical
impact of direct action and social struggle is weakened. Given this, is it
surprising that anarchists argue that the people _"must organise their powers
apart from and against the State."_ [Bakunin, **The Political Philosophy of
Bakunin**, p. 376]

To conclude, anarchists are only "apolitical" about bourgeois elections and
the dubious liberty and benefits associated with picking who will rule us and
maintain capitalism for the next four or five years as well as the usefulness
of socialists participating in them. We feel that our predictions have been
confirmed time and time again. Anarchists reject electioneering not because
they are "apolitical" but because they do not desire to see politics remain a
thing purely for politicians and bureaucrats. Political issues are far too
important to leave to such people. Anarchists desire to see political
discussion and change develop from the bottom up, this is hardly "apolitical"
-- in fact with our desire to see ordinary people directly discuss the issues
that affect them, act to change things by their own action and draw their own
conclusions from their own activity anarchists are very "political." The
process of individual and social liberation is the most political activity we
can think of!

[‹ J.1 Are anarchists involved in social struggles?](/afaq/secJ1.html "Go to
previous page" ) [up](/afaq/secJcon.html "Go to parent page" ) [J.3 What kinds
of organisation do anarchists build? ›](/afaq/secJ3.html "Go to next page" )

