# An Anarchist FAQ: Introduction to Volume 1

As many anarchists have noted, our ideal must be one of the most misunderstood
and misrepresented political theories on the planet. "An Anarchist FAQ" (AFAQ)
aims to change this by presenting the basics of anarchist theory and history,
refuting the most common distortions and nonsense about it and providing
anarchists with a resource they can use to aid their arguments and struggles
for freedom. This is important, as much of the ground covered in AFAQ was
provoked by having to critique other theories and refute attacks on anarchism.

Anarchism has changed over the years and will continue to evolve and change as
circumstances do likewise and new struggles are fought and (hopefully) won. It
is not some fixed ideology, but rather a means of understanding an evolving
world and to change it in libertarian directions. As such, AFAQ seeks to place
specific aspects of anarchism into their historical context. For example,
certain aspects of Proudhon’s ideas can only be understood by remembering that
he lived at a time when the vast majority of working people were peasants and
artisans. Many commentators (particularly Marxist ones) seem to forget this
(and that he supported co-operatives for large-scale industry). Much the same
can be said of Bakunin, Tucker and so on. I hope AFAQ will help anarchism
continue to develop to meet new circumstances by summarising what has gone
before so that we can build on it.

We also seek to draw out what anarchists have in common while not denying
their differences. After all, individualist-anarchist Benjamin Tucker would
have agreed with communist-anarchist Peter Kropotkin when he stated that
anarchism was the _"no government form of socialism."_ While some anarchists
seem to take more time in critiquing and attacking their comrades over
(ultimately) usually minor differences than fighting oppression, I personally
think that this activity while, at times, essential is hardly the most
fruitful use of our limited resources -- particularly when it is about
possible future developments (whether it is on the economic nature of a free
society or our attitude to a currently non-existing syndicalist union!). So we
have discussed the differences between anarchist schools of thought as well as
within them, but we have tried to build bridges by stressing where they agree
rather than create walls.

Needless to say, not all anarchists will agree with what is in AFAQ (it is,
after all, as we have always stressed "An Anarchist FAQ", not "The Anarchist
FAQ" as some comrades flatteringly call it). From my experience, most
anarchists agree with most of it even if they have quibbles about certain
aspects of it. I know that comrades do point others to it (I once saw a
Marxist complain that anarchists always suggested he read AFAQ, so I explained
to him that this was what having a "Frequency Asked Questions" was all about).
So AFAQ is only a guide, you need to discover anarchism for yourself and
develop and apply it in your own way. Hopefully AFAQ will help that process by
presenting an overview of anarchism and indicating what it is, what it is not
and where to find out more.

Some may object to the length of many of the answers and that is a valid
point. However, some questions and issues cannot be dealt with quickly and be
considered as remotely convincing. For example, simply stating that anarchists
think that capitalism is exploitative and that claims otherwise are wrong may
be both correct and short but it hardly a convincing reply to someone aware of
the various defences of profit, interest and rent invented by capitalist
economists. Similarly, stating that Marxist ideology helped destroy the
Russian Revolution is, again, both correct and short but it would never
convince a Leninist who stresses the impact of civil war on Bolshevik
practice. Then there is the issue of sources. We have tried to let anarchists
speak for themselves on most issues and that can take space. Some of the
evidence we use is from books and articles the general reader may not have
easy access so we have tried to present full quotes to show that our use is
correct (the number of times I’ve tracked down references only to discover
they did not say what was suggested is, sadly, quite numerous).

Moreover, refuting distortions and inventions about anarchism can be lengthy
simply because of the necessity of providing supporting evidence. Time and
again, the same mistakes and straw man arguments are regurgitated by those
unwilling or unable to look at the source material (Marxists are particularly
bad at this, simply repeating _ad nauseum_ the assertions of Marx and Engels
as if they were accurate). Assumptions are piled onto assumptions, assertions
repeated as if they were factual. AFAQ seeks to address these and present
evidence to refute them once and for all. Simply saying that some statement is
false may be correct, but hardly convincing unless you already know a lot
about the subject. So I hope that readers will understand and find even the
longest answers interesting and informative (one of the advantages of a FAQ
format is that people can simply go to the sections they are interested in and
skip others).

This volume covers what anarchism is, where it comes from, what it has done,
what it is against (and why) as well as what anarchism is not (i.e., showing
why "anarcho"-capitalism is not a form of anarchism).

The latter may come as a surprise to most. Few anarchists, never mind the
general population, have heard of that specific ideology (it is US based, in
the main) and those who have heard of it may wonder why we bothered given its
obvious non-anarchist nature. Sadly, we need to cover this ground simply
because some academics insist in listing it alongside genuine forms of
anarchism and that needs to be exposed for the nonsense it is. Few serious
thinkers would list fascism along side socialism, regardless of whether its
supporters call their ideology "National Socialism" or "National Syndicalism"
(unsurprisingly, right-"libertarians" do precisely that). No one took the
Soviet bloc states seriously when they described themselves as "peoples'
democracies" nor considered their governments democratic. Anarchism seems to
be excluded from such common-sense and so we find academics discussing
"anarcho"-capitalists along side anarchism simply, I suspect, because they
**_call_** themselves "anarchists." That almost all anarchists reject their
claims to being anarchists does not seem to be a sufficient warning about
taking such statements at face value! For obvious reasons, we have not wasted
space in explaining why another US based ideology, "National Anarchism", is
not anarchism. While some individual anarchists were racist, the notion that
anarchism has anything in common with those who aim for racially pure
nationalist communities is ridiculous. Even academics have not fallen for
**_that_**, although for almost all genuine anarchists "anarcho"-capitalism
makes as little sense as "anarcho"-nationalism.

Then there is the history of AFAQ. As indicated in the original introduction,
AFAQ was prompted by battles with "anarcho"-capitalists on-line in the early
1990s. However, while AFAQ may have started as a reply to the
"anarcho"-capitalists it is no longer that. It would be a mistake to think
that they are more significant than they actually are or that many anarchists
bother with them (most, I am sure, have never heard of it). I did consider
whether it was wiser to simply exclude section F from the book but, in the
end, I decided it should remain. Partly, for the reasons above and partly
because it does serve another, more useful, purpose. Neo-liberalism is based,
in many ways, on right-"libertarian" dogmas so critiquing those helps our
struggle against "actually existing" capitalism and the current attacks by the
ruling class.

I do not wish anarchism to go the same way that "libertarian" has gone in the
US (and, to a lesser extent, in the UK). Between the 1890s and 1970s,
libertarian was simply a pseudonym for anarchist or similar socialist
theories. However, the American free-market right appropriated the label in
the 1970s and now it means supporters of minimal state (or private-state)
capitalism. Such is the power having ideas that bolster the wealthy! The
change in "libertarian" is such that some people talk about "libertarian
anarchism" -- as if you can have an "authoritarian anarchism"! That these
people include "anarcho"-capitalists simply shows how ignorant of anarchism
they actually are and how alien the ideology is to our movement (I've seen
quite a few of them proclaim anarchism is simply a "new" form of Marxism,
which shows their grasp of the subject). Equally bizarrely, these self-
proclaimed "libertarian anarchists" are also those who most fervently defend
the **authoritarian** social relationships inherent within capitalism! In
other words, if "authoritarian anarchists" **_could_** exist then the
"libertarian anarchists" would be them!

As AFAQ explains, being opposed to the state is a necessary, but not
sufficient, condition for being an anarchist. Not only is this clear from the
works of anarchist thinkers and anarchism as a social movement, but also from
the nature of the idea itself. To be an anarchist you must also be a socialist
(i.e. opposed to capitalist property and the exploitation of labour). It is no
coincidence that Godwin and Proudhon independently analysed private property
from a libertarian perspective and drew similar conclusions or that Kropotkin
and Tucker considered themselves socialists. To deny this critique is to deny
anarchism as a movement and as a socio-political theory never mind its history
and the aims of anarchists across the years.

Furthermore, as AFAQ stresses, to be a **_consistent_** anarchist you must
recognise that freedom is more than simply the ability to change masters.
Anarchism means "no authority" (an-archy) and to support social relationships
marked by authority (hier-**_archy_**) produces a self-contradictory mess
(such as supporting forms of domination, such as wage labour, which are
essentially identical to those produced by the state – and, sometimes,
admitted as such!). Anarchism is, fundamentally, a theory of organisation
based on individuals associating together without restricting, and so denying
and limiting, their freedom and individuality. This means that a consistent
anarchism is rooted in free association within a context of self-management,
decentralisation and "bottom-up" decision-making (i.e., it is rooted in
political, economic and social equality). While it is possible to be an
anarchist while opposing exploitation but not all forms of hierarchical social
relationships, it is hardly logical nor a convincing position.

AFAQ also seeks to go into subjects anarchists have, traditionally, been weak
on, such as economics (which is ironic, as Proudhon made his name by his
economic critiques). In this sense, it is a resource for anarchists both in
terms of our own history and ideas but also on subjects which we inevitably
come across in our struggles (hopefully, the critiques we provide of
capitalism, neo-liberalism and so forth will also be useful to other
radicals). We have tried to indicate the quoted source is an anarchist or
libertarian. If in doubt, please look at the bibliography on the webpage. This
breaks references down into libertarian (anarchist and non-anarchist) thinkers
(or sympathetic accounts of anarchism) and non-libertarians (which, needless
to say, includes right-"libertarians"). It should go without saying that
quoting an expert on one subject does not mean anarchists subscribe to their
opinions on other matters. Thus if we quote, say, a Keynesian or post-
Keynesian economist on how capitalism works it does not imply we support their
specific political recommendations.

Some have criticised AFAQ for not including some of the more recent
developments within anarchism, which is fair enough. I have asked on numerous
occasions for such critics to contribute a section on these and, of course,
for referenced corrections for any mistakes others think we have done. Nothing
has been forthcoming and we have usually discovered mistakes ourselves and
corrected them (although a steady flow of emails pointing out typos has come
our way). We have always been a small collective and we cannot do everything.
This also explains why important social events like, say, the turn of the
century Argentinean revolt against neo-liberalism is not discussed in [section
A.5](secA5.html) (this is a wonderful example of anarchist ideas being
spontaneously applied in practice during a mass revolt). Suffice to say,
anarchistic tendencies, ideas and practices develop all the time and anarchism
is growing in influence but if we continually added to AFAQ to reflect this
then it would never have become ready for publication! As it is, we have
excluded most of the appendices from the book version (these remain available
on the website along with a lengthy links page).

I would like to thank everybody who has helped and contributed (directly and
indirectly, knowingly and unknowingly) to AFAQ. As for authorship, AFAQ
started as a collective effort and remained so for many years. I have been the
only person involved from the start and have done the bulk of the work on it.
Moreover, the task of getting it ready and revised for publication has fallen
to me. I have enjoyed it, in the main. This explains why the book has my name
on it rather than a collective. I feel I have earned that right. As such, I
claim responsibility for any typos and examples of bad grammar that remain. I
have substantially revised AFAQ for publication and while I have tried to find
them all, I am sure I have failed (particularly in sections that were
effectively rewritten). I hope these do not detract from the book too much.

Finally, on a personal note I would like to dedicate this book to my partner
and two lovely children. They are a constant source of inspiration, love,
support and hope (not to mention patience!). If this work makes the world we
live in better for them then it has been more than worthwhile. For, when it
comes down to it, anarchism is simply about making the world a freer and
better place. If we forget that, then we forget what makes us anarchists in
the first place.

Iain McKay

[An Anarchist FAQ](index.html)

# A Summation

**_"No question, the word anarchy freaks people. Yet anarchy -- rule by no one -- has always struck me as the same as democracy carried to its logical and reasonable conclusions. Of course those who rule -- bosses and politicians, capital and the state -- cannot imagine that people could rule themselves, for to admit that people can live without authority and rulers pulls out the whole underpinnings of their ideology. Once you admit that people can -- and do, today, in many spheres of their lives -- run things easier, better and more fairly than the corporation and the government can, there's no justification for the boss and the premier. I think most of us realise and understand that, in our guts, but schools, culture, the police, all the authoritarian apparatuses, tell us we need bosses, we need to be controlled 'for our own good.' It's not for our own good – it's for the good of the boss, plain and simple."_**

**_"Anarchism is a demand for real freedom and real autonomy"_**

**_"But I also remain convinced that something like an anarchist future, a world of no bosses or politicians, one in which people, all people, can live full and meaningful lives, is possible and desirable. We see glimpses of it all around us in our day-to-day lives, as people organise much of their lives without depending on someone to tell them what to do. We see it in that spirit of revolt -- a spirit that is often twisted by anger and despair, but nonetheless shows us that people have not given up. We see it in the political activism, the social lives, the demands for decency and respect and autonomy people put forward, the desire to be individuals while still being part of a community._**

**_"No, I don't think bowling leagues are the anarchist utopia, but they, like much of our lives outside of the workplace, are organised without hierarchy and oppression; the most meaningful, truly human parts of our lives already work best when organised on anarchist principles. Yet I also believe that in its function as critique and as a vision of the future -- perhaps the only one that doesn't end in our extinction as a species, or, as Orwell put it, as a jackboot smashing a human face, forever -- anarchism is not only desirable but possible and necessary."_**

Mark Leier: **The Case for Anarchy**

[‹ An Anarchist FAQ after ten years](/afaq/10years.html "Go to previous page"
) [up](/afaq/intro.html "Go to parent page" ) [An Anarchist FAQ: Introduction
to Volume 2 ›](/afaq/vol2intro.html "Go to next page" )

