#ifndef _mkdic_h_included_
#define _mkdic_h_included_

#include <xstr.h>

/** ñ */
struct word_entry {
  /** ʻ̾ */
  char *wt;
  /**  */
  int freq;
  /** ñ */
  char *word;
  /** եΥեå */
  int offset;
};

/** ɤ */
struct yomi_entry {
  /* ɤߤʸ */
  xstr *index_xstr;
  /* եΥڡΥեå */
  int offset;
  /* ƥȥ */
  int nr_entries;
  struct word_entry *entries;
  struct yomi_entry *next;
  struct yomi_entry *hash_next;
};

#define YOMI_HASH 1024

/*  */
struct yomi_entry_list {
  /* ФΥꥹ */
  struct yomi_entry *head;
  /* եθФο */
  int nr_entries;
  /* ФñĤΤο */
  int nr_valid_entries;
  /* ñο */
  int nr_words;
  /**/
  struct yomi_entry *hash[YOMI_HASH];
  struct yomi_entry **ye_array;
};

/* hash */
struct versatile_hash {
  char *buf;
  FILE *fp;
};

#define ADJUST_FREQ_UP 1
#define ADJUST_FREQ_DOWN 2
#define ADJUST_FREQ_KILL 3

/* ѥޥ */
struct adjust_command {
  int type;
  xstr *yomi;
  char *wt;
  char *word;
  struct adjust_command *next;
};

/**/
struct yomi_entry *find_yomi_entry(struct yomi_entry_list *yl,
				   xstr *index, int create);

/* 񤭽ФѤ */
void write_nl(FILE *fp, int i);

/* 㼭 */
struct uc_dict *create_uc_dict(struct yomi_entry_list *yl);
void read_uc_file(struct uc_dict *ud, const char *fn);
void make_ucdict(FILE *out,  struct uc_dict *uc);
/**/

void fill_uc_to_hash(struct versatile_hash *vh, struct uc_dict *dict);

#endif
