//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006,2007,2008 Mikhail Fedotov <anyremote@mail.ru>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
//

#ifndef _UTILS_H
#define _UTILS_H

#include "parse.h"

#define LOGFILE 	"/anyremote.log"

#define TIMER_RUN       1
#define TIMER_PAUSE     2

#define CFG2(...)     sprintf(tmp,__VA_ARGS__);logger("CFG",     tmp);
#define DEBUG2(...)   sprintf(tmp,__VA_ARGS__);logger("DEBUG",   tmp);
#define ERROR2(...)   sprintf(tmp,__VA_ARGS__);logger("ERROR",   tmp);
#define INFO2(...)    sprintf(tmp,__VA_ARGS__);logger("INFO",    tmp);
#define WARNING2(...) sprintf(tmp,__VA_ARGS__);logger("WARNING", tmp);

typedef struct TC
{	
	cmdItem *timer;
        
	int	ticks;
	int	times;
        
        int     status;
        
	struct TC  *next;
} timerCmd;

typedef struct VV
{	
	char *name;
	char *value;
	int  size;
	struct VV  *next;
} varData;

void        printHelp         (void);
void        initLog         (void);
void        logger          (char *head, char *str);

timerCmd*   createTimer     (cmdItem *ci);
timerCmd*   findTimer       (char *id, timerCmd **prev);
int         verifyTimers    (int ticksInSec);
int         cancelTimer     (char *id);
void        freeTimers      (void);

int         setVar          (const char *name, const char *val, int size);
varData*    searchVar       (const char *id, int len);
void        freeVars        (void);

int         isDataNew       (int what, char *data, int size);
void        freeCachedData  (void);

int         flushData       (void);
void        flushOldConf    (void);

void        setResFile      (void);
char*       getResFile      (void);

#endif
