
#ifndef _FILEITEM_H
#define _FILEITEM_H

#include <string>

#include "config.h"
#include "lockable.h"
#include <header.h>

// Life line (process states) of a file description item
typedef unsigned int FiStatus;
#define FIST_FRESH 		0
#define FIST_INITED		1
#define FIST_DLPENDING		4
#define FIST_DLGOTHEAD		8
#define FIST_DLRECEIVING	16
#define FIST_COMPLETE		32
// usually unreachable states
#define FIST_ERROR 			999
#define FIST_ERRNOUSER		9999

// some fileitem members need to know them...
class fileitem;
typedef SHARED_PTR<fileitem> tFileItemPtr;

class fileitem : public condition
{

public:
	
	~fileitem();
	
	// initialize file item, return the status
	FiStatus Setup(bool bDynType);
	
	int GetFileFd();
	uint64_t GetTransferCount();
	
	// downloader instruments
	
	virtual bool StoreHeader(const header & h);
	virtual void SetFailureMode(const MYSTD::string & message, FiStatus fist=FIST_ERROR);
	/*!
	 * \return true IFF ok and caller might continue. False -> caller should abort.
	 */
	virtual bool StoreFileData(const char *data, unsigned int size);
	virtual header const * GetHeader();
	
	bool m_bCheckFreshness;
	volatile FiStatus status;
	uint64_t m_nIncommingCount;
	off_t m_nSizeChecked, m_nSizeSeen;
	MYSTD::string m_sPath, m_sKey;
	
protected:
	int m_filefd;
	header m_head;

private:
	friend tFileItemPtr GetFileItem(MYSTD::string sPath);
	fileitem(MYSTD::string);

};

// public constructor wrapper, get a unique object from the map
tFileItemPtr GetFileItem(MYSTD::string sPath); // also opens the cached file and increases reference count
void DelUser(MYSTD::string sPath); // decrease dependent user count
extern lockable mapLck;

#endif


