
#define LOCAL_DEBUG
#include "debug.h"

#include "pkgimport.h"
#include "header.h"
#include "dirwalk.h"
#include "meta.h"
#include "acfg.h"
#include "filereader.h"
#include "dlcon.h"

#include <string>
//#include <iostream>
#include <cstdio>
#include <errno.h>

using namespace MYSTD;

bool bUseCache(true);

#define MAX_SUSI_SIZE 60
#define SCACHEFILE (acfg::cachedir+sPathSep+"_impkeycache")


pkgimport::pkgimport(int fd) : expiration(fd), m_bPickIfiles(false)
{
}

void pkgimport::ProcessOther(const string &sPath, const struct stat &stinfo) 
{
	// NOOP;
}
void pkgimport::ProcessRegular(const string &sPath, const struct stat &stinfo) 
{
		//string sRelName=fileNode->sPath.substr(acfg::cachedir.length()+1);
		
		rechecks::eFileKind kind = m_rex.getFiletype(sPath.c_str());

		if( rechecks::FILE_INDEX == kind && m_bPickIfiles
				&& sPath.compare(acfg::cachedir.size()+1, 7, "_import"))
		{
			//cout << "Is ifile\n";
			m_volatileFiles.push_back(sPath);
		}
		else if (rechecks::FILE_PKG == kind && !m_bPickIfiles)
		{

			// get a fingerprint, either by checksumming or from fpr cache
		tFingerprint fpr;
		tCmapIter cacheIt;

		//cout << "any cached key for: " << sPath << ", "<< stinfo.st_size 
		//	<< ";" << stinfo.st_mtime << "?"<<endl;

		if (bUseCache && m_cacheMap.end() != (cacheIt =m_cacheMap.find(tFInfo(
				sPath, stinfo.st_size, stinfo.st_mtime))))
		{
			fpr=cacheIt->second;
			SendMsg(string("<font color=blue>Checked ")+sPath
					+" (fingerprint from cache)</font><br>\n");
		}
		else
		{
			if (filereader::GetMd5Sum(sPath, fpr.sum))
			{
				fpr.size=stinfo.st_size;
				SendMsg(string("<font color=blue>Checked ")+sPath
						+" (fingerprint created)</font><br>\n");
			}
			else
			{
				SendMsg(string("<font color=red>Error checking ")+sPath
						+"</font><br>\n");
				return;
			}

		}

		// add this entry immediately if needed and get its reference
		tFInfo & node = m_importFileMap[fpr];

		if (node.sPath.empty())
		{ // fresh, just added to the map
			node.sPath=sPath;
			node.fsize=stinfo.st_size;
			node.mtime=stinfo.st_mtime;
		}
		else // is already there, must be a duplicate
		{
			// add the new one as deletion candidate with a different/incorrect key
			fpr.size*=2;
			tFInfo & dupe = m_importFileMap[fpr];
			dupe.bFileUsed = true;
		}
	}
}

bool FileCopy(const string &from, const string to)
{
	// not possible? different filesystems?
	acbuf buf;
	buf.init(50000);
	int in(-1), out(-1);

	in=open(from.c_str(), O_RDONLY);
	if (in<0) // error, here?!
		return false;

	while (true)
	{
		int err;
		err=buf.sysread(in);
		if (err<0)
		{
			if (err==-EAGAIN || err==-EINTR)
				continue;
			else
				goto error_copying;
		}
		else if (err==0)
			break;
		// don't open unless the input is readable, for sure
		if (out<0)
		{
			out=open(to.c_str(), O_WRONLY | O_CREAT | O_TRUNC, 00644);
			if (out<0)
				goto error_copying;
		}
		err=buf.syswrite(out);
		if (err<=0)
		{
			if (err==-EAGAIN || err==-EINTR)
				continue;
			else
				goto error_copying;
		}

	}

	close(in);
	close(out);
	return true;

	error_copying: if (in>=0)
		close(in);
	if (out>=0)
		close(out);
	return false;
}
bool pkgimport::LinkOrCopy(const MYSTD::string &from, const MYSTD::string &to)
{
	mkbasedir(to);
	
	//ldbg("Moving " <<from<< " to " << to);
	
	// hardlinks don't work with symlinks properly...
	struct stat stinfo, toinfo;
	
	if(0==lstat(from.c_str(), &stinfo) && S_ISLNK(stinfo.st_mode))
	{
		char buf[PATH_MAX+1];
		buf[PATH_MAX]=0x0;
		
		if (!realpath(from.c_str(), buf))
			return false;
		return (0==symlink(buf, to.c_str()));		
	}
	else
	{
		if(0!=stat(from.c_str(), &stinfo))
				return false;
		
		if(0==stat(to.c_str(), &toinfo))
		{
			// same file, don't care
			if(stinfo.st_dev==toinfo.st_dev && stinfo.st_ino == toinfo.st_ino)
				return true;
			
			// unlink, this file must go. If that fails, we have weird permissions anyway.
			if(0!=unlink(to.c_str()))
				return false;
		}
		if (0==link(from.c_str(), to.c_str()))
			return true;

		SendMsg("(couldn't link, copying contents)");
		if(!FileCopy(from,to))
			return false;
		
		// make sure the copy is ok
		return (0 == stat(from.c_str(), &stinfo) 
				&& 0 == stat(to.c_str(), &toinfo)
				&& toinfo.st_size==stinfo.st_size);
		
	}

	return false;
}

inline void pkgimport::_LoadKeyCache()
{
	if(!bUseCache)
		return;
	
	filereader reader;
	if(!reader.OpenFile(SCACHEFILE))
		return;

	string sLine;
	tFInfo key;
	tFingerprint fpr;
#define _getline { if(!reader.GetOneLine(sLine)) break; }
	
	while(true)
	{
		_getline;
		key.sPath=sLine;
		_getline;
		key.fsize=atol(sLine.c_str());
		fpr.size=key.fsize;
		_getline;
		key.mtime=atol(sLine.c_str());
		_getline;
		CsAsciiToBin((const unsigned char*) sLine.data(), fpr.sum);
		//cerr << "Found cached fingerprint: " << fpr.size << ";"<< sLine<<endl;
		
		m_cacheMap[key]=fpr;
		
	}
}
			
void pkgimport::Action(const string &cmd) 
{
// TODO: import path from cmd?
	m_sSrcPath=acfg::cachedir+sPathSep+"_import";
	
	SendMsg(string("Importing from ")+m_sSrcPath+" directory, scanning...<br>\n");
	
	m_nDropPrefLen=1+m_sSrcPath.length();
	
	_LoadKeyCache();
	
	m_bPickIfiles=true;
	DirectoryWalk(acfg::cachedir, this);
	UINT piCount(0), siCount(0);
	for(tStrVec::const_iterator it=m_volatileFiles.begin();it!=m_volatileFiles.end();it++)
	{
		piCount+=(stmiss!=it->find("Packages"));
		siCount+=(stmiss!=it->find("Sources"));
	}
	if(0==piCount+siCount)
	{
		SendMsg("<font size=0 color=red>No index files detected. Unable to continue, cannot map files to internal locations.</font>");
		return;
	}
	_UpdateVolatileFiles();
	if(m_bErrAbort && m_nErrorCount>0)
	{
		SendMsg("Found errors during processing, aborting as requested.");
		return;
	}
	//_GuessAndGetIfiles();
	
	m_bPickIfiles=false;
	DirectoryWalk(m_sSrcPath, this);
	if(m_importFileMap.empty())
	{
		SendMsg("No appropriate files found in the _import directory.<br>\nDone.<br>\n");
		return;
	}
	
	// drop it, usable data moved to the import map
	m_cacheMap.clear();
	
	_ParseVolatileFilesAndHandleEntries();
	
	FILE *cfh(NULL);
	if(bUseCache)
	{ 
		cfh=fopen(SCACHEFILE.c_str(), "w");
		if(!cfh)
		{
			unlink(SCACHEFILE.c_str());
			cfh=fopen(SCACHEFILE.c_str(), "w");
		}
	}
	
	for(tImapIter it=m_importFileMap.begin(); it!=m_importFileMap.end();it++)
	{
		// delete imported stuff, and cache the fingerprint only when file was deleted
		bool bCacheIt=(NULL!=cfh);
		
		if(it->second.bFileUsed && 0==unlink(it->second.sPath.c_str()))
				bCacheIt=false;
		
		if(bCacheIt)
		{
			fprintf(cfh, "%s\n%"PRIu64"\n%"PRIu64"\n%s\n", 
					it->second.sPath.c_str(),
					it->second.fsize,
					it->second.mtime, 
					CsBinToString(it->first.sum).c_str());
		}
	}
	if(cfh)
	{
		fclose(cfh);
		cfh=NULL;
	}
}

#ifdef WAS_EXPERIMENTAL_CODE_TO_GUESS_VOLATILE_FILES_FROM_INDEXFILES
void pkgimport::_GuessAndGetIfiles()
{
	const char *suffixes[] = { ".bz2", ".gz" };
	for(tStrVec::iterator it=m_volatileFiles.begin(); it!=m_volatileFiles.end(); it++)
	{
		//cout << "checke: " << *it<<endl;
		tStrPos pos=it->find(".diff/Index");
		if(pos == stmiss)
			continue;
		for(UINT i=0; i<_countof(suffixes); i++)
		{
			string sCand=it->substr(0, pos);
			sCand+=suffixes[i];
			//cout << "huhu: " << sCand<<endl;
			for(
					tStrVec::iterator it2=m_volatileFiles.begin();
					it2!=m_volatileFiles.end();
					it2++)
				if(sCand==*it2)
					goto probe_next_ifile;
			
			header h;
			if(!h.LoadFromFile( (*it)+".head") || h.type!=header::ANSWER)
				continue;
			
			if(!h.h[header::XORIG])
				continue;
			
			string orig=h.h[header::XORIG];
			//cout << "x-original: " << orig <<endl;
			// must be well formated to be valid
			if (0!=orig.compare(0, 7, "http://"))
				continue;
			// find the same in the original url
			pos=orig.find(".diff/Index");
			//cout << "huhu: " << orig << " hit: " << pos <<endl;
			if(pos==stmiss) // TODO: report something meaningfull, url inconsistency?
				continue;
			orig.erase(pos);
			orig+=suffixes[i];
			
			string sKeyPath=sCand.substr(acfg::cachedir.size()+1, stmiss);
			SendMsg(string("Probing download of ") + orig + " to " + sKeyPath + "<br>\n");
			// no rewritting or backends voodoo, too fragile. Just using the old URL slightly modified.
			
			tFileItemPtr fi=GetFileItem(sKeyPath);
			fi->Setup(true);
			if(!fi)
			{
				SendMsg("Error creating internal file object<br>");
				continue;
			}
			bool bOk=false;
			tHttpUrl url;
			long nFileLen(-1);
			if(url.SetHttpUrl(orig))
			{
				dlcon dl;
				dl.AddJob(fi, url);
				dl.WorkLoop(true);
				string sErr;
				bOk=(fi->status == FIST_COMPLETE);
				DelUser(orig);
			}
			if(bOk) {
				char buf[50];
				sprintf(buf, "OK, got %ld bytes.<br>", nFileLen);
				SendMsg(buf);
				goto probe_next_ifile;
			}
				
		}
		
		probe_next_ifile:
		continue;
	}
}
#endif

#if 0
void HttpEscape(string &s)
{
	tStrPos p;
	while(stmiss!=(p=s.find_first_of("~ ")))
	{
		switch(s[p])
		{
		case('~'): s.replace(p, 1, "%7e"); break;
		case(' '): s.replace(p, 1, "&nbsp"); break;
		}
	}
}
#endif

extern uint_fast16_t hexmap[];

inline void UrlDecode(string &s)
{
	for(string::size_type i=0; i<s.length(); i++)
	{
		if(s[i]!='%')
			continue;
		if(i>s.length()-3) // cannot start another sequence here (too short), keep as-is
			continue;
		char decoded=16*hexmap[(unsigned char) s[i+1]] + hexmap[(unsigned char) s[i+2]];
		s.replace(i, 3, 1, decoded);
	}
}

void pkgimport::_HandlePkgEntry(const MYSTD::string & refererPath, const NoCaseStringMap &info)
{
	NoCaseStringMap::const_iterator it;
	tFingerprint fprCand;
	
	it=info.find("MD5sum");
	if(it==info.end() || it->second.length()!=32 || 
			! CsAsciiToBin((unsigned char *) it->second.data(), fprCand.sum))
		return;
	
	it=info.find("Size");
	if(it==info.end())
		return;
	fprCand.size=atol(it->second.c_str());
	
	it=info.find("Filename");
	if(it==info.end())
		return;
	
	// keep 'it' at the filename
	
	ldbg( "Looking for key: "  << CsBinToString(fprCand.sum));
	tImapIter it2=m_importFileMap.find(fprCand);
	if (it2 != m_importFileMap.end())
	{
		//cerr << "HIT"<<endl;
		string sDest;
		string sFrom=it2->second.sPath;
		// assume official structure where dists folder is on the same 
		// level where listed relative paths start
		tStrPos pos=refererPath.rfind("/dists/");
		if (pos!=stmiss && pos>=acfg::cachedir.length())
			sDest=refererPath.substr(0, pos+1);
		else
			sDest=refererPath.substr(0, refererPath.rfind('/')+1);
		sDest+=it->second;


		/* 
		 * NOT NEEDED right now, gets the pure filename from the ifile entry 
		 * 
		 * 
		// some URL escapping may be relevant for us
		UrlDecode(sDest);
		
		// strip the epoch like archive management does
		tStrPos nColPos=sDest.find(':');
		if(nColPos!=stmiss)
		{
			for(tStrPos nPos=nColPos-1; nPos>0 && sDest[nPos] != '/'; nPos--)
			{
				if('_' == sDest[nPos])
				{
					sDest.erase(nPos+1, nColPos-nPos);
					break;
				}
				if(!isalpha((unsigned char) sDest[nPos]))
					break;
			}
		}
		*/

		SendMsg(string("<font color=green>HIT: ")+sFrom+" is "+it->second
				+ "<br>DESTINATION: "+sDest+"</font><br>\n");

		// linking and moving would shred them when the link leads to the same target
		struct stat tmp1, tmp2;

		if (0==stat(sDest.c_str(), &tmp1) && 0==stat(sFrom.c_str(), &tmp2)
				&& tmp1.st_ino==tmp2.st_ino&& tmp1.st_dev==tmp2.st_dev)
		{
			//cerr << "Same target file, ignoring."<<endl;
			it2->second.bFileUsed=true;
			return;
		}

		unlink(sDest.c_str());
		unlink((sDest+".head").c_str());

		if (!LinkOrCopy(sFrom, sDest))
		{
			SendMsg("<font color=red>ERROR: couldn't link or copy file.</font><br>\n");
			return;
		}

		header h;
		h.frontLine="HTTP/1.1 200 OK";
		h.set(header::CONTENT_LENGTH, it2->second.fsize);
		h.type=header::ANSWER;
		if (h.StoreToFile(sDest+".head")<=0)
		{
			aclog::err("Unable to store generated header");
			return; // junk may remain but that's a job for cleanup later
		}
		it2->second.bFileUsed=true;
	}
}


/*
void tFInfo::Dump(FILE *fh, const string & second)
{
	fprintf(fh, "%s;%lu;%lu\n%s\n", sPath.c_str(), nSize, nTime, second.c_str());
}

void pkgimport::_GetCachedKey(const string & sPath, const struct stat &stinfo, string &out)
{
	char buf[PATH_MAX+5+3*sizeof(unsigned long)];
	sprintf(buf, "%s\n%lu\n%lu\n", sPath.c_str(), (unsigned long) stinfo.st_size,
			(unsigned long) stinfo.st_mtime);
	tStringMap::const_iterator it=m_cacheMap.find(buf);
	if(it==m_cacheMap.end())
		out.clear();
	else
		out=it->second;
}

 */
