#include "main.h"

extern int STATUS_WHEEL;

int gettag(char *string, FILE *fp)
{
	int c = 0, i=1;

	string[0] = '<';

	while ((c=getc(fp))!='>' && !feof(fp))                     /* Read until you reach the HTML tag end char */
	{
		string[i] = (char)c;
		i++;
		update_status;
	}

	if(feof(fp) && c != '>')
	{
		post_message("gettag() experienced an error with this tag's syntax: ");

		string[i] = '\0';
		printf("[\"%s\"] @ %ld + %c\n\n", string, ftell(fp), (char)fgetc(fp));

		return 0;
	}

	string[i] = '>';
	string[i+1] = '\0';
	return 1;
}


FILE *Parse_Tags(FILE *in)
{
	FILE *out = tmpfile();
	int c, myTag[STRING_BUFFER_SIZE], status = 1;

	if(in == NULL) // trying to anticipate why debian bug #120883 happens
	{
		post_message("|c[|s] NULL was passed to Parse_Tags().");
		exit(0);
	}

	fseek(in, 0L, SEEK_SET);
	post_message("|c[|s] Parsing Tags");

	while(!feof(in))
	{
		c = fgetc(in);
		if(c=='<')
		{
			update_status;
			memset(myTag, ' ', STRING_BUFFER_SIZE-1);
			if(!gettag(myTag, in))
			{
				fclose(in);
				fclose(out);
				return NULL;
			}
			if(strstr(myTag, "non-US") == NULL)
				fprintf(out, "%s\n", myTag);
		}
	}

	fclose(in);
	fflush(stdout);
	return out;
}


FILE *Parse_Tag_Values(FILE *in)
{
	char myBuff[STRING_BUFFER_SIZE];
	int i;

	FILE *out = tmpfile();
	fseek(in, 0L, SEEK_SET);
	post_message("|c[|s] Parsing TAG Values");

	while(!strstr(myBuff, "<td") && !feof(in))      // Just goes to correct place to look for servers
	{
		memset(myBuff, ' ', STRING_BUFFER_SIZE-1);
		fgets(myBuff, STRING_BUFFER_SIZE, in);
	}

	while(!feof(in))
	{
		memset(myBuff, ' ', STRING_BUFFER_SIZE-1);
		fgets(myBuff, STRING_BUFFER_SIZE, in);
		update_status;
		if(strstr(myBuff, "href") && !strstr(myBuff, "http"))// && !strstr(myBuff, "ftp.br"))
		{
			for(i=0; myBuff[i-1] != '\"'; i++)
			{
				if(!STATUS_WHEEL)
					post_message("[|s]");
			}
			while(myBuff[i] != '\"' && i < strlen(myBuff))
			{
				fputc(myBuff[i], out);
				i++;
				update_status;
			}
			if(i == strlen(myBuff) && myBuff[i] != '\"')
			{
				printf("[Warning: Unrecoverable internal parse error. Exitting immediately.]\n");
				fclose(in);
				fclose(out);
				return NULL;
			}
			fputc('\n', out);
		}
	}

	fclose(in);
	fflush(stdout);
	return out;
}


/*
void Parse_URLS(char *inName, char *outName)
{
	char myBuff[STRING_BUFFER_SIZE];
	int i;
 
	FILE *in = fopen(inName, "r");
	FILE *out = fopen(outName, "w");
 
        memset(myBuff, ' ', STRING_BUFFER_SIZE-1);
 
        while(!feof(in))
        {
                fgets(myBuff, STRING_BUFFER_SIZE, in);
                if(myBuff[0] == 'f' || myBuff[1] == 'h')
                {
                for(i=0; myBuff[i-1] != '/'; i++); i++;
                while(myBuff[i] != '/' && i < strlen(myBuff))
                {
                        fputc(myBuff[i], out);
                        i++;
                }
		if(i == strlen(myBuff) && myBuff[i] != '/')
		{
			printf("[Warning: Unrecoverable internal parse error. Exitting immediately.]\n");
			fcloseall();
			exit(-1);
		}
                fputc('\n', out);
                }
 
                memset(myBuff, ' ', STRING_BUFFER_SIZE-1);
        }
 
	fclose(in);
	fclose(out);
}
 
double maxthru;
 
void Generate_Sources_List(char *inFile)
{
	char myBuff[STRING_BUFFER_SIZE];
	char Top_Three[3][STRING_BUFFER_SIZE];
	double Top_Max[3];
	char bigBuff[TOP_SCORES][STRING_BUFFER_SIZE];
 
	int i, c, t;
 
	FILE *in = fopen(inFile, "r");
	FILE *out = fopen(SOURCES_LIST, "w");
	FILE *saved;
 
	i = c = 0;
	Top_Max[0] = 0;
	Top_Max[1] = 0;
	Top_Max[2] = 0;
	Top_Three[0][0] = Top_Three[1][0] = Top_Three[2][0] = '\0';
 
	if(BING_FLAG)
	{
		post_message("Starting file generation using BING      ");
		post_message("Output may hang - Wait until it finishes ");
	}
 
 
	if(SAVE_TOP_FLAG)
		saved = fopen(TOP_FILE, "w");
	else
		saved = fopen(TEMP_WINNERS, "w");
 
	memset(myBuff, ' ', STRING_BUFFER_SIZE-1);
 
	for(i=0; i < TOP_SCORES; i++)
	{
		memset(bigBuff[i], ' ', STRING_BUFFER_SIZE-1);
		sprintf(bigBuff[i], " ");
	}
 
	while(!feof(in) && c < TOP_SCORES)
	{
		memset(myBuff, ' ', STRING_BUFFER_SIZE-1);
		fscanf(in, "  %d %s", &t, myBuff);
		
		if(!feof(in))
		{
			for(i=0; i < c; i++)
				if(!strcmp(bigBuff[i], myBuff))
					break;
 
			if(strcmp(bigBuff[i], myBuff))
			{
				strcpy(bigBuff[c], myBuff);
				fputs(myBuff, saved);
				fputs("\n", saved);
				c++;
			}
		}
	}
 
	fclose(in);
	fclose(saved);
	fclose(out);
	fcloseall();
 
	if(SAVE_TOP_FLAG)
	{
		post_message("Generating the saved file you chose with -s.");
		rename(TOP_FILE, "temp.mirrors.top.file");
		out = fopen(TOP_FILE, "w");
	}
	else
	{
		rename(TEMP_WINNERS, "temp.mirrors.top.file");
		out = fopen(TEMP_WINNERS, "w");
	}
	
	saved = fopen("temp.mirrors.top.file", "r");
 
	if(out == NULL || saved == NULL)
	{
		post_message("Strange error: Already checked files are now missing");
		post_message("Unrecoverable error.");
		exit(1);
	}
 
	while(!feof(saved))
	{
		memset(myBuff, ' ', STRING_BUFFER_SIZE-1);
		fgets(myBuff, STRING_BUFFER_SIZE, saved);
		myBuff[strlen(myBuff)-1] = '\0';
		in = fopen(SERVER_FILE, "r");
		while(!feof(in))
		{
			memset(bigBuff[0], ' ', STRING_BUFFER_SIZE-1);
			fgets(bigBuff[0], STRING_BUFFER_SIZE, in);
 
			bigBuff[0][strlen(bigBuff[0])-1] = '\0';
			if(strstr(bigBuff[0], myBuff)) // && !isspace(bigBuff[0][0]))
			{
					if(BING_FLAG && !strstr(bigBuff[0], "non-US"))
					{
						maxthru = 0;
						my_bing(ipAddress, myBuff);
				
						if(maxthru > Top_Max[0])
						{
							strcpy(Top_Three[0], bigBuff[0]);
							Top_Max[0] = maxthru;
						}
						else if(maxthru > Top_Max[1])
						{
							strcpy(Top_Three[1], bigBuff[0]);
							Top_Max[1] = maxthru;
						}
						else if(maxthru > Top_Max[2])
						{
							strcpy(Top_Three[2], bigBuff[0]);
							Top_Max[2] = maxthru;
						}
//						printf("\n### %s @ %e ###",
					}
					else if(!strstr(bigBuff[0], "non-US"))
					{
						if(strlen(Top_Three[0]) < 2) strcpy(Top_Three[0], bigBuff[0]);
						else if(strlen(Top_Three[1]) < 2) strcpy(Top_Three[1], bigBuff[0]);
						else if(strlen(Top_Three[2]) < 2) strcpy(Top_Three[2], bigBuff[0]);
          }
				fprintf(out, "%s\n", bigBuff[0]);
				break;
			}
		}
		fclose(in);
	}
	fclose(out);
	fclose(saved);
	remove("temp.mirrors.top.file");
 
	if(BING_FLAG)
	{
	  printf("\n");
		post_message("Top servers are");
		printf("\n");
		for(i=0; i < 3; i++)
		{
			printf("[#%d: %s @ ", i, Top_Three[i]);
			
			if(Top_Max[i]<1e3)
	    	printf("%6.3fbps]\n", Top_Max[i]);
	    else if (Top_Max[i]>1e6)
	      printf("%6.3fMbps]\n", Top_Max[i]/1e6);
			else
				printf("%6.3fKbps]\n", Top_Max[i]/1e3);
		}
  }
 
 
	fcloseall();
	out = fopen(SOURCES_LIST, "w");
 
  fprintf(out, "# This sources.list was generated by apt-sources\n");
  fprintf(out, "# Author: Danny Rodriguez [messiah@optonline.net]\n");
  fprintf(out, "# Version %1.2f\n#\n", VERSION);
 
	if(BING_FLAG)
	{
		fprintf(out, "# BING Option was used during this file's creation\n#\n");
	}
	else fprintf(out, "#\n");
 
  fprintf(out, "# See sources.list(5) for more information\n");
				
 
 
	switch(DISTRIB_FLAG)
	{
		case STABLE:
			post_message("Using STABLE distribution.");
			fprintf(out, "deb %s stable main\n", Top_Three[0]);
			if(c > 2)
				fprintf(out, "deb %s stable contrib\n", Top_Three[1]);
			if(c > 3)
				fprintf(out, "deb %s stable non-free\n", Top_Three[2]);
		break;
		case UNSTABLE:
			post_message("Using UNSTABLE distribution.");
			fprintf(out, "deb %s unstable main\n", Top_Three[0]);
			if(c > 2)
				fprintf(out, "deb %s unstable contrib\n", Top_Three[1]);
			if(c > 3)
				fprintf(out, "deb %s unstable non-free\n", Top_Three[2]);
		break;
		case TESTING:
			post_message("Using TESTING distribution.");
			fprintf(out, "deb %s testing main\n", Top_Three[0]);
			if(c > 2)
			fprintf(out, "deb %s testing contrib\n", Top_Three[1]);
			if(c > 3)
			fprintf(out, "deb %s testing non-free\n", Top_Three[2]);
		break;
	};
} */
