// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package codebuild_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/codebuild"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleCodeBuild_BatchGetBuilds() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.BatchGetBuildsInput{
		Ids: []*string{ // Required
			aws.String("NonEmptyString"), // Required
			// More values...
		},
	}
	resp, err := svc.BatchGetBuilds(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_BatchGetProjects() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.BatchGetProjectsInput{
		Names: []*string{ // Required
			aws.String("NonEmptyString"), // Required
			// More values...
		},
	}
	resp, err := svc.BatchGetProjects(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_CreateProject() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.CreateProjectInput{
		Artifacts: &codebuild.ProjectArtifacts{ // Required
			Type:          aws.String("ArtifactsType"), // Required
			Location:      aws.String("String"),
			Name:          aws.String("String"),
			NamespaceType: aws.String("ArtifactNamespace"),
			Packaging:     aws.String("ArtifactPackaging"),
			Path:          aws.String("String"),
		},
		Environment: &codebuild.ProjectEnvironment{ // Required
			ComputeType: aws.String("ComputeType"),     // Required
			Image:       aws.String("NonEmptyString"),  // Required
			Type:        aws.String("EnvironmentType"), // Required
			EnvironmentVariables: []*codebuild.EnvironmentVariable{
				{ // Required
					Name:  aws.String("NonEmptyString"), // Required
					Value: aws.String("String"),         // Required
				},
				// More values...
			},
		},
		Name: aws.String("ProjectName"), // Required
		Source: &codebuild.ProjectSource{ // Required
			Type: aws.String("SourceType"), // Required
			Auth: &codebuild.SourceAuth{
				Type:     aws.String("SourceAuthType"), // Required
				Resource: aws.String("String"),
			},
			Buildspec: aws.String("String"),
			Location:  aws.String("String"),
		},
		Description:   aws.String("ProjectDescription"),
		EncryptionKey: aws.String("NonEmptyString"),
		ServiceRole:   aws.String("NonEmptyString"),
		Tags: []*codebuild.Tag{
			{ // Required
				Key:   aws.String("KeyInput"),
				Value: aws.String("ValueInput"),
			},
			// More values...
		},
		TimeoutInMinutes: aws.Int64(1),
	}
	resp, err := svc.CreateProject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_DeleteProject() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.DeleteProjectInput{
		Name: aws.String("NonEmptyString"), // Required
	}
	resp, err := svc.DeleteProject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_ListBuilds() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.ListBuildsInput{
		NextToken: aws.String("String"),
		SortOrder: aws.String("SortOrderType"),
	}
	resp, err := svc.ListBuilds(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_ListBuildsForProject() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.ListBuildsForProjectInput{
		ProjectName: aws.String("NonEmptyString"), // Required
		NextToken:   aws.String("String"),
		SortOrder:   aws.String("SortOrderType"),
	}
	resp, err := svc.ListBuildsForProject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_ListCuratedEnvironmentImages() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	var params *codebuild.ListCuratedEnvironmentImagesInput
	resp, err := svc.ListCuratedEnvironmentImages(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_ListProjects() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.ListProjectsInput{
		NextToken: aws.String("NonEmptyString"),
		SortBy:    aws.String("ProjectSortByType"),
		SortOrder: aws.String("SortOrderType"),
	}
	resp, err := svc.ListProjects(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_StartBuild() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.StartBuildInput{
		ProjectName: aws.String("NonEmptyString"), // Required
		ArtifactsOverride: &codebuild.ProjectArtifacts{
			Type:          aws.String("ArtifactsType"), // Required
			Location:      aws.String("String"),
			Name:          aws.String("String"),
			NamespaceType: aws.String("ArtifactNamespace"),
			Packaging:     aws.String("ArtifactPackaging"),
			Path:          aws.String("String"),
		},
		BuildspecOverride: aws.String("String"),
		EnvironmentVariablesOverride: []*codebuild.EnvironmentVariable{
			{ // Required
				Name:  aws.String("NonEmptyString"), // Required
				Value: aws.String("String"),         // Required
			},
			// More values...
		},
		SourceVersion:            aws.String("String"),
		TimeoutInMinutesOverride: aws.Int64(1),
	}
	resp, err := svc.StartBuild(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_StopBuild() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.StopBuildInput{
		Id: aws.String("NonEmptyString"), // Required
	}
	resp, err := svc.StopBuild(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCodeBuild_UpdateProject() {
	sess := session.Must(session.NewSession())

	svc := codebuild.New(sess)

	params := &codebuild.UpdateProjectInput{
		Name: aws.String("NonEmptyString"), // Required
		Artifacts: &codebuild.ProjectArtifacts{
			Type:          aws.String("ArtifactsType"), // Required
			Location:      aws.String("String"),
			Name:          aws.String("String"),
			NamespaceType: aws.String("ArtifactNamespace"),
			Packaging:     aws.String("ArtifactPackaging"),
			Path:          aws.String("String"),
		},
		Description:   aws.String("ProjectDescription"),
		EncryptionKey: aws.String("NonEmptyString"),
		Environment: &codebuild.ProjectEnvironment{
			ComputeType: aws.String("ComputeType"),     // Required
			Image:       aws.String("NonEmptyString"),  // Required
			Type:        aws.String("EnvironmentType"), // Required
			EnvironmentVariables: []*codebuild.EnvironmentVariable{
				{ // Required
					Name:  aws.String("NonEmptyString"), // Required
					Value: aws.String("String"),         // Required
				},
				// More values...
			},
		},
		ServiceRole: aws.String("NonEmptyString"),
		Source: &codebuild.ProjectSource{
			Type: aws.String("SourceType"), // Required
			Auth: &codebuild.SourceAuth{
				Type:     aws.String("SourceAuthType"), // Required
				Resource: aws.String("String"),
			},
			Buildspec: aws.String("String"),
			Location:  aws.String("String"),
		},
		Tags: []*codebuild.Tag{
			{ // Required
				Key:   aws.String("KeyInput"),
				Value: aws.String("ValueInput"),
			},
			// More values...
		},
		TimeoutInMinutes: aws.Int64(1),
	}
	resp, err := svc.UpdateProject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
