# 
# cat-archive-log.sh - spew an archive log file
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "print the contents of an archive log entry\\n"
                printf "usage: cat-archive-log [options] [archive/]revision \\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf " -R --root root                specify the local archive root\\n"
                printf " -A --archive archive          specify the archive name\\n"
                printf "\\n"
		printf "  --headers                   show only log headers\\n"
                printf "\\n"
                printf "Print the contents of the log entry for REVISION.\\n"
                printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=
headers_only=
debug_opt=

while test $# -ne 0 ; do

  case "$1" in 

    --debug)		shift
    			debug_opt=--debug
			printf "\n" 1>&2
			printf "cat-archive-log: DEBUGGING ACTIVATED\n" 1>&2
			printf "\n" 1>&2
			set -x
			;;
			
    -R|--root)          shift
                        if test $# -eq 0 ; then
                          printf "cat-archive-log: -r and --root require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archroot="$1"
                        shift
                        ;;

    -A|--archive)       shift
                        if test $# -eq 0 ; then
                          printf "cat-archive-log: -a and --archive require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archive="$1"
                        shift
                        ;;

    --headers)		shift
    			headers_only=--headers
			;;

    --)			shift
    			break
			;;
			
    -*)                 printf "cat-archive-log: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# ordinary arguments
# 

if test $# -ne 1 ; then
  printf "usage: cat-archive-log [options] [archive/]revision\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

archive_revision="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

arch=${archive_revision%%/*}
revision=${archive_revision#*/}

if test "$arch" = "$revision" ; then
  arch=`larch my-default-archive -R "$archroot" -A "$archive"`
fi

archive="$arch"

larch valid-archive-name -e cat-archive-log -- "$archive"
larch valid-package-name -e cat-archive-log --patch-level -- "$revision"

category=`larch parse-package-name --basename $revision`
branch=`larch parse-package-name $revision`
vsn=`larch parse-package-name --vsn $revision`
lvl=`larch parse-package-name --lvl $revision`

log_file=$category/$branch/$branch--$vsn/$lvl/log



################################################################
# Ensure that We Have an Archive Connection 
# 

if test "$WITHARCHIVE" != "$archive" ; then

  exec larch with-archive -R "$archroot" -A "$archive" \
      larch cat-archive-log $debug_opt -R "$archroot" -A "$archive" $headers_only "$archive/$revision" 
fi

################################################################
# Print the Log Entry
# 

wftp-home

if test -z "$headers_only" ; then
  wftp-get $log_file
else
  wftp-get $log_file | sed -e "/^\$/,\$d"
fi
