# 
# get-archive-name.sh - Return the name of a local archive
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "print the name of a local archive\\n"
		printf "usage: get-archive-name [options]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root root                specify the local archive root\\n"
		printf "\\n"
		printf "If the -R option is not specified, the archive root is\\n"
		printf "taken from the environment variable \$ARCHROOT.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=

while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "parse-archive-branch: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;

    -*)			printf "get-archive-name: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 0 ; then
  printf "usage: get-archive-name [options]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi


################################################################
# Get the archive root
# 

if test "x$archroot" = x ; then
  archroot="$ARCHROOT"

  if test "x$archroot" = x ; then
    printf "get-archive-name: no archive root specified\\n" 1>&2
    printf "  use -R or set \$ARCHROOT\\n" 1>&2
    exit 1
  fi
fi

cd "$archroot"
archive="`cat =meta-info/name`"

if ! larch valid-archive-name -- "$archive" ; then
  printf "get-archive-name: invalid archive name in archive!\\n" 1>&2
  printf "  name file: %s/=meta-info/name\\n" "$archroot" 1>&2
  printf "  invalid name: %s\\n" "$archive" 1>&2
  exit 1
fi

printf "%s\\n" "$archive"



