# noop: do nothing
# 
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
	        printf "do nothing\\n"
                printf "usage: noop [options] [args...]\\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf "Do nothing.  Ignore unrecognized options and arguments.\\n"
                printf "\\n"
                exit 0
                ;;

      *)
		;;
    esac
  done
fi

################################################################
# The Hard Part
# 

exit 0

# tag: Tom Lord Tue Dec  4 14:54:39 2001 (archives/noop.sh)
#

