# version-readme.sh: print the =README of a version
# 
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "print the =README of a version\\n"
		printf "usage: version-readme [options] [archive/]version\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root root                specify the local archive root\\n"
		printf " -A --archive archive          specify the archive name\\n"
		printf "\\n"
		printf "Print the contents of the =README file of a particular archive\\n"
		printf "version.  If the version has no =README, nothing is printed.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=

while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "version-readme: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;

    -A|--archive)	shift
    			if test $# -eq 0 ; then
			  printf "version-readme: -A and --archive require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archive="$1"
			shift
			;;


    -*)			printf "version-readme: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -gt 1 ; then
  printf "usage: version-readme [options] [[archive/]category]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

if test $# -ne 0 ; then
  versionspec="$1"
  shift
else
  versionspec=
fi

################################################################
# Sanity Check and Process Defaults
# 

if test -z "$versionspec" ; then
  versionspec=`larch tree-version`
  if test -z "$archive" ; then
    archive=`larch parse-package-name -R "$root" -A "$archive" --arch "$versionspec"`
  fi
  versionspec=`larch parse-package-name --package-version "$versionspec"`
fi

larch valid-package-name -e version-readme --vsn "$versionspec"
archive=`larch parse-package-name -R "$root" -A "$archive" --arch "$versionspec"`
category=`larch parse-package-name --basename "$versionspec"`
branch=`larch parse-package-name "$versionspec"`
version=`larch parse-package-name --package-version "$versionspec"`

################################################################
# Establish an Archive Connection
# 

if test "$WITHARCHIVE" != "$archive" ; then
  exec larch with-archive -A "$archive" larch version-readme -A "$archive" "$version"
fi


################################################################
# Print the List
# 

wftp-home
wftp-cd "$category/$branch/$version"

if wftp-ls | grep -q -E "^=README$" ; then
  wftp-get =README
fi

# tag: Tom Lord Wed Jan 23 01:48:42 2002 (archives/version-readme.sh)
#
