# 
# manifest.sh - print the inventory manifest
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "print the inventory manifest\\n"
                printf "usage: manifest [options]\\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf " -d --dir DIR                  cd to DIR first\\n"
                printf "\\n"
                printf "Print the inventory manifest of a project tree.\\n"
                printf "\\n"
                printf "The inventory manifest is a list of files previously recorded\\n"
                printf "as the expected file inventory.\\n"
                printf "\\n"
                printf "See also \"larch set-manifest\" and \"larch check-manifest\".\\n"
                printf "\\n"
                printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

dir=.

while test $# -ne 0 ; do

  case "$1" in 

    -d|--dir)		shift
			if test $# -eq 0 ; then
			  printf "manifest: -d and --dir require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			dir="$1"
			shift
			;;

    --)			shift
    			break
			;;
			
    -*)                 printf "manifest: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 0 ; then
  printf "usage: manifest [options]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

################################################################
# Sanity Check and Process Defaults
# 

here="`pwd`"
cd "$dir"
dir="`pwd`"

cd "$dir"
wdroot="`larch tree-root`"

manifest="$wdroot/{arch}/=manifest"

if test ! -e "$manifest" ; then

  printf "manifest: no manifest recorded\\n" 1>&2
  printf "\\n" 1>&2
  printf "Try \"larch set-manifest --help\".\\n" 1>&2
  exit 1

fi


################################################################
# Print
# 

cat "$manifest"
