# indicated-config-file: compute a config file path
# 
################################################################
# Copyright (C) 2002 Jonathan Geisler
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "compute a config file path\\n"
		printf "usage: indicated-config-file [options] [--] config\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -e --errname prog             specify program name for errors\\n"
		printf "\\n"
		printf " --exists                      ensure that the config file exists\\n"
		printf " --new                         ensure that the config file does\\n"
		printf "                                not exist\\n"
		printf " -f --force                    suppress the check implied by --new\\n"
		printf " --dir DIR                     search the configs directory of the\\n"
		printf "                                projects tree containing DIR.\\n"
		printf " --config-dir CFG              search directory CFG for config files\\n"
		printf "\\n"
		printf "If CONFIG is valid according to \"larch valid-config-name\"\\n"
		printf "print the absolute path name of the named config file.\\n"
		printf "\\n"
		printf "Exit with status 0 if CONFIG is a valid config name,\\n"
		printf "status 1 otherwise.\\n"
		printf "\\n"
		printf "See \"larch valid-config-name --help\" for more information\\n"
		printf "about config names and the various options to this command.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

errname="indicated-config-file"
dir=.
config_dir=
exists=
new=
force=

while test $# -ne 0 ; do

  case "$1" in 
    --)				shift
    				break
    				;;

    -e|--errname)		shift
				if test $# -eq 0 ; then
				  printf "indicated-config-file: -e and --errname require an argument\\n" 1>&2
				  printf "try --help\\n" 1>&2
				  exit 1
				fi
				errname="$1"
				shift
				;;

    --exists)                   exists=--exists
				new=
				shift
				;;
    
    --new)                      new=--new
				exists=
				shift
				;;

    -f|--force)                 force=--force
				shift
				;;

    --dir)                      shift
				if test $# -eq 0 ; then
				  printf "indicated-config-file: --dir requires an argument\\n" 1>&2
				  printf "try --help\\n" 1>&2
				  exit 1
				fi
				dir="$1"
				shift
				;;

    --config-dir)               shift
				if test $# -eq 0 ; then
				  print "indicated-config-file: --config-dir requires an argument\\n" 1>&2
				  print "try --help\\n" 1>&2
				  exit 1
				fi
				config_dir="$1"
				shift
				;;

    -*)				printf "indicated-config-file: unrecognized option (%s)\\n" "$1" 1>&2
				printf "try --help\\n" 1>&2
				exit 1
				;;

    *)				break
    				;;
  esac

done


################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: indicated-config-file [options] config\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

config="$1"

################################################################
# Sanity Check and Process Defaults
# 

larch valid-config-name -e "$errname" --config-dir "$config_dir" --dir "$dir" $exists $new $force "$config"

here=`pwd`

if test -z "$config_dir" ; then

  cd "$dir"
  wdroot="`larch tree-root`"
  config_dir="$wdroot/configs"

fi

if test ! -d "$config_dir" ; then
  if test ! -z "$errname" ; then
    printf "\\n" 1>&2
    printf "%s: config-dir does not exist\\n" "$errname" 1>&2
    printf "  config-dir: %s\\n" "$config_dir" 1>&2
    printf "\\n" 1>&2
  fi
  exit 1
fi

config_file="$config_dir/$config"


################################################################
# Print Config File Name
# 

printf "%s\\n" "$config_file"


# tag: Jonathan Geisler Sat Mar  2 17:50:09 CST 2002 (naming-conventions/indicated-config-file.sh)
#
