# 
# body-indent.sh: copy input to output, indenting
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "copy input to output, indenting\\n"
		printf "usage: body-indent [options]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --sub                         indent for a sub-level\\n"
		printf " --nonl                        don't add a final newline\\n"
		printf " --html                        generate html instead of outline\\n"
		printf "\\n"
		printf "Copy input to output, indenting for the current outline level\\n"
		printf "or the indicated sub-level.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

sublvl=
nonl=
html=

while test $# -ne 0 ; do

  case "$1" in 

    --sub)		shift
    			sublvl="$sublvl*"
			;;

    --nonl)		shift
    			nonl=--nonl
			;;

    --html)		shift
    			html=--html
			;;

    --)			shift
    			break
			;;

    -*)			printf "body-indent: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Do It
# 

if test -z "$ARCH__OUTLINE_DEPTH" ; then
  ARCH__OUTLINE_DEPTH="*"
fi

depth_str="$ARCH__OUTLINE_DEPTH$sublvl"
spaces="`printf %*s $((1 + ${#depth_str})) \" \"`"

if test ! -z "$html" ; then
  printf "<pre>\\n"
fi

if test -z "$html" ; then
  expand | sed -e "s/^/$spaces/"
else
  expand \
  | sed -e '{
	      s/&/\&amp;/g
	      s/</\&lt;/g
	      s/>/\&gt;/g
	      s/"/\&quot;/g
	    }'
fi

if test ! -z "$html" ; then
  if test -z "$nonl" ; then
    printf "\\n</pre>\\n"
  else
    printf "</pre>\\n"
  fi
elif test -z "$nonl" ; then
    printf "\\n"
fi


# tag: Tom Lord Wed Dec 12 05:51:49 2001 (output/body-indent.sh)
#
