# 
# tag: Tom Lord Sun Dec  9 04:25:33 2001 (patch-logs/add-log.sh)
#
# add-log.sh: add a version patch log to a project tree
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "add a version patch log to a project tree\\n"
		printf "usage: add-log [options] [archive/]version\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root root                specify the local archive root\\n"
		printf " -A --archive archive          specify the archive name\\n"
		printf "\\n"
		printf " -d --dir DIR                  cd to DIR first\\n"
		printf "\\n"
		printf "Add a patch log for VERSION to the project tree containing DIR\\n"
		printf "(or the current directory).\\n"
		printf "\\n"
		printf "A project tree patch log is a pre-requisit for checking the\\n"
		printf "directory in on that version, or updating with patches from that\\n"
		printf "version.\\n"
		printf "\\n"
		printf "Note that versions recorded for a project tree are\\n"
		printf "recorded by fully qualified version names: an archive name\\n"
		printf "plus the name of a version within that archive.\\n"
		printf "\\n"
		printf "You can specify the archive for this version as an ordinary\\n"
		printf "command line argument (ARCHIVE/VERSION) or via -R, -A and\\n"
		printf "the environment as usual (try \"larch my-default-archive\\n"
		printf " --help\").\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=
dir=.

while test $# -ne 0 ; do

  case "$1" in 

    -d|--dir)		shift
			if test $# -eq 0 ; then
			  printf "add-log: -d and --dir require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			dir="$1"
			shift
			;;

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "add-log: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;

    -A|--archive)	shift
    			if test $# -eq 0 ; then
			  printf "add-log: -A and --archive require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archive="$1"
			shift
			;;


    -*)			printf "add-log: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: add-log [options] [archive/]version\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

arch_version="$1"

################################################################
# Sanity Check
# 

cd "$dir"
dir="`pwd`"

larch valid-package-name -e "add-log" --vsn -- "$arch_version"

archive=`larch parse-package-name -R "$archroot" -A "$archive" --arch "$arch_version"`
version=`larch parse-package-name -R "$archroot" -A "$archive" --package-version "$arch_version"`
category=`larch parse-package-name -b $version`
branch=`larch parse-package-name $version`

cd "$dir"
wdroot="`larch tree-root --accurate`"

logdir="$wdroot/{arch}/$category/$branch/$version/$archive/patch-log"

if test -e "$logdir" ; then
  printf "add-log: patch log already exists\\n" 1>&2
  printf "  source tree: %s\\n" "$wdroot" 1>&2
  printf "  version: %s/%s\\n" $archive $version 1>&2
  printf "\\n" 1>&2
  printf "try larch logs --help\\n" 1>&2
  printf "\\n" 1>&2
  exit 1
fi


################################################################
# Do It
# 

mkdir -p "$logdir"

# tag: Tom Lord Mon Dec 17 18:48:52 2001 (patch-logs/add-log.sh)
#
