# 
# with-archive-settings.sh: report with-archive env. settings
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 
errname=with-archive-settings

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "report with-archive environment settings\\n"
		printf "usage: with-archive-settings [options]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "Return a shell script that restores the environment variables\\n"
   		printf "used by \"larch with-archive\" to their current values.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    -*)			printf "with-archive-settings: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 0 ; then
    printf "usage: with-archive-settings [options]\\n" 1>&2
    printf "try --help\\n" 1>&2
    exit 1
fi

################################################################
# The Answer
#

printf "WITHARCHIVE='%s' ; \\\\\\n" "$WITHARCHIVE" 
printf "WITHARCHIVELOC='%s' ; \\\\\\n" "$WITHARCHIVELOC" 

printf "WFTP_MY_ADDR='%s' ; \\\\\\n" "$WFTP_MY_ADDR" 
printf "WFTP_SITE='%s' ; \\\\\\n" "$WFTP_SITE" 
printf "WFTP_SECRET='%s' ; \\\\\\n" "$WFTP_SECRET" 
printf "WFTP_SITE_ADDR='%s' ; \\\\\\n" "$WFTP_SITE_ADDR" 
printf "WFTP='%s'\\n" "$WFTP" 

# tag: Tom Lord Sat Jan  5 12:21:06 2002 (remote/with-archive-settings.sh)
#
