# 
# with-archive.sh - connect to a possibly remote archive
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 
errname=with-archive

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "*+connect to a (possibly remote) archive\\n"
		printf "usage: with-archive [options] command [args...]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root root                specify the local archive root\\n"
		printf " -A --archive archive          specify the archive name\\n"
		printf " -e --errname name             program name for error messages\\n"
		printf "\\n"
		printf "Connect to the default archive and execute COMMAND with ARGS.\\n"
   		printf "\\n"
		printf "If the archive is remote this involves logging in to the remote\\n"
		printf "FTP server.\\n"
		printf "\\n"
		printf "For information about how the archive to operate on is selected,\\n"
		printf "try \"larch my-default-archive --help\".\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=

while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "with-archive: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;

    -A|--archive)	shift
    			if test $# -eq 0 ; then
			  printf "with-archive: -A and --archive require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archive="$1"
			shift
			;;

    -e|--errname)	shift
    			if test $# -eq 0 ; then
			  printf "with-archive: -e and --errname require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			errname="$1"
			shift
			;;

    -*)			printf "with-archive: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 1 ; then
    printf "usage: with-archive [options] command [args...]\\n" 1>&2
    printf "try --help\\n" 1>&2
    exit 1
fi

################################################################
# Sanity Check and Process Defaults
# 

archive=`larch my-default-archive -e "$errname" -R "$archroot" -A "$archive"`

################################################################
# Find the Archive Location
# 

location="`larch whereis-archive -R \"$archroot\" $archive`"

################################################################
# Connect and execute the command
# 

if test "$WITHARCHIVE" = "$archive" ; then

  loc="`wftp-pwd`"
  wftp-home
  "$@"
  wftp-home
  wftp-cd "$loc"

else

  WITHARCHIVE="$archive"
  WITHARCHIVELOC="$location"

  export WITHARCHIVE
  export WITHARCHIVELOC

  with-ftp "$location" "$@"

fi

