# -v archive_list
# 

BEGIN {
  	 if (archive_list != "")
	   {
	     while (getline < archive_list)
	       {
		 is_indexed_archive[$0] = 1;
	       }

	     close(archive_list);
	   }
       }
{
  first = $0;
  last_conseq = "";

  current_version_patch_type = first;
  sub("-[^-]*$", "", current_version_patch_type);

  current_n = first;
  sub(".*-", "", current_n);
  
  while (getline this)
    {

      this_version_patch_type = this;
      sub("-[^-]*$", "", this_version_patch_type);

      this_n = this;
      sub(".*-", "", this_n);

      if ((this_version_patch_type == current_version_patch_type) && (this_n == (current_n - 1)))
	{
	  last_conseq = this;
	  current_n = this_n;
	}
      else
	{
	  print_conseq_seq(first, current_n);

	  last_conseq = "";
	  first = this;

	  current_version_patch_type = first;
	  sub("-[^-]*$", "", current_version_patch_type);

	  current_n = first;
	  sub(".*-", "", current_n);
	}
    }

  print_conseq_seq(first, current_n);
}

function print_conseq_seq(first, last_n)
{
  first_n = first;
  sub(".*-", "", first_n);
  if (first_n == last_n)
    last_n = "";

  type = first;
  sub(".*--", "", type);
  sub("-.*", "", type);

  print "<tr>";
  print "<td>";

  first_text = first;
  last_text = type "-" last_n;

  if (archive_list != "")
    {
      a = first;
      sub("/.*", "", a);

      if (is_indexed_archive[a])
	{
	  r = first;
	  sub(".*/", "", r);

	  v = r;
	  sub("--[^-]*-[^-]*$", "", v);

	  b = v;
	  sub("--[^-]*$", "", b);

	  c = b;
	  sub("--.*$", "", c);

	  first_text = "<a target=\"@TARGET@\" \
			   href=\"@BROWSERREPOS@/" a "/cats/" c "/branches/" b "/vsns/" v "/patches-full.d/loc-" type "-" first_n ".html#" type "-" first_n "\">" first_text "</a>";

	  if (last_n)
  	    last_text = "<a target=\"@TARGET@\" \
			    href=\"@BROWSERREPOS@/" a "/cats/" c "/branches/" b "/vsns/" v "/patches-full.d/loc-" type "-" first_n ".html#" type "-" last_n "\">" last_text "</a>";
	}
    }

  if (last_n)
    printf("<code><small>\n%s ... %s\n</small></code>\n", first_text, last_text);
  else
    printf("<code><small>\n%s\n</small></code>\n", first_text);
  print "</td>";

  print "</tr>";
}

# tag: Tom Lord Mon Jan 28 01:13:09 2002 (web/patch-list-rows.awk)
#
