# -v title
# -v report_root
# -v library_root
# -v archive
# -v version
# -v creator_emph
# 
# -v archive_list
# 
# -v page_bg
# -v table_bg
# -v headers_bg
# -v note_color
# -v revision_notes
# 
# -v link_target
# 

BEGIN {
  	 if (archive_list != "")
	   {
	     while (getline < archive_list)
	       {
		 is_indexed_archive[$0] = 1;
	       }

	     close(archive_list);
	   }
  	 if (revision_notes != "")
	   {
	     FS = ":";
	     while (getline < revision_notes)
	       {
		 rev = $1;
		 note = $2;

		 note_vsn = rev;
		 sub("--[^-]*-[^-]*$", "", note_vsn);

		 if (note_vsn == (archive "/" version))
		   {
		     lvl = rev;
		     sub(".*--", "", lvl);
		     rev_notes[lvl] = rev_notes[lvl] "<br><small><font color=\"" note_color "\">" note "</font></small>\n";
		   }
	       }
	     FS = " ";
	   }

	 close(revision_notes);

  	 if (page_bg == "")
	   page_bg = "#bebebe";

	 if (table_bg == "")
	   table_bg = "#bebebe";

	 if (headers_bg == "")
	   headers_bg = "#bebebe";

 	 some = 0; 
	 in_body = 0;

         print "<HTML>"
         print ""
         print "<HEAD><TITLE>" title "</TITLE></HEAD>"
         print ""
         print "<BODY bgcolor=\"" page_bg "\">"
         print ""
         print ""
         print "<table border=\"3\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"" table_bg "\" width=\"100%\">";
         print "<caption><font color=\"#dedede\"><i>" title "</i></font></caption>"
       }
    
{
  if (match($0, "^[ \t]"))
    {
      if (!in_body)
        {
	  print "revisions-right-index: input format error\n" | "cat 1>&2";
	  exit(1);
        }
      if ((creator_emph == "") || (creator_emph == creator_id))
	{
          print $0;
	}
    }
  else
    {
      if (in_body && ((creator_emph == "") || (creator_emph == creator_id)))
        {
          print "</pre></font></td></tr>";		# end of the optional second row (Summary:) in the patch level table
          in_body = 0;
	  if (full)
	    {
	      add_details();
	    }
        }

      if (some)
	{
	  print "</table>";				# end of the previous patch level
	  print "</td>";
	  print "</tr>";
	}

      some = 1;
      lvl = $1

      getline date;
      getline creator;

      creator_id=creator;

      sub("^.*&lt;", "", creator_id);
      sub("&gt;$", "", creator_id);


      print "<tr>";	# each patch level is one row in the outermost table, with one row and one column
      print "<td>";

      # that column contains a table with one column, one or two rows (two if we are showing the Summary:)
      #
      if ((creator_emph == "") || (creator_emph == creator_id))
        print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">";
      else
        print "<table bgcolor=\"#bebebe\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">";

      print "<tr>";
      print "<td>";

      print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">";	# the top row of a patch level table is a table with one row, two columns
      print "<tr>";



      print "<td>";			# the patch level name column

      if ((creator_emph == "") || (creator_emph == creator_id))
	{
	  i_a="";
	  i_b="";
	}
      else
	{
	  i_a="<small><i>"
	  i_b="</i></small>"
	}

      if ( "" == report_root )
        {
          print i_a "<code>" lvl "</code>" i_b;
        }
      else
        {
	  if (full)
	    patch_name = version "--" lvl;
	  else
	    patch_name = lvl;

	  print i_a "<code><b>" patch_name "</b></code>" i_b;
          print "<a name=\"" lvl "\" target=\"" link_target "\" href=\"" library_root "/" version "--" lvl "/,,patch-set/=log.txt\">";
	  print "<small><i>log entry</i></small>";
	  print "</a>";
          print "<small><i><a target=\"" link_target "\" href=\"" report_root "/" lvl "/=REPORT.html\">patch set</a></i></small> ";
	  print "<small><i><a target=\"" link_target "\" href=\"" library_root "/" version "--" lvl "\">source</a></i></small> ";
	  print "<br>";
	  print "<small><i><a target=\"" link_target "\" href=\"" report_root "/" lvl "/files-by-name.html\">files</a></code></small>";
	  print "<small><code><a target=\"" link_target "\" href=\"changelog.html#"lvl "\">ChangeLog</a></code></small>";
	  print "<small><i><a target=\"" link_target "\" href=\"patches-full.d/loc-" lvl ".html#" lvl "\">details</a></code></small>";
	  if (rev_notes[lvl] != "")
	    {
	      printf("%s", rev_notes[lvl]);
	    }
        }
      print "</td>";			# end of patch level name column

      print "<td align=\"right\"><font color=\"#000000\">";		# the creator column
      print "<p align=\"right\">" i_a creator i_b;
      print "<br><small><i> (" date ")</i></small>";
      print "</font></td>";						# end of creator column
      in_body = 1;
      print "</tr>";
      print "</table>";							# end of patch level/creator table
      print "</td>";
      print "</tr>";							# end of first row of patch level table

      if ((creator_emph == "") || (creator_emph == creator_id))
	{
	  print "<tr>";							# if we're showing the summary, a second row in the patch level table
	  print "<td><font color=\"#000000\"><pre>";
	}
   }
}
    
function add_details()
{
  new_patches_command = "larch library-log " archive "/" version "--" lvl " \
    			| larch log-header-field --list new-patches \
			| grep -v -F " archive "/" version "--" lvl " \
			| larch sort-revisions --full --reverse";

  removed_patches_command = "larch library-log " archive "/" version "--" lvl " \
			     | larch log-header-field --list removed-patches \
			     | larch sort-revisions --full --reverse";

  new_patch = "";
  removed_patch = "";


  print "<tr>";	# Details are an extra row in the patch level table.  That row is a table with three columns, one row.
  print "<td>"; 
  print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">";
  print "<tr>";

  print "<td width=\"50\">"; # COLUMN ONE: negative space
  print "</td>";
  

  print "<td>"; # COLUMN2: NEW AND REMOVED PATCHES

  print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";  # merge/revert report is a table with 1 col, 2 rows

  print "<tr>"; # patches merged into this patch level
  print "<td>";
  new_patches_command | getline new_patch;
  if (new_patch != "")
    print_patch_table("merged in", new_patch, new_patches_command);
  print "</td>";
  print "</tr>";

  print "<tr>"; # patches merge out of this patch level
  print "<td>";
  removed_patches_command | getline removed_patch;
  if (removed_patch != "")
    print_patch_table("reverted (or unlogged)", removed_patch, removed_patches_command);
  print "</td>";
  print "</tr>";

  print "</table>"; # end of merge/revert report
  print "</td>"; # END OF COLUMN2 (NEW AND REMOVED PATCHES)
  close(new_patches_command);
  close(removed_patches_command);

  print "<td>"; # COLUMN3: SMALL FORMAT PATCH REPORT
  print "<font color=\"#000000\">";
  print "<small>";

  patch_report_cmd = "larch nested larch patch-report --html --no-intro --omit-empty --link-root reports/" lvl " reports/" lvl;

  while (patch_report_cmd | getline pr)
    print pr;

  close (patch_report_cmd);

  print "</small>";
  print "</font>";
  print "</td>";

  print "</tr>"; # END OF DETAILS
  print "</table>";
  print "</td>";
  print "</tr>"
}

function print_patch_table(caption, first, command)
{
  print "<table>";

  print "<caption><font color=\"#000000\"><i>" caption "</i></font></caption>";

  last_conseq = "";

  current_version_patch_type = first;
  sub("-[^-]*$", "", current_version_patch_type);

  current_n = first;
  sub(".*-", "", current_n);
  

  while (command | getline this)
    {

      this_version_patch_type = this;
      sub("-[^-]*$", "", this_version_patch_type);

      this_n = this;
      sub(".*-", "", this_n);

      if ((this_version_patch_type == current_version_patch_type) && (this_n == (current_n - 1)))
	{
	  last_conseq = this;
	  current_n = this_n;
	}
      else
	{
	  print_conseq_seq(first, current_n);

	  last_conseq = "";
	  first = this;

	  current_version_patch_type = first;
	  sub("-[^-]*$", "", current_version_patch_type);

	  current_n = first;
	  sub(".*-", "", current_n);
	}
    }

  print_conseq_seq(first, current_n);

  print "</table>";
}

function print_conseq_seq(first, last_n)
{
  first_n = first;
  sub(".*-", "", first_n);
  if (first_n == last_n)
    last_n = "";

  type = first;
  sub(".*--", "", type);
  sub("-.*", "", type);

  print "<tr>";


  print "<td>";

  first_text = first;
  last_text = type "-" last_n;

  if (archive_list != "")
    {
      a = first;
      sub("/.*", "", a);

      if (is_indexed_archive[a])
	{
	  r = first;
	  sub(".*/", "", r);

	  v = r;
	  sub("--[^-]*-[^-]*$", "", v);

	  b = v;
	  sub("--[^-]*$", "", b);

	  c = b;
	  sub("--.*$", "", c);

	  first_text = "<a target=\"" link_target "\" \
			   href=\"../../../../../../../" a "/cats/" c "/branches/" b "/vsns/" v "/patches-full.d/loc-" type "-" first_n ".html#" type "-" first_n "\">" first_text "</a>";

	  if (last_n)
  	    last_text = "<a target=\"" link_target "\" \
			    href=\"../../../../../../../" a "/cats/" c "/branches/" b "/vsns/" v "/patches-full.d/loc-" type "-" first_n ".html#" type "-" last_n "\">" last_text "</a>";
	}
    }

  if (last_n)
    printf("<code><small>%s ... %s\n</small></code>\n", first_text, last_text);
  else
    printf("<code><small>%s\n</small></code>\n", first_text);
  print "</td>";

  print "</tr>";
}


END {
      if (in_body && ((creator_emph == "") || (creator_emph == creator_id)))
        {
          print "</pre></font></td></tr>";		# end of the optional second row (Summary:) in the patch level table
          in_body = 0;
	  if (full)
	    {
	      add_details();
	    }
        }

      if (some)
	{
	  print "</table>";				# end of the previous patch level
	  print "</td>";
	  print "</tr>";
	}

      print "</table>";
      print "";
      print "</BODY>";
      print "";
      print "</HTML>";
    }



# tag: Tom Lord Sat Jan 26 16:51:35 2002 (web/revisions-right-index.awk)
#
